/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Api {
    private final Map<String, ApiClass> mClasses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Api parseApi(File apiFile) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(apiFile);
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            ApiParser apiParser = new ApiParser();
            parser.parse((InputStream)fileInputStream, (DefaultHandler)apiParser);
            Api api = new Api(apiParser.getClasses());
            return api;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private Api(Map<String, ApiClass> classes) {
        this.mClasses = new HashMap<String, ApiClass>(classes);
    }

    ApiClass getClass(String fqcn) {
        return this.mClasses.get(fqcn);
    }

    Map<String, ApiClass> getClasses() {
        return Collections.unmodifiableMap(this.mClasses);
    }
}

