/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.IsAndroidProject;
import com.android.tools.lint.detector.api.IsLibraryProject;
import com.android.tools.lint.detector.api.MinSdkAtLeast;
import com.android.tools.lint.detector.api.MinSdkLessThan;
import com.android.tools.lint.detector.api.NotAndroidProject;
import com.android.tools.lint.detector.api.NotLibraryProject;
import com.android.tools.lint.detector.api.TargetSdkAtLeast;
import com.android.tools.lint.detector.api.TargetSdkLessThan;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0006\u001a\u0006\u0010\b\u001a\u00020\u0001\u001a\u0006\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"isAndroidProject", "Lcom/android/tools/lint/detector/api/Constraint;", "isLibraryProject", "minSdkAtLeast", "minSdkVersion", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "", "minSdkLessThan", "notAndroidProject", "notLibraryProject", "targetSdkAtLeast", "targetSdkVersion", "targetSdkLessThan", "lint-api"})
@JvmName(name="Constraints")
public final class Constraints {
    @NotNull
    public static final Constraint minSdkAtLeast(int minSdkVersion) {
        return new MinSdkAtLeast(ApiConstraint.Companion.atLeast(minSdkVersion, 0));
    }

    @NotNull
    public static final Constraint minSdkLessThan(int minSdkVersion) {
        return new MinSdkLessThan(ApiConstraint.Companion.atLeast(minSdkVersion, 0));
    }

    @NotNull
    public static final Constraint minSdkAtLeast(@NotNull ApiConstraint minSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)minSdkVersion, (String)"minSdkVersion");
        return new MinSdkAtLeast(minSdkVersion);
    }

    @NotNull
    public static final Constraint minSdkLessThan(@NotNull ApiConstraint minSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)minSdkVersion, (String)"minSdkVersion");
        return new MinSdkLessThan(minSdkVersion);
    }

    @NotNull
    public static final Constraint targetSdkAtLeast(int targetSdkVersion) {
        return new TargetSdkAtLeast(targetSdkVersion);
    }

    @NotNull
    public static final Constraint targetSdkLessThan(int targetSdkVersion) {
        return new TargetSdkLessThan(targetSdkVersion);
    }

    @NotNull
    public static final Constraint isLibraryProject() {
        return new IsLibraryProject();
    }

    @NotNull
    public static final Constraint isAndroidProject() {
        return new IsAndroidProject();
    }

    @NotNull
    public static final Constraint notLibraryProject() {
        return new NotLibraryProject();
    }

    @NotNull
    public static final Constraint notAndroidProject() {
        return new NotAndroidProject();
    }
}

