/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u0004H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/detector/api/ArrayReference;", "", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "dimensions", "", "getDimensions", "()I", "size", "getSize", "toString", "ByClass", "ByName", "Companion", "Lcom/android/tools/lint/detector/api/ArrayReference$ByClass;", "Lcom/android/tools/lint/detector/api/ArrayReference$ByName;", "lint-api"})
public abstract class ArrayReference {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ArrayReference() {
    }

    public abstract int getSize();

    public abstract int getDimensions();

    @NotNull
    protected abstract String getClassName();

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("Array Reference: " + this.getClassName());
        boolean bl = false;
        int n = this.getDimensions();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            sb.append("[]");
        }
        sb.append("[" + this.getSize() + "]");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"Array Ref\u2026      sb.toString()\n    }");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ArrayReference of(@NotNull Class<?> klass, int size, int dimensions) {
        return Companion.of(klass, size, dimensions);
    }

    @JvmStatic
    @NotNull
    public static final ArrayReference of(@NotNull String name, int size, int dimensions) {
        return Companion.of(name, size, dimensions);
    }

    public /* synthetic */ ArrayReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/detector/api/ArrayReference$ByClass;", "Lcom/android/tools/lint/detector/api/ArrayReference;", "type", "Ljava/lang/Class;", "size", "", "dimensions", "(Ljava/lang/Class;II)V", "className", "", "getClassName", "()Ljava/lang/String;", "getDimensions", "()I", "getSize", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "lint-api"})
    private static final class ByClass
    extends ArrayReference {
        @NotNull
        private final Class<?> type;
        private final int size;
        private final int dimensions;

        public ByClass(@NotNull Class<?> type, int size, int dimensions) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(null);
            this.type = type;
            this.size = size;
            this.dimensions = dimensions;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public int getDimensions() {
            return this.dimensions;
        }

        @Override
        @NotNull
        protected String getClassName() {
            String string = this.type.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.toString()");
            return string;
        }

        private final Class<?> component1() {
            return this.type;
        }

        public final int component2() {
            return this.getSize();
        }

        public final int component3() {
            return this.getDimensions();
        }

        @NotNull
        public final ByClass copy(@NotNull Class<?> type, int size, int dimensions) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            return new ByClass(type, size, dimensions);
        }

        public static /* synthetic */ ByClass copy$default(ByClass byClass, Class clazz, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                clazz = byClass.type;
            }
            if ((n3 & 2) != 0) {
                n = byClass.getSize();
            }
            if ((n3 & 4) != 0) {
                n2 = byClass.getDimensions();
            }
            return byClass.copy(clazz, n, n2);
        }

        @Override
        @NotNull
        public String toString() {
            return "ByClass(type=" + this.type + ", size=" + this.getSize() + ", dimensions=" + this.getDimensions() + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.getSize());
            result = result * 31 + Integer.hashCode(this.getDimensions());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ByClass)) {
                return false;
            }
            ByClass byClass = (ByClass)other;
            if (!Intrinsics.areEqual(this.type, byClass.type)) {
                return false;
            }
            if (this.getSize() != byClass.getSize()) {
                return false;
            }
            return this.getDimensions() == byClass.getDimensions();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c4\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/detector/api/ArrayReference$ByName;", "Lcom/android/tools/lint/detector/api/ArrayReference;", "className", "", "size", "", "dimensions", "(Ljava/lang/String;II)V", "getClassName", "()Ljava/lang/String;", "getDimensions", "()I", "getSize", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "lint-api"})
    private static final class ByName
    extends ArrayReference {
        @NotNull
        private final String className;
        private final int size;
        private final int dimensions;

        public ByName(@NotNull String className, int size, int dimensions) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            super(null);
            this.className = className;
            this.size = size;
            this.dimensions = dimensions;
        }

        @Override
        @NotNull
        protected String getClassName() {
            return this.className;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public int getDimensions() {
            return this.dimensions;
        }

        @NotNull
        protected final String component1() {
            return this.getClassName();
        }

        public final int component2() {
            return this.getSize();
        }

        public final int component3() {
            return this.getDimensions();
        }

        @NotNull
        public final ByName copy(@NotNull String className, int size, int dimensions) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            return new ByName(className, size, dimensions);
        }

        public static /* synthetic */ ByName copy$default(ByName byName, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = byName.getClassName();
            }
            if ((n3 & 2) != 0) {
                n = byName.getSize();
            }
            if ((n3 & 4) != 0) {
                n2 = byName.getDimensions();
            }
            return byName.copy(string, n, n2);
        }

        @Override
        @NotNull
        public String toString() {
            return "ByName(className=" + this.getClassName() + ", size=" + this.getSize() + ", dimensions=" + this.getDimensions() + ")";
        }

        public int hashCode() {
            int result = this.getClassName().hashCode();
            result = result * 31 + Integer.hashCode(this.getSize());
            result = result * 31 + Integer.hashCode(this.getDimensions());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ByName)) {
                return false;
            }
            ByName byName = (ByName)other;
            if (!Intrinsics.areEqual((Object)this.getClassName(), (Object)byName.getClassName())) {
                return false;
            }
            if (this.getSize() != byName.getSize()) {
                return false;
            }
            return this.getDimensions() == byName.getDimensions();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/detector/api/ArrayReference$Companion;", "", "()V", "of", "Lcom/android/tools/lint/detector/api/ArrayReference;", "klass", "Ljava/lang/Class;", "size", "", "dimensions", "name", "", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ArrayReference of(@NotNull Class<?> klass, int size, int dimensions) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            return new ByClass(klass, size, dimensions);
        }

        @JvmStatic
        @NotNull
        public final ArrayReference of(@NotNull String name, int size, int dimensions) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ByName(name, size, dimensions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

