/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.SdkConstants;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.support.AndroidxName;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.google.common.collect.ImmutableMap;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.java.UnknownJavaExpression;

public class ResourceEvaluator {
    public static final ResourceType COLOR_INT_MARKER_TYPE = ResourceType.PUBLIC;
    public static final ResourceType DIMENSION_MARKER_TYPE = ResourceType.SAMPLE_DATA;
    public static final ResourceType DIMENSION_SP_MARKER_TYPE = ResourceType.OVERLAYABLE;
    public static final ResourceType DIMENSION_DP_MARKER_TYPE = ResourceType.AAPT;
    public static final ResourceType[] DIMENSION_MARKERS = new ResourceType[]{DIMENSION_MARKER_TYPE, DIMENSION_SP_MARKER_TYPE, DIMENSION_DP_MARKER_TYPE};
    public static final ResourceType ANY_RES_MARKER_TYPE = ResourceType.MACRO;
    public static final AndroidxName COLOR_INT_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"ColorInt");
    public static final AndroidxName PX_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Px");
    public static final AndroidxName DIMENSION_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Dimension");
    public static final String RES_SUFFIX = "Res";
    public static final AndroidxName ANIMATOR_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"AnimatorRes");
    public static final AndroidxName ANIM_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"AnimRes");
    public static final AndroidxName ANY_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"AnyRes");
    public static final AndroidxName ARRAY_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"ArrayRes");
    public static final AndroidxName BOOL_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"BoolRes");
    public static final AndroidxName COLOR_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"ColorRes");
    public static final AndroidxName ATTR_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"AttrRes");
    public static final AndroidxName DIMEN_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"DimenRes");
    public static final AndroidxName DRAWABLE_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"DrawableRes");
    public static final AndroidxName FONT_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"FontRes");
    public static final AndroidxName FRACTION_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"FractionRes");
    public static final AndroidxName ID_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"IdRes");
    public static final AndroidxName INTEGER_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"IntegerRes");
    public static final AndroidxName INTERPOLATOR_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"InterpolatorRes");
    public static final AndroidxName LAYOUT_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"LayoutRes");
    public static final AndroidxName MENU_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"MenuRes");
    public static final AndroidxName PLURALS_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"PluralsRes");
    public static final AndroidxName RAW_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RawRes");
    public static final AndroidxName STRING_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"StringRes");
    public static final AndroidxName STYLEABLE_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"StyleableRes");
    public static final AndroidxName STYLE_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"StyleRes");
    public static final AndroidxName TRANSITION_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"TransitionRes");
    public static final AndroidxName XML_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"XmlRes");
    private final JavaEvaluator evaluator;
    public static final AndroidxName NAVIGATION_RES_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"NavigationRes");
    private static final ImmutableMap<String, ResourceType> TYPE_FROM_ANNOTATION_SIGNATURE = ImmutableMap.builder().put((Object)ANIMATOR_RES_ANNOTATION.oldName(), (Object)ResourceType.ANIMATOR).put((Object)ANIMATOR_RES_ANNOTATION.newName(), (Object)ResourceType.ANIMATOR).put((Object)ANIM_RES_ANNOTATION.oldName(), (Object)ResourceType.ANIM).put((Object)ANIM_RES_ANNOTATION.newName(), (Object)ResourceType.ANIM).put((Object)ARRAY_RES_ANNOTATION.oldName(), (Object)ResourceType.ARRAY).put((Object)ARRAY_RES_ANNOTATION.newName(), (Object)ResourceType.ARRAY).put((Object)ATTR_RES_ANNOTATION.oldName(), (Object)ResourceType.ATTR).put((Object)ATTR_RES_ANNOTATION.newName(), (Object)ResourceType.ATTR).put((Object)BOOL_RES_ANNOTATION.oldName(), (Object)ResourceType.BOOL).put((Object)BOOL_RES_ANNOTATION.newName(), (Object)ResourceType.BOOL).put((Object)COLOR_RES_ANNOTATION.oldName(), (Object)ResourceType.COLOR).put((Object)COLOR_RES_ANNOTATION.newName(), (Object)ResourceType.COLOR).put((Object)DIMEN_RES_ANNOTATION.oldName(), (Object)ResourceType.DIMEN).put((Object)DIMEN_RES_ANNOTATION.newName(), (Object)ResourceType.DIMEN).put((Object)DRAWABLE_RES_ANNOTATION.oldName(), (Object)ResourceType.DRAWABLE).put((Object)DRAWABLE_RES_ANNOTATION.newName(), (Object)ResourceType.DRAWABLE).put((Object)FONT_RES_ANNOTATION.oldName(), (Object)ResourceType.FONT).put((Object)FONT_RES_ANNOTATION.newName(), (Object)ResourceType.FONT).put((Object)FRACTION_RES_ANNOTATION.oldName(), (Object)ResourceType.FRACTION).put((Object)FRACTION_RES_ANNOTATION.newName(), (Object)ResourceType.FRACTION).put((Object)ID_RES_ANNOTATION.oldName(), (Object)ResourceType.ID).put((Object)ID_RES_ANNOTATION.newName(), (Object)ResourceType.ID).put((Object)INTEGER_RES_ANNOTATION.oldName(), (Object)ResourceType.INTEGER).put((Object)INTEGER_RES_ANNOTATION.newName(), (Object)ResourceType.INTEGER).put((Object)INTERPOLATOR_RES_ANNOTATION.oldName(), (Object)ResourceType.INTERPOLATOR).put((Object)INTERPOLATOR_RES_ANNOTATION.newName(), (Object)ResourceType.INTERPOLATOR).put((Object)LAYOUT_RES_ANNOTATION.oldName(), (Object)ResourceType.LAYOUT).put((Object)LAYOUT_RES_ANNOTATION.newName(), (Object)ResourceType.LAYOUT).put((Object)MENU_RES_ANNOTATION.oldName(), (Object)ResourceType.MENU).put((Object)MENU_RES_ANNOTATION.newName(), (Object)ResourceType.MENU).put((Object)NAVIGATION_RES_ANNOTATION.oldName(), (Object)ResourceType.NAVIGATION).put((Object)NAVIGATION_RES_ANNOTATION.newName(), (Object)ResourceType.NAVIGATION).put((Object)PLURALS_RES_ANNOTATION.oldName(), (Object)ResourceType.PLURALS).put((Object)PLURALS_RES_ANNOTATION.newName(), (Object)ResourceType.PLURALS).put((Object)RAW_RES_ANNOTATION.oldName(), (Object)ResourceType.RAW).put((Object)RAW_RES_ANNOTATION.newName(), (Object)ResourceType.RAW).put((Object)STRING_RES_ANNOTATION.oldName(), (Object)ResourceType.STRING).put((Object)STRING_RES_ANNOTATION.newName(), (Object)ResourceType.STRING).put((Object)STYLEABLE_RES_ANNOTATION.oldName(), (Object)ResourceType.STYLEABLE).put((Object)STYLEABLE_RES_ANNOTATION.newName(), (Object)ResourceType.STYLEABLE).put((Object)STYLE_RES_ANNOTATION.oldName(), (Object)ResourceType.STYLE).put((Object)STYLE_RES_ANNOTATION.newName(), (Object)ResourceType.STYLE).put((Object)TRANSITION_RES_ANNOTATION.oldName(), (Object)ResourceType.TRANSITION).put((Object)TRANSITION_RES_ANNOTATION.newName(), (Object)ResourceType.TRANSITION).put((Object)XML_RES_ANNOTATION.oldName(), (Object)ResourceType.XML).put((Object)XML_RES_ANNOTATION.newName(), (Object)ResourceType.XML).build();
    private boolean allowDereference = true;

    public ResourceEvaluator(JavaEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public ResourceEvaluator allowDereference(boolean allow) {
        this.allowDereference = allow;
        return this;
    }

    public static ResourceUrl getResource(JavaEvaluator evaluator, PsiElement element) {
        return new ResourceEvaluator(evaluator).getResource(element);
    }

    public static ResourceUrl getResource(JavaEvaluator evaluator, UElement element) {
        return new ResourceEvaluator(evaluator).getResource(element);
    }

    public static EnumSet<ResourceType> getResourceTypes(JavaEvaluator evaluator, PsiElement element) {
        return new ResourceEvaluator(evaluator).getResourceTypes(element);
    }

    public static EnumSet<ResourceType> getResourceTypes(JavaEvaluator evaluator, UElement element) {
        return new ResourceEvaluator(evaluator).getResourceTypes(element);
    }

    public ResourceUrl getResource(UElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof UIfExpression) {
            UIfExpression expression = (UIfExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (UElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResource((UElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResource((UElement)expression.getElseExpression());
            }
        } else {
            ResourceUrl url;
            UExpression selector;
            if (element instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)element;
                return this.getResource((UElement)parenthesizedExpression.getExpression());
            }
            if (element instanceof UCallExpression) {
                UCallExpression call = (UCallExpression)element;
                PsiMethod function = call.resolve();
                PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)function, PsiClass.class);
                if (function != null && containingClass != null) {
                    List args;
                    String qualifiedName = containingClass.getQualifiedName();
                    String name = Lint.getMethodName(call);
                    if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || SdkConstants.CLASS_V4_FRAGMENT.isEquals(qualifiedName) || "android.content.res.TypedArray".equals(qualifiedName)) && name != null && name.startsWith("get") && !(args = call.getValueArguments()).isEmpty()) {
                        return this.getResource((UElement)args.get(0));
                    }
                }
            } else if (this.allowDereference && element instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)element).getSelector()) instanceof UCallExpression && (url = this.getResource((UElement)selector)) != null) {
                return url;
            }
        }
        if (element instanceof UReferenceExpression) {
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return url;
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)resolved;
                UExpression lastAssignment = UastLintUtils.findLastAssignment(variable, element);
                if (lastAssignment != null) {
                    return this.getResource((UElement)lastAssignment);
                }
                return null;
            }
        }
        return null;
    }

    public ResourceUrl getResource(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResource((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResource((PsiElement)expression.getElseExpression());
            }
        } else {
            if (element instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
                return this.getResource((PsiElement)parenthesizedExpression.getExpression());
            }
            if (element instanceof PsiMethodCallExpression && this.allowDereference) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                PsiReferenceExpression expression = call.getMethodExpression();
                PsiMethod method = call.resolveMethod();
                if (method != null && method.getContainingClass() != null) {
                    PsiExpression[] args;
                    String qualifiedName = method.getContainingClass().getQualifiedName();
                    String name = expression.getReferenceName();
                    if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || SdkConstants.CLASS_V4_FRAGMENT.isEquals(qualifiedName) || "android.content.res.TypedArray".equals(qualifiedName)) && name != null && name.startsWith("get") && (args = call.getArgumentList().getExpressions()).length > 0) {
                        return this.getResource((PsiElement)args[0]);
                    }
                }
            } else if (element instanceof PsiReference) {
                PsiLocalVariable variable;
                PsiExpression last;
                ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
                if (url != null) {
                    return url;
                }
                PsiElement resolved = ((PsiReference)element).resolve();
                if (resolved instanceof PsiField) {
                    url = ResourceEvaluator.getResourceConstant(resolved);
                    if (url != null) {
                        return url;
                    }
                    PsiField field = (PsiField)resolved;
                    if (field.getInitializer() != null) {
                        return this.getResource((PsiElement)field.getInitializer());
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(element, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                    return this.getResource((PsiElement)last);
                }
            }
        }
        return null;
    }

    public EnumSet<ResourceType> getResourceTypes(UElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof UIfExpression) {
            UIfExpression expression = (UIfExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (UElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResourceTypes((UElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResourceTypes((UElement)expression.getElseExpression());
            }
            EnumSet<ResourceType> left = this.getResourceTypes((UElement)expression.getThenExpression());
            EnumSet<ResourceType> right = this.getResourceTypes((UElement)expression.getElseExpression());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            EnumSet<ResourceType> copy = EnumSet.copyOf(left);
            copy.addAll(right);
            return copy;
        }
        if (element instanceof UParenthesizedExpression) {
            UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)element;
            return this.getResourceTypes((UElement)parenthesizedExpression.getExpression());
        }
        if (element instanceof UQualifiedReferenceExpression || element instanceof UCallExpression) {
            UElement probablyCallExpression = element;
            if (element instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression qualifiedExpression = (UQualifiedReferenceExpression)element;
                probablyCallExpression = qualifiedExpression.getSelector();
            }
            if (probablyCallExpression instanceof UCallExpression) {
                EnumSet<ResourceType> types;
                UCallExpression call = (UCallExpression)probablyCallExpression;
                PsiMethod method = call.resolve();
                if (method != null) {
                    types = this.getTypesFromAnnotations((PsiModifierListOwner)method);
                    if (types != null) {
                        return types;
                    }
                } else if (call.getKind() == UastCallKind.NESTED_ARRAY_INITIALIZER) {
                    types = EnumSet.noneOf(ResourceType.class);
                    for (UExpression argument : call.getValueArguments()) {
                        EnumSet<ResourceType> resourceTypes = this.getResourceTypes((UElement)argument);
                        if (resourceTypes == null || resourceTypes.isEmpty()) continue;
                        types.addAll(resourceTypes);
                    }
                    if (!types.isEmpty()) {
                        return types;
                    }
                }
            }
        } else if (element instanceof UBlockExpression) {
            List expressions = ((UBlockExpression)element).getExpressions();
            return this.getResourceTypes((UElement)CollectionsKt.lastOrNull((List)expressions));
        }
        if (element instanceof UReferenceExpression) {
            EnumSet<ResourceType> types;
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return EnumSet.of(url.type);
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiModifierListOwner && (types = this.getTypesFromAnnotations((PsiModifierListOwner)resolved)) != null && !types.isEmpty()) {
                return types;
            }
            if (resolved instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)resolved;
                UExpression lastAssignment = UastLintUtils.findLastAssignment(variable, element);
                if (lastAssignment != null) {
                    return this.getResourceTypes((UElement)lastAssignment);
                }
                return null;
            }
        }
        return null;
    }

    public EnumSet<ResourceType> getResourceTypes(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResourceTypes((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResourceTypes((PsiElement)expression.getElseExpression());
            }
            EnumSet<ResourceType> left = this.getResourceTypes((PsiElement)expression.getThenExpression());
            EnumSet<ResourceType> right = this.getResourceTypes((PsiElement)expression.getElseExpression());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            EnumSet<ResourceType> copy = EnumSet.copyOf(left);
            copy.addAll(right);
            return copy;
        }
        if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            return this.getResourceTypes((PsiElement)parenthesizedExpression.getExpression());
        }
        if (element instanceof PsiMethodCallExpression) {
            EnumSet<ResourceType> types;
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            PsiMethod method = call.resolveMethod();
            if (method != null && (types = this.getTypesFromAnnotations((PsiModifierListOwner)method)) != null) {
                return types;
            }
        } else if (element instanceof PsiReference) {
            PsiLocalVariable variable;
            PsiExpression last;
            EnumSet<ResourceType> types;
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return EnumSet.of(url.type);
            }
            PsiElement resolved = ((PsiReference)element).resolve();
            if (resolved instanceof PsiModifierListOwner && (types = this.getTypesFromAnnotations((PsiModifierListOwner)resolved)) != null && !types.isEmpty()) {
                return types;
            }
            if (resolved instanceof PsiField) {
                url = ResourceEvaluator.getResourceConstant(resolved);
                if (url != null) {
                    return EnumSet.of(url.type);
                }
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return this.getResourceTypes((PsiElement)field.getInitializer());
                }
                return null;
            }
            if (resolved instanceof PsiParameter) {
                return this.getTypesFromAnnotations((PsiModifierListOwner)((PsiParameter)resolved));
            }
            if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(element, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                return this.getResourceTypes((PsiElement)last);
            }
        }
        return null;
    }

    private EnumSet<ResourceType> getTypesFromAnnotations(PsiModifierListOwner owner) {
        if (this.evaluator == null) {
            return null;
        }
        return ResourceEvaluator.getTypesFromAnnotations(this.evaluator, owner);
    }

    public static EnumSet<ResourceType> getTypesFromAnnotations(JavaEvaluator evaluator, PsiModifierListOwner owner) {
        PsiElement origin;
        List<UAnnotation> annotations = evaluator.getAnnotations(owner, true, null);
        EnumSet<ResourceType> typeAnnotations = ResourceEvaluator.getTypesFromAnnotations(annotations);
        if ((typeAnnotations == null || typeAnnotations.isEmpty()) && owner instanceof KtLightMethod && (origin = LightClassUtilsKt.getUnwrapped((PsiElement)owner)) instanceof KtProperty) {
            ArrayList<UAnnotation> newAnnotations = null;
            List entries = ((KtProperty)origin).getAnnotationEntries();
            for (KtAnnotationEntry entry : entries) {
                UAnnotation converted = (UAnnotation)UastFacade.INSTANCE.convertElement((PsiElement)entry, null, UAnnotation.class);
                if (newAnnotations == null) {
                    newAnnotations = new ArrayList<UAnnotation>();
                }
                newAnnotations.add(converted);
            }
            if (newAnnotations != null) {
                return ResourceEvaluator.getTypesFromAnnotations(newAnnotations);
            }
        }
        return typeAnnotations;
    }

    public static EnumSet<ResourceType> getTypesFromAnnotations(List<UAnnotation> annotations) {
        EnumSet<ResourceType> resources = null;
        for (UAnnotation annotation : annotations) {
            ResourceType type = ResourceEvaluator.getTypeFromAnnotation(annotation);
            if (type == null) continue;
            if (type == ANY_RES_MARKER_TYPE) {
                return ResourceEvaluator.getAnyRes();
            }
            if (resources == null) {
                resources = EnumSet.of(type);
                continue;
            }
            resources.add(type);
        }
        return resources;
    }

    public static EnumSet<ResourceType> getTypesFromAnnotationList(List<AnnotationInfo> annotations) {
        EnumSet<ResourceType> resources = null;
        for (AnnotationInfo annotation : annotations) {
            ResourceType type = ResourceEvaluator.getTypeFromAnnotation(annotation.getAnnotation());
            if (type == null) continue;
            if (type == ANY_RES_MARKER_TYPE) {
                return ResourceEvaluator.getAnyRes();
            }
            if (resources == null) {
                resources = EnumSet.of(type);
                continue;
            }
            resources.add(type);
        }
        return resources;
    }

    public static ResourceType getTypeFromAnnotation(String signature) {
        return ResourceEvaluator.getTypeFromAnnotation(null, signature);
    }

    public static ResourceType getTypeFromAnnotation(UAnnotation annotation) {
        return ResourceEvaluator.getTypeFromAnnotation(annotation, annotation.getQualifiedName());
    }

    public static ResourceType getTypeFromAnnotation(UAnnotation annotation, String signature) {
        if (signature == null) {
            return null;
        }
        if (AndroidPlatformAnnotations.isPlatformAnnotation(signature)) {
            signature = AndroidPlatformAnnotations.toAndroidxAnnotation(signature);
        }
        if (COLOR_INT_ANNOTATION.isEquals(signature)) {
            return COLOR_INT_MARKER_TYPE;
        }
        if (PX_ANNOTATION.isEquals(signature)) {
            return DIMENSION_MARKER_TYPE;
        }
        if (DIMENSION_ANNOTATION.isEquals(signature)) {
            if (annotation != null) {
                UExpression unit = annotation.findAttributeValue("unit");
                if (unit instanceof UReferenceExpression) {
                    String name = null;
                    PsiElement resolved = ((UReferenceExpression)unit).resolve();
                    if (resolved instanceof PsiNamedElement) {
                        name = ((PsiNamedElement)resolved).getName();
                    } else {
                        UElement leaf = UastLintUtilsKt.findSelector((UElement)unit);
                        if (leaf instanceof USimpleNameReferenceExpression) {
                            name = ((USimpleNameReferenceExpression)leaf).getIdentifier();
                        }
                    }
                    if ("DP".equals(name)) {
                        return DIMENSION_DP_MARKER_TYPE;
                    }
                    if ("SP".equals(name)) {
                        return DIMENSION_SP_MARKER_TYPE;
                    }
                    if ("PX".equals(name)) {
                        return DIMENSION_MARKER_TYPE;
                    }
                    return null;
                }
                if (unit instanceof ULiteralExpression) {
                    return ResourceEvaluator.getDimensionFromIntValue(((ULiteralExpression)unit).getValue());
                }
                if (unit != null && unit.getSourcePsi() instanceof PsiLiteralExpression) {
                    PsiLiteralExpression psi = (PsiLiteralExpression)unit.getSourcePsi();
                    return ResourceEvaluator.getDimensionFromIntValue(psi.getValue());
                }
                if (unit instanceof UnknownJavaExpression) {
                    return null;
                }
            }
            return DIMENSION_MARKER_TYPE;
        }
        if (ANY_RES_ANNOTATION.isEquals(signature)) {
            return ANY_RES_MARKER_TYPE;
        }
        return ResourceEvaluator.getTypeFromAnnotationSignature(signature);
    }

    private static ResourceType getDimensionFromIntValue(Object value) {
        if (value instanceof Integer) {
            switch ((Integer)value) {
                case 0: {
                    return DIMENSION_DP_MARKER_TYPE;
                }
                case 1: {
                    return DIMENSION_MARKER_TYPE;
                }
                case 2: {
                    return DIMENSION_SP_MARKER_TYPE;
                }
            }
            return null;
        }
        return null;
    }

    public static ResourceType getTypeFromAnnotationSignature(String signature) {
        return (ResourceType)TYPE_FROM_ANNOTATION_SIGNATURE.get((Object)signature);
    }

    public static ResourceUrl getResourceConstant(PsiElement node) {
        PsiClass rClass;
        PsiField field;
        PsiClass typeClass;
        if (node instanceof PsiReferenceExpression) {
            PsiReferenceExpression reference;
            PsiReferenceExpression select;
            PsiReferenceExpression expression = (PsiReferenceExpression)node;
            if (expression.getQualifier() instanceof PsiReferenceExpression && (select = (PsiReferenceExpression)expression.getQualifier()).getQualifier() instanceof PsiReferenceExpression && "R".equals((reference = (PsiReferenceExpression)select.getQualifier()).getReferenceName())) {
                String typeName = select.getReferenceName();
                String name = expression.getReferenceName();
                ResourceType type = ResourceType.fromClassName((String)typeName);
                if (type != null && name != null) {
                    boolean isFramework = reference.getQualifier() instanceof PsiReferenceExpression && "android".equals(((PsiReferenceExpression)reference.getQualifier()).getReferenceName());
                    return ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework);
                }
            }
        } else if (node instanceof PsiField && (typeClass = (field = (PsiField)node).getContainingClass()) != null && (rClass = typeClass.getContainingClass()) != null && "R".equals(rClass.getName())) {
            String name = field.getName();
            ResourceType type = ResourceType.fromClassName((String)typeClass.getName());
            if (type != null && name != null) {
                String qualifiedName = rClass.getQualifiedName();
                boolean isFramework = qualifiedName != null && qualifiedName.startsWith("android.");
                return ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework);
            }
        }
        return null;
    }

    public static ResourceUrl getResourceConstant(UElement node) {
        ResourceReference reference = ResourceReference.get(node);
        if (reference == null || reference.getHeuristic()) {
            return null;
        }
        String name = reference.getName();
        ResourceType type = reference.getType();
        boolean isFramework = reference.getPackage().equals("android");
        return ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework);
    }

    public static EnumSet<ResourceType> getAnyRes() {
        EnumSet<ResourceType> types = EnumSet.allOf(ResourceType.class);
        types.remove(COLOR_INT_MARKER_TYPE);
        types.remove(DIMENSION_MARKER_TYPE);
        types.remove(DIMENSION_SP_MARKER_TYPE);
        types.remove(DIMENSION_DP_MARKER_TYPE);
        types.remove(ANY_RES_MARKER_TYPE);
        return types;
    }
}

