/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import java.io.File;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/detector/api/GradleContext;", "Lcom/android/tools/lint/detector/api/Context;", "gradleVisitor", "Lcom/android/tools/lint/client/api/GradleVisitor;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/GradleVisitor;Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;)V", "getGradleVisitor", "()Lcom/android/tools/lint/client/api/GradleVisitor;", "getLocation", "Lcom/android/tools/lint/detector/api/Location;", "cookie", "", "getPropertyKeyCookie", "getPropertyPairCookie", "isSuppressedWithComment", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "report", "", "location", "message", "", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "Companion", "lint-api"})
public final class GradleContext
extends Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleVisitor gradleVisitor;
    private static final Pattern DIGITS = Pattern.compile("\\d+");

    public GradleContext(@NotNull GradleVisitor gradleVisitor, @NotNull LintDriver driver, @NotNull Project project, @Nullable Project main, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)gradleVisitor, (String)"gradleVisitor");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(driver, project, main, file, null, 16, null);
        this.gradleVisitor = gradleVisitor;
    }

    @NotNull
    public final GradleVisitor getGradleVisitor() {
        return this.gradleVisitor;
    }

    @NotNull
    public final Location getLocation(@NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return this.gradleVisitor.createLocation(this, cookie);
    }

    public final boolean isSuppressedWithComment(@NotNull Object cookie, @NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        int startOffset = this.gradleVisitor.getStartOffset(this, cookie);
        return startOffset >= 0 && this.isSuppressedWithComment(startOffset, issue);
    }

    @Deprecated(message="unused", replaceWith=@ReplaceWith(expression="cookie", imports={}))
    @NotNull
    public final Object getPropertyKeyCookie(@NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return cookie;
    }

    @Deprecated(message="unused", replaceWith=@ReplaceWith(expression="cookie", imports={}))
    @NotNull
    public final Object getPropertyPairCookie(@NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        return cookie;
    }

    public final void report(@NotNull Issue issue, @NotNull Object cookie, @NotNull Location location2, @NotNull String message2, @Nullable LintFix fix) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Incident incident = new Incident(issue, cookie, location2, message2, fix);
        LintClient.report$default(this.getDriver().getClient(), this, incident, null, 4, null);
    }

    public static /* synthetic */ void report$default(GradleContext gradleContext, Issue issue, Object object, Location location2, String string, LintFix lintFix, int n, Object object2) {
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        gradleContext.report(issue, object, location2, string, lintFix);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/detector/api/GradleContext$Companion;", "", "()V", "DIGITS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getIntLiteralValue", "", "value", "", "defaultValue", "getStringLiteralValue", "isNonNegativeInteger", "", "token", "isStringLiteral", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getStringLiteralValue(@NotNull String value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value.length() > 2 && (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null))) {
                String string2 = value;
                int n = 1;
                int n2 = value.length() - 1;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = null;
            }
            return string;
        }

        public final int getIntLiteralValue(@NotNull String value, int defaultValue) {
            int n;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                n = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                n = defaultValue;
            }
            return n;
        }

        public final boolean isNonNegativeInteger(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return DIGITS.matcher(token).matches();
        }

        public final boolean isStringLiteral(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return StringsKt.startsWith$default((String)token, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)token, (String)"\"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)token, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)token, (String)"'", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

