/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelVariant;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016J-\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0(\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010)J+\u0010*\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0(\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010+\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020\rH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020/H\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010\r2\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u000202H\u0016J#\u00103\u001a\b\u0012\u0004\u0012\u00020$0(2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u00106J\u001e\u00103\u001a\b\u0012\u0004\u0012\u000208072\u0006\u00104\u001a\u0002092\u0006\u00105\u001a\u00020\u0010H\u0016J\u0014\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010<\u001a\u00020 H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020;H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u000e2\u0006\u0010@\u001a\u00020/H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u000e2\u0006\u0010@\u001a\u000202H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010A\u001a\u0004\u0018\u00010\u00052\u0006\u0010B\u001a\u00020CJ\u0012\u0010D\u001a\u0004\u0018\u00010\r2\u0006\u0010<\u001a\u00020 H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020;H\u0016J\u0014\u0010E\u001a\u0004\u0018\u00010 2\b\u0010F\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010G\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010H\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\"\u0010I\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "myProject", "Lcom/intellij/openapi/project/Project;", "myLintProject", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/lint/detector/api/Project;)V", "dependencies", "Lcom/android/tools/lint/model/LintModelDependencies;", "getDependencies", "()Lcom/android/tools/lint/model/LintModelDependencies;", "packageInfoCache", "", "", "Lcom/intellij/psi/PsiPackage;", "areSignaturesEqual", "", "method1", "Lcom/intellij/psi/PsiMethod;", "method2", "computeArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "erasure", "Lcom/intellij/psi/PsiType;", "type", "extendsClass", "cls", "Lcom/intellij/psi/PsiClass;", "className", "strict", "findAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "listOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "annotationNames", "", "(Lcom/intellij/psi/PsiModifierListOwner;[Ljava/lang/String;)Lcom/intellij/psi/PsiAnnotation;", "findAnnotationInHierarchy", "findClass", "qualifiedName", "findJarPath", "element", "Lcom/intellij/psi/PsiElement;", "containingFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/uast/UElement;", "getAllAnnotations", "owner", "inHierarchy", "(Lcom/intellij/psi/PsiModifierListOwner;Z)[Lcom/intellij/psi/PsiAnnotation;", "", "Lorg/jetbrains/uast/UAnnotation;", "Lorg/jetbrains/uast/UAnnotated;", "getClassType", "Lcom/intellij/psi/PsiClassType;", "psiClass", "getInternalName", "psiClassType", "getPackage", "node", "getProject", "file", "Ljava/io/File;", "getQualifiedName", "getTypeClass", "psiType", "implementsInterface", "interfaceName", "inheritsFrom", "lint-api"})
public class DefaultJavaEvaluator
extends JavaEvaluator {
    @Nullable
    private final com.intellij.openapi.project.Project myProject;
    @Nullable
    private final Project myLintProject;
    @NotNull
    private final Map<String, PsiPackage> packageInfoCache;

    public DefaultJavaEvaluator(@Nullable com.intellij.openapi.project.Project myProject, @Nullable Project myLintProject) {
        this.myProject = myProject;
        this.myLintProject = myLintProject;
        boolean bl = false;
        this.packageInfoCache = new LinkedHashMap();
    }

    @Override
    @Nullable
    public LintModelDependencies getDependencies() {
        LintModelVariant variant;
        if (this.myLintProject != null && this.myLintProject.isAndroidProject() && (variant = this.myLintProject.getBuildVariant()) != null) {
            return variant.getMainArtifact().getDependencies();
        }
        return null;
    }

    @Override
    public boolean extendsClass(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    public boolean implementsInterface(@NotNull PsiClass cls, @NotNull String interfaceName, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)cls, (String)"cls");
        Intrinsics.checkParameterIsNotNull((Object)interfaceName, (String)"interfaceName");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)interfaceName);
    }

    @Override
    public boolean inheritsFrom(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        PsiClass psiClass = cls;
        if (psiClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName) {
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        com.intellij.openapi.project.Project project = this.myProject;
        if (project == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findClass(qualifiedName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)this.myProject));
    }

    @Override
    @Nullable
    public PsiClassType getClassType(@Nullable PsiClass psiClass) {
        return this.myProject != null && psiClass != null ? JavaPsiFacade.getElementFactory((com.intellij.openapi.project.Project)this.myProject).createType(psiClass) : null;
    }

    @Override
    @Nullable
    public PsiClass getTypeClass(@Nullable PsiType psiType) {
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        return psiClassType == null ? null : psiClassType.resolve();
    }

    @Override
    @NotNull
    public List<UAnnotation> getAllAnnotations(@NotNull UAnnotated owner, boolean inHierarchy) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        if (owner instanceof UDeclaration) {
            List annotations = owner.getUAnnotations();
            PsiAnnotation[] psiAnnotations = this.getAllAnnotations(((UDeclaration)owner).getPsi(), inHierarchy);
            PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])annotations;
            boolean bl = false;
            if (!psiAnnotationArray.isEmpty()) {
                List list2;
                Object object;
                psiAnnotationArray = psiAnnotations;
                bl = false;
                if (psiAnnotationArray.length == 0) {
                    return annotations;
                }
                boolean modified = false;
                LinkedHashMap map = new LinkedHashMap();
                for (UAnnotation annotation : annotations) {
                    String string;
                    Object object2 = annotation.getQualifiedName();
                    if (object2 == null) {
                        String string2;
                        object = annotation.getUastAnchor();
                        String string3 = string2 = object == null ? null : object.getName();
                        if (string2 == null) continue;
                        string = string2;
                    } else {
                        string = object2;
                    }
                    String name = string;
                    object2 = map;
                    boolean bl2 = false;
                    object2.put(name, annotation);
                }
                for (PsiAnnotation psi : psiAnnotations) {
                    Object signature;
                    String string = psi.getQualifiedName();
                    if (string == null || map.get(signature = (object = string)) != null) continue;
                    object = map;
                    string = JavaUAnnotation.Companion.wrap(psi);
                    boolean bl3 = false;
                    object.put(signature, string);
                    modified = true;
                }
                if (modified) {
                    Collection collection = map.values();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"map.values");
                    list2 = CollectionsKt.toList((Iterable)collection);
                } else {
                    list2 = annotations;
                }
                return list2;
            }
            return JavaUAnnotation.Companion.wrap(psiAnnotations);
        }
        return owner.getUAnnotations();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        if (owner instanceof UDeclaration) {
            return this.getAllAnnotations(((UDeclaration)owner).getPsi(), inHierarchy);
        }
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"getAllAnnotations(owner, inHierarchy, null, false)");
        return psiAnnotationArray;
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, String ... annotationNames) {
        Intrinsics.checkParameterIsNotNull((Object)listOwner, (String)"listOwner");
        Intrinsics.checkParameterIsNotNull((Object)annotationNames, (String)"annotationNames");
        if (listOwner instanceof UDeclaration) {
            PsiModifierListOwner psiModifierListOwner = ((UDeclaration)listOwner).getPsi();
            String[] stringArray = new String[annotationNames.length];
            System.arraycopy(annotationNames, 0, stringArray, 0, annotationNames.length);
            return this.findAnnotationInHierarchy(psiModifierListOwner, stringArray);
        }
        Object[] objectArray = new String[annotationNames.length];
        System.arraycopy(annotationNames, 0, objectArray, 0, annotationNames.length);
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)listOwner, (Set)Sets.newHashSet((Object[])objectArray));
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        Intrinsics.checkParameterIsNotNull((Object)annotationNames, (String)"annotationNames");
        if (listOwner instanceof UDeclaration) {
            PsiModifierListOwner psiModifierListOwner = ((UDeclaration)listOwner).getPsi();
            String[] stringArray = new String[annotationNames.length];
            System.arraycopy(annotationNames, 0, stringArray, 0, annotationNames.length);
            return this.findAnnotation(psiModifierListOwner, stringArray);
        }
        String[] stringArray = new String[annotationNames.length];
        System.arraycopy(annotationNames, 0, stringArray, 0, annotationNames.length);
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (boolean)false, (String[])stringArray);
    }

    @Override
    public boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        Intrinsics.checkParameterIsNotNull((Object)method1, (String)"method1");
        Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method2");
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)method1, (PsiMethod)method2);
    }

    @Override
    @Nullable
    public Project getProject(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Object object = element.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = object == null ? null : object.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile;
        object = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile3);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"virtualToIoFile(virtualFile)");
        Object file = object;
        return this.getProject((File)file);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Project getProject(@NotNull File file) {
        Object v1;
        void $this$maxBy$iv;
        LintClient lintClient;
        Collection<Project> collection;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Project project = this.myLintProject;
        Collection<Project> collection2 = project == null ? null : (collection = (lintClient = project.getClient()) == null ? null : lintClient.getKnownProjects());
        if (collection == null) {
            return null;
        }
        Collection<Project> projects = collection;
        if (projects.isEmpty()) {
            return null;
        }
        String path2 = file.getPath();
        project = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)projects), (Function1)((Function1)new Function1<Project, Boolean>(path2){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Project it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)this.$path, (Object)it.getDir().getPath())) return true;
                String string = this.$path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
                if (!StringsKt.startsWith$default((String)string, (String)Intrinsics.stringPlus((String)it.getDir().getPath(), (Object)File.separator), (boolean)false, (int)2, null)) return false;
                return true;
            }
        }));
        boolean $i$f$maxBy = false;
        void $this$maxByOrNull$iv$iv = $this$maxBy$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v1 = maxElem$iv$iv;
            } else {
                Project it = (Project)maxElem$iv$iv;
                boolean bl = false;
                int maxValue$iv$iv = it.getDir().getPath().length();
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    Project it2 = (Project)e$iv$iv;
                    $i$a$-maxBy-DefaultJavaEvaluator$getProject$2 = false;
                    int v$iv$iv = it2.getDir().getPath().length();
                    if (maxValue$iv$iv >= v$iv$iv) continue;
                    maxElem$iv$iv = e$iv$iv;
                    maxValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v1 = maxElem$iv$iv;
            }
        }
        return v1;
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiFile containingFile = element.getContainingFile();
        return this.findJarPath(containingFile);
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull UElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        UFile uFile = UastUtils.getContainingUFile((UElement)element);
        return uFile != null ? this.findJarPath(uFile.getSourcePsi()) : null;
    }

    private final String findJarPath(PsiFile containingFile) {
        VirtualFile file;
        if (containingFile instanceof PsiCompiledFile && (file = ((PsiCompiledFile)containingFile).getVirtualFile()) != null && Intrinsics.areEqual((Object)file.getFileSystem().getProtocol(), (Object)"jar")) {
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            String path2 = string;
            int separatorIndex = StringsKt.indexOf$default((CharSequence)path2, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (separatorIndex >= 0) {
                String string2 = path2;
                int n = 0;
                boolean bl = false;
                String string3 = string2.substring(n, separatorIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull PsiElement node) {
        PsiFile containingFile;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PsiFile psiFile = node instanceof PsiFile ? (PsiFile)node : null;
        PsiFile psiFile2 = containingFile = psiFile == null ? node.getContainingFile() : psiFile;
        if (containingFile != null) {
            if (containingFile instanceof PsiJavaFile) {
                return this.packageInfoCache.computeIfAbsent(((PsiJavaFile)containingFile).getPackageName(), new Function<String, PsiPackage>(this, node){
                    final /* synthetic */ DefaultJavaEvaluator this$0;
                    final /* synthetic */ PsiElement $node;
                    {
                        this.this$0 = $receiver;
                        this.$node = $node;
                    }

                    @NotNull
                    public final PsiPackage apply(@NotNull String name) {
                        PsiClass cls;
                        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                        PsiClass psiClass = cls = this.this$0.findClass(Intrinsics.stringPlus((String)name, (Object)".package-info"));
                        PsiModifierList modifierList = psiClass == null ? null : psiClass.getModifierList();
                        psiClass = this.$node.getManager();
                        return (PsiPackage)new PsiPackageImpl(modifierList, name, (PsiManager)psiClass){
                            final /* synthetic */ PsiModifierList $modifierList;
                            final /* synthetic */ String $name;
                            {
                                this.$modifierList = $modifierList;
                                this.$name = $name;
                                super($super_call_param$1, $name);
                            }

                            @Nullable
                            public PsiModifierList getAnnotationList() {
                                return this.$modifierList != null ? (PsiModifierList)new PsiCompositeModifierList(this.getManager(), CollectionsKt.listOf((Object)this.$modifierList)) : null;
                            }
                        };
                    }
                });
            }
            PsiDirectory dir = containingFile.getParent();
            if (dir != null) {
                return JavaDirectoryService.getInstance().getPackage(dir);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull UElement node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        UFile uFile = UastUtils.getContainingUFile((UElement)node);
        return uFile != null ? this.getPackage((PsiElement)uFile.getPsi()) : null;
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClassType psiClassType) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)psiClassType, (String)"psiClassType");
        PsiType erased = this.erasure((PsiType)psiClassType);
        if (erased instanceof PsiClassType) {
            PsiClassType psiClassType2 = (PsiClassType)erased;
            string = super.getQualifiedName(psiClassType2);
        } else {
            string = super.getQualifiedName(psiClassType);
        }
        return string;
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        return psiClass.getQualifiedName();
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClassType psiClassType) {
        Intrinsics.checkParameterIsNotNull((Object)psiClassType, (String)"psiClassType");
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getInternalName((PsiClassType)erased) : super.getInternalName(psiClassType);
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        return Lint.getInternalName(psiClass);
    }

    @Override
    @Nullable
    public PsiType erasure(@Nullable PsiType type) {
        return TypeConversionUtil.erasure((PsiType)type);
    }

    @Override
    @NotNull
    public Map<UExpression, PsiParameter> computeArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        int n;
        boolean bl;
        Object object;
        Object parameter;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        PsiParameterList parameterList = psiParameterList;
        if (parameterList.getParametersCount() == 0) {
            return MapsKt.emptyMap();
        }
        Map<UExpression, PsiParameter> kotlinMap = Lint.computeKotlinArgumentMapping(call, method);
        if (kotlinMap != null) {
            return kotlinMap;
        }
        List arguments = call.getValueArguments();
        Object[] parameters = parameterList.getParameters();
        int j = 0;
        Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"parameters");
        Object object2 = (PsiParameter)ArraysKt.firstOrNull((Object[])parameters);
        String first = object2 == null ? null : object2.getName();
        object2 = first;
        if ((Intrinsics.areEqual(object2 == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)object2, (String)"$this", (boolean)false, (int)2, null)), (Object)true) || Intrinsics.areEqual((object2 = first) == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)object2, (String)"$self", (boolean)false, (int)2, null)), (Object)true)) && Lint.isKotlin(call.getSourcePsi())) {
            int n2 = j;
            j = n2 + 1;
        }
        int i = 0;
        int n3 = Math.min(parameters.length, arguments.size());
        HashMap map = new HashMap(2 * n3);
        while (j < n3) {
            UExpression argument = (UExpression)arguments.get(i);
            parameter = parameters[j];
            Map map2 = map;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"parameter");
            object = parameter;
            bl = false;
            map2.put(argument, object);
            n = i;
            i = n + 1;
            n = j;
            j = n + 1;
        }
        if (i < arguments.size() && j > 0) {
            int argument = j;
            j = argument + -1;
            while (i < arguments.size()) {
                UExpression argument2 = (UExpression)arguments.get(i);
                parameter = parameters[j];
                Map map3 = map;
                Intrinsics.checkExpressionValueIsNotNull((Object)parameter, (String)"parameter");
                object = parameter;
                bl = false;
                map3.put(argument2, object);
                n = i;
                i = n + 1;
            }
        }
        return map;
    }
}

