/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api.interprocedural;

import com.android.tools.lint.detector.api.interprocedural.CallGraph;
import com.android.tools.lint.detector.api.interprocedural.CallTarget;
import com.android.tools.lint.detector.api.interprocedural.ClassHierarchy;
import com.android.tools.lint.detector.api.interprocedural.DispatchReceiverEvaluator;
import com.android.tools.lint.detector.api.interprocedural.DispatchReceiverEvaluatorKt;
import com.android.tools.lint.detector.api.interprocedural.MutableCallGraph;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u0013H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0018H\u0002J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u0018H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraphVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "receiverEval", "Lcom/android/tools/lint/detector/api/interprocedural/DispatchReceiverEvaluator;", "classHierarchy", "Lcom/android/tools/lint/detector/api/interprocedural/ClassHierarchy;", "conservative", "", "(Lcom/android/tools/lint/detector/api/interprocedural/DispatchReceiverEvaluator;Lcom/android/tools/lint/detector/api/interprocedural/ClassHierarchy;Z)V", "callGraph", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "getCallGraph", "()Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "mutableCallGraph", "Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph;", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitElement", "Lorg/jetbrains/uast/UElement;", "constructors", "", "Lorg/jetbrains/uast/UMethod;", "isCallable", "isStaticallyDispatched", "ExplicitSuperConstructorCallFinder", "lint-api"})
public final class CallGraphVisitor
extends AbstractUastVisitor {
    private final MutableCallGraph mutableCallGraph;
    private final DispatchReceiverEvaluator receiverEval;
    private final ClassHierarchy classHierarchy;
    private final boolean conservative;

    @NotNull
    public final CallGraph getCallGraph() {
        return this.mutableCallGraph;
    }

    public boolean visitElement(@NotNull UElement node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        UElement uElement = node;
        if (uElement instanceof UMethod || uElement instanceof ULambdaExpression) {
            this.mutableCallGraph.getNode(node);
        }
        return super.visitElement(node);
    }

    public boolean visitClass(@NotNull UClass node) {
        UClass superClass;
        UClass uClass;
        PsiElement $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        UClass uClass2 = node.getSuperClass();
        PsiElement psiElement = $receiver$iv = uClass2 != null && (uClass2 = uClass2.getPsi()) != null ? uClass2.getNavigationElement() : null;
        if (psiElement != null) {
            PsiElement psiElement2;
            PsiElement it$iv = psiElement2 = psiElement;
            uClass = (UClass)((UastContext)ServiceManager.getService((Project)$receiver$iv.getProject(), UastContext.class)).convertElementWithParent($receiver$iv, UClass.class);
        } else {
            uClass = null;
        }
        if ((superClass = uClass) != null) {
            Object object;
            Object object2;
            Collection callers;
            block6: {
                Object it;
                Object element$iv$iv2;
                Collection $receiver$iv$iv;
                Iterable $receiver$iv2;
                List<UMethod> constructors = this.constructors(node);
                Iterable $i$a$1$let = $receiver$iv2 = (Iterable)constructors;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv2 : $receiver$iv$iv) {
                    it = (UMethod)element$iv$iv2;
                    ExplicitSuperConstructorCallFinder explicitSuperFinder = new ExplicitSuperConstructorCallFinder();
                    it.accept((UastVisitor)explicitSuperFinder);
                    boolean bl = !explicitSuperFinder.getFoundExplicitCall();
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                List thoseWithoutExplicitSuper = (List)destination$iv$iv;
                $receiver$iv$iv = constructors;
                callers = !$receiver$iv$iv.isEmpty() ? (Collection)thoseWithoutExplicitSuper : (Collection)CollectionsKt.listOf((Object)node);
                Object object3 = object2 = (Iterable)this.constructors(superClass);
                element$iv$iv2 = object3.iterator();
                while (element$iv$iv2.hasNext()) {
                    it = element$iv$iv2.next();
                    Object it2 = it;
                    if (!it2.getUastParameters().isEmpty()) continue;
                    object = it;
                    break block6;
                }
                object = null;
            }
            UMethod uMethod = object;
            UElement callee = uMethod != null ? (UElement)uMethod : (UElement)superClass;
            Object $receiver = object2 = this.mutableCallGraph;
            MutableCallGraph.MutableNode calleeNode = ((MutableCallGraph)$receiver).getNode(callee);
            Iterable $receiver$iv3 = callers;
            for (Object element$iv : $receiver$iv3) {
                UElement it = (UElement)element$iv;
                ((MutableCallGraph)$receiver).getNode(it).getEdges().add(new CallGraph.Edge(calleeNode, null, CallGraph.Edge.Kind.DIRECT));
            }
        }
        return super.visitClass(node);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Object v8;
        boolean isFunctionalCall;
        boolean throughSuper;
        boolean staticallyDispatched;
        List overrides;
        UMethod baseCallee;
        Function2<UElement, CallGraph.Edge.Kind, Unit> addEdge$;
        MutableCallGraph.MutableNode mutableNode;
        Collection collection;
        block30: {
            UMethod uMethod;
            CallTarget it;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterator iterator;
            Iterable containingClass;
            Collection collection2;
            UAnnotated parent;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UAnnotated uAnnotated = parent = (UAnnotated)UastUtils.getParentOfType((UElement)((UElement)node), (boolean)true, UMethod.class, (Class[])new Class[]{ULambdaExpression.class, UClassInitializer.class, UField.class});
            if (uAnnotated instanceof UMethod || uAnnotated instanceof ULambdaExpression) {
                collection2 = CollectionsKt.listOf((Object)parent);
            } else if (uAnnotated instanceof UClassInitializer || uAnnotated instanceof UField) {
                UAnnotated uAnnotated2 = parent;
                if (uAnnotated2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UDeclaration");
                }
                UDeclaration decl = (UDeclaration)uAnnotated2;
                if (decl.isStatic()) {
                    return super.visitCallExpression(node);
                }
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)decl));
                if (uClass == null) {
                    return super.visitCallExpression(node);
                }
                containingClass = uClass;
                List<UMethod> ctors = this.constructors((UClass)containingClass);
                iterator = ctors;
                collection2 = !iterator.isEmpty() ? (Collection)ctors : (Collection)CollectionsKt.listOf((Object)containingClass);
            } else {
                return super.visitCallExpression(node);
            }
            Collection callers = collection2;
            containingClass = $receiver$iv = (Iterable)callers;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                UElement uElement = (UElement)item$iv$iv;
                collection = destination$iv$iv;
                mutableNode = this.mutableCallGraph.getNode((UElement)it);
                collection.add(mutableNode);
            }
            List callerNodes = (List)destination$iv$iv;
            addEdge$ = new Function2<UElement, CallGraph.Edge.Kind, Unit>(this, node, callerNodes){
                final /* synthetic */ CallGraphVisitor this$0;
                final /* synthetic */ UCallExpression $node;
                final /* synthetic */ List $callerNodes;

                public final void invoke(@Nullable UElement callee, @NotNull CallGraph.Edge.Kind kind) {
                    MutableCallGraph.MutableNode mutableNode;
                    Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
                    UElement uElement = callee;
                    if (uElement != null) {
                        UElement uElement2;
                        UElement it = uElement2 = uElement;
                        mutableNode = CallGraphVisitor.access$getMutableCallGraph$p(this.this$0).getNode(it);
                    } else {
                        mutableNode = null;
                    }
                    MutableCallGraph.MutableNode calleeNode = mutableNode;
                    CallGraph.Edge edge = new CallGraph.Edge(calleeNode, this.$node, kind);
                    Iterable $receiver$iv = this.$callerNodes;
                    for (T element$iv : $receiver$iv) {
                        MutableCallGraph.MutableNode it = (MutableCallGraph.MutableNode)element$iv;
                        it.getEdges().add(edge);
                    }
                }
                {
                    this.this$0 = callGraphVisitor;
                    this.$node = uCallExpression;
                    this.$callerNodes = list2;
                    super(2);
                }
            };
            Object $receiver$iv2 = (PsiElement)node.resolve();
            PsiElement psiElement = $receiver$iv2;
            if (psiElement != null) {
                Iterator it$iv = iterator = psiElement;
                uMethod = (UMethod)((UastContext)ServiceManager.getService((Project)$receiver$iv2.getProject(), UastContext.class)).convertElementWithParent((PsiElement)$receiver$iv2, UMethod.class);
            } else {
                uMethod = null;
            }
            if ((baseCallee = uMethod) == null) {
                if (UastExpressionUtils.isConstructorCall((UElement)((UElement)node))) {
                    UReferenceExpression uReferenceExpression = node.getClassReference();
                    UElement uElement = UastContextKt.toUElement(uReferenceExpression != null && (uReferenceExpression = uReferenceExpression.resolve()) != null ? uReferenceExpression.getNavigationElement() : null);
                    if (!(uElement instanceof UClass)) {
                        uElement = null;
                    }
                    UClass uClass = (UClass)uElement;
                    if (uClass == null) {
                        return super.visitCallExpression(node);
                    }
                    UClass constructedClass = uClass;
                    addEdge$.invoke((UElement)constructedClass, CallGraph.Edge.Kind.DIRECT);
                } else if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"invoke")) {
                    addEdge$.invoke(null, CallGraph.Edge.Kind.INVOKE);
                    $receiver$iv2 = DispatchReceiverEvaluatorKt.getTargets(node, this.receiverEval);
                    iterator = $receiver$iv2.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        it = (CallTarget)element$iv;
                        addEdge$.invoke(it.getElement(), CallGraph.Edge.Kind.TYPE_EVIDENCED);
                    }
                }
                return super.visitCallExpression(node);
            }
            overrides = SequencesKt.toList(this.classHierarchy.allOverridesOf(baseCallee));
            staticallyDispatched = this.isStaticallyDispatched(baseCallee);
            throughSuper = node.getReceiver() instanceof USuperExpression;
            isFunctionalCall = Intrinsics.areEqual((Object)baseCallee.getPsi(), (Object)LambdaUtil.getFunctionalInterfaceMethod((PsiType)node.getReceiverType()));
            Iterable $receiver$iv3 = CollectionsKt.plus((Collection)overrides, (Object)baseCallee);
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv3) {
                UMethod it2 = (UMethod)element$iv;
                if (!this.isCallable(it2)) continue;
                if (found$iv) {
                    v8 = null;
                    break block30;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v8 = !found$iv ? null : single$iv;
        }
        UMethod uniqueImpl = v8;
        if (staticallyDispatched || throughSuper) {
            addEdge$.invoke((UElement)baseCallee, CallGraph.Edge.Kind.DIRECT);
        } else if (uniqueImpl != null && !isFunctionalCall) {
            if (Intrinsics.areEqual((Object)uniqueImpl, (Object)baseCallee) ^ true) {
                addEdge$.invoke((UElement)baseCallee, CallGraph.Edge.Kind.BASE);
            }
            addEdge$.invoke((UElement)uniqueImpl, CallGraph.Edge.Kind.UNIQUE);
        } else {
            Object it;
            UMethod it3;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Object element$iv;
            Iterable found$iv = $receiver$iv = (Iterable)DispatchReceiverEvaluatorKt.getTargets(node, this.receiverEval);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            element$iv = $receiver$iv$iv.iterator();
            while (element$iv.hasNext()) {
                Object item$iv$iv = element$iv.next();
                CallTarget $i$a$1$singleOrNull = (CallTarget)item$iv$iv;
                collection = destination$iv$iv;
                mutableNode = it3.getElement();
                collection.add(mutableNode);
            }
            List evidencedTargets = (List)destination$iv$iv;
            $receiver$iv = evidencedTargets;
            for (Object element$iv2 : $receiver$iv) {
                it = (UElement)element$iv2;
                addEdge$.invoke((UElement)it, CallGraph.Edge.Kind.TYPE_EVIDENCED);
            }
            if (!evidencedTargets.contains(baseCallee)) {
                addEdge$.invoke((UElement)baseCallee, CallGraph.Edge.Kind.BASE);
            }
            if (this.conservative) {
                $receiver$iv = overrides;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                it = $receiver$iv$iv.iterator();
                while (it.hasNext()) {
                    Object element$iv$iv = it.next();
                    it3 = (UMethod)element$iv$iv;
                    if (!(!evidencedTargets.contains(it3) && this.isCallable(it3))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv2 : $receiver$iv) {
                    it = (UMethod)element$iv2;
                    addEdge$.invoke((UElement)it, CallGraph.Edge.Kind.NON_UNIQUE_OVERRIDE);
                }
            }
        }
        return super.visitCallExpression(node);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UMethod> constructors(@NotNull UClass $receiver) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Object[] objectArray = $receiver$iv = (Object[])$receiver.getMethods();
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            UMethod it = (UMethod)element$iv$iv;
            if (!it.isConstructor()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallable(@NotNull UMethod $receiver) {
        if ($receiver.hasModifierProperty("abstract")) {
            return false;
        }
        PsiClass psiClass = $receiver.getContainingClass();
        if (psiClass == null) return true;
        if (!psiClass.isInterface()) return true;
        boolean bl = $receiver.hasModifierProperty("default");
        return bl;
    }

    private final boolean isStaticallyDispatched(@NotNull UMethod $receiver) {
        PsiClass psiClass = $receiver.getContainingClass();
        if (psiClass == null) {
            return true;
        }
        PsiClass parentClass = psiClass;
        return $receiver.isConstructor() || $receiver.isStatic() || $receiver.isFinal() || Intrinsics.areEqual((Object)$receiver.getVisibility(), (Object)UastVisibility.PRIVATE) || parentClass instanceof PsiAnonymousClass || parentClass.hasModifierProperty("final");
    }

    public CallGraphVisitor(@NotNull DispatchReceiverEvaluator receiverEval, @NotNull ClassHierarchy classHierarchy, boolean conservative) {
        Intrinsics.checkParameterIsNotNull((Object)receiverEval, (String)"receiverEval");
        Intrinsics.checkParameterIsNotNull((Object)classHierarchy, (String)"classHierarchy");
        this.receiverEval = receiverEval;
        this.classHierarchy = classHierarchy;
        this.conservative = conservative;
        this.mutableCallGraph = new MutableCallGraph();
    }

    public /* synthetic */ CallGraphVisitor(DispatchReceiverEvaluator dispatchReceiverEvaluator, ClassHierarchy classHierarchy, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(dispatchReceiverEvaluator, classHierarchy, bl);
    }

    @NotNull
    public static final /* synthetic */ MutableCallGraph access$getMutableCallGraph$p(CallGraphVisitor $this) {
        return $this.mutableCallGraph;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/CallGraphVisitor$ExplicitSuperConstructorCallFinder;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "()V", "foundExplicitCall", "", "getFoundExplicitCall", "()Z", "setFoundExplicitCall", "(Z)V", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "lint-api"})
    private static final class ExplicitSuperConstructorCallFinder
    extends AbstractUastVisitor {
        private boolean foundExplicitCall;

        public final boolean getFoundExplicitCall() {
            return this.foundExplicitCall;
        }

        public final void setFoundExplicitCall(boolean bl) {
            this.foundExplicitCall = bl;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"super")) {
                this.foundExplicitCall = true;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return true;
        }
    }
}

