/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.AnnotationLookup;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006Jh\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J0\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J5\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010#\u001a\u00020$2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020&0%2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010'J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010#\u001a\u00020$2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0016\u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0019J\u0016\u0010*\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010.\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010/\u001a\u000200J\u0016\u00101\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u000202J\u0016\u00103\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00104\u001a\u000205R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/tools/lint/client/api/AnnotationHandler;", "", "scanners", "Lcom/google/common/collect/Multimap;", "", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "(Lcom/google/common/collect/Multimap;)V", "annotationLookup", "Lcom/android/tools/lint/client/api/AnnotationLookup;", "relevantAnnotations", "", "getRelevantAnnotations", "()Ljava/util/Set;", "checkAnnotations", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "argument", "Lorg/jetbrains/uast/UElement;", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "method", "Lcom/intellij/psi/PsiMethod;", "annotations", "", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "packageAnnotations", "checkCall", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkContextAnnotations", "origCall", "filterRelevantAnnotations", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;[Lcom/intellij/psi/PsiAnnotation;Lorg/jetbrains/uast/UElement;)Ljava/util/List;", "visitAnnotation", "annotation", "visitArrayAccessExpression", "expression", "Lorg/jetbrains/uast/UArrayAccessExpression;", "visitCallExpression", "visitEnumConstant", "constant", "Lorg/jetbrains/uast/UEnumConstant;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "visitVariable", "variable", "Lorg/jetbrains/uast/UVariable;", "lint-api"})
public final class AnnotationHandler {
    @NotNull
    private final Set<String> relevantAnnotations;
    private final AnnotationLookup annotationLookup;
    private final Multimap<String, SourceCodeScanner> scanners;

    @NotNull
    public final Set<String> getRelevantAnnotations() {
        return this.relevantAnnotations;
    }

    private final void checkContextAnnotations(JavaContext context2, PsiMethod method, UElement origCall, List<? extends UAnnotation> allMethodAnnotations) {
        UElement call = origCall;
        UElement uElement = Lint.skipParentheses(call.getUastParent());
        if (uElement == null) {
            return;
        }
        UElement p = uElement;
        if (p instanceof UQualifiedReferenceExpression) {
            call = p;
            UElement uElement2 = p.getUastParent();
            if (uElement2 == null) {
                return;
            }
            p = uElement2;
        }
        if (p instanceof UBinaryExpression) {
            UExpression check = null;
            UElement binary = p;
            if (call == ((UBinaryExpression)binary).getLeftOperand()) {
                check = ((UBinaryExpression)binary).getRightOperand();
            } else if (call == ((UBinaryExpression)binary).getRightOperand()) {
                check = ((UBinaryExpression)binary).getLeftOperand();
            }
            if (check != null) {
                UastBinaryOperator uastBinaryOperator = ((UBinaryExpression)p).getOperator();
                AnnotationHandler.checkAnnotations$default(this, context2, (UElement)check, Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.ASSIGN) ? AnnotationUsageType.ASSIGNMENT : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) || Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS) || Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS) || Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS) ? AnnotationUsageType.EQUALITY : AnnotationUsageType.BINARY), method, allMethodAnnotations, null, null, null, 224, null);
            }
        } else if (p instanceof UQualifiedReferenceExpression) {
            List arguments;
            UExpression selector;
            UQualifiedReferenceExpression ref = (UQualifiedReferenceExpression)p;
            if (Intrinsics.areEqual((Object)"equals", (Object)ref.getResolvedName()) && (selector = ref.getSelector()) instanceof UCallExpression && (arguments = ((UCallExpression)selector).getValueArguments()).size() == 1) {
                AnnotationHandler.checkAnnotations$default(this, context2, (UElement)arguments.get(0), AnnotationUsageType.EQUALITY, method, allMethodAnnotations, null, null, null, 224, null);
            }
        } else if (UastExpressionUtils.isAssignment((UElement)p)) {
            UElement uElement3 = p;
            if (uElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UBinaryExpression");
            }
            UBinaryExpression assignment = (UBinaryExpression)uElement3;
            UExpression rExpression = assignment.getRightOperand();
            AnnotationHandler.checkAnnotations$default(this, context2, (UElement)rExpression, AnnotationUsageType.ASSIGNMENT, method, allMethodAnnotations, null, null, null, 224, null);
        } else if (call instanceof UVariable) {
            UElement variable = call;
            PsiVariable variablePsi = ((UVariable)call).getPsi();
            UMethod uMethod = UastUtils.getContainingUMethod((UElement)call);
            if (uMethod != null) {
                uMethod.accept((UastVisitor)new AbstractUastVisitor(this, variable, variablePsi, context2, method, allMethodAnnotations){
                    final /* synthetic */ AnnotationHandler this$0;
                    final /* synthetic */ UElement $variable;
                    final /* synthetic */ PsiVariable $variablePsi;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ PsiMethod $method;
                    final /* synthetic */ List $allMethodAnnotations;

                    public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                        UExpression expression;
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        PsiElement resolved = node.resolve();
                        if ((Intrinsics.areEqual((Object)this.$variable, (Object)resolved) || Intrinsics.areEqual((Object)this.$variablePsi, (Object)resolved)) && (expression = (UExpression)UastUtils.getParentOfType((UElement)((UElement)node), UExpression.class, (boolean)true)) != null) {
                            UExpression uExpression = (UExpression)UastUtils.getParentOfType((UElement)((UElement)node), UExpression.class, (boolean)false);
                            if (uExpression == null) {
                                return false;
                            }
                            UExpression inner = uExpression;
                            AnnotationHandler.checkAnnotations$default(this.this$0, this.$context, (UElement)inner, AnnotationUsageType.VARIABLE_REFERENCE, this.$method, this.$allMethodAnnotations, null, null, null, 224, null);
                            return false;
                        }
                        return super.visitSimpleNameReferenceExpression(node);
                    }
                    {
                        this.this$0 = $outer;
                        this.$variable = $captured_local_variable$1;
                        this.$variablePsi = $captured_local_variable$2;
                        this.$context = $captured_local_variable$3;
                        this.$method = $captured_local_variable$4;
                        this.$allMethodAnnotations = $captured_local_variable$5;
                    }
                });
            }
            UExpression initializer = ((UVariable)variable).getUastInitializer();
            if (initializer != null) {
                AnnotationHandler.checkAnnotations$default(this, context2, (UElement)initializer, AnnotationUsageType.ASSIGNMENT, null, allMethodAnnotations, null, null, null, 224, null);
            }
        }
    }

    private final void checkAnnotations(JavaContext context2, UElement argument, AnnotationUsageType type, PsiMethod method, List<? extends UAnnotation> annotations, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, List<? extends UAnnotation> packageAnnotations) {
        for (UAnnotation uAnnotation : annotations) {
            String signature;
            if (uAnnotation.getQualifiedName() == null) {
                continue;
            }
            Collection uastScanners = this.scanners.get((Object)signature);
            if (uastScanners == null) continue;
            for (SourceCodeScanner scanner : uastScanners) {
                if (!scanner.isApplicableAnnotationUsage(type)) continue;
                scanner.visitAnnotationUsage(context2, argument, type, uAnnotation, signature, method, annotations, allMethodAnnotations, allClassAnnotations, packageAnnotations);
            }
        }
    }

    static /* bridge */ /* synthetic */ void checkAnnotations$default(AnnotationHandler annotationHandler, JavaContext javaContext, UElement uElement, AnnotationUsageType annotationUsageType, PsiMethod psiMethod, List list2, List list3, List list4, List list5, int n, Object object) {
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        annotationHandler.checkAnnotations(javaContext, uElement, annotationUsageType, psiMethod, list2, list3, list4, list5);
    }

    public final void visitMethod(@NotNull JavaContext context2, @NotNull UMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context2.getEvaluator();
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((UAnnotated)method, true));
        Collection collection = methodAnnotations;
        if (!collection.isEmpty()) {
            UExpression body = method.getUastBody();
            if (body != null && !(body instanceof UBlockExpression) && !(body instanceof UReturnExpression)) {
                AnnotationHandler.checkAnnotations$default(this, context2, (UElement)body, AnnotationUsageType.METHOD_RETURN, (PsiMethod)method, methodAnnotations, methodAnnotations, null, null, 192, null);
            } else {
                method.accept((UastVisitor)new AbstractUastVisitor(this, context2, method, methodAnnotations){
                    final /* synthetic */ AnnotationHandler this$0;
                    final /* synthetic */ JavaContext $context;
                    final /* synthetic */ UMethod $method;
                    final /* synthetic */ List $methodAnnotations;

                    public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        UExpression returnValue = node.getReturnExpression();
                        if (returnValue != null) {
                            AnnotationHandler.checkAnnotations$default(this.this$0, this.$context, (UElement)returnValue, AnnotationUsageType.METHOD_RETURN, (PsiMethod)this.$method, this.$methodAnnotations, this.$methodAnnotations, null, null, 192, null);
                        }
                        return super.visitReturnExpression(node);
                    }
                    {
                        this.this$0 = $outer;
                        this.$context = $captured_local_variable$1;
                        this.$method = $captured_local_variable$2;
                        this.$methodAnnotations = $captured_local_variable$3;
                    }
                });
            }
        }
    }

    public final void visitCallExpression(@NotNull JavaContext context2, @NotNull UCallExpression call) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        PsiMethod method = call.resolve();
        if (method != null) {
            this.checkCall(context2, method, call);
        }
    }

    public final void visitAnnotation(@NotNull JavaContext context2, @NotNull UAnnotation annotation) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null || StringsKt.startsWith$default((String)qualifiedName, (String)"java.", (boolean)false, (int)2, null) || SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(qualifiedName)) {
            return;
        }
        List attributeValues = annotation.getAttributeValues();
        if (attributeValues.isEmpty()) {
            return;
        }
        PsiClass psiClass = annotation.resolve();
        if (psiClass == null) {
            return;
        }
        PsiClass resolved = psiClass;
        for (UNamedExpression expression : attributeValues) {
            String name;
            PsiMethod[] methods;
            String string = expression.getName();
            if (string == null) {
                string = "value";
            }
            if (((Object[])(methods = resolved.findMethodsByName(name = string, false))).length != 1) continue;
            PsiMethod method = methods[0];
            JavaEvaluator evaluator = context2.getEvaluator();
            PsiMethod psiMethod = method;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
            List methodAnnotations = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)psiMethod, true), null, 4, null);
            Collection collection = methodAnnotations;
            if (!(!collection.isEmpty())) continue;
            UExpression value = expression.getExpression();
            AnnotationHandler.checkAnnotations$default(this, context2, (UElement)value, AnnotationUsageType.ANNOTATION_REFERENCE, method, methodAnnotations, methodAnnotations, null, null, 192, null);
        }
    }

    public final void visitEnumConstant(@NotNull JavaContext context2, @NotNull UEnumConstant constant) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)constant, (String)"constant");
        PsiMethod method = constant.resolveMethod();
        if (method != null) {
            this.checkCall(context2, method, (UCallExpression)constant);
        }
    }

    public final void visitArrayAccessExpression(@NotNull JavaContext context2, @NotNull UArrayAccessExpression expression) {
        PsiAnnotation[] allAnnotations;
        JavaEvaluator evaluator;
        List<UAnnotation> methodAnnotations;
        Collection collection;
        PsiElement resolved;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        UExpression arrayExpression = expression.getReceiver();
        if (arrayExpression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)arrayExpression).resolve()) instanceof PsiModifierListOwner && !(collection = (Collection)(methodAnnotations = this.filterRelevantAnnotations(evaluator = context2.getEvaluator(), allAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)resolved, true), (UElement)expression))).isEmpty()) {
            this.checkContextAnnotations(context2, null, (UElement)expression, methodAnnotations);
        }
    }

    public final void visitVariable(@NotNull JavaContext context2, @NotNull UVariable variable) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        JavaEvaluator evaluator = context2.getEvaluator();
        PsiVariable psi = variable.getPsi();
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)psi, true), (UElement)variable);
        Collection collection = methodAnnotations;
        if (!collection.isEmpty()) {
            this.checkContextAnnotations(context2, null, (UElement)variable, methodAnnotations);
        }
    }

    private final void checkCall(JavaContext context2, PsiMethod method, UCallExpression call) {
        Map<UExpression, PsiParameter> mapping;
        List pkgAnnotations;
        List<UAnnotation> classAnnotations;
        JavaEvaluator evaluator = context2.getEvaluator();
        PsiAnnotation[] allAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, true);
        List<UAnnotation> methodAnnotations = this.filterRelevantAnnotations(evaluator, allAnnotations, (UElement)call);
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            List list2;
            PsiAnnotation[] annotations = evaluator.getAllAnnotations((PsiModifierListOwner)containingClass, true);
            classAnnotations = this.filterRelevantAnnotations(evaluator, annotations, (UElement)call);
            PsiPackage pkg = evaluator.getPackage((PsiElement)containingClass);
            if (pkg != null) {
                PsiAnnotation[] annotations2 = evaluator.getAllAnnotations((PsiModifierListOwner)pkg, false);
                list2 = AnnotationHandler.filterRelevantAnnotations$default(this, evaluator, annotations2, null, 4, null);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            pkgAnnotations = list2;
        } else {
            classAnnotations = CollectionsKt.emptyList();
            pkgAnnotations = CollectionsKt.emptyList();
        }
        if (!methodAnnotations.isEmpty()) {
            this.checkAnnotations(context2, (UElement)call, AnnotationUsageType.METHOD_CALL, method, methodAnnotations, methodAnnotations, classAnnotations, pkgAnnotations);
            this.checkContextAnnotations(context2, method, (UElement)call, methodAnnotations);
        }
        if (!classAnnotations.isEmpty()) {
            this.checkAnnotations(context2, (UElement)call, AnnotationUsageType.METHOD_CALL_CLASS, method, classAnnotations, methodAnnotations, classAnnotations, pkgAnnotations);
        }
        if (!pkgAnnotations.isEmpty()) {
            this.checkAnnotations(context2, (UElement)call, AnnotationUsageType.METHOD_CALL_PACKAGE, method, pkgAnnotations, methodAnnotations, classAnnotations, pkgAnnotations);
        }
        Map<UExpression, PsiParameter> map = mapping = evaluator.computeArgumentMapping(call, method);
        Iterator<Map.Entry<UExpression, PsiParameter>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UExpression, PsiParameter> entry;
            Map.Entry<UExpression, PsiParameter> entry2 = entry = iterator.next();
            UExpression argument = entry2.getKey();
            entry2 = entry;
            PsiParameter parameter = entry2.getValue();
            PsiAnnotation[] allParameterAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)parameter, true);
            List<UAnnotation> filtered = this.filterRelevantAnnotations(evaluator, allParameterAnnotations, (UElement)call);
            if (filtered.isEmpty()) continue;
            this.checkAnnotations(context2, (UElement)argument, AnnotationUsageType.METHOD_CALL_PARAMETER, method, filtered, methodAnnotations, classAnnotations, pkgAnnotations);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations, UElement context2) {
        List result = null;
        int length = ((Object[])annotations).length;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        for (int i = 0; i < annotations.length; ++i) {
            PsiJavaCodeReferenceElement ref;
            PsiAnnotation annotation = annotations[i];
            String signature = annotation.getQualifiedName();
            if (signature == null || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null) && !this.relevantAnnotations.contains(signature)) continue;
            if (this.relevantAnnotations.contains(signature)) {
                UAnnotation uAnnotation = JavaUAnnotation.Companion.wrap(annotation);
                if (length == 1) {
                    return CollectionsKt.listOf((Object)uAnnotation);
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(uAnnotation);
                continue;
            }
            if (annotation.getNameReferenceElement() == null) {
                continue;
            }
            PsiElement cls = ref.resolve();
            if (!(cls instanceof PsiClass) || !((PsiClass)cls).isAnnotationType()) continue;
            PsiAnnotation[] innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false);
            int n = 0;
            int n2 = innerAnnotations.length;
            while (n < n2) {
                void j;
                PsiAnnotation inner = innerAnnotations[j];
                String a = inner.getQualifiedName();
                if (a != null && this.relevantAnnotations.contains(a)) {
                    if (result == null) {
                        result = new ArrayList(2);
                    }
                    UAnnotation innerU = this.annotationLookup.findRealAnnotation(inner, (PsiClass)cls, context2);
                    result.add(innerU);
                }
                ++j;
            }
        }
        List list2 = result;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    static /* bridge */ /* synthetic */ List filterRelevantAnnotations$default(AnnotationHandler annotationHandler, JavaEvaluator javaEvaluator, PsiAnnotation[] psiAnnotationArray, UElement uElement, int n, Object object) {
        if ((n & 4) != 0) {
            uElement = null;
        }
        return annotationHandler.filterRelevantAnnotations(javaEvaluator, psiAnnotationArray, uElement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<UAnnotation> filterRelevantAnnotations(JavaEvaluator evaluator, List<? extends UAnnotation> annotations) {
        List result = null;
        int length = annotations.size();
        if (length == 0) {
            return annotations;
        }
        for (UAnnotation annotation : annotations) {
            String signature = annotation.getQualifiedName();
            if (signature == null || StringsKt.startsWith$default((String)signature, (String)"java.", (boolean)false, (int)2, null) && !this.relevantAnnotations.contains(signature)) continue;
            if (this.relevantAnnotations.contains(signature)) {
                if (length == 1) {
                    return annotations;
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(annotation);
                continue;
            }
            PsiClass cls = annotation.resolve();
            if (cls == null || !cls.isAnnotationType()) continue;
            PsiAnnotation[] innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false);
            int n = 0;
            int n2 = innerAnnotations.length;
            while (n < n2) {
                void j;
                PsiAnnotation inner = innerAnnotations[j];
                String a = inner.getQualifiedName();
                if (a != null && this.relevantAnnotations.contains(a)) {
                    if (result == null) {
                        result = new ArrayList(2);
                    }
                    UAnnotation innerU = AnnotationLookup.findRealAnnotation$default(this.annotationLookup, inner, cls, null, 4, null);
                    result.add(innerU);
                }
                ++j;
            }
        }
        return result != null ? result : CollectionsKt.emptyList();
    }

    public AnnotationHandler(@NotNull Multimap<String, SourceCodeScanner> scanners) {
        Intrinsics.checkParameterIsNotNull(scanners, (String)"scanners");
        this.scanners = scanners;
        this.relevantAnnotations = new HashSet((Collection)this.scanners.keys());
        this.annotationLookup = new AnnotationLookup();
    }
}

