/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Density
implements Comparable<Density>,
ResourceEnum,
Serializable {
    public static final Density XXXHIGH = new Density("xxxhdpi", "XXX-High Density", 640, 18);
    public static final Density XXHIGH = new Density("xxhdpi", "XX-High Density", 480, 16);
    public static final Density XHIGH = new Density("xhdpi", "X-High Density", 320, 8);
    public static final Density HIGH = new Density("hdpi", "High Density", 240, 4);
    public static final Density TV = new Density("tvdpi", "TV Density", 213, 13);
    public static final Density MEDIUM = new Density("mdpi", "Medium Density", 160, 4);
    public static final Density LOW = new Density("ldpi", "Low Density", 120, 4);
    public static final Density ANYDPI = new Density("anydpi", "Any Density", 65534, 21);
    public static final Density NODPI = new Density("nodpi", "No Density", 65535, 4);
    private static final Density[] values = new Density[]{XXXHIGH, XXHIGH, XHIGH, HIGH, TV, MEDIUM, LOW, ANYDPI, NODPI};
    public static final int DEFAULT_DENSITY = MEDIUM.getDpiValue();
    private static final Map<String, Density> densityByValue = Maps.newHashMap();
    private static final Pattern sDensityPattern = Pattern.compile("^(\\d+)dpi$");
    private static final long serialVersionUID = 1L;
    private final String mValue;
    private final String mDisplayValue;
    private final int mDpi;
    private final int mSince;

    @NotNull
    public static Density create(int dpi) {
        Density density = Density.getEnum(dpi);
        if (density != null) {
            return density;
        }
        return new Density(dpi);
    }

    public static Density create(String value) {
        Density density = Density.getEnum(value);
        if (density != null) {
            return density;
        }
        Matcher m = sDensityPattern.matcher(value);
        if (!m.matches()) {
            return null;
        }
        String dpiString = m.group(1);
        try {
            int dpi = Integer.parseInt(dpiString);
            density = Density.getEnum(dpi);
            if (density == null) {
                density = new Density(dpi);
            }
            return density;
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Density(int density) {
        this.mValue = density + "dpi";
        this.mDisplayValue = this.mValue;
        this.mDpi = density;
        this.mSince = 1;
    }

    private Density(String value, String displayValue, int density, int since) {
        this.mValue = value;
        this.mDisplayValue = displayValue;
        this.mDpi = density;
        this.mSince = since;
    }

    public int hashCode() {
        return this.mDpi;
    }

    public boolean equals(Object otherInstance) {
        if (!(otherInstance instanceof Density)) {
            return false;
        }
        Density other = (Density)otherInstance;
        return this.mValue.equals(other.mValue) && this.mDisplayValue.equals(other.mDisplayValue) && this.mDpi == other.mDpi && this.mSince == other.mSince;
    }

    public String toString() {
        return this.mDisplayValue;
    }

    @Override
    public int compareTo(@NotNull Density other) {
        return other.mDpi - this.mDpi;
    }

    @NotNull
    public static Density[] values() {
        return values;
    }

    public static Density getEnum(String value) {
        return densityByValue.get(value);
    }

    public static Density getEnum(int dpiValue) {
        Collection<Density> densities = densityByValue.values();
        for (Density density : densities) {
            if (density.mDpi != dpiValue) continue;
            return density;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    public int getDpiValue() {
        return this.mDpi;
    }

    public int since() {
        return this.mSince;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mDisplayValue;
    }

    public static Set<Density> getRecommendedValuesForDevice() {
        HashSet<Density> densities = new HashSet<Density>(densityByValue.values());
        densities.remove(TV);
        densities.remove(NODPI);
        densities.remove(ANYDPI);
        return densities;
    }

    public boolean isRecommended() {
        return densityByValue.containsValue(this) && this != TV;
    }

    @Override
    public boolean isValidValueForDevice() {
        return this != NODPI && this != ANYDPI;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    static {
        for (Density density : values) {
            densityByValue.put(density.mValue, density);
        }
    }
}

