/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.ide.common.rendering.api;

public class AndroidConstants {

    public static final String NULL_RESOURCE = "@null";

    public static final String ANDROID_NS_NAME = "android";

    public static final String ANDROID_URI = "http://schemas.android.com/apk/res/android";

    public static final String TOOLS_NS_NAME = "tools";

    public static final String TOOLS_URI = "http://schemas.android.com/tools";

    public static final String URI_PREFIX = "http://schemas.android.com/apk/res/";

    public static final String AAPT_URI = "http://schemas.android.com/aapt";

    public static final String AUTO_URI = "http://schemas.android.com/apk/res-auto";

    public static final String URI_DOMAIN_PREFIX = "http://schemas.android.com/";

    public static final String TAG_DECLARE_STYLEABLE = "declare-styleable";

    public static final String TAG_PUBLIC = "public";

    public static final String TAG_EAT_COMMENT = "eat-comment";

    public static final String TAG_ITEM = "item";

    public static final String ATTR_TYPE = "type";

    public static final String PREFIX_THEME_REF = "?";

    public static final String PREFIX_RESOURCE_REF = "@";

    public static final String REFERENCE_STYLE = "style/";

    public static final String APP_PREFIX = "app";

    public static final String ANDROID_PKG = "android";

    public static final String ATTR_VISIBILITY = "visibility";

    public static final String ATTR_LAYOUT_WIDTH = "layout_width";

    public static final String ATTR_LAYOUT_HEIGHT = "layout_height";

    public static final String VALUE_MATCH_PARENT = "match_parent";

    public static final String DOT_XML = ".xml";
}
