/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.java.generate;

import com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.java.generate.JavaUastCodeGenerationPluginKt;
import org.jetbrains.uast.java.generate.JavaUastElementFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J7\u0010\u001f\u001a\u0004\u0018\u0001H \"\b\b\u0000\u0010 *\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u0002H 2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H 0%H\u0016\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006("}, d2={"Lorg/jetbrains/uast/java/generate/JavaUastCodeGenerationPlugin;", "Lorg/jetbrains/uast/generate/UastCodeGenerationPlugin;", "()V", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "adjustChainStyleToMethodCalls", "", "oldPsi", "Lcom/intellij/psi/PsiElement;", "newPsi", "bindToElement", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "element", "cleanupMethodCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "methodCall", "getElementFactory", "Lorg/jetbrains/uast/generate/UastElementFactory;", "project", "Lcom/intellij/openapi/project/Project;", "importMemberOnDemand", "Lorg/jetbrains/uast/UExpression;", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "initializeField", "uField", "Lorg/jetbrains/uast/UField;", "uParameter", "Lorg/jetbrains/uast/UParameter;", "replace", "T", "Lorg/jetbrains/uast/UElement;", "oldElement", "newElement", "elementType", "Ljava/lang/Class;", "(Lorg/jetbrains/uast/UElement;Lorg/jetbrains/uast/UElement;Ljava/lang/Class;)Lorg/jetbrains/uast/UElement;", "shortenReference", "intellij.java.uast"})
public final class JavaUastCodeGenerationPlugin
implements UastCodeGenerationPlugin {
    @Override
    @NotNull
    public UastElementFactory getElementFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new JavaUastElementFactory(project);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaLanguage, (String)"INSTANCE");
        return (Language)javaLanguage;
    }

    private final PsiMethodCallExpression cleanupMethodCall(PsiMethodCallExpression methodCall) {
        PsiType[] psiTypeArray = methodCall.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"methodCall.typeArguments");
        if (!(((Object[])psiTypeArray).length == 0)) {
            PsiMethod psiMethod = methodCall.resolveMethod();
            if (psiMethod == null) {
                return methodCall;
            }
            PsiMethod resolved2 = psiMethod;
            if (methodCall.getTypeArguments().length == resolved2.getTypeParameters().length && PsiDiamondTypeUtil.areTypeArgumentsRedundant((PsiType[])methodCall.getTypeArguments(), (PsiExpression)((PsiExpression)methodCall), (boolean)false, (PsiMethod)resolved2, (PsiTypeParameter[])resolved2.getTypeParameters())) {
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)methodCall.getProject()).createExpressionFromText("foo()", null);
                Intrinsics.checkNotNull((Object)psiExpression, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
                PsiMethodCallExpression emptyTypeArgumentsMethodCall = (PsiMethodCallExpression)psiExpression;
                methodCall.getTypeArgumentList().replace((PsiElement)emptyTypeArgumentsMethodCall.getTypeArgumentList());
            }
        }
        PsiElement psiElement = JavaCodeStyleManager.getInstance((Project)methodCall.getProject()).shortenClassReferences((PsiElement)methodCall);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        return (PsiMethodCallExpression)psiElement;
    }

    private final void adjustChainStyleToMethodCalls(PsiElement oldPsi, PsiElement newPsi) {
        if (oldPsi instanceof PsiMethodCallExpression && newPsi instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)oldPsi).getMethodExpression().getQualifierExpression() != null && ((PsiMethodCallExpression)newPsi).getMethodExpression().getQualifier() != null) {
            PsiElement[] psiElementArray = ((PsiMethodCallExpression)oldPsi).getMethodExpression().getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"oldPsi.methodExpression.children");
            if (ArraysKt.getOrNull((Object[])psiElementArray, (int)1) instanceof PsiWhiteSpace) {
                PsiElement[] psiElementArray2 = ((PsiMethodCallExpression)newPsi).getMethodExpression().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"newPsi.methodExpression.children");
                if (!(ArraysKt.getOrNull((Object[])psiElementArray2, (int)1) instanceof PsiWhiteSpace)) {
                    ((PsiMethodCallExpression)newPsi).getMethodExpression().addAfter(((PsiMethodCallExpression)oldPsi).getMethodExpression().getChildren()[1], ((PsiMethodCallExpression)newPsi).getMethodExpression().getChildren()[0]);
                }
            }
        }
    }

    @Override
    @Nullable
    public <T extends UElement> T replace(@NotNull UElement oldElement, @NotNull T newElement, @NotNull Class<T> elementType) {
        Object t;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)oldElement, (String)"oldElement");
        Intrinsics.checkNotNullParameter(newElement, (String)"newElement");
        Intrinsics.checkNotNullParameter(elementType, (String)"elementType");
        PsiElement psiElement2 = oldElement.getSourcePsi();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement oldPsi = psiElement2;
        PsiElement psiElement3 = newElement.getSourcePsi();
        if (psiElement3 == null) {
            return null;
        }
        PsiElement newPsi = psiElement3;
        this.adjustChainStyleToMethodCalls(oldPsi, newPsi);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)oldPsi.getProject());
        PsiElement updOldPsi = (newPsi instanceof PsiBlockStatement || newPsi instanceof PsiCodeBlock) && oldPsi.getParent() instanceof PsiExpressionStatement ? oldPsi.getParent() : oldPsi;
        if (updOldPsi instanceof PsiStatement && newPsi instanceof PsiExpression) {
            Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"factory");
            PsiStatement psiStatement = JavaUastCodeGenerationPluginKt.access$createExpressionStatement(factory, (PsiExpression)newPsi);
            if (psiStatement == null) {
                return null;
            }
            psiElement = (PsiElement)psiStatement;
        } else if (updOldPsi instanceof PsiCodeBlock && newPsi instanceof PsiBlockStatement) {
            PsiCodeBlock psiCodeBlock = ((PsiBlockStatement)newPsi).getCodeBlock();
            Intrinsics.checkNotNullExpressionValue((Object)psiCodeBlock, (String)"newPsi.codeBlock");
            psiElement = (PsiElement)psiCodeBlock;
        } else {
            psiElement = newPsi;
        }
        PsiElement updNewPsi = psiElement;
        PsiElement replaced = updOldPsi.replace(updNewPsi);
        if (replaced instanceof PsiExpressionStatement) {
            Class[] classArray = new Class[]{elementType};
            t = UastContextKt.toUElementOfExpectedTypes((PsiElement)((PsiExpressionStatement)replaced).getExpression(), classArray);
        } else if (replaced instanceof PsiMethodCallExpression) {
            Class[] classArray = new Class[]{elementType};
            t = UastContextKt.toUElementOfExpectedTypes((PsiElement)this.cleanupMethodCall((PsiMethodCallExpression)replaced), classArray);
        } else if (replaced instanceof PsiReferenceExpression) {
            Class[] classArray = new Class[]{elementType};
            t = UastContextKt.toUElementOfExpectedTypes(JavaCodeStyleManager.getInstance((Project)((PsiReferenceExpression)replaced).getProject()).shortenClassReferences(replaced), classArray);
        } else {
            Class[] classArray = new Class[]{elementType};
            t = UastContextKt.toUElementOfExpectedTypes(replaced, classArray);
        }
        return t;
    }

    @Override
    @Nullable
    public PsiElement bindToElement(@NotNull UReferenceExpression reference, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = reference.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourceReference = psiElement;
        if (!(sourceReference instanceof PsiReference)) {
            return null;
        }
        return ((PsiReference)sourceReference).bindToElement(element);
    }

    @Override
    @Nullable
    public UReferenceExpression shortenReference(@NotNull UReferenceExpression reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        PsiElement psiElement = reference.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourceReference = psiElement;
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)sourceReference.getProject());
        PsiElement $this$toUElementOfType$iv = styleManager.shortenClassReferences(sourceReference);
        boolean $i$f$toUElementOfType = false;
        return UastContextKt.toUElement($this$toUElementOfType$iv, UReferenceExpression.class);
    }

    @Override
    @Nullable
    public UExpression importMemberOnDemand(@NotNull UQualifiedReferenceExpression reference) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        PsiElement psiElement = reference.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement source = psiElement;
        PsiElement psiElement2 = source;
        if (psiElement2 instanceof PsiMethodCallExpression) {
            pair = TuplesKt.to((Object)((PsiMethodCallExpression)source).getMethodExpression().getQualifierExpression(), (Object)((PsiMethodCallExpression)source).getMethodExpression());
        } else if (psiElement2 instanceof PsiReferenceExpression) {
            pair = TuplesKt.to((Object)((PsiReferenceExpression)source).getQualifier(), (Object)((PsiReferenceExpression)source).getReferenceNameElement());
        } else {
            return null;
        }
        Pair pair2 = pair;
        PsiElement qualifier = (PsiElement)pair2.component1();
        PsiElement selector2 = (PsiElement)pair2.component2();
        if (qualifier == null || selector2 == null) {
            return null;
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)selector2);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(selector)");
        SmartPsiElementPointer ptr = smartPsiElementPointer;
        PsiElement $this$childrenOfType$iv = qualifier;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, PsiIdentifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(this, T::class.java)");
        PsiIdentifier psiIdentifier = (PsiIdentifier)CollectionsKt.firstOrNull((List)list);
        if (psiIdentifier == null) {
            return null;
        }
        PsiIdentifier qualifierIdentifier = psiIdentifier;
        AddOnDemandStaticImportAction.invoke((Project)source.getProject(), (PsiFile)source.getContainingFile(), null, (PsiElement)((PsiElement)qualifierIdentifier));
        PsiElement psiElement3 = ptr.getElement();
        PsiElement $this$toUElementOfType$iv = psiElement3 != null ? psiElement3.getParent() : null;
        boolean $i$f$toUElementOfType = false;
        return UastContextKt.toUElement($this$toUElementOfType$iv, UExpression.class);
    }

    @Override
    public void initializeField(@NotNull UField uField, @NotNull UParameter uParameter) {
        Intrinsics.checkNotNullParameter((Object)uField, (String)"uField");
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        UMethod uMethod = UastUtils.getParentOfType(uParameter, UMethod.class, false);
        if (uMethod == null) {
            return;
        }
        UMethod uMethod2 = uMethod;
        PsiElement psiElement = uMethod2.getSourcePsi();
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        PsiCodeBlock psiCodeBlock = psiMethod2.getBody();
        if (psiCodeBlock == null) {
            return;
        }
        PsiCodeBlock body2 = psiCodeBlock;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiMethod2.getProject()).getElementFactory();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getInstance(psiMethod.project).elementFactory");
        PsiElementFactory elementFactory = psiElementFactory;
        String prefix = Intrinsics.areEqual((Object)uField.getName(), (Object)uParameter.getName()) ? "this." : "";
        PsiStatement psiStatement = elementFactory.createStatementFromText(prefix + uField.getName() + " = " + uParameter.getName() + ";", (PsiElement)psiMethod2);
        Intrinsics.checkNotNullExpressionValue((Object)psiStatement, (String)"elementFactory.createSta\u2026meter.name};\", psiMethod)");
        PsiStatement statement = psiStatement;
        PsiElement lastBodyElement = body2.getLastBodyElement();
        if (lastBodyElement instanceof PsiWhiteSpace) {
            ((PsiWhiteSpace)lastBodyElement).replace((PsiElement)statement);
        } else {
            body2.add((PsiElement)statement);
        }
    }
}

