/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsReifiedNativeChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "js.frontend"})
public final class JsReifiedNativeChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtTypeArgumentList ktTypeArgumentList = resolvedCall2.getCall().getTypeArgumentList();
        List<KtTypeProjection> typeArgumentList = ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null;
        Map<TypeParameterDescriptor, KotlinType> map = resolvedCall2.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getTypeArguments(...)");
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : map.entrySet()) {
            ClassifierDescriptor typeArgDescriptor;
            TypeParameterDescriptor typeParam = entry.getKey();
            KotlinType typeArg = entry.getValue();
            if (!typeParam.isReified() || (typeArgDescriptor = typeArg.getConstructor().getDeclarationDescriptor()) == null || !AnnotationsUtils.isNativeInterface(typeArgDescriptor)) continue;
            KtElement typeArgumentPsi = typeArgumentList != null ? (KtElement)typeArgumentList.get(typeParam.getIndex()).getTypeReference() : resolvedCall2.getCall().getCallElement();
            BindingTrace bindingTrace = context.getTrace();
            KtElement ktElement = typeArgumentPsi;
            Intrinsics.checkNotNull((Object)ktElement);
            bindingTrace.report(ErrorsJs.EXTERNAL_INTERFACE_AS_REIFIED_TYPE_ARGUMENT.on((PsiElement)ktElement, typeArg));
        }
    }
}

