/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@PhaseDescription(name="RestoreInlineLambda", description="Traverse INLINE_LAMBDA blocks and restore original expression before converting it into inline lambda.This is required because JVM will not convert these lambdas into classes otherwise.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RestoreInlineLambda;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "backend.jvm.lower"})
public final class RestoreInlineLambda
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public RestoreInlineLambda(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getEnableIrInliner()) {
            irFile.transform((IrElementTransformer)this, (Object)null);
        }
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.isInline()) {
            for (IrValueParameter parameter : declaration.getValueParameters()) {
                IrBlock lambda;
                if (!IrInlineUtilsKt.isInlineParameter$default(parameter, null, 1, null)) continue;
                IrExpressionBody irExpressionBody = parameter.getDefaultValue();
                IrExpression irExpression = irExpressionBody != null ? irExpressionBody.getExpression() : null;
                if ((irExpression instanceof IrBlock ? (IrBlock)irExpression : null) == null) continue;
                lambda = lambda;
                Object object = CollectionsKt.first(lambda.getStatements());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                IrFunction function2 = (IrFunction)object;
                Object object2 = CollectionsKt.last(lambda.getStatements());
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference reference2 = (IrFunctionReference)object2;
                IrAttributeContainer irAttributeContainer = reference2.getAttributeOwnerId();
                Intrinsics.checkNotNull((Object)irAttributeContainer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                IrExpression original = (IrExpression)irAttributeContainer;
                if (original instanceof IrFunctionExpression) {
                    function2.setOrigin(IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA());
                    reference2.setOrigin(((IrFunctionExpression)original).getOrigin());
                    continue;
                }
                if (!(original instanceof IrCallableReference)) continue;
                IrExpressionBody irExpressionBody2 = parameter.getDefaultValue();
                if (irExpressionBody2 != null) {
                    irExpressionBody2.setExpression(original);
                }
            }
        }
        return super.visitFunction(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getSUSPEND_CONVERSION())) {
            Object object = CollectionsKt.first(expression2.getStatements());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
            IrFunction function2 = (IrFunction)object;
            function2.setOrigin(IrDeclarationOrigin.Companion.getADAPTER_FOR_SUSPEND_CONVERSION());
            IrStatement possibleReference = (IrStatement)CollectionsKt.last(expression2.getStatements());
            IrStatement reference2 = possibleReference instanceof IrTypeOperatorCall ? (IrStatement)((IrTypeOperatorCall)possibleReference).getArgument() : possibleReference;
            Intrinsics.checkNotNull((Object)reference2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            ((IrFunctionReference)reference2).setOrigin(expression2.getOrigin());
        }
        return super.visitBlock(expression2);
    }
}

