/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"declarationCanBeLazilyResolved", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nNonLocalDeclarationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonLocalDeclarationUtils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/NonLocalDeclarationUtilsKt\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,32:1\n81#2,7:33\n76#2,2:40\n57#2:42\n78#2:43\n*S KotlinDebug\n*F\n+ 1 NonLocalDeclarationUtils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/NonLocalDeclarationUtilsKt\n*L\n28#1:33,7\n28#1:40,2\n28#1:42\n28#1:43\n*E\n"})
public final class NonLocalDeclarationUtilsKt {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean declarationCanBeLazilyResolved(@NotNull KtDeclaration declaration) {
        PsiElement parent2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtDeclaration ktDeclaration = declaration;
        if (ktDeclaration instanceof KtDestructuringDeclarationEntry) return false;
        if (ktDeclaration instanceof KtFunctionLiteral) return false;
        if (ktDeclaration instanceof KtTypeParameter) {
            return false;
        }
        if (ktDeclaration instanceof KtPrimaryConstructor) {
            PsiElement psiElement = ((KtPrimaryConstructor)declaration).getParent();
            if (!(psiElement instanceof KtClassOrObject)) return false;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement;
            if (ktClassOrObject == null) return false;
            if (ktClassOrObject.isLocal()) return false;
            return true;
        }
        if (ktDeclaration instanceof KtParameter) {
            if (!((KtParameter)declaration).hasValOrVar()) return false;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(declaration);
            if (ktClassOrObject == null) return false;
            if (ktClassOrObject.isLocal()) return false;
            return true;
        }
        if (ktDeclaration instanceof KtCallableDeclaration || ktDeclaration instanceof KtEnumEntry || ktDeclaration instanceof KtClassInitializer) {
            parent2 = declaration.getParent();
            if (parent2 instanceof KtFile) {
                return true;
            }
            if (parent2 instanceof KtClassBody) {
                PsiElement psiElement = ((KtClassBody)parent2).getParent();
                if (!(psiElement instanceof KtClassOrObject)) return false;
                KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement;
                if (ktClassOrObject == null) return false;
                if (ktClassOrObject.isLocal()) return false;
                return true;
            }
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            if (!(ktDeclaration instanceof KtNamedDeclaration)) {
                return false;
            }
            if (ktDeclaration instanceof KtClassOrObject) {
                if (((KtClassOrObject)declaration).isLocal()) return false;
                return true;
            }
            if (ktDeclaration instanceof KtTypeAlias) {
                if (((KtTypeAlias)declaration).isTopLevel()) return true;
                if (((KtTypeAlias)declaration).getClassId() == null) return false;
                return true;
            }
            String message$iv = "Unexpected " + Reflection.getOrCreateKotlinClass(declaration.getClass());
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$declarationCanBeLazilyResolved_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$declarationCanBeLazilyResolved_u24lambda_u240, "declaration", declaration);
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        if (!(parent2 instanceof KtBlockExpression)) return false;
        boolean bl = ((KtBlockExpression)parent2).getParent() instanceof KtScript;
        return bl;
    }
}

