/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.InventNamesForLocalClasses;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInventNamesForLocalClassesImpl;", "Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "generateNamesForRegeneratedObjects", "", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "computeTopLevelClassName", "", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "sanitizeNameIfNeeded", "name", "putLocalClassName", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "localClassName", "backend.jvm.lower"})
public class JvmInventNamesForLocalClassesImpl
extends InventNamesForLocalClasses {
    @NotNull
    private final JvmBackendContext context;

    public JvmInventNamesForLocalClassesImpl(@NotNull JvmBackendContext context, boolean generateNamesForRegeneratedObjects) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(generateNamesForRegeneratedObjects);
        this.context = context;
    }

    public /* synthetic */ JvmInventNamesForLocalClassesImpl(JvmBackendContext jvmBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(jvmBackendContext, bl);
    }

    @NotNull
    protected final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    protected String computeTopLevelClassName(@NotNull IrClass clazz) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Object object2 = clazz.getParent();
        IrFile irFile = object2 instanceof IrFile ? (IrFile)object2 : null;
        if (irFile == null) {
            throw new AssertionError((Object)("Top-level class expected: " + RenderIrElementKt.render$default(clazz, null, 1, null)));
        }
        IrFile file2 = irFile;
        if (Intrinsics.areEqual((Object)clazz.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFILE_CLASS()) || Intrinsics.areEqual((Object)clazz.getOrigin(), (Object)IrDeclarationOrigin.Companion.getSYNTHETIC_FILE_CLASS())) {
            object = FileClassLoweringKt.getFileClassInfo(file2).getFileClassFqName();
        } else {
            object2 = file2.getPackageFqName().child(clazz.getName());
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        FqName classFqn = object;
        String string2 = JvmClassName.byFqNameWithoutInnerClasses(classFqn).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        return string2;
    }

    @NotNull
    protected String sanitizeNameIfNeeded(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string2 = JvmCodegenUtil.sanitizeNameIfNeeded(name2, this.context.getConfig().getLanguageVersionSettings());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sanitizeNameIfNeeded(...)");
        return string2;
    }

    protected void putLocalClassName(@NotNull IrAttributeContainer declaration, @NotNull String localClassName) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)localClassName, (String)"localClassName");
        JvmIrAttributesKt.setLocalClassType(declaration, Type.getObjectType((String)localClassName));
    }
}

