/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.intrinsics.AndAnd;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayGet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayIterator;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySize;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BinaryOp;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Clone;
import org.jetbrains.kotlin.backend.jvm.intrinsics.CompareTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.EnumEntries;
import org.jetbrains.kotlin.backend.jvm.intrinsics.EnumValueOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.EnumValues;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ExplicitEquals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.GetClassByDescriptor;
import org.jetbrains.kotlin.backend.jvm.intrinsics.GetJavaObjectType;
import org.jetbrains.kotlin.backend.jvm.intrinsics.GetJavaPrimitiveType;
import org.jetbrains.kotlin.backend.jvm.intrinsics.HandleResultOfReflectiveAccess;
import org.jetbrains.kotlin.backend.jvm.intrinsics.HashCode;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Increment;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntIncr;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicShouldHaveBeenLowered;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Inv;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrCheckNotNull;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrDataClassArrayMemberHashCode;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrDataClassArrayMemberToString;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIllegalArgumentException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrNoWhenBranchMatchedException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IsArrayOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IteratorNext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.JvmDebuggerInvokeSpecial;
import org.jetbrains.kotlin.backend.jvm.intrinsics.JvmInvokeDynamic;
import org.jetbrains.kotlin.backend.jvm.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.MonitorInstruction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NewArray;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Not;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NumberCast;
import org.jetbrains.kotlin.backend.jvm.intrinsics.OrOr;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.RangeTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.RangeUntil;
import org.jetbrains.kotlin.backend.jvm.intrinsics.SignatureString;
import org.jetbrains.kotlin.backend.jvm.intrinsics.SingleArgumentInlineFunctionIntrinsic;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringGetChar;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringPlus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowKotlinNothingValueException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.TypeOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryMinus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryPlus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnsafeCoerce;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u0001:\u0002ABB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020#0\u001a0\u0019H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010\u001c2\u0006\u0010$\u001a\u00020*J*\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00192\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u001cH\u0002J*\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00192\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u001cH\u0002J2\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00192\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u001c2\u0006\u00100\u001a\u000201H\u0002J*\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00192\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0002J\u001a\u00106\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019H\u0002J\u001a\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019H\u0002J*\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00192\u0006\u00108\u001a\u0002012\u0006\u00109\u001a\u00020%H\u0002J6\u0010:\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020;0\u001a0\u00192\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\u001d\u001aR\u0012\u0004\u0012\u00020\u001f\u0012\u001e\u0012\u001c\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0 0 0\u001ej(\u0012\u0004\u0012\u00020\u001f\u0012\u001e\u0012\u001c\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0 0 `!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\u00020%*\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;)V", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "kotlinFqn", "Lorg/jetbrains/kotlin/name/FqName;", "kotlinJvmFqn", "kotlinJvmInternalUnsafeFqn", "kotlinReflectFqn", "kotlinEnumsFqn", "anyFqn", "arrayFqn", "cloneableFqn", "intFqn", "kClassFqn", "stringFqn", "intrinsics", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "intrinsicsMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "intrinsicsThatShouldHaveBeenLowered", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicShouldHaveBeenLowered;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "getSymbol", "(Lorg/jetbrains/kotlin/builtins/PrimitiveType;)Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "unaryFunForPrimitives", "name", "intrinsic", "binaryFunForPrimitivesAcrossPrimitives", "binaryFunForPrimitives", "parameter", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "binaryOp", "methodName", "opcode", "", "numberConversionMethods", "arrayMethods", "elementClass", "arrayClass", "primitiveComparisonIntrinsics", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveComparison;", "typeToIrFun", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "operator", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "Key", "Companion", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nIrIntrinsicMethods.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrIntrinsicMethods.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1557#2:274\n1628#2,3:275\n1557#2:296\n1628#2,3:297\n1557#2:300\n1628#2,3:301\n1368#2:304\n1454#2,5:305\n1557#2:310\n1628#2,3:311\n1368#2:314\n1454#2,2:315\n1557#2:317\n1628#2,3:318\n1456#2,3:321\n1611#2,9:330\n1863#2:339\n1864#2:341\n1620#2:342\n381#3,7:278\n381#3,7:285\n126#4:292\n153#4,3:293\n77#4:324\n97#4,5:325\n1#5:340\n*S KotlinDebug\n*F\n+ 1 IrIntrinsicMethods.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods\n*L\n114#1:274\n114#1:275,3\n147#1:296\n147#1:297,3\n163#1:300\n163#1:301,3\n168#1:304\n168#1:305,5\n178#1:310\n178#1:311,3\n185#1:314\n185#1:315,2\n186#1:317\n186#1:318,3\n185#1:321,3\n209#1:330,9\n209#1:339\n209#1:341\n209#1:342\n131#1:278,7\n132#1:285,7\n138#1:292\n138#1:293,3\n192#1:324\n192#1:325,5\n209#1:340\n*E\n"})
public final class IrIntrinsicMethods {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final JvmSymbols symbols;
    @NotNull
    private final FqName kotlinFqn;
    @NotNull
    private final FqName kotlinJvmFqn;
    @NotNull
    private final FqName kotlinJvmInternalUnsafeFqn;
    @NotNull
    private final FqName kotlinReflectFqn;
    @NotNull
    private final FqName kotlinEnumsFqn;
    @NotNull
    private final FqName anyFqn;
    @NotNull
    private final FqName arrayFqn;
    @NotNull
    private final FqName cloneableFqn;
    @NotNull
    private final FqName intFqn;
    @NotNull
    private final FqName kClassFqn;
    @NotNull
    private final FqName stringFqn;
    @NotNull
    private final List<Pair<Key, IntrinsicMethod>> intrinsics;
    @NotNull
    private final HashMap<String, Map<FqName, Map<Key, IntrinsicMethod>>> intrinsicsMap;
    @NotNull
    private static final Increment INC = new Increment(1);
    @NotNull
    private static final Increment DEC = new Increment(-1);
    @NotNull
    private static final ExplicitEquals EXPLICIT_EQUALS = new ExplicitEquals();

    /*
     * WARNING - void declaration
     */
    public IrIntrinsicMethods(@NotNull IrBuiltIns irBuiltIns, @NotNull JvmSymbols symbols) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)((Object)symbols), (String)"symbols");
        this.irBuiltIns = irBuiltIns;
        this.symbols = symbols;
        this.kotlinFqn = StandardNames.BUILT_INS_PACKAGE_FQ_NAME;
        this.kotlinJvmFqn = new FqName("kotlin.jvm");
        this.kotlinJvmInternalUnsafeFqn = new FqName("kotlin.jvm.internal.unsafe");
        this.kotlinReflectFqn = StandardNames.KOTLIN_REFLECT_FQ_NAME;
        this.kotlinEnumsFqn = new FqName("kotlin.enums");
        FqName fqName = StandardNames.FqNames.any.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"toSafe(...)");
        this.anyFqn = fqName;
        FqName fqName2 = StandardNames.FqNames.array.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe(...)");
        this.arrayFqn = fqName2;
        FqName fqName3 = StandardNames.FqNames.cloneable.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"toSafe(...)");
        this.cloneableFqn = fqName3;
        FqName fqName4 = StandardNames.FqNames._int.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"toSafe(...)");
        this.intFqn = fqName4;
        FqName fqName5 = StandardNames.FqNames.kClass.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"toSafe(...)");
        this.kClassFqn = fqName5;
        FqName fqName6 = StandardNames.FqNames.string.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName6, (String)"toSafe(...)");
        this.stringFqn = fqName6;
        Object object = new Pair[40];
        object[0] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, new FqName("T"), "<get-javaClass>", CollectionsKt.emptyList()), (Object)JavaClassProperty.INSTANCE);
        object[1] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, this.kClassFqn, "<get-javaObjectType>", CollectionsKt.emptyList()), (Object)GetJavaObjectType.INSTANCE);
        object[2] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, this.kClassFqn, "<get-javaPrimitiveType>", CollectionsKt.emptyList()), (Object)GetJavaPrimitiveType.INSTANCE);
        object[3] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, this.kClassFqn, "<get-java>", CollectionsKt.emptyList()), (Object)KClassJavaProperty.INSTANCE);
        object[4] = TuplesKt.to((Object)new Key(this.kotlinJvmInternalUnsafeFqn, null, "monitorEnter", CollectionsKt.listOf((Object)this.anyFqn)), (Object)MonitorInstruction.MONITOR_ENTER);
        object[5] = TuplesKt.to((Object)new Key(this.kotlinJvmInternalUnsafeFqn, null, "monitorExit", CollectionsKt.listOf((Object)this.anyFqn)), (Object)MonitorInstruction.MONITOR_EXIT);
        object[6] = TuplesKt.to((Object)new Key(this.kotlinJvmFqn, this.arrayFqn, "isArrayOf", CollectionsKt.emptyList()), (Object)IsArrayOf.INSTANCE);
        object[7] = TuplesKt.to((Object)new Key(this.kotlinFqn, null, "arrayOfNulls", CollectionsKt.listOf((Object)this.intFqn)), (Object)NewArray.INSTANCE);
        object[8] = TuplesKt.to((Object)new Key(this.cloneableFqn, null, "clone", CollectionsKt.emptyList()), (Object)Clone.INSTANCE);
        object[9] = TuplesKt.to((Object)new Key(this.kotlinFqn, null, "enumValues", CollectionsKt.emptyList()), (Object)EnumValues.INSTANCE);
        object[10] = TuplesKt.to((Object)new Key(this.kotlinFqn, null, "enumValueOf", CollectionsKt.listOf((Object)this.stringFqn)), (Object)EnumValueOf.INSTANCE);
        object[11] = TuplesKt.to((Object)new Key(this.kotlinEnumsFqn, null, "enumEntries", CollectionsKt.emptyList()), (Object)EnumEntries.INSTANCE);
        object[12] = TuplesKt.to((Object)new Key(this.kotlinFqn, this.stringFqn, "plus", CollectionsKt.listOf((Object)this.anyFqn)), (Object)StringPlus.INSTANCE);
        object[13] = TuplesKt.to((Object)new Key(this.kotlinReflectFqn, null, "typeOf", CollectionsKt.emptyList()), (Object)TypeOf.INSTANCE);
        Key key = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEqeqSymbol());
        Intrinsics.checkNotNull((Object)key);
        KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktSingleValueToken), (String)"EQEQ");
        object[14] = TuplesKt.to((Object)key, (Object)new Equals(ktSingleValueToken));
        Key key2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEqeqeqSymbol());
        Intrinsics.checkNotNull((Object)key2);
        KtSingleValueToken ktSingleValueToken2 = KtTokens.EQEQEQ;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktSingleValueToken2), (String)"EQEQEQ");
        object[15] = TuplesKt.to((Object)key2, (Object)new Equals(ktSingleValueToken2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.irBuiltIns.getIeee754equalsFunByOperandType().get(this.irBuiltIns.getFloatClass());
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        Key key3 = IrIntrinsicMethods.Companion.toKey(irSimpleFunctionSymbol);
        Intrinsics.checkNotNull((Object)key3);
        Type type2 = Type.FLOAT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"FLOAT_TYPE");
        object[16] = TuplesKt.to((Object)key3, (Object)new Ieee754Equals(type2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.irBuiltIns.getIeee754equalsFunByOperandType().get(this.irBuiltIns.getDoubleClass());
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol2);
        Key key4 = IrIntrinsicMethods.Companion.toKey(irSimpleFunctionSymbol2);
        Intrinsics.checkNotNull((Object)key4);
        Type type3 = Type.DOUBLE_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"DOUBLE_TYPE");
        object[17] = TuplesKt.to((Object)key4, (Object)new Ieee754Equals(type3));
        Key key5 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getBooleanNotSymbol());
        Intrinsics.checkNotNull((Object)key5);
        object[18] = TuplesKt.to((Object)key5, (Object)Not.INSTANCE);
        Key key6 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getNoWhenBranchMatchedExceptionSymbol());
        Intrinsics.checkNotNull((Object)key6);
        object[19] = TuplesKt.to((Object)key6, (Object)IrNoWhenBranchMatchedException.INSTANCE);
        Key key7 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getIllegalArgumentExceptionSymbol());
        Intrinsics.checkNotNull((Object)key7);
        object[20] = TuplesKt.to((Object)key7, (Object)IrIllegalArgumentException.INSTANCE);
        Key key8 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getCheckNotNullSymbol());
        Intrinsics.checkNotNull((Object)key8);
        object[21] = TuplesKt.to((Object)key8, (Object)IrCheckNotNull.INSTANCE);
        Key key9 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getAndandSymbol());
        Intrinsics.checkNotNull((Object)key9);
        object[22] = TuplesKt.to((Object)key9, (Object)AndAnd.INSTANCE);
        Key key10 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getOrorSymbol());
        Intrinsics.checkNotNull((Object)key10);
        object[23] = TuplesKt.to((Object)key10, (Object)OrOr.INSTANCE);
        Key key11 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getDataClassArrayMemberHashCodeSymbol());
        Intrinsics.checkNotNull((Object)key11);
        object[24] = TuplesKt.to((Object)key11, (Object)IrDataClassArrayMemberHashCode.INSTANCE);
        Key key12 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getDataClassArrayMemberToStringSymbol());
        Intrinsics.checkNotNull((Object)key12);
        object[25] = TuplesKt.to((Object)key12, (Object)IrDataClassArrayMemberToString.INSTANCE);
        Key key13 = IrIntrinsicMethods.Companion.toKey(this.symbols.getSingleArgumentInlineFunction());
        Intrinsics.checkNotNull((Object)key13);
        object[26] = TuplesKt.to((Object)key13, (Object)SingleArgumentInlineFunctionIntrinsic.INSTANCE);
        Key key14 = IrIntrinsicMethods.Companion.toKey(this.symbols.getUnsafeCoerceIntrinsic());
        Intrinsics.checkNotNull((Object)key14);
        object[27] = TuplesKt.to((Object)key14, (Object)UnsafeCoerce.INSTANCE);
        Key key15 = IrIntrinsicMethods.Companion.toKey(this.symbols.getSignatureStringIntrinsic());
        Intrinsics.checkNotNull((Object)key15);
        object[28] = TuplesKt.to((Object)key15, (Object)SignatureString.INSTANCE);
        Key key16 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowNullPointerException());
        Intrinsics.checkNotNull((Object)key16);
        Type type4 = Type.getObjectType((String)"java/lang/NullPointerException");
        Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"getObjectType(...)");
        object[29] = TuplesKt.to((Object)key16, (Object)new ThrowException(type4));
        Key key17 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowTypeCastException());
        Intrinsics.checkNotNull((Object)key17);
        Type type5 = Type.getObjectType((String)"kotlin/TypeCastException");
        Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"getObjectType(...)");
        object[30] = TuplesKt.to((Object)key17, (Object)new ThrowException(type5));
        Key key18 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowUnsupportedOperationException());
        Intrinsics.checkNotNull((Object)key18);
        Type type6 = Type.getObjectType((String)"java/lang/UnsupportedOperationException");
        Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"getObjectType(...)");
        object[31] = TuplesKt.to((Object)key18, (Object)new ThrowException(type6));
        Key key19 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowIllegalAccessException());
        Intrinsics.checkNotNull((Object)key19);
        Type type7 = Type.getObjectType((String)"java/lang/IllegalAccessException");
        Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"getObjectType(...)");
        object[32] = TuplesKt.to((Object)key19, (Object)new ThrowException(type7));
        Key key20 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowKotlinNothingValueException());
        Intrinsics.checkNotNull((Object)key20);
        object[33] = TuplesKt.to((Object)key20, (Object)ThrowKotlinNothingValueException.INSTANCE);
        Key key21 = IrIntrinsicMethods.Companion.toKey(this.symbols.getJvmIndyIntrinsic());
        Intrinsics.checkNotNull((Object)key21);
        object[34] = TuplesKt.to((Object)key21, (Object)JvmInvokeDynamic.INSTANCE);
        Key key22 = IrIntrinsicMethods.Companion.toKey(this.symbols.getJvmDebuggerInvokeSpecialIntrinsic());
        Intrinsics.checkNotNull((Object)key22);
        object[35] = TuplesKt.to((Object)key22, (Object)JvmDebuggerInvokeSpecial.INSTANCE);
        Key key23 = IrIntrinsicMethods.Companion.toKey(this.symbols.getGetClassByDescriptor());
        Intrinsics.checkNotNull((Object)key23);
        object[36] = TuplesKt.to((Object)key23, (Object)GetClassByDescriptor.INSTANCE);
        Key key24 = IrIntrinsicMethods.Companion.toKey(this.symbols.getHandleResultOfReflectiveAccess());
        Intrinsics.checkNotNull((Object)key24);
        object[37] = TuplesKt.to((Object)key24, (Object)HandleResultOfReflectiveAccess.INSTANCE);
        Key key25 = IrIntrinsicMethods.Companion.toKey(this.symbols.getIntPostfixIncrDecr());
        Intrinsics.checkNotNull((Object)key25);
        object[38] = TuplesKt.to((Object)key25, (Object)new IntIncr(false));
        Key key26 = IrIntrinsicMethods.Companion.toKey(this.symbols.getIntPrefixIncrDecr());
        Intrinsics.checkNotNull((Object)key26);
        object[39] = TuplesKt.to((Object)key26, (Object)new IntIncr(true));
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])object), (Iterable)this.numberConversionMethods()), (Iterable)this.unaryFunForPrimitives("plus", UnaryPlus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("unaryPlus", UnaryPlus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("minus", UnaryMinus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("unaryMinus", UnaryMinus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("inv", Inv.INSTANCE)), (Iterable)this.unaryFunForPrimitives("inc", INC)), (Iterable)this.unaryFunForPrimitives("dec", DEC)), (Iterable)this.unaryFunForPrimitives("hashCode", HashCode.INSTANCE)), (Iterable)this.binaryFunForPrimitives("equals", EXPLICIT_EQUALS, this.irBuiltIns.getAnyClass())), (Iterable)this.binaryFunForPrimitivesAcrossPrimitives("rangeTo", RangeTo.INSTANCE)), (Iterable)this.binaryFunForPrimitivesAcrossPrimitives("rangeUntil", RangeUntil.INSTANCE)), (Iterable)this.binaryOp("plus", 96)), (Iterable)this.binaryOp("minus", 100)), (Iterable)this.binaryOp("times", 104)), (Iterable)this.binaryOp("div", 108)), (Iterable)this.binaryOp("mod", 112)), (Iterable)this.binaryOp("rem", 112)), (Iterable)this.binaryOp("shl", 120)), (Iterable)this.binaryOp("shr", 122)), (Iterable)this.binaryOp("ushr", 124)), (Iterable)this.binaryOp("and", 126)), (Iterable)this.binaryOp("or", 128)), (Iterable)this.binaryOp("xor", 130)), (Iterable)this.binaryFunForPrimitivesAcrossPrimitives("compareTo", CompareTo.INSTANCE)), (Object)IrIntrinsicMethods.Companion.createKeyMapping(Not.INSTANCE, this.irBuiltIns.getBooleanClass(), "not", new IrClassifierSymbol[0]));
        object = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        Collection collection3 = CollectionsKt.plus((Collection)collection2, (Object)IrIntrinsicMethods.Companion.createKeyMapping(StringGetChar.INSTANCE, this.irBuiltIns.getStringClass(), "get", (IrClassifierSymbol[])object));
        object = this.symbols.getPrimitiveIteratorsByType().values();
        Collection collection4 = collection3;
        IrIntrinsicMethods irIntrinsicMethods = this;
        boolean bl = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void iteratorClass;
            IrClassSymbol irClassSymbol = (IrClassSymbol)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(IrIntrinsicMethods.Companion.createKeyMapping(IteratorNext.INSTANCE, (IrClassSymbol)iteratorClass, "next", new IrClassifierSymbol[0]));
        }
        collection = (List)destination$iv$iv;
        Collection collection5 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection4, (Iterable)collection), (Iterable)this.arrayMethods());
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map = this.irBuiltIns.getLessFunByOperandType();
        KtSingleValueToken ktSingleValueToken3 = KtTokens.LT;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktSingleValueToken3), (String)"LT");
        Collection collection6 = CollectionsKt.plus((Collection)collection5, (Iterable)this.primitiveComparisonIntrinsics(map, ktSingleValueToken3));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map2 = this.irBuiltIns.getLessOrEqualFunByOperandType();
        KtSingleValueToken ktSingleValueToken4 = KtTokens.LTEQ;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktSingleValueToken4), (String)"LTEQ");
        Collection collection7 = CollectionsKt.plus((Collection)collection6, (Iterable)this.primitiveComparisonIntrinsics(map2, ktSingleValueToken4));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map3 = this.irBuiltIns.getGreaterFunByOperandType();
        KtSingleValueToken ktSingleValueToken5 = KtTokens.GT;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktSingleValueToken5), (String)"GT");
        Collection collection8 = CollectionsKt.plus((Collection)collection7, (Iterable)this.primitiveComparisonIntrinsics(map3, ktSingleValueToken5));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map4 = this.irBuiltIns.getGreaterOrEqualFunByOperandType();
        KtSingleValueToken ktSingleValueToken6 = KtTokens.GTEQ;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktSingleValueToken6), (String)"GTEQ");
        irIntrinsicMethods.intrinsics = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection8, (Iterable)this.primitiveComparisonIntrinsics(map4, ktSingleValueToken6)), (Iterable)this.intrinsicsThatShouldHaveBeenLowered());
        this.intrinsicsMap = new HashMap();
        for (Pair pair : this.intrinsics) {
            Object object2;
            Object object3;
            Map $this$getOrPut$iv;
            Key key27 = (Key)pair.component1();
            IntrinsicMethod intrinsic = (IntrinsicMethod)pair.component2();
            Map $i$f$mapTo22 = this.intrinsicsMap;
            Object key$iv = key27.getName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                Map answer$iv = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            $this$getOrPut$iv = (Map)object3;
            key$iv = key27.getReceiverParameterTypeName();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl4 = false;
                Map answer$iv = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((Map)object2).put(key27, intrinsic);
        }
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final JvmSymbols getSymbols() {
        return this.symbols;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicShouldHaveBeenLowered>> intrinsicsThatShouldHaveBeenLowered() {
        Collection collection;
        Object object;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = this.symbols.getPrimitiveTypesToPrimitiveArrays();
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            String name2;
            object = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrClassSymbol primitiveClassSymbol = (IrClassSymbol)object.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)((IrClass)primitiveClassSymbol.getOwner()).getName().asString(), (String)"asString(...)");
            String arrayOfFunName = CapitalizeDecapitalizeKt.decapitalizeAsciiOnly(name2) + "Of";
            collection.add(new Key(this.kotlinFqn, null, arrayOfFunName, CollectionsKt.listOf((Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)primitiveClassSymbol.getOwner()))));
        }
        $this$map$iv = new Key[]{new Key(this.kotlinFqn, this.anyFqn, "toString", CollectionsKt.emptyList()), new Key(this.kotlinFqn, null, "arrayOf", CollectionsKt.listOf((Object)this.arrayFqn)), new Key(this.stringFqn, null, "plus", CollectionsKt.listOf((Object)this.anyFqn))};
        $this$map$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object[])$this$map$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            item$iv$iv = iterator2.next();
            object = (Key)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)IntrinsicShouldHaveBeenLowered.INSTANCE));
        }
        return (List)destination$iv$iv;
    }

    private final IrClassSymbol getSymbol(PrimitiveType $this$symbol) {
        IrType irType = this.irBuiltIns.getPrimitiveTypeToIrType().get((Object)$this$symbol);
        Intrinsics.checkNotNull((Object)irType);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return irClassSymbol;
    }

    @Nullable
    public final IntrinsicMethod getIntrinsic(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        IrFunction function2 = symbol2.getOwner();
        String string2 = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String name2 = string2;
        Map<FqName, Map<Key, IntrinsicMethod>> map = this.intrinsicsMap.get(name2);
        if (map == null) {
            return null;
        }
        Map<FqName, Map<Key, IntrinsicMethod>> byName = map;
        FqName receiverFqName = IrIntrinsicMethods.Companion.computeExtensionReceiverFqName(function2);
        Map<Key, IntrinsicMethod> map2 = byName.get(receiverFqName);
        if (map2 == null) {
            return null;
        }
        Map<Key, IntrinsicMethod> byReceiver = map2;
        FqName fqName = IrIntrinsicMethods.Companion.computeOwnerFqName(function2);
        if (fqName == null) {
            return null;
        }
        FqName ownerFqName = fqName;
        return byReceiver.get(new Key(ownerFqName, receiverFqName, name2, IrIntrinsicMethods.Companion.computeValueParameterFqNames(function2)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> unaryFunForPrimitives(String name2, IntrinsicMethod intrinsic) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)PrimitiveType.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type2;
            PrimitiveType primitiveType = (PrimitiveType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IrIntrinsicMethods.Companion.createKeyMapping(intrinsic, this.getSymbol((PrimitiveType)type2), name2, new IrClassifierSymbol[0]));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> binaryFunForPrimitivesAcrossPrimitives(String name2, IntrinsicMethod intrinsic) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = (Iterable)PrimitiveType.getEntries();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PrimitiveType parameter = (PrimitiveType)((Object)element$iv$iv);
            boolean bl = false;
            Iterable list$iv$iv = this.binaryFunForPrimitives(name2, intrinsic, this.getSymbol(parameter));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> binaryFunForPrimitives(String name2, IntrinsicMethod intrinsic, IrClassifierSymbol parameter) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)PrimitiveType.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type2;
            PrimitiveType primitiveType = (PrimitiveType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrClassifierSymbol[] irClassifierSymbolArray = new IrClassifierSymbol[]{parameter};
            collection.add(IrIntrinsicMethods.Companion.createKeyMapping(intrinsic, this.getSymbol((PrimitiveType)type2), name2, irClassifierSymbolArray));
        }
        return (List)destination$iv$iv;
    }

    private final List<Pair<Key, IntrinsicMethod>> binaryOp(String methodName, int opcode) {
        return this.binaryFunForPrimitivesAcrossPrimitives(methodName, new BinaryOp(opcode));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> numberConversionMethods() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = PrimitiveType.NUMBER_TYPES;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            PrimitiveType type2 = (PrimitiveType)((Object)element$iv$iv);
            boolean bl = false;
            ImmutableSet<Name> immutableSet = OperatorConventions.NUMBER_CONVERSIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"NUMBER_CONVERSIONS");
            Iterable $this$map$iv = (Iterable)immutableSet;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void method;
                Name name2 = (Name)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                IntrinsicMethod intrinsicMethod = NumberCast.INSTANCE;
                IrClassSymbol irClassSymbol = this.getSymbol(type2);
                String string2 = method.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                collection.add(IrIntrinsicMethods.Companion.createKeyMapping(intrinsicMethod, irClassSymbol, string2, new IrClassifierSymbol[0]));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> arrayMethods() {
        void $this$flatMapTo$iv$iv;
        Map $this$flatMap$iv = this.symbols.getPrimitiveArraysToPrimitiveTypes();
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            IrClassSymbol array = (IrClassSymbol)entry.getKey();
            PrimitiveType primitiveType = (PrimitiveType)((Object)entry.getValue());
            Iterable list$iv$iv = this.arrayMethods(this.getSymbol(primitiveType), array);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.arrayMethods(((IrTypeParameter)CollectionsKt.single(((IrClass)this.symbols.getArray().getOwner()).getTypeParameters())).getSymbol(), this.symbols.getArray()));
    }

    private final List<Pair<Key, IntrinsicMethod>> arrayMethods(IrClassifierSymbol elementClass, IrClassSymbol arrayClass) {
        Object[] objectArray = new Pair[6];
        objectArray[0] = IrIntrinsicMethods.Companion.createKeyMapping(ArraySize.INSTANCE, arrayClass, "<get-size>", new IrClassifierSymbol[0]);
        IrClassifierSymbol[] irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        objectArray[1] = IrIntrinsicMethods.Companion.createKeyMapping(NewArray.INSTANCE, arrayClass, "<init>", irClassifierSymbolArray);
        irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass(), elementClass};
        objectArray[2] = IrIntrinsicMethods.Companion.createKeyMapping(ArraySet.INSTANCE, arrayClass, "set", irClassifierSymbolArray);
        irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        objectArray[3] = IrIntrinsicMethods.Companion.createKeyMapping(ArrayGet.INSTANCE, arrayClass, "get", irClassifierSymbolArray);
        objectArray[4] = IrIntrinsicMethods.Companion.createKeyMapping(Clone.INSTANCE, arrayClass, "clone", new IrClassifierSymbol[0]);
        objectArray[5] = IrIntrinsicMethods.Companion.createKeyMapping(ArrayIterator.INSTANCE, arrayClass, "iterator", new IrClassifierSymbol[0]);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, PrimitiveComparison>> primitiveComparisonIntrinsics(Map<IrClassifierSymbol, ? extends IrSimpleFunctionSymbol> typeToIrFun, KtSingleValueToken operator) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)PrimitiveType.getEntries();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PrimitiveType primitiveType = (PrimitiveType)((Object)element$iv$iv);
            boolean bl2 = false;
            IrType irType = this.irBuiltIns.getPrimitiveTypeToIrType().get((Object)primitiveType);
            Intrinsics.checkNotNull((Object)irType);
            IrClassifierSymbol irPrimitiveClassifier = IrTypesKt.getClassifierOrFail(irType);
            if (typeToIrFun.get(irPrimitiveClassifier) == null) {
                pair = null;
            } else {
                IrSimpleFunctionSymbol irFunSymbol;
                Key key = IrIntrinsicMethods.Companion.toKey(irFunSymbol);
                Intrinsics.checkNotNull((Object)key);
                pair = TuplesKt.to((Object)key, (Object)new PrimitiveComparison(primitiveType, operator));
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\fH\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\fH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\fH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0013H\u0002J\u0014\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0015*\u00020\fH\u0002JE\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001f\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Companion;", "", "<init>", "()V", "INC", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Increment;", "DEC", "EXPLICIT_EQUALS", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/ExplicitEquals;", "toKey", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "computeOwnerFqName", "Lorg/jetbrains/kotlin/name/FqName;", "computeExtensionReceiverFqName", "computeParameterFqName", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "computeValueParameterFqNames", "", "createKeyMapping", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "intrinsic", "klass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "name", "", "args", "", "(Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Ljava/lang/String;[Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Lkotlin/Pair;", "backend.jvm.codegen"})
    @SourceDebugExtension(value={"SMAP\nIrIntrinsicMethods.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrIntrinsicMethods.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,273:1\n1557#2:274\n1628#2,3:275\n11165#3:278\n11500#3,3:279\n*S KotlinDebug\n*F\n+ 1 IrIntrinsicMethods.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Companion\n*L\n261#1:274\n261#1:275,3\n269#1:278\n269#1:279,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Key toKey(IrFunctionSymbol $this$toKey) {
            return this.toKey($this$toKey.getOwner());
        }

        private final Key toKey(IrFunction $this$toKey) {
            FqName fqName = this.computeOwnerFqName($this$toKey);
            if (fqName == null) {
                return null;
            }
            FqName fqName2 = this.computeExtensionReceiverFqName($this$toKey);
            String string2 = $this$toKey.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            return new Key(fqName, fqName2, string2, this.computeValueParameterFqNames($this$toKey));
        }

        private final FqName computeOwnerFqName(IrFunction $this$computeOwnerFqName) {
            FqName fqName;
            IrDeclarationParent parent2 = $this$computeOwnerFqName.getParent();
            if (parent2 instanceof IrClass) {
                if (IrUtilsKt.isFileClass((IrDeclaration)((Object)parent2))) {
                    IrDeclarationParent irDeclarationParent = ((IrClass)parent2).getParent();
                    Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrPackageFragment");
                    fqName = ((IrPackageFragment)irDeclarationParent).getPackageFqName();
                } else {
                    fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((Object)parent2));
                }
            } else {
                fqName = parent2 instanceof IrPackageFragment ? ((IrPackageFragment)parent2).getPackageFqName() : null;
            }
            FqName ownerFqName = fqName;
            return ownerFqName;
        }

        private final FqName computeExtensionReceiverFqName(IrFunction $this$computeExtensionReceiverFqName) {
            return this.computeParameterFqName($this$computeExtensionReceiverFqName.getExtensionReceiverParameter());
        }

        private final FqName computeParameterFqName(IrValueParameter parameter) {
            IrAnnotationContainer irAnnotationContainer = parameter;
            return this.computeParameterFqName(irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? IrTypesKt.getClassifierOrNull((IrType)irAnnotationContainer) : null);
        }

        private final FqName computeParameterFqName(IrClassifierSymbol parameter) {
            FqName fqName;
            Object object = parameter;
            if (object != null && (object = object.getOwner()) != null) {
                Object it = object;
                boolean bl = false;
                Object object2 = it;
                fqName = object2 instanceof IrClass ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)it) : (object2 instanceof IrTypeParameter ? new FqName(((IrTypeParameter)it).getName().asString()) : null);
            } else {
                fqName = null;
            }
            return fqName;
        }

        /*
         * WARNING - void declaration
         */
        private final List<FqName> computeValueParameterFqNames(IrFunction $this$computeValueParameterFqNames) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$computeValueParameterFqNames.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.computeParameterFqName((IrValueParameter)p0));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Key, IntrinsicMethod> createKeyMapping(IntrinsicMethod intrinsic, IrClassSymbol klass, String name2, IrClassifierSymbol ... args) {
            Collection<FqName> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)klass.getOwner());
            Intrinsics.checkNotNull((Object)fqName);
            IrClassifierSymbol[] irClassifierSymbolArray = args;
            String string2 = name2;
            FqName fqName2 = null;
            FqName fqName3 = fqName;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var13_16 = item$iv$iv = $this$mapTo$iv$iv[j];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.computeParameterFqName((IrClassifierSymbol)it));
            }
            Collection<FqName> collection2 = collection = (List)destination$iv$iv;
            String string3 = string2;
            FqName fqName4 = fqName2;
            FqName fqName5 = fqName3;
            return TuplesKt.to((Object)new Key(fqName5, fqName4, string3, (List<FqName>)collection2), (Object)intrinsic);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "", "owner", "Lorg/jetbrains/kotlin/name/FqName;", "receiverParameterTypeName", "name", "", "valueParameterTypeNames", "", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Ljava/util/List;)V", "getOwner", "()Lorg/jetbrains/kotlin/name/FqName;", "getReceiverParameterTypeName", "getName", "()Ljava/lang/String;", "getValueParameterTypeNames", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.jvm.codegen"})
    public static final class Key {
        @NotNull
        private final FqName owner;
        @Nullable
        private final FqName receiverParameterTypeName;
        @NotNull
        private final String name;
        @NotNull
        private final List<FqName> valueParameterTypeNames;

        public Key(@NotNull FqName owner, @Nullable FqName receiverParameterTypeName, @NotNull String name2, @NotNull List<FqName> valueParameterTypeNames) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(valueParameterTypeNames, (String)"valueParameterTypeNames");
            this.owner = owner;
            this.receiverParameterTypeName = receiverParameterTypeName;
            this.name = name2;
            this.valueParameterTypeNames = valueParameterTypeNames;
        }

        @NotNull
        public final FqName getOwner() {
            return this.owner;
        }

        @Nullable
        public final FqName getReceiverParameterTypeName() {
            return this.receiverParameterTypeName;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<FqName> getValueParameterTypeNames() {
            return this.valueParameterTypeNames;
        }

        @NotNull
        public final FqName component1() {
            return this.owner;
        }

        @Nullable
        public final FqName component2() {
            return this.receiverParameterTypeName;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final List<FqName> component4() {
            return this.valueParameterTypeNames;
        }

        @NotNull
        public final Key copy(@NotNull FqName owner, @Nullable FqName receiverParameterTypeName, @NotNull String name2, @NotNull List<FqName> valueParameterTypeNames) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(valueParameterTypeNames, (String)"valueParameterTypeNames");
            return new Key(owner, receiverParameterTypeName, name2, valueParameterTypeNames);
        }

        public static /* synthetic */ Key copy$default(Key key, FqName fqName, FqName fqName2, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                fqName = key.owner;
            }
            if ((n & 2) != 0) {
                fqName2 = key.receiverParameterTypeName;
            }
            if ((n & 4) != 0) {
                string2 = key.name;
            }
            if ((n & 8) != 0) {
                list = key.valueParameterTypeNames;
            }
            return key.copy(fqName, fqName2, string2, list);
        }

        @NotNull
        public String toString() {
            return "Key(owner=" + this.owner + ", receiverParameterTypeName=" + this.receiverParameterTypeName + ", name=" + this.name + ", valueParameterTypeNames=" + this.valueParameterTypeNames + ')';
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + (this.receiverParameterTypeName == null ? 0 : this.receiverParameterTypeName.hashCode());
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.valueParameterTypeNames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.owner, (Object)key.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receiverParameterTypeName, (Object)key.receiverParameterTypeName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)key.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.valueParameterTypeNames, key.valueParameterTypeNames);
        }
    }
}

