/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.finder;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002J&\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002J&\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002JB\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J#\u0010(\u001a\b\u0012\u0004\u0012\u00020&0\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010)J#\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.2\u0006\u0010/\u001a\u00020\u0011H\u0002J#\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u00102J\u001e\u00103\u001a\b\u0012\u0004\u0012\u000201042\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "Lcom/intellij/psi/PsiElementFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinFinderMarker;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "kotlinAsJavaSupport", "Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "findClass", "Lcom/intellij/psi/PsiClass;", "qualifiedName", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClasses", "", "qualifiedNameString", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "findClassesAndObjects", "", "Lorg/jetbrains/kotlin/name/FqName;", "answer", "", "findInterfaceDefaultImpls", "findRepeatableAnnotationContainer", "findSyntheticInnerClass", "syntheticName", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "", "getClassNames", "", "psiPackage", "Lcom/intellij/psi/PsiPackage;", "findPackage", "getSubPackages", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiPackage;", "getClasses", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "sortByPreferenceToSourceFile", "list", "Lcom/intellij/util/SmartList;", "searchScope", "getPackageFiles", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiFile;", "getPackageFilesFilter", "Lcom/intellij/openapi/util/Condition;", "Companion", "light-classes-base"})
@SourceDebugExtension(value={"SMAP\nJavaElementFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaElementFinder.kt\norg/jetbrains/kotlin/asJava/finder/JavaElementFinder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n37#2,2:192\n37#2,2:198\n37#2,2:200\n37#2,2:204\n1557#3:194\n1628#3,3:195\n1010#3,2:202\n*S KotlinDebug\n*F\n+ 1 JavaElementFinder.kt\norg/jetbrains/kotlin/asJava/finder/JavaElementFinder\n*L\n52#1:192,2\n135#1:198,2\n152#1:200,2\n164#1:204,2\n135#1:194\n135#1:195,3\n159#1:202,2\n*E\n"})
public final class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinAsJavaSupport kotlinAsJavaSupport;

    public JavaElementFinder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
        this.kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(this.project);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return (PsiClass)ArraysKt.firstOrNull((Object[])this.findClasses(qualifiedName, scope2));
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedNameString, (String)"qualifiedNameString");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiClass.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList answer = new SmartList();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope2, (List)answer);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClasses(qualifiedName, scope2));
        answer.addAll(this.kotlinAsJavaSupport.getKotlinInternalClasses(qualifiedName, scope2));
        this.sortByPreferenceToSourceFile((SmartList<PsiClass>)answer, scope2);
        Collection $this$toTypedArray$iv = (Collection)answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName, scope2, answer);
        this.findRepeatableAnnotationContainer(qualifiedName, scope2, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName, scope2);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = this.kotlinAsJavaSupport.getLightClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private final void findInterfaceDefaultImpls(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName, "DefaultImpls", scope2, answer, (Function1<? super KtClassOrObject, Boolean>)((Function1)JavaElementFinder::findInterfaceDefaultImpls$lambda$0));
    }

    private final void findRepeatableAnnotationContainer(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName, "Container", scope2, answer, (Function1<? super KtClassOrObject, Boolean>)((Function1)JavaElementFinder::findRepeatableAnnotationContainer$lambda$1));
    }

    private final void findSyntheticInnerClass(FqName qualifiedName, String syntheticName, GlobalSearchScope scope2, List<PsiClass> answer, Function1<? super KtClassOrObject, Boolean> predicate) {
        if (qualifiedName.isRoot() || !Intrinsics.areEqual((Object)qualifiedName.shortName().asString(), (Object)syntheticName)) {
            return;
        }
        FqName fqName = qualifiedName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"parent(...)");
        for (KtClassOrObject classOrObject : this.kotlinAsJavaSupport.findClassOrObjectDeclarations(fqName, scope2)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            if (!((Boolean)predicate.invoke((Object)classOrObject)).booleanValue() || this.kotlinAsJavaSupport.getLightClass(classOrObject) == null || interfaceClass.findInnerClassByName(syntheticName, false) == null) continue;
            answer.add(implsClass);
        }
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        HashSet<String> answer = new HashSet<String>();
        answer.addAll(this.kotlinAsJavaSupport.getFacadeNames(packageFQN, scope2));
        for (KtClassOrObject declaration : declarations2) {
            String name2;
            if (declaration.getName() == null) continue;
            answer.add(name2);
        }
        return answer;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        Intrinsics.checkNotNullParameter((Object)qualifiedNameString, (String)"qualifiedNameString");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName = new FqName(qualifiedNameString);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        GlobalSearchScope allScope = globalSearchScope;
        return this.kotlinAsJavaSupport.packageExists(fqName, allScope) ? (PsiPackage)new KtLightPackage(this.psiManager, fqName, allScope) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Collection<FqName> subpackages = this.kotlinAsJavaSupport.getSubPackages(new FqName(psiPackage.getQualifiedName()), scope2);
        Iterable $this$map$iv = subpackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KtLightPackage(this.psiManager, (FqName)it, scope2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiPackage[0]);
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        SmartList answer = new SmartList();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClassesInPackage(packageFQN, scope2));
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        for (KtClassOrObject declaration : declarations2) {
            KtLightClass aClass;
            if (this.kotlinAsJavaSupport.getLightClass(declaration) == null) continue;
            answer.add((Object)aClass);
        }
        this.sortByPreferenceToSourceFile((SmartList<PsiClass>)answer, scope2);
        Collection $this$toTypedArray$iv = (Collection)answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void sortByPreferenceToSourceFile(SmartList<PsiClass> list, GlobalSearchScope searchScope) {
        if (list.size() < 2) {
            return;
        }
        ContainerUtil.quickSort((List)((List)list), Companion.byClasspathComparator(searchScope));
        List $this$sortBy$iv = (List)list;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PsiClass it = (PsiClass)a;
                    boolean bl = false;
                    boolean bl2 = !(it instanceof ClsClassImpl);
                    it = (PsiClass)b;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!(it instanceof ClsClassImpl)));
                }
            });
        }
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Collection<KtFile> $this$toTypedArray$iv = this.kotlinAsJavaSupport.findFilesForPackage(new FqName(psiPackage.getQualifiedName()), scope2);
        boolean $i$f$toTypedArray = false;
        Collection<KtFile> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiFile[0]);
    }

    @NotNull
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return arg_0 -> JavaElementFinder.getPackageFilesFilter$lambda$4(psiPackage, arg_0);
    }

    private static final boolean findInterfaceDefaultImpls$lambda$0(KtClassOrObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KtClass && ((KtClass)it).isInterface();
    }

    private static final boolean findRepeatableAnnotationContainer$lambda$1(KtClassOrObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LightClassUtilsKt.getHasRepeatableAnnotationContainer(it);
    }

    private static final boolean getPackageFilesFilter$lambda$4(PsiPackage $psiPackage, PsiFile input) {
        return !(input instanceof KtFile) ? true : Intrinsics.areEqual((Object)$psiPackage.getQualifiedName(), (Object)((KtFile)input).getPackageFqName().asString());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "project", "Lcom/intellij/openapi/project/Project;", "byClasspathComparator", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/Comparator;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "light-classes-base"})
    @SourceDebugExtension(value={"SMAP\nJavaElementFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaElementFinder.kt\norg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,191:1\n25#2,2:192\n*S KotlinDebug\n*F\n+ 1 JavaElementFinder.kt\norg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion\n*L\n176#1:192,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaElementFinder getInstance(@NotNull Project project) {
            Object object;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Object[] objectArray = PsiElementFinder.EP.getPoint((AreaInstance)project).getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
                Object[] $this$firstIsInstanceOrNull$iv = objectArray;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof JavaElementFinder)) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            JavaElementFinder javaElementFinder = (JavaElementFinder)object;
            if (javaElementFinder == null) {
                throw new IllegalStateException((JavaElementFinder.class.getSimpleName() + " is not found for project " + project).toString());
            }
            return javaElementFinder;
        }

        @NotNull
        public final Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope) {
            Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
            return (arg_0, arg_1) -> Companion.byClasspathComparator$lambda$0(searchScope, arg_0, arg_1);
        }

        private static final int byClasspathComparator$lambda$0(GlobalSearchScope $searchScope, PsiElement o1, PsiElement o2) {
            VirtualFile f1 = PsiUtilCore.getVirtualFile((PsiElement)o1);
            VirtualFile f2 = PsiUtilCore.getVirtualFile((PsiElement)o2);
            return f1 == f2 ? 0 : (f1 == null ? -1 : (f2 == null ? 1 : $searchScope.compare(f2, f1)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

