/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.google.gwt.dev.js.rhino.EvaluatorException;
import com.google.gwt.dev.js.rhino.MessagesBundle;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;

public class Context {
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    static final boolean printTrees = true;
    static final boolean printICode = true;
    static final boolean check = true;
    private static MessagesBundle messages = new MessagesBundle();
    private static Hashtable threadContexts = new Hashtable(11);
    private static Object threadLocalCx;
    private static Method threadLocalGet;
    private static Method threadLocalSet;
    int version;
    int errorCount;
    private ErrorReporter errorReporter;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    private boolean compileFunctionsWithDynamicScopeFlag;
    private int enterCount;
    private Object[] listeners;
    private Hashtable hashtable;
    private ClassLoader applicationClassLoader;
    private Hashtable activationNames;
    int instructionCount;
    int instructionThreshold;

    public Context() {
        this.setLanguageVersion(0);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context cx) {
        Context old = Context.getCurrentContext();
        if (cx == null) {
            if (old != null) {
                cx = old;
            } else {
                cx = new Context();
                Context.setThreadContext(cx);
            }
        } else if (cx.enterCount != 0) {
            if (cx != old) {
                throw new RuntimeException("Cannot enter Context active on another thread");
            }
        } else if (old != null) {
            cx = old;
        } else {
            Context.setThreadContext(cx);
        }
        ++cx.enterCount;
        return cx;
    }

    public static void exit() {
        boolean released = false;
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("Calling Context.exit without previous Context.enter");
        }
        if (cx.enterCount < 1) {
            Context.codeBug();
        }
        --cx.enterCount;
        if (cx.enterCount == 0) {
            released = true;
            Context.setThreadContext(null);
        }
    }

    public static Context getCurrentContext() {
        if (threadLocalCx != null) {
            try {
                return (Context)threadLocalGet.invoke(threadLocalCx, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread t = Thread.currentThread();
        return (Context)threadContexts.get(t);
    }

    private static void setThreadContext(Context cx) {
        if (threadLocalCx != null) {
            try {
                threadLocalSet.invoke(threadLocalCx, cx);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread t = Thread.currentThread();
        if (cx != null) {
            threadContexts.put(t, cx);
        } else {
            threadContexts.remove(t);
        }
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int version2) {
        this.version = version2;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public ErrorReporter setErrorReporter(ErrorReporter reporter) {
        this.errorReporter = reporter;
        return reporter;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public static void reportWarning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        if (message == null) {
            Context.$$$reportNull$$$1(0);
        }
        if (startPosition == null) {
            Context.$$$reportNull$$$1(1);
        }
        if (endPosition == null) {
            Context.$$$reportNull$$$1(2);
        }
        if (message == null) {
            Context.$$$reportNull$$$0(0);
        }
        if (startPosition == null) {
            Context.$$$reportNull$$$0(1);
        }
        if (endPosition == null) {
            Context.$$$reportNull$$$0(2);
        }
        Context cx = Context.getContext();
        cx.getErrorReporter().warning(message, startPosition, endPosition);
    }

    public static void reportError(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Context cx;
        if (message == null) {
            Context.$$$reportNull$$$1(3);
        }
        if (startPosition == null) {
            Context.$$$reportNull$$$1(4);
        }
        if (endPosition == null) {
            Context.$$$reportNull$$$1(5);
        }
        if (message == null) {
            Context.$$$reportNull$$$0(3);
        }
        if (startPosition == null) {
            Context.$$$reportNull$$$0(4);
        }
        if (endPosition == null) {
            Context.$$$reportNull$$$0(5);
        }
        if ((cx = Context.getCurrentContext()) != null) {
            ++cx.errorCount;
        } else {
            throw new EvaluatorException(message);
        }
        cx.getErrorReporter().error(message, startPosition, endPosition);
    }

    public boolean hasFeature(int featureIndex) {
        switch (featureIndex) {
            case 1: {
                return this.version == 100 || this.version == 110 || this.version == 120;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.version == 120;
            }
        }
        throw new IllegalArgumentException();
    }

    static String getMessage0(String messageId) {
        return Context.getMessage(messageId, null);
    }

    static String getMessage2(String messageId, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return Context.getMessage(messageId, arguments);
    }

    static Context getContext() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return cx;
    }

    static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        try {
            formatString = messages.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("No message resource found for message property " + messageId);
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }

    static void codeBug() {
        throw new RuntimeException("FAILED ASSERTION");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPosition";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endPosition";
                break;
            }
        }
        objectArray2[1] = "com/google/gwt/dev/js/rhino/Context";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reportWarning";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPosition";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endPosition";
                break;
            }
        }
        objectArray2[1] = "com/google/gwt/dev/js/rhino/Context";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reportWarning";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

