/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.LiteralFormatUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.utils.NumberWithRadix;
import org.jetbrains.kotlin.utils.NumbersKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"FP_LITERAL_PARTS", "Lkotlin/text/Regex;", "hasIllegalUnderscore", "", "text", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "hasLongSuffix", "hasUnsignedLongSuffix", "hasUnsignedSuffix", "parseBoolean", "parseDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "parseFloatingLiteral", "", "parseLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "parseNumericLiteral", "type", "psi"})
@SourceDebugExtension(value={"SMAP\nParseUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParseUtils.kt\norg/jetbrains/kotlin/parsing/ParseUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1755#2,3:114\n*S KotlinDebug\n*F\n+ 1 ParseUtils.kt\norg/jetbrains/kotlin/parsing/ParseUtilsKt\n*L\n26#1:114,3\n*E\n"})
public final class ParseUtilsKt {
    @NotNull
    private static final Regex FP_LITERAL_PARTS = new Regex("([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*)[f]?");

    public static final boolean hasIllegalUnderscore(@NotNull String text2, @NotNull IElementType elementType) {
        boolean bl;
        block7: {
            List list2;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
                int start = 0;
                int end = text2.length();
                if (StringsKt.startsWith((String)text2, (String)"0x", (boolean)true) || StringsKt.startsWith((String)text2, (String)"0b", (boolean)true)) {
                    start += 2;
                }
                if (StringsKt.endsWith((CharSequence)text2, (char)'l', (boolean)true)) {
                    --end;
                }
                String string2 = text2.substring(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                list2 = CollectionsKt.listOf((Object)string2);
            } else {
                list2 = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)Regex.findAll$default((Regex)FP_LITERAL_PARTS, (CharSequence)text2, (int)0, (int)2, null), (Function1)hasIllegalUnderscore.parts.1.INSTANCE));
            }
            List parts2 = list2;
            Iterable $this$any$iv = parts2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(it != null && (StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"_", (boolean)false, (int)2, null)))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasLongSuffix(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.endsWith$default((CharSequence)text2, (char)'l', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text2, (char)'L', (boolean)false, (int)2, null);
    }

    public static final boolean hasUnsignedSuffix(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.endsWith$default((CharSequence)text2, (char)'u', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text2, (char)'U', (boolean)false, (int)2, null);
    }

    public static final boolean hasUnsignedLongSuffix(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.endsWith$default((String)text2, (String)"ul", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text2, (String)"uL", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text2, (String)"Ul", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)text2, (String)"UL", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final Number parseNumericLiteral(@NotNull String text2, @NotNull IElementType type2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        String string2 = LiteralFormatUtil.removeUnderscores((String)text2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"removeUnderscores(...)");
        String canonicalText = string2;
        IElementType iElementType = type2;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INTEGER_CONSTANT) ? (Number)ParseUtilsKt.parseLong(canonicalText) : (Number)(Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FLOAT_CONSTANT) ? ParseUtilsKt.parseFloatingLiteral(canonicalText) : null);
    }

    private static final Long parseLong(String text2) {
        Long l;
        try {
            boolean isUnsigned = false;
            String numberWithoutSuffix = null;
            if (ParseUtilsKt.hasUnsignedLongSuffix(text2)) {
                isUnsigned = true;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text2, 2);
            } else if (ParseUtilsKt.hasUnsignedSuffix(text2)) {
                isUnsigned = true;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text2, 1);
            } else if (ParseUtilsKt.hasLongSuffix(text2)) {
                isUnsigned = false;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text2, 1);
            } else {
                isUnsigned = false;
                numberWithoutSuffix = text2;
            }
            NumberWithRadix numberWithRadix = NumbersKt.extractRadix(numberWithoutSuffix);
            String number = numberWithRadix.component1();
            int radix = numberWithRadix.component2();
            l = isUnsigned ? Long.parseUnsignedLong(number, radix) : Long.parseLong(number, radix);
        }
        catch (NumberFormatException e) {
            l = null;
        }
        return l;
    }

    private static final Number parseFloatingLiteral(String text2) {
        if (StringsKt.endsWith$default((CharSequence)text2, (char)'f', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)text2, (char)'F', (boolean)false, (int)2, null)) {
            return ParseUtilsKt.parseFloat(text2);
        }
        return ParseUtilsKt.parseDouble(text2);
    }

    private static final Double parseDouble(String text2) {
        Double d;
        try {
            d = Double.parseDouble(text2);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        return d;
    }

    private static final Float parseFloat(String text2) {
        Float f;
        try {
            f = Float.valueOf(Float.parseFloat(text2));
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    public static final boolean parseBoolean(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (Intrinsics.areEqual((Object)"true", (Object)text2)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)"false", (Object)text2)) {
            return false;
        }
        throw new IllegalStateException("Must not happen. A boolean literal has text: " + text2);
    }

    private static final String parseLong$removeSuffix(String $this$parseLong_u24removeSuffix, int i2) {
        String string2 = $this$parseLong_u24removeSuffix.substring(0, $this$parseLong_u24removeSuffix.length() - i2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }
}

