/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"renameLabels", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "js.translator"})
public final class RenameLabelsKt {
    public static final void renameLabels(@NotNull JsNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.accept(new RecursiveJsVisitor(){
            private final Map<JsName, JsName> replacements;
            private Set<String> labels;
            {
                this.replacements = new LinkedHashMap<K, V>();
                this.labels = new LinkedHashSet<E>();
            }

            public final Map<JsName, JsName> getReplacements() {
                return this.replacements;
            }

            public final Set<String> getLabels() {
                return this.labels;
            }

            public final void setLabels(Set<String> set) {
                Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
                this.labels = set;
            }

            protected void visitElement(JsNode node) {
                block1: {
                    JsName name2;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    super.visitElement(node);
                    if (!(node instanceof HasName) || (name2 = ((HasName)((Object)node)).getName()) == null) break block1;
                    JsName jsName = this.replacements.get(name2);
                    if (jsName != null) {
                        JsName it = jsName;
                        boolean bl = false;
                        ((HasName)((Object)node)).setName(it);
                    }
                }
            }

            public void visitLabel(JsLabel x) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    String addedName = null;
                    if (x.getName().isTemporary()) {
                        String string2 = x.getName().getIdent();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdent(...)");
                        String resolvedName = string2;
                        int suffix = 0;
                        while (!this.labels.add(resolvedName)) {
                            resolvedName = x.getName().getIdent() + '_' + suffix++;
                        }
                        Map<JsName, JsName> map = this.replacements;
                        JsName jsName = x.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                        JsName jsName2 = jsName;
                        JsName jsName3 = JsDynamicScope.INSTANCE.declareName(resolvedName);
                        Intrinsics.checkNotNullExpressionValue((Object)jsName3, (String)"declareName(...)");
                        JsName jsName4 = jsName3;
                        map.put(jsName2, jsName4);
                        addedName = resolvedName;
                    }
                    super.visitLabel(x);
                    String string3 = addedName;
                    if (string3 == null) break block2;
                    String it = string3;
                    boolean bl = false;
                    this.labels.remove(it);
                }
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Set<String> oldLabels = this.labels;
                this.labels = new LinkedHashSet<E>();
                super.visitFunction(x);
                this.labels = oldLabels;
            }
        });
    }
}

