/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.ExpressionDecomposer;
import org.jetbrains.kotlin.js.inline.InlineFunctionDefinition;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.InliningScope;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedLocalFunctionDeclarationsKt;
import org.jetbrains.kotlin.js.inline.clean.SubstituteKTypesKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0016J\u001c\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010 \u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00182\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u001c\u0010 \u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/inline/InlineAstVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "jsInliner", "Lorg/jetbrains/kotlin/js/inline/JsInliner;", "scope", "Lorg/jetbrains/kotlin/js/inline/InliningScope;", "(Lorg/jetbrains/kotlin/js/inline/JsInliner;Lorg/jetbrains/kotlin/js/inline/InliningScope;)V", "copyInlineMetadata", "", "from", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "to", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "doAcceptStatementList", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "endVisit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "call", "hasToBeInlined", "", "node", "patchReturnsFromSecondaryConstructor", "tryCreatePropertyGetterInvocation", "tryCreatePropertySetterInvocation", "visit", "js.translator"})
@SourceDebugExtension(value={"SMAP\nInlineAstVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineAstVisitor.kt\norg/jetbrains/kotlin/js/inline/InlineAstVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class InlineAstVisitor
extends JsVisitorWithContextImpl {
    @NotNull
    private final JsInliner jsInliner;
    @NotNull
    private final InliningScope scope;

    public InlineAstVisitor(@NotNull JsInliner jsInliner, @NotNull InliningScope scope2) {
        Intrinsics.checkNotNullParameter((Object)jsInliner, (String)"jsInliner");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.jsInliner = jsInliner;
        this.scope = scope2;
    }

    public boolean visit(@NotNull JsInvocation x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(x);
        if (inlineMetadata != null) {
            InlineMetadata it = inlineMetadata;
            boolean bl = false;
            this.jsInliner.process(new InlineFunctionDefinition(it.getFunction(), it.getTag().getValue()), x, this.scope.getFragment(), this.scope);
            return false;
        }
        FunctionWithWrapper functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(x);
        if (functionWithWrapper != null) {
            FunctionWithWrapper it = functionWithWrapper;
            boolean bl = false;
            this.jsInliner.process(new InlineFunctionDefinition(it, null), x, this.scope.getFragment(), this.scope);
            return false;
        }
        return super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return (Boolean)this.jsInliner.getCycleReporter().withFunction(x, (Function0)new Function0<Boolean>(this, x, ctx){
            final /* synthetic */ InlineAstVisitor this$0;
            final /* synthetic */ JsFunction $x;
            final /* synthetic */ JsContext<?> $ctx;
            {
                this.this$0 = $receiver;
                this.$x = $x;
                this.$ctx = $ctx;
                super(0);
            }

            public final Boolean invoke() {
                return InlineAstVisitor.access$visit$s772187716(this.this$0, this.$x, this.$ctx);
            }
        });
    }

    public void endVisit(@NotNull JsFunction function2, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.patchReturnsFromSecondaryConstructor(function2);
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        JsNode jsNode = jsBlock;
        JsFunctionScope jsFunctionScope = function2.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)jsFunctionScope, (String)"getScope(...)");
        NamingUtilsKt.refreshLabelNames(jsNode, jsFunctionScope);
        RemoveUnusedLocalFunctionDeclarationsKt.removeUnusedLocalFunctionDeclarations(function2);
        new FunctionPostProcessor(function2, null, 2, null).apply();
        SubstituteKTypesKt.substituteKTypes(function2);
    }

    public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            JsInvocation jsInvocation = this.tryCreatePropertyGetterInvocation(x);
            if (jsInvocation == null) break block0;
            JsInvocation it = jsInvocation;
            boolean bl = false;
            this.endVisit(it, ctx);
        }
    }

    public void endVisit(@NotNull JsBinaryOperation x, @NotNull JsContext<? super JsNode> ctx) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            JsInvocation jsInvocation = this.tryCreatePropertySetterInvocation(x);
            if (jsInvocation == null) break block0;
            JsInvocation it = jsInvocation;
            boolean bl = false;
            this.endVisit(it, ctx);
        }
    }

    public void endVisit(@NotNull JsInvocation call2, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (this.hasToBeInlined(call2)) {
            InlineableResult inlineableResult = this.jsInliner.inline(this.scope, call2, this.getLastStatementLevelContext().getCurrentNode());
            JsStatement inlineableBody = inlineableResult.component1();
            JsExpression resultExpression2 = inlineableResult.component2();
            this.getLastStatementLevelContext().addPrevious(JsAstUtils.flattenStatement(inlineableBody));
            if (resultExpression2 == null) {
                this.getLastStatementLevelContext().removeMe();
            } else {
                ctx.replaceMe((JsNode)resultExpression2);
            }
        }
    }

    @Override
    protected void doAcceptStatementList(@NotNull List<JsStatement> statements2) {
        List<JsStatement> additionalStatements2;
        Intrinsics.checkNotNullParameter(statements2, (String)"statements");
        for (int i2 = 0; i2 < statements2.size(); i2 += additionalStatements2.size() + 1) {
            additionalStatements2 = ExpressionDecomposer.Companion.preserveEvaluationOrder(statements2.get(i2), (Function1<? super JsNode, Boolean>)((Function1)new Function1<JsNode, Boolean>((Object)this){

                public final Boolean invoke(JsNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return InlineAstVisitor.access$hasToBeInlined((InlineAstVisitor)this.receiver, p0);
                }

                public final String getSignature() {
                    return "hasToBeInlined(Lorg/jetbrains/kotlin/js/backend/ast/JsNode;)Z";
                }

                public final String getName() {
                    return "hasToBeInlined";
                }

                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(InlineAstVisitor.class);
                }
            }));
            statements2.addAll(i2, (Collection<JsStatement>)additionalStatements2);
        }
        super.doAcceptStatementList(statements2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasToBeInlined(JsNode node) {
        JsNode jsNode = node;
        if (!(jsNode instanceof JsInvocation)) {
            if (jsNode instanceof JsNameRef) {
                if (MetadataProperties.isInline((JsNameRef)node) == null) return false;
                JsInvocation jsInvocation = this.tryCreatePropertyGetterInvocation((JsNameRef)node);
                if (jsInvocation == null) return false;
                JsInvocation it = jsInvocation;
                boolean bl = false;
                boolean bl2 = this.hasToBeInlined(it);
                if (!bl2) return false;
                return true;
            }
            if (!(jsNode instanceof JsBinaryOperation)) return false;
            if (!((JsBinaryOperation)node).getOperator().isAssignment()) return false;
            JsExpression jsExpression = ((JsBinaryOperation)node).getArg1();
            if (jsExpression == null) return false;
            JsExpression left = jsExpression;
            boolean bl = false;
            if (!(left instanceof JsNameRef)) return false;
            if (MetadataProperties.isInline((JsNameRef)left) == null) return false;
            JsInvocation jsInvocation = this.tryCreatePropertySetterInvocation((JsBinaryOperation)node);
            if (jsInvocation == null) return false;
            JsInvocation it = jsInvocation;
            boolean bl3 = false;
            boolean bl4 = this.hasToBeInlined(it);
            if (!bl4) return false;
            return true;
        }
        boolean bl = this.hasToBeInlined((JsInvocation)node);
        return bl;
    }

    private final boolean hasToBeInlined(JsInvocation call2) {
        return Intrinsics.areEqual((Object)MetadataProperties.isInline(call2), (Object)true) && this.jsInliner.getFunctionDefinitionLoader().hasFunctionDefinition(call2, this.scope);
    }

    private final void patchReturnsFromSecondaryConstructor(JsFunction function2) {
        block0: {
            JsName jsName = MetadataProperties.getForcedReturnVariable(function2);
            if (jsName == null) break block0;
            JsName returnVariable = jsName;
            boolean bl = false;
            function2.getBody().accept(new RecursiveJsVisitor(returnVariable){
                final /* synthetic */ JsName $returnVariable;
                {
                    this.$returnVariable = $returnVariable;
                }

                public void visitReturn(JsReturn x) {
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    x.setExpression(this.$returnVariable.makeRef());
                }
            });
        }
    }

    private final JsInvocation tryCreatePropertyGetterInvocation(JsNameRef x) {
        if (MetadataProperties.isInline(x) != null && MetadataProperties.getDescriptor(x) instanceof PropertyGetterDescriptor) {
            JsInvocation dummyInvocation = new JsInvocation((JsExpression)x, new JsExpression[0]);
            this.copyInlineMetadata(x, dummyInvocation);
            return dummyInvocation;
        }
        return null;
    }

    private final JsInvocation tryCreatePropertySetterInvocation(JsBinaryOperation x) {
        if (!x.getOperator().isAssignment() || !(x.getArg1() instanceof JsNameRef)) {
            return null;
        }
        JsExpression jsExpression = x.getArg1();
        Intrinsics.checkNotNull((Object)jsExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
        JsNameRef name2 = (JsNameRef)jsExpression;
        if (MetadataProperties.isInline(name2) != null && MetadataProperties.getDescriptor(name2) instanceof PropertySetterDescriptor) {
            JsExpression[] jsExpressionArray = new JsExpression[]{x.getArg2()};
            JsInvocation dummyInvocation = new JsInvocation((JsExpression)name2, jsExpressionArray);
            this.copyInlineMetadata(name2, dummyInvocation);
            return dummyInvocation;
        }
        return null;
    }

    private final void copyInlineMetadata(JsNameRef from2, JsInvocation to) {
        MetadataProperties.setInline(to, MetadataProperties.isInline(from2));
        MetadataProperties.setDescriptor(to, MetadataProperties.getDescriptor(from2));
        MetadataProperties.setPsiElement(to, MetadataProperties.getPsiElement(from2));
    }

    public static final /* synthetic */ boolean access$visit$s772187716(InlineAstVisitor $this, JsFunction p0, JsContext p1) {
        return super.visit(p0, p1);
    }

    public static final /* synthetic */ boolean access$hasToBeInlined(InlineAstVisitor $this, JsNode node) {
        return $this.hasToBeInlined(node);
    }
}

