/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.CallToPotentiallyHiddenSymbolResult;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CallToDeprecatedOverrideOfHidden;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.resolve.calls.SyntheticsKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ4\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isHiddenForThisCallSite", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isDeprecatedHidden", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckerSinkKt\n*L\n1#1,861:1\n21#2:862\n28#3,2:863\n22#3,9:865\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n*L\n755#1:862\n760#1:863,2\n760#1:865,9\n*E\n"})
public final class CheckHiddenDeclaration
extends ResolutionStage {
    @NotNull
    public static final CheckHiddenDeclaration INSTANCE = new CheckHiddenDeclaration();

    private CheckHiddenDeclaration() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        block9: {
            void $this$yieldDiagnostic$iv;
            Object $this$isActual$iv;
            block7: {
                FirCallableSymbol symbol2;
                block8: {
                    FirBasedSymbol<?> firBasedSymbol = candidate2.getSymbol();
                    FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
                    if (firCallableSymbol == null) {
                        return Unit.INSTANCE;
                    }
                    symbol2 = firCallableSymbol;
                    $this$isActual$iv = symbol2;
                    boolean $i$f$isActual = false;
                    if (((FirCallableSymbol)$this$isActual$iv).getRawStatus().isActual()) {
                        return Unit.INSTANCE;
                    }
                    if (this.isDeprecatedHidden(symbol2, context2, callInfo)) break block7;
                    if (!(symbol2 instanceof FirConstructorSymbol)) break block8;
                    FirTypeAliasSymbol firTypeAliasSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructorSymbol)symbol2);
                    if (firTypeAliasSymbol != null ? this.isDeprecatedHidden(firTypeAliasSymbol, context2, callInfo) : false) break block7;
                }
                if (!this.isHiddenForThisCallSite(symbol2, callInfo, candidate2, context2.getSession(), sink)) break block9;
            }
            $this$isActual$iv = sink;
            ResolutionDiagnostic diagnostic$iv = HiddenCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean isDeprecatedHidden(FirBasedSymbol<?> $this$isDeprecatedHidden, ResolutionContext context2, CallInfo callInfo) {
        DeprecationInfo deprecation;
        DeprecationInfo deprecationInfo = deprecation = DeprecationUtilsKt.getDeprecation($this$isDeprecatedHidden, context2.getSession(), callInfo.getCallSite());
        return (deprecationInfo != null ? deprecationInfo.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN;
    }

    private final boolean isHiddenForThisCallSite(FirCallableSymbol<?> symbol2, CallInfo callInfo, Candidate candidate2, FirSession session2, CheckerSink sink) {
        if (symbol2 instanceof FirSimpleSyntheticPropertySymbol && SyntheticsKt.getDeprecatedOverrideOfHidden((FirSimpleSyntheticPropertySymbol)symbol2)) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        if (((FirCallableDeclaration)symbol2.getFir()).getDispatchReceiverType() == null || !(symbol2 instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        boolean isSuperCall = ResolutionStagesKt.isSuperCall(callInfo.getCallSite(), session2);
        if (DeprecationUtilsKt.hiddenStatusOfCall(symbol2, isSuperCall, false) == CallToPotentiallyHiddenSymbolResult.Hidden) {
            return true;
        }
        FirScope firScope2 = candidate2.getOriginScope();
        FirTypeScope firTypeScope = firScope2 instanceof FirTypeScope ? (FirTypeScope)firScope2 : null;
        if (firTypeScope == null) {
            return false;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.BooleanRef hidden = new Ref.BooleanRef();
        Ref.BooleanRef deprecated = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(isSuperCall, hidden, deprecated){
            final /* synthetic */ boolean $isSuperCall;
            final /* synthetic */ Ref.BooleanRef $hidden;
            final /* synthetic */ Ref.BooleanRef $deprecated;
            {
                this.$isSuperCall = $isSuperCall;
                this.$hidden = $hidden;
                this.$deprecated = $deprecated;
                super(1);
            }

            public final ProcessorAction invoke(FirNamedFunctionSymbol it) {
                ProcessorAction processorAction;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CallToPotentiallyHiddenSymbolResult result2 = DeprecationUtilsKt.hiddenStatusOfCall(it, this.$isSuperCall, true);
                if (result2 != CallToPotentiallyHiddenSymbolResult.Visible) {
                    if (result2 == CallToPotentiallyHiddenSymbolResult.Hidden) {
                        this.$hidden.element = true;
                    } else if (result2 == CallToPotentiallyHiddenSymbolResult.VisibleWithDeprecation) {
                        this.$deprecated.element = true;
                    }
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
                return processorAction;
            }
        }));
        if (deprecated.element) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        return hidden.element;
    }
}

