/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionEvaluator;
import org.jetbrains.kotlin.fir.expressions.FirExpressionEvaluatorKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationArgumentMappingBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayLiteralBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0014\u001a\u00020\u0015*\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u0016\u001a\u00020\u0006*\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J)\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u0018*\u0006\u0012\u0002\b\u00030\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u0019H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator;", "", "()V", "evaluateAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "evaluateDefault", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "evaluateExpression", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "evaluatePropertyInitializer", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "canBeEvaluated", "", "evaluate", "visit", "T", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "wasVisited", "EvaluationVisitor", "providers"})
@SourceDebugExtension(value={"SMAP\nFirExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,550:1\n47#2:551\n1755#3,3:552\n1246#3,4:557\n462#4:555\n412#4:556\n*S KotlinDebug\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator\n*L\n40#1:551\n71#1:552,3\n75#1:557,4\n75#1:555\n75#1:556\n*E\n"})
public final class FirExpressionEvaluator {
    @NotNull
    public static final FirExpressionEvaluator INSTANCE = new FirExpressionEvaluator();

    private FirExpressionEvaluator() {
    }

    @Nullable
    public final FirEvaluatorResult evaluatePropertyInitializer(@NotNull FirProperty property2, @NotNull FirSession session2) {
        ConeKotlinType type2;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirMemberDeclaration $this$isConst$iv = property2;
        boolean $i$f$isConst = false;
        if (!$this$isConst$iv.getStatus().isConst()) {
            return null;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(property2.getReturnTypeRef());
        ConeKotlinType coneKotlinType2 = type2 = coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType(coneKotlinType, session2) : null;
        if (type2 == null || type2 instanceof ConeErrorType || !FirConstChecksKt.canBeUsedForConstVal(type2)) {
            return null;
        }
        FirExpression initializer2 = property2.getInitializer();
        if (initializer2 == null || !this.canBeEvaluated(initializer2, session2)) {
            return null;
        }
        return this.evaluate(initializer2, session2);
    }

    @Nullable
    public final FirEvaluatorResult evaluateDefault(@NotNull FirValueParameter valueParameter2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!DeclarationUtilsKt.isAnnotationConstructor((FirBasedSymbol)valueParameter2.getContainingFunctionSymbol(), session2)) {
            return null;
        }
        FirExpression firExpression2 = valueParameter2.getDefaultValue();
        if (firExpression2 == null) {
            return null;
        }
        FirExpression defaultValueToEvaluate = firExpression2;
        if (!this.canBeEvaluated(defaultValueToEvaluate, session2)) {
            return null;
        }
        return this.evaluate(defaultValueToEvaluate, session2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<Name, FirEvaluatorResult> evaluateAnnotationArguments(@NotNull FirAnnotation annotation2, @NotNull FirSession session2) {
        void $this$mapValuesTo$iv$iv;
        boolean bl;
        Map<Name, FirExpression> argumentMapping2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            argumentMapping2 = annotation2.getArgumentMapping().getMapping();
            Iterable $this$any$iv = argumentMapping2.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirExpression expr = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (!(!INSTANCE.canBeEvaluated(expr, session2))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Map<Name, FirExpression> $this$mapValues$iv = argumentMapping2;
        boolean $i$f$mapValues = false;
        Map<Name, FirExpression> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl4 = false;
            FirExpression expression2 = (FirExpression)entry2.getValue();
            FirEvaluatorResult firEvaluatorResult = INSTANCE.evaluate(expression2, session2);
            map3.put(k, firEvaluatorResult);
        }
        return destination$iv$iv;
    }

    @Nullable
    public final FirEvaluatorResult evaluateExpression(@NotNull FirExpression expression2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!this.canBeEvaluated(expression2, session2)) {
            return null;
        }
        return this.evaluate(expression2, session2);
    }

    private final boolean canBeEvaluated(FirExpression $this$canBeEvaluated, FirSession session2) {
        boolean intrinsicConstEvaluation = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
        if ($this$canBeEvaluated == null || intrinsicConstEvaluation || $this$canBeEvaluated instanceof FirLazyExpression || !FirTypeUtilsKt.isResolved($this$canBeEvaluated)) {
            return false;
        }
        return FirConstChecksKt.canBeEvaluatedAtCompileTime($this$canBeEvaluated, session2, false, false);
    }

    private final FirEvaluatorResult evaluate(FirExpression $this$evaluate, FirSession session2) {
        EvaluationVisitor visitor2 = new EvaluationVisitor(session2);
        return visitor2.evaluate($this$evaluate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T visit(FirCallableSymbol<?> $this$visit, Function0<? extends T> block) {
        Object object = $this$visit.getFir();
        FirProperty firProperty = object instanceof FirProperty ? (FirProperty)object : null;
        if (firProperty == null) {
            return (T)block.invoke();
        }
        FirProperty firProperty2 = firProperty;
        FirEvaluatorResult oldEvaluatedResult = DeclarationAttributesKt.getEvaluatedInitializer(firProperty2);
        DeclarationAttributesKt.setEvaluatedInitializer(firProperty2, FirEvaluatorResult.DuringEvaluation.INSTANCE);
        try {
            object = block.invoke();
            return (T)object;
        }
        finally {
            DeclarationAttributesKt.setEvaluatedInitializer(firProperty2, oldEvaluatedResult);
        }
    }

    private final boolean wasVisited(FirCallableSymbol<?> $this$wasVisited) {
        Object e = $this$wasVisited.getFir();
        FirProperty firProperty = e instanceof FirProperty ? (FirProperty)e : null;
        if (firProperty == null) {
            return false;
        }
        FirProperty firProperty2 = firProperty;
        return Intrinsics.areEqual((Object)DeclarationAttributesKt.getEvaluatedInitializer(firProperty2), (Object)FirEvaluatorResult.DuringEvaluation.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u00020$2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u0002052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00106\u001a\u00020\u0002\"\u0004\b\u0000\u001072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H7092\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u0010/\u001a\u00020$2\u0006\u0010>\u001a\u00020?H\u0002J\u001a\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010F\u001a\u00020\u00022\u0006\u0010G\u001a\u00020H2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010I\u001a\u00020\u00022\u0006\u0010J\u001a\u00020K2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010L\u001a\u00020\u00022\u0006\u0010M\u001a\u00020N2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010O\u001a\u00020\u00022\u0006\u0010P\u001a\u00020Q2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010R\u001a\u00020\u00022\u0006\u0010S\u001a\u00020T2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "evaluate", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitArgumentList", "argumentList", "Lorg/jetbrains/kotlin/fir/expressions/FirArgumentList;", "visitArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "visitClassReferenceExpression", "classReferenceExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirClassReferenceExpression;", "visitComparisonExpression", "comparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "visitConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntryDeserializedAccessExpression", "enumEntryDeserializedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirEnumEntryDeserializedAccessExpression;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "visitFunctionCall", "functionCall", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitIntegerLiteralOperatorCall", "integerLiteralOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "visitLiteralExpression", "T", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "visitNamedFunction", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitResolvedNamedReference", "resolvedNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitSpreadArgumentExpression", "spreadArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSpreadArgumentExpression;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "providers"})
    @SourceDebugExtension(value={"SMAP\nFirExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirEvaluatorResult.kt\norg/jetbrains/kotlin/fir/FirEvaluatorResultKt\n+ 5 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 6 FirNamedArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirNamedArgumentExpressionBuilderKt\n+ 7 FirArrayLiteralBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArrayLiteralBuilderKt\n+ 8 FirVarargArgumentsExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirVarargArgumentsExpressionBuilderKt\n+ 9 FirSpreadArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSpreadArgumentExpressionBuilderKt\n+ 10 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 11 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 12 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 13 FirAnnotationBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationBuilderKt\n+ 14 FirAnnotationArgumentMappingBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationArgumentMappingBuilderKt\n*L\n1#1,550:1\n423#2:551\n1246#3,2:552\n1249#3:558\n1557#3:563\n1628#3,2:564\n1630#3:570\n1557#3:591\n1628#3,2:592\n1630#3:598\n1557#3:612\n1628#3,2:613\n1630#3:619\n1557#3:643\n1628#3,2:644\n1630#3:650\n1557#3:663\n1628#3,2:664\n1630#3:670\n28#4,4:554\n28#4,4:566\n28#4,4:575\n28#4,4:583\n28#4,4:594\n28#4,4:603\n28#4,4:607\n28#4,4:615\n28#4,6:621\n28#4,6:632\n28#4,4:638\n28#4,4:646\n28#4,6:651\n28#4,6:657\n28#4,4:666\n28#4,6:672\n33#5,4:559\n54#6,4:571\n44#7,4:579\n46#8,4:587\n53#9,4:599\n43#10:611\n45#10:631\n43#10:642\n45#10:671\n1#11:620\n63#12,4:627\n66#13,10:678\n32#14,4:688\n*S KotlinDebug\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor\n*L\n140#1:551\n140#1:552,2\n140#1:558\n144#1:563\n144#1:564,2\n144#1:570\n175#1:591\n175#1:592,2\n175#1:598\n237#1:612\n237#1:613,2\n237#1:619\n303#1:643\n303#1:644,2\n303#1:650\n333#1:663\n333#1:664,2\n333#1:670\n140#1:554,4\n144#1:566,4\n153#1:575,4\n165#1:583,4\n175#1:594,4\n184#1:603,4\n210#1:607,4\n238#1:615,4\n260#1:621,6\n274#1:632,6\n290#1:638,4\n304#1:646,4\n321#1:651,6\n322#1:657,6\n334#1:666,4\n342#1:672,6\n142#1:559,4\n150#1:571,4\n161#1:579,4\n171#1:587,4\n181#1:599,4\n237#1:611\n273#1:631\n303#1:642\n342#1:671\n261#1:627,4\n377#1:678,10\n378#1:688,4\n*E\n"})
    private static final class EvaluationVisitor
    extends FirVisitor {
        @NotNull
        private final FirSession session;

        public EvaluationVisitor(@NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.session = session2;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final FirEvaluatorResult evaluate(@Nullable FirExpression expression2) {
            Object object = expression2;
            if (object == null || (object = (FirEvaluatorResult)((FirExpression)object).accept(this, null)) == null) {
                object = FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            return object;
        }

        @NotNull
        public FirEvaluatorResult visitElement(@NotNull FirElement element, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            throw new IllegalStateException(("FIR element \"" + Reflection.getOrCreateKotlinClass(element.getClass()) + "\" is not supported in constant evaluation").toString());
        }

        @NotNull
        public <T> FirEvaluatorResult visitLiteralExpression(@NotNull FirLiteralExpression<T> literalExpression, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter(literalExpression, (String)"literalExpression");
            return FirExpressionEvaluatorKt.access$wrap(literalExpression);
        }

        @NotNull
        public FirEvaluatorResult visitResolvedNamedReference(@NotNull FirResolvedNamedReference resolvedNamedReference, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)resolvedNamedReference, (String)"resolvedNamedReference");
            return FirExpressionEvaluatorKt.access$wrap(resolvedNamedReference);
        }

        @NotNull
        public FirEvaluatorResult visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
            return FirExpressionEvaluatorKt.access$wrap(resolvedQualifier);
        }

        @NotNull
        public FirEvaluatorResult visitGetClassCall(@NotNull FirGetClassCall getClassCall, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
            return FirExpressionEvaluatorKt.access$wrap(getClassCall);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitArgumentList(@NotNull FirArgumentList argumentList2, @Nullable Void data2) {
            FirArgumentList firArgumentList;
            Intrinsics.checkNotNullParameter((Object)argumentList2, (String)"argumentList");
            if (argumentList2 instanceof FirResolvedArgumentList) {
                void destination$iv;
                void $this$mapKeysTo$iv;
                Map map = ((FirResolvedArgumentList)argumentList2).getMapping();
                Map map2 = new LinkedHashMap();
                FirArgumentList firArgumentList2 = ((FirResolvedArgumentList)argumentList2).getOriginalArgumentList();
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv = $this$mapKeysTo$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it$iv;
                    FirElement firElement;
                    FirExpression it;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    void var24_35 = destination$iv;
                    boolean $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22 = false;
                    FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it.getKey());
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                    if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl = false;
                        return it2;
                    }
                    if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        firElement = (FirExpression)firElement2;
                    } else {
                        firElement = null;
                    }
                    if ((FirExpression)firElement == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    Map.Entry entry2 = (Map.Entry)element$iv$iv;
                    void var18_31 = var24_35;
                    boolean bl = false;
                    Object $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22 = it$iv.getValue();
                    var18_31.put(it, $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22);
                }
                firArgumentList = FirArgumentUtilKt.buildResolvedArgumentList(firArgumentList2, (LinkedHashMap)destination$iv);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                FirArgumentListBuilder firArgumentListBuilder;
                boolean $i$f$buildArgumentList = false;
                FirArgumentListBuilder $this$visitArgumentList_u24lambda_u244 = firArgumentListBuilder = new FirArgumentListBuilder();
                boolean bl = false;
                $this$visitArgumentList_u24lambda_u244.setSource(argumentList2.getSource());
                Iterable $i$f$associateByTo = argumentList2.getArguments();
                List<FirExpression> list2 = $this$visitArgumentList_u24lambda_u244.getArguments();
                boolean $i$f$map = false;
                void it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    FirElement firElement;
                    FirExpression it2 = (FirExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(it2);
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                    if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it3 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl3 = false;
                        return it3;
                    }
                    if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement3 instanceof FirExpression)) {
                            firElement3 = null;
                        }
                        firElement = (FirExpression)firElement3;
                    } else {
                        firElement = null;
                    }
                    FirExpression firExpression2 = (FirExpression)firElement;
                    if (firExpression2 == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    collection.add(firExpression2);
                }
                list2.addAll((List)destination$iv$iv);
                firArgumentList = firArgumentListBuilder.build();
            }
            return FirExpressionEvaluatorKt.access$wrap(firArgumentList);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @Nullable Void data2) {
            FirElement firElement;
            FirNamedArgumentExpressionBuilder firNamedArgumentExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)namedArgumentExpression, (String)"namedArgumentExpression");
            boolean $i$f$buildNamedArgumentExpression = false;
            FirNamedArgumentExpressionBuilder $this$visitNamedArgumentExpression_u24lambda_u246 = firNamedArgumentExpressionBuilder = new FirNamedArgumentExpressionBuilder();
            boolean bl = false;
            $this$visitNamedArgumentExpression_u24lambda_u246.setSource(namedArgumentExpression.getSource());
            $this$visitNamedArgumentExpression_u24lambda_u246.getAnnotations().addAll((Collection<FirAnnotation>)namedArgumentExpression.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(namedArgumentExpression.getExpression());
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                firElement = (FirExpression)firElement2;
            } else {
                firElement = null;
            }
            FirExpression firExpression2 = (FirExpression)firElement;
            if (firExpression2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitNamedArgumentExpression_u24lambda_u246.setExpression(firExpression2);
            $this$visitNamedArgumentExpression_u24lambda_u246.setSpread(namedArgumentExpression.isSpread());
            $this$visitNamedArgumentExpression_u24lambda_u246.setName(namedArgumentExpression.getName());
            return FirExpressionEvaluatorKt.access$wrap(firNamedArgumentExpressionBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @Nullable Void data2) {
            FirElement firElement;
            FirArrayLiteralBuilder firArrayLiteralBuilder;
            Intrinsics.checkNotNullParameter((Object)arrayLiteral, (String)"arrayLiteral");
            boolean $i$f$buildArrayLiteral = false;
            FirArrayLiteralBuilder $this$visitArrayLiteral_u24lambda_u248 = firArrayLiteralBuilder = new FirArrayLiteralBuilder();
            boolean bl = false;
            $this$visitArrayLiteral_u24lambda_u248.setSource(arrayLiteral.getSource());
            $this$visitArrayLiteral_u24lambda_u248.setConeTypeOrNull(arrayLiteral.getConeTypeOrNull());
            $this$visitArrayLiteral_u24lambda_u248.getAnnotations().addAll((Collection<FirAnnotation>)arrayLiteral.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.visitArgumentList(arrayLiteral.getArgumentList(), data2);
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirArgumentList)) {
                    firElement2 = null;
                }
                firElement = (FirArgumentList)firElement2;
            } else {
                firElement = null;
            }
            FirArgumentList firArgumentList = (FirArgumentList)firElement;
            if (firArgumentList == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitArrayLiteral_u24lambda_u248.setArgumentList(firArgumentList);
            return FirExpressionEvaluatorKt.access$wrap(firArrayLiteralBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @Nullable Void data2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)varargArgumentsExpression, (String)"varargArgumentsExpression");
            boolean $i$f$buildVarargArgumentsExpression = false;
            FirVarargArgumentsExpressionBuilder $this$visitVarargArgumentsExpression_u24lambda_u2411 = firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
            boolean bl = false;
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setSource(varargArgumentsExpression.getSource());
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setConeTypeOrNull(varargArgumentsExpression.getConeTypeOrNull());
            $this$visitVarargArgumentsExpression_u24lambda_u2411.getAnnotations().addAll((Collection<FirAnnotation>)varargArgumentsExpression.getAnnotations());
            Iterable iterable = varargArgumentsExpression.getArguments();
            List<FirExpression> list2 = $this$visitVarargArgumentsExpression_u24lambda_u2411.getArguments();
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl3 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirExpression firExpression3 = (FirExpression)firElement;
                if (firExpression3 == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firExpression3);
            }
            list2.addAll((List)destination$iv$iv);
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setConeElementTypeOrNull(varargArgumentsExpression.getConeElementTypeOrNull());
            return FirExpressionEvaluatorKt.access$wrap(firVarargArgumentsExpressionBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitSpreadArgumentExpression(@NotNull FirSpreadArgumentExpression spreadArgumentExpression, @Nullable Void data2) {
            FirElement firElement;
            FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder;
            Intrinsics.checkNotNullParameter((Object)spreadArgumentExpression, (String)"spreadArgumentExpression");
            boolean $i$f$buildSpreadArgumentExpression = false;
            FirSpreadArgumentExpressionBuilder $this$visitSpreadArgumentExpression_u24lambda_u2413 = firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
            boolean bl = false;
            $this$visitSpreadArgumentExpression_u24lambda_u2413.setSource(spreadArgumentExpression.getSource());
            $this$visitSpreadArgumentExpression_u24lambda_u2413.getAnnotations().addAll((Collection<FirAnnotation>)spreadArgumentExpression.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(spreadArgumentExpression.getExpression());
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                firElement = (FirExpression)firElement2;
            } else {
                firElement = null;
            }
            FirExpression firExpression2 = (FirExpression)firElement;
            if (firExpression2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitSpreadArgumentExpression_u24lambda_u2413.setExpression(firExpression2);
            return FirExpressionEvaluatorKt.access$wrap(firSpreadArgumentExpressionBuilder.build());
        }

        @NotNull
        public FirEvaluatorResult visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @Nullable Void data2) {
            FirEvaluatorResult firEvaluatorResult;
            Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
            FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(propertyAccessExpression.getCalleeReference(), false, 1, null);
            if (firCallableSymbol == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirCallableSymbol propertySymbol = firCallableSymbol;
            if (INSTANCE.wasVisited(propertySymbol)) {
                return FirEvaluatorResult.RecursionInInitializer.INSTANCE;
            }
            FirCallableSymbol firCallableSymbol2 = propertySymbol;
            if (firCallableSymbol2 instanceof FirPropertySymbol) {
                if (FirExpressionEvaluatorKt.access$isStringLength(propertySymbol.getCallableId()) || FirExpressionEvaluatorKt.access$isCharCode(propertySymbol.getCallableId())) {
                    FirElement firElement;
                    FirEvaluatorResult receiver = this.evaluate(propertyAccessExpression.getExplicitReceiver());
                    boolean bl = false;
                    FirEvaluatorResult $this$unwrapOr$iv = receiver;
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv;
                    if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl2 = false;
                        return it;
                    }
                    if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        firElement = (FirExpression)firElement2;
                    } else {
                        firElement = null;
                    }
                    FirExpression firExpression2 = (FirExpression)firElement;
                    if (firExpression2 == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    FirExpression unaryArg = firExpression2;
                    firEvaluatorResult = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(FirExpressionEvaluatorKt.access$evaluateUnary(unaryArg, propertySymbol.getCallableId()), propertyAccessExpression);
                } else {
                    firEvaluatorResult = EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy(propertySymbol, propertyAccessExpression, this, ((FirProperty)((FirPropertySymbol)propertySymbol).getFir()).getInitializer());
                }
            } else if (firCallableSymbol2 instanceof FirFieldSymbol) {
                firEvaluatorResult = EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy(propertySymbol, propertyAccessExpression, this, ((FirField)((FirFieldSymbol)propertySymbol).getFir()).getInitializer());
            } else if (firCallableSymbol2 instanceof FirEnumEntrySymbol) {
                firEvaluatorResult = FirExpressionEvaluatorKt.access$wrap(propertyAccessExpression);
            } else {
                throw new IllegalStateException(("FIR symbol \"" + Reflection.getOrCreateKotlinClass(propertySymbol.getClass()) + "\" is not supported in constant evaluation").toString());
            }
            return firEvaluatorResult;
        }

        @NotNull
        public FirEvaluatorResult visitFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
            FirNamedReference calleeReference = functionCall.getCalleeReference();
            if (!(calleeReference instanceof FirResolvedNamedReference)) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirBasedSymbol<?> symbol2 = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            return symbol2 instanceof FirNamedFunctionSymbol ? this.visitNamedFunction(functionCall, (FirNamedFunctionSymbol)symbol2) : (symbol2 instanceof FirConstructorSymbol ? this.visitConstructorCall(functionCall) : (FirEvaluatorResult)FirEvaluatorResult.NotEvaluated.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        private final FirEvaluatorResult visitNamedFunction(FirFunctionCall functionCall, FirNamedFunctionSymbol symbol2) {
            FirEvaluatorResult firEvaluatorResult;
            void $this$mapTo$iv$iv;
            Object[] objectArray = new FirExpression[]{functionCall.getDispatchReceiver(), functionCall.getExtensionReceiver()};
            List receivers = CollectionsKt.listOfNotNull((Object[])objectArray);
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            Iterable $this$map$iv = CollectionsKt.plus((Collection)receivers, (Iterable)$this$arguments$iv.getArgumentList().getArguments());
            boolean $i$f$map22 = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv;
                if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl2 = false;
                    return it2;
                }
                if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List evaluatedArgs = (List)destination$iv$iv;
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)CollectionsKt.getOrNull((List)evaluatedArgs, (int)0);
            if (firLiteralExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression opr1 = firLiteralExpression;
            Object $i$f$map22 = FirExpressionEvaluatorKt.access$evaluateUnary(opr1, symbol2.getCallableId());
            if ($i$f$map22 != null && (object = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral($i$f$map22, functionCall)) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
            FirLiteralExpression firLiteralExpression2 = (FirLiteralExpression)CollectionsKt.getOrNull((List)evaluatedArgs, (int)1);
            if (firLiteralExpression2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression opr2 = firLiteralExpression2;
            object = FirExpressionEvaluatorKt.access$evaluateBinary(opr1, symbol2.getCallableId(), opr2);
            if (object != null && (firEvaluatorResult = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(object, functionCall)) != null) {
                FirEvaluatorResult it = firEvaluatorResult;
                boolean bl = false;
                return it;
            }
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private final FirEvaluatorResult visitConstructorCall(FirFunctionCall constructorCall) {
            ConeSimpleKotlinType type2 = ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getResolvedType(constructorCall), this.session));
            FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(type2, this.session);
            if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                FirElement firElement;
                FirFunctionCallBuilder $this$unwrapOr$iv;
                FirEvaluatorResult firEvaluatorResult = (FirEvaluatorResult)constructorCall.getArgumentList().accept(this, null);
                boolean $i$f$unwrapOr = false;
                FirFunctionCallBuilder firFunctionCallBuilder = $this$unwrapOr$iv;
                if (firFunctionCallBuilder instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)((Object)$this$unwrapOr$iv);
                    boolean bl = false;
                    return it;
                }
                if (firFunctionCallBuilder instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)((Object)$this$unwrapOr$iv)).getResult();
                    if (!(firElement2 instanceof FirResolvedArgumentList)) {
                        firElement2 = null;
                    }
                    firElement = (FirResolvedArgumentList)firElement2;
                } else {
                    firElement = null;
                }
                FirResolvedArgumentList firResolvedArgumentList = (FirResolvedArgumentList)firElement;
                if (firResolvedArgumentList == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                FirResolvedArgumentList evaluatedArgs = firResolvedArgumentList;
                boolean $i$f$buildFunctionCall = false;
                FirFunctionCallBuilder $this$visitConstructorCall_u24lambda_u2421 = $this$unwrapOr$iv = new FirFunctionCallBuilder();
                boolean bl = false;
                $this$visitConstructorCall_u24lambda_u2421.setConeTypeOrNull(constructorCall.getConeTypeOrNull());
                $this$visitConstructorCall_u24lambda_u2421.getAnnotations().addAll((Collection<FirAnnotation>)constructorCall.getAnnotations());
                $this$visitConstructorCall_u24lambda_u2421.getTypeArguments().addAll((Collection<FirTypeProjection>)constructorCall.getTypeArguments());
                $this$visitConstructorCall_u24lambda_u2421.setSource(constructorCall.getSource());
                $this$visitConstructorCall_u24lambda_u2421.getNonFatalDiagnostics().addAll((Collection<ConeDiagnostic>)constructorCall.getNonFatalDiagnostics());
                $this$visitConstructorCall_u24lambda_u2421.setArgumentList(evaluatedArgs);
                $this$visitConstructorCall_u24lambda_u2421.setCalleeReference(constructorCall.getCalleeReference());
                $this$visitConstructorCall_u24lambda_u2421.setOrigin(constructorCall.getOrigin());
                return FirExpressionEvaluatorKt.access$wrap($this$unwrapOr$iv.build());
            }
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(type2)) {
                FirLiteralExpression firLiteralExpression;
                FirElement firElement;
                void $this$unwrapOr$iv;
                Object $this$argument$iv = constructorCall;
                boolean $i$f$getArgument = false;
                $this$argument$iv = this.evaluate((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
                boolean $i$f$unwrapOr = false;
                void var7_10 = $this$unwrapOr$iv;
                if (var7_10 instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl = false;
                    return it;
                }
                if (var7_10 instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement3 instanceof FirLiteralExpression)) {
                        firElement3 = null;
                    }
                    firElement = (FirLiteralExpression)firElement3;
                } else {
                    firElement = null;
                }
                if ((firLiteralExpression = (FirLiteralExpression)firElement) == null || (firLiteralExpression = firLiteralExpression.getValue()) == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                FirLiteralExpression argument2 = firLiteralExpression;
                return FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(argument2, constructorCall);
            }
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }

        @NotNull
        public FirEvaluatorResult visitIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)integerLiteralOperatorCall, (String)"integerLiteralOperatorCall");
            return this.visitFunctionCall((FirFunctionCall)integerLiteralOperatorCall, data2);
        }

        @NotNull
        public FirEvaluatorResult visitComparisonExpression(@NotNull FirComparisonExpression comparisonExpression, @Nullable Void data2) {
            boolean bl;
            FirElement firElement;
            Intrinsics.checkNotNullParameter((Object)comparisonExpression, (String)"comparisonExpression");
            FirEvaluatorResult it = this.visitFunctionCall(comparisonExpression.getCompareToCall(), data2);
            boolean bl2 = false;
            FirEvaluatorResult $this$unwrapOr$iv = it;
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl3 = false;
                return it2;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirLiteralExpression)) {
                    firElement2 = null;
                }
                firElement = (FirLiteralExpression)firElement2;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
            Object t = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            Integer n = t instanceof Integer ? (Integer)t : null;
            if (n == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            int intResult = n;
            switch (WhenMappings.$EnumSwitchMapping$0[comparisonExpression.getOperation().ordinal()]) {
                case 1: {
                    if (intResult < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (intResult <= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (intResult > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (intResult >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported comparison operation type \"" + comparisonExpression.getOperation().name() + '\"').toString());
                }
            }
            boolean compareToResult = bl;
            return FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(compareToResult, comparisonExpression);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @Nullable Void data2) {
            boolean bl;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Object $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl3 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List evaluatedArgs = (List)destination$iv$iv;
            if (evaluatedArgs.size() != 2) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[equalityOperatorCall.getOperation().ordinal()]) {
                case 5: {
                    bl = Intrinsics.areEqual(((FirLiteralExpression)evaluatedArgs.get(0)).getValue(), ((FirLiteralExpression)evaluatedArgs.get(1)).getValue());
                    break;
                }
                case 6: {
                    if (!Intrinsics.areEqual(((FirLiteralExpression)evaluatedArgs.get(0)).getValue(), ((FirLiteralExpression)evaluatedArgs.get(1)).getValue())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Operation \"" + (Object)((Object)equalityOperatorCall.getOperation()) + "\" is not supported in compile time evaluation").toString());
                }
            }
            boolean result2 = bl;
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.Boolean.INSTANCE, equalityOperatorCall));
        }

        @NotNull
        public FirEvaluatorResult visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @Nullable Void data2) {
            boolean bl;
            FirElement firElement;
            FirElement firElement2;
            Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
            FirEvaluatorResult left = this.evaluate(binaryLogicExpression.getLeftOperand());
            FirEvaluatorResult right = this.evaluate(binaryLogicExpression.getRightOperand());
            FirEvaluatorResult $this$unwrapOr$iv = left;
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement3 instanceof FirLiteralExpression)) {
                    firElement3 = null;
                }
                firElement2 = (FirLiteralExpression)firElement3;
            } else {
                firElement2 = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement2;
            Object t = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            Boolean bl3 = t instanceof Boolean ? (Boolean)t : null;
            if (bl3 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            boolean leftBoolean = bl3;
            FirEvaluatorResult $this$unwrapOr$iv2 = right;
            boolean $i$f$unwrapOr2 = false;
            FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv2;
            if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv2;
                boolean bl4 = false;
                return it;
            }
            if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement4 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv2).getResult();
                if (!(firElement4 instanceof FirLiteralExpression)) {
                    firElement4 = null;
                }
                firElement = (FirLiteralExpression)firElement4;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression2 = (FirLiteralExpression)firElement;
            Object t2 = firLiteralExpression2 != null ? firLiteralExpression2.getValue() : null;
            Boolean bl5 = t2 instanceof Boolean ? (Boolean)t2 : null;
            if (bl5 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            boolean rightBoolean = bl5;
            switch (WhenMappings.$EnumSwitchMapping$1[binaryLogicExpression.getKind().ordinal()]) {
                case 1: {
                    if (leftBoolean && rightBoolean) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (leftBoolean || rightBoolean) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Boolean logic expression of a kind \"" + (Object)((Object)binaryLogicExpression.getKind()) + "\" is not supported in compile time evaluation").toString());
                }
            }
            boolean result2 = bl;
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.Boolean.INSTANCE, binaryLogicExpression));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @Nullable Void data2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)stringConcatenationCall, (String)"stringConcatenationCall");
            Iterable $this$map$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression2 = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl2 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List strings2 = (List)destination$iv$iv;
            String result2 = CollectionsKt.joinToString$default((Iterable)strings2, (CharSequence)"", null, null, (int)0, null, (Function1)visitStringConcatenationCall.result.1.INSTANCE, (int)30, null);
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.String.INSTANCE, stringConcatenationCall));
        }

        @NotNull
        public FirEvaluatorResult visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @Nullable Void data2) {
            FirElement firElement;
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            if (typeOperatorCall.getOperation() != FirOperation.AS) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirCall $this$argument$iv = typeOperatorCall;
            boolean $i$f$getArgument = false;
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl = false;
                return it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirLiteralExpression)) {
                    firElement2 = null;
                }
                firElement = (FirLiteralExpression)firElement2;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
            if (firLiteralExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression result2 = firLiteralExpression;
            if (TypeUtilsKt.isSubtypeOf$default(FirTypeUtilsKt.getResolvedType(result2), FirTypeUtilsKt.getResolvedType(typeOperatorCall), this.session, false, 4, null)) {
                return FirExpressionEvaluatorKt.access$wrap(result2);
            }
            return FirExpressionEvaluatorKt.access$wrap(typeOperatorCall);
        }

        @NotNull
        public FirEvaluatorResult visitEnumEntryDeserializedAccessExpression(@NotNull FirEnumEntryDeserializedAccessExpression enumEntryDeserializedAccessExpression, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)enumEntryDeserializedAccessExpression, (String)"enumEntryDeserializedAccessExpression");
            return FirExpressionEvaluatorKt.access$wrap(enumEntryDeserializedAccessExpression);
        }

        @NotNull
        public FirEvaluatorResult visitClassReferenceExpression(@NotNull FirClassReferenceExpression classReferenceExpression, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)classReferenceExpression, (String)"classReferenceExpression");
            return FirExpressionEvaluatorKt.access$wrap(classReferenceExpression);
        }

        @NotNull
        public FirEvaluatorResult visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Void data2) {
            Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
            return this.visitAnnotation((FirAnnotation)annotationCall, data2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitAnnotation(@NotNull FirAnnotation annotation2, @Nullable Void data2) {
            void $this$visitAnnotation_u24lambda_u2433_u24lambda_u2432;
            FirAnnotationBuilder firAnnotationBuilder;
            Object object;
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            Map<Name, FirExpression> mapping2 = annotation2.getArgumentMapping().getMapping();
            if (mapping2.isEmpty()) {
                return FirExpressionEvaluatorKt.access$wrap(annotation2);
            }
            Map evaluatedMapping = new LinkedHashMap();
            for (Map.Entry<Name, FirExpression> entry : mapping2.entrySet()) {
                Name name2 = entry.getKey();
                FirExpression expression2 = entry.getValue();
                FirEvaluatorResult evaluatedExpression = this.evaluate(expression2);
                if (evaluatedExpression instanceof FirEvaluatorResult.Evaluated) {
                    Map map = evaluatedMapping;
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)evaluatedExpression).getResult();
                    Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    object = (FirExpression)firElement;
                    map.put(name2, object);
                    continue;
                }
                return evaluatedExpression;
            }
            boolean $i$f$buildAnnotationCopy = false;
            FirAnnotationBuilder copyBuilder$iv = new FirAnnotationBuilder();
            copyBuilder$iv.setSource(annotation2.getSource());
            copyBuilder$iv.setUseSiteTarget(annotation2.getUseSiteTarget());
            copyBuilder$iv.setAnnotationTypeRef(annotation2.getAnnotationTypeRef());
            copyBuilder$iv.setArgumentMapping(annotation2.getArgumentMapping());
            copyBuilder$iv.getTypeArguments().addAll((Collection<FirTypeProjection>)annotation2.getTypeArguments());
            FirAnnotationBuilder $this$visitAnnotation_u24lambda_u2433 = firAnnotationBuilder = copyBuilder$iv;
            boolean bl = false;
            boolean $i$f$buildAnnotationArgumentMapping = false;
            Object object2 = object = new FirAnnotationArgumentMappingBuilder();
            FirAnnotationBuilder firAnnotationBuilder2 = $this$visitAnnotation_u24lambda_u2433;
            boolean bl2 = false;
            $this$visitAnnotation_u24lambda_u2433_u24lambda_u2432.getMapping().putAll(evaluatedMapping);
            firAnnotationBuilder2.setArgumentMapping(((FirAnnotationArgumentMappingBuilder)object).build());
            return FirExpressionEvaluatorKt.access$wrap(firAnnotationBuilder.build());
        }

        private static final FirEvaluatorResult visitPropertyAccessExpression$evaluateOrCopy(FirCallableSymbol<?> propertySymbol, FirPropertyAccessExpression $propertyAccessExpression, EvaluationVisitor this$0, FirExpression initializer2) {
            return (FirEvaluatorResult)INSTANCE.visit(propertySymbol, (Function0)new Function0<FirEvaluatorResult>(initializer2, $propertyAccessExpression, this$0){
                final /* synthetic */ FirExpression $initializer;
                final /* synthetic */ FirPropertyAccessExpression $propertyAccessExpression;
                final /* synthetic */ EvaluationVisitor this$0;
                {
                    this.$initializer = $initializer;
                    this.$propertyAccessExpression = $propertyAccessExpression;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final FirEvaluatorResult invoke() {
                    return this.$initializer instanceof FirLiteralExpression ? FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$copy((FirLiteralExpression)this.$initializer, this.$propertyAccessExpression)) : this.this$0.evaluate(this.$initializer);
                }
            });
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[FirOperation.values().length];
                try {
                    nArray[FirOperation.LT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.LT_EQ.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.GT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.GT_EQ.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.EQ.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.NOT_EQ.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[LogicOperationKind.values().length];
                try {
                    nArray[LogicOperationKind.AND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogicOperationKind.OR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

