/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructedClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0017\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J$\u0010\u001c\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J*\u0010\u001d\u001a\u00020\u0006*\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002R\u001c\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0018\u0010\f\u001a\u00020\u0006*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "isInlineWithReified", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isInsideInterface", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "isPrimitiveExportableConeKotlinType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "check", "", "declaration", "context", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "validateDeclarationOnConsumableName", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isExportable", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "currentlyProcessed", "", "isExportableReturn", "isExportableTypeArguments", "isFunctionType", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExportDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExportDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n37#2:261\n46#2:262\n43#2:264\n57#2:265\n1#3:263\n34#4:266\n1755#5,3:267\n*S KotlinDebug\n*F\n+ 1 FirJsExportDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExportDeclarationChecker\n*L\n68#1:261\n85#1:262\n137#1:264\n161#1:265\n161#1:266\n169#1:267,3\n*E\n"})
public final class FirJsExportDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExportDeclarationChecker INSTANCE = new FirJsExportDeclarationChecker();

    private FirJsExportDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (!FirJsHelpersKt.isExportedObject(declaration.getSymbol(), context2) || !(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        boolean hasJsName = FirAnnotationUtilsKt.hasAnnotation(declaration, JsStandardClassIds.Annotations.JsName, context2.getSession());
        FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(reporter2, declaration, context2, "expect");
        }
        this.validateDeclarationOnConsumableName((FirMemberDeclaration)declaration, context2, reporter2);
        FirMemberDeclaration firMemberDeclaration = (FirMemberDeclaration)declaration;
        if (firMemberDeclaration instanceof FirFunction) {
            for (FirTypeParameterRef typeParameter2 : ((FirMemberDeclaration)declaration).getTypeParameters()) {
                FirJsExportDeclarationChecker.check$checkTypeParameter(context2, declaration, reporter2, typeParameter2);
            }
            if (this.isInlineWithReified((FirCallableSymbol)((FirFunction)declaration).getSymbol())) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(reporter2, declaration, context2, "inline function with reified type parameters");
                return;
            }
            FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend()) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(reporter2, declaration, context2, "suspend function");
                return;
            }
            if (declaration instanceof FirConstructor && !((FirConstructor)declaration).isPrimary() && !hasJsName) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(reporter2, declaration, context2, "secondary constructor without @JsName");
            }
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            for (FirValueParameter parameter2 : ((FirFunction)declaration).getValueParameters()) {
                FirJsExportDeclarationChecker.check$checkValueParameter(context2, declaration, reporter2, parameter2);
            }
            ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(((FirFunction)declaration).getReturnTypeRef());
            if (!(declaration instanceof FirConstructor) && !FirJsExportDeclarationChecker.isExportableReturn$default(this, returnType2, context2.getSession(), null, 2, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"return", (Object)returnType2, (DiagnosticContext)context2, null, 32, null);
            }
        } else if (firMemberDeclaration instanceof FirProperty) {
            boolean bl;
            FirClassSymbol containingClass;
            KtSourceElement ktSourceElement = declaration.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                return;
            }
            if (FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration)) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(reporter2, declaration, context2, "extension property");
                return;
            }
            FirClassLikeSymbol<?> parameter2 = FirHelpersKt.getContainingClassSymbol(declaration, context2.getSession());
            FirClassSymbol firClassSymbol = containingClass = parameter2 instanceof FirClassSymbol ? (FirClassSymbol)parameter2 : null;
            if (firClassSymbol != null) {
                FirClassSymbol firClassSymbol2 = firClassSymbol;
                FirVariable firVariable = (FirVariable)declaration;
                FirClassSymbol p0 = firClassSymbol2;
                boolean bl2 = false;
                bl = UtilsKt.isEnumEntries(firVariable, p0);
            } else {
                bl = false;
            }
            boolean enumEntriesProperty = bl;
            ConeKotlinType returnType3 = FirTypeUtilsKt.getConeType(((FirProperty)declaration).getReturnTypeRef());
            if (!enumEntriesProperty && !FirJsExportDeclarationChecker.isExportable$default(this, returnType3, context2.getSession(), null, 2, null)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"property", (Object)returnType3, (DiagnosticContext)context2, null, 32, null);
            }
        } else if (firMemberDeclaration instanceof FirClass) {
            String wrongDeclaration;
            for (FirTypeParameterRef typeParameter3 : ((FirMemberDeclaration)declaration).getTypeParameters()) {
                FirJsExportDeclarationChecker.check$checkTypeParameter(context2, declaration, reporter2, typeParameter3);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((FirClass)declaration).getClassKind().ordinal()]) {
                case 1: {
                    String string2 = "annotation class";
                    break;
                }
                case 2: {
                    String string2;
                    if (this.isInsideInterface(context2)) {
                        string2 = "nested class inside exported interface";
                        break;
                    }
                    FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$isInline = false;
                    if ($this$isInline$iv.getStatus().isInline()) {
                        string2 = "value class";
                        break;
                    }
                    string2 = null;
                    break;
                }
                default: {
                    String string2 = wrongDeclaration = this.isInsideInterface(context2) && !((FirMemberDeclaration)declaration).getStatus().isCompanion() ? "nested/inner declaration inside exported interface" : null;
                }
            }
            if (this.isInsideInterface(context2) && ((FirMemberDeclaration)declaration).getStatus().isCompanion() && !Intrinsics.areEqual((Object)FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)declaration), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNAMED_COMPANION_IN_EXPORTED_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            }
            if (wrongDeclaration != null) {
                FirJsExportDeclarationChecker.check$reportWrongExportedDeclaration(reporter2, declaration, context2, wrongDeclaration);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideInterface(CheckerContext $this$isInsideInterface) {
        Object object = CollectionsKt.lastOrNull($this$isInsideInterface.getContainingDeclarations());
        if (!(object instanceof FirClass)) return false;
        FirClass firClass = (FirClass)object;
        FirClass parent2 = firClass;
        if (parent2 == null) return false;
        FirClass $this$isInterface$iv = parent2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    private final boolean isInlineWithReified(FirCallableSymbol<?> $this$isInlineWithReified) {
        boolean bl;
        block5: {
            if ($this$isInlineWithReified instanceof FirPropertyAccessorSymbol) {
                bl = this.isInlineWithReified(((FirPropertyAccessorSymbol)$this$isInlineWithReified).getPropertySymbol());
            } else {
                Iterable $this$any$iv = $this$isInlineWithReified.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private final boolean isExportableReturn(ConeKotlinType $this$isExportableReturn, FirSession session2, Set<ConeKotlinType> currentlyProcessed) {
        return ConeBuiltinTypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, session2, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportableReturn(coneKotlinType, firSession, set);
    }

    private final boolean isExportableTypeArguments(ConeKotlinType $this$isExportableTypeArguments, FirSession session2, Set<ConeKotlinType> currentlyProcessed, boolean isFunctionType) {
        Boolean bl;
        if ($this$isExportableTypeArguments.getTypeArguments().length == 0) {
            return true;
        }
        int n = ArraysKt.getLastIndex((Object[])$this$isExportableTypeArguments.getTypeArguments());
        for (int i2 = 0; i2 < n; ++i2) {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType($this$isExportableTypeArguments.getTypeArguments()[i2]);
            if (coneKotlinType != null ? this.isExportable(coneKotlinType, session2, currentlyProcessed) : false) continue;
            return false;
        }
        if (isFunctionType) {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)ArraysKt.last((Object[])$this$isExportableTypeArguments.getTypeArguments()));
            bl = coneKotlinType != null ? Boolean.valueOf(this.isExportableReturn(coneKotlinType, session2, currentlyProcessed)) : null;
        } else {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)ArraysKt.last((Object[])$this$isExportableTypeArguments.getTypeArguments()));
            bl = coneKotlinType != null ? Boolean.valueOf(this.isExportable(coneKotlinType, session2, currentlyProcessed)) : null;
        }
        Boolean isLastExportable = bl;
        return Intrinsics.areEqual((Object)isLastExportable, (Object)true);
    }

    private final boolean isExportable(ConeKotlinType $this$isExportable, FirSession session2, Set<ConeKotlinType> currentlyProcessed) {
        boolean bl;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        boolean isFunctionType = FunctionalTypeUtilsKt.isBasicFunctionType($this$isExportable, session2);
        boolean isExportableArgs = this.isExportableTypeArguments($this$isExportable, session2, currentlyProcessed, isFunctionType);
        currentlyProcessed.remove($this$isExportable);
        if (isFunctionType || !isExportableArgs) {
            return isExportableArgs;
        }
        ConeKotlinType nonNullable = TypeUtilsKt.withNullability$default($this$isExportable, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(session2), null, false, 12, null);
        boolean isPrimitiveExportableType = ConeBuiltinTypeUtilsKt.isAny(nonNullable) || ConeBuiltinTypeUtilsKt.isNullableAny(nonNullable) || nonNullable instanceof ConeDynamicType || this.isPrimitiveExportableConeKotlinType(nonNullable);
        FirClassifierSymbol<?> symbol2 = TypeUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType($this$isExportable, session2), session2);
        if (isPrimitiveExportableType) {
            bl = true;
        } else {
            FirClassifierSymbol<?> firClassifierSymbol = symbol2;
            bl = !(firClassifierSymbol != null ? FirDeclarationUtilKt.isMemberDeclaration((FirBasedSymbol)firClassifierSymbol) : false) ? false : (ConeBuiltinTypeUtilsKt.isEnum($this$isExportable) ? true : FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)symbol2, session2) || FirJsHelpersKt.isExportedObject((FirBasedSymbol)symbol2, session2));
        }
        return bl;
    }

    static /* synthetic */ boolean isExportable$default(FirJsExportDeclarationChecker firJsExportDeclarationChecker, ConeKotlinType coneKotlinType, FirSession firSession, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new HashSet();
        }
        return firJsExportDeclarationChecker.isExportable(coneKotlinType, firSession, set);
    }

    private final boolean isPrimitiveExportableConeKotlinType(ConeKotlinType $this$isPrimitiveExportableConeKotlinType) {
        return $this$isPrimitiveExportableConeKotlinType instanceof ConeTypeParameterType || ConeBuiltinTypeUtilsKt.isBoolean($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isString($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveNumberOrNullableType($this$isPrimitiveExportableConeKotlinType) && !ConeBuiltinTypeUtilsKt.isLong($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isNonPrimitiveArray($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableList($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableSet($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMap($this$isPrimitiveExportableConeKotlinType) || ConeBuiltinTypeUtilsKt.isMutableMap($this$isPrimitiveExportableConeKotlinType);
    }

    private final void validateDeclarationOnConsumableName(FirMemberDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter2) {
        if (!FirHelpersKt.isTopLevel(context2) || FirDeclarationUtilKt.getNameOrSpecialName(declaration).isSpecial()) {
            return;
        }
        FirExpression jsNameArgument = FirHelpersKt.getAnnotationFirstArgument(declaration.getSymbol(), JsStandardClassIds.Annotations.JsName, context2.getSession());
        Object object = jsNameArgument;
        if (object == null || (object = ((FirExpression)object).getSource()) == null) {
            object = declaration.getSource();
        }
        Object reportTarget = object;
        FirLiteralExpression firLiteralExpression = jsNameArgument instanceof FirLiteralExpression ? (FirLiteralExpression)jsNameArgument : null;
        Object object2 = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        String string2 = object2 instanceof String ? (String)object2 : null;
        if (string2 == null) {
            String string3 = FirDeclarationUtilKt.getNameOrSpecialName(declaration).asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        }
        String name2 = string2;
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name2) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name2) && Intrinsics.areEqual((Object)FirJsHelpersKt.sanitizeName(name2), (Object)name2)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)reportTarget, FirJsErrors.INSTANCE.getNON_CONSUMABLE_EXPORTED_IDENTIFIER(), (Object)name2, (DiagnosticContext)context2, null, 16, null);
    }

    private static final void check$checkTypeParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirTypeParameterRef typeParameter2) {
        if (typeParameter2 instanceof FirConstructedClassTypeParameterRef) {
            return;
        }
        for (FirResolvedTypeRef upperBound : typeParameter2.getSymbol().getResolvedBounds()) {
            if (FirJsExportDeclarationChecker.isExportable$default(INSTANCE, upperBound.getType(), $context.getSession(), null, 2, null)) continue;
            KtSourceElement ktSourceElement = upperBound.getSource();
            if (ktSourceElement == null && (ktSourceElement = typeParameter2.getSource()) == null) {
                ktSourceElement = $declaration.getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"upper bound", (Object)upperBound.getType(), (DiagnosticContext)$context, null, 32, null);
        }
    }

    private static final void check$checkValueParameter(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirValueParameter valueParameter2) {
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef());
        if (!FirJsExportDeclarationChecker.isExportable$default(INSTANCE, type2, $context.getSession(), null, 2, null)) {
            KtSourceElement ktSourceElement = valueParameter2.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = $declaration.getSource();
            }
            KtSourceElement source = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirJsErrors.INSTANCE.getNON_EXPORTABLE_TYPE(), (Object)"parameter", (Object)type2, (DiagnosticContext)$context, null, 32, null);
        }
    }

    private static final void check$reportWrongExportedDeclaration(DiagnosticReporter $reporter, FirDeclaration $declaration, CheckerContext $context, String kind) {
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$declaration.getSource(), FirJsErrors.INSTANCE.getWRONG_EXPORTED_DECLARATION(), (Object)kind, (DiagnosticContext)$context, null, 16, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

