/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\u0011\u001a\u00020\u0012*\u00020\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirArrayOfNothingQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkTypeAndTypeArguments", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isArrayOfNothing", "", "checkers"})
public final class FirArrayOfNothingQualifierChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirArrayOfNothingQualifierChecker INSTANCE = new FirArrayOfNothingQualifierChecker();

    private FirArrayOfNothingQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        ConeKotlinType resolvedType = FirTypeUtilsKt.getResolvedType(expression2);
        this.checkTypeAndTypeArguments(resolvedType, expression2.getCalleeReference().getSource(), context2, reporter2);
    }

    public final boolean isArrayOfNothing(@NotNull ConeKotlinType $this$isArrayOfNothing) {
        Intrinsics.checkNotNullParameter((Object)$this$isArrayOfNothing, (String)"<this>");
        if (!ConeBuiltinTypeUtilsKt.isArrayTypeOrNullableArrayType($this$isArrayOfNothing)) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.firstOrNull((Object[])$this$isArrayOfNothing.getType().getTypeArguments());
        if (coneTypeProjection == null || (coneTypeProjection = ConeTypeProjectionKt.getType(coneTypeProjection)) == null) {
            return false;
        }
        ConeTypeProjection typeParameterType = coneTypeProjection;
        return ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing((ConeKotlinType)typeParameterType);
    }

    private final void checkTypeAndTypeArguments(ConeKotlinType type2, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter2) {
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(type2, context2.getSession());
        if (this.isArrayOfNothing(fullyExpandedType2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Array<Nothing> is illegal", (DiagnosticContext)context2, null, 16, null);
        } else {
            for (ConeTypeProjection typeArg : fullyExpandedType2.getTypeArguments()) {
                ConeKotlinType typeArgType;
                if (ConeTypeProjectionKt.getType(typeArg) == null) continue;
                this.checkTypeAndTypeArguments(typeArgType, source, context2, reporter2);
            }
        }
    }
}

