/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThreadLocalCheckerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeSharedImmutableChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "sharedImmutableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.native"})
public final class NativeSharedImmutableChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeSharedImmutableChecker INSTANCE = new NativeSharedImmutableChecker();
    @NotNull
    private static final FqName sharedImmutableFqName = new FqName("kotlin.native.concurrent.SharedImmutable");

    private NativeSharedImmutableChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        NativeThreadLocalCheckerKt.check(this, sharedImmutableFqName, declaration, descriptor2, context2, ErrorsNative.INAPPLICABLE_SHARED_IMMUTABLE_PROPERTY, (Function1<? super DeclarationDescriptor, Boolean>)((Function1)new Function1<DeclarationDescriptor, Boolean>(descriptor2, context2, declaration){
            final /* synthetic */ DeclarationDescriptor $descriptor;
            final /* synthetic */ DeclarationCheckerContext $context;
            final /* synthetic */ KtDeclaration $declaration;
            {
                this.$descriptor = $descriptor;
                this.$context = $context;
                this.$declaration = $declaration;
                super(1);
            }

            public final Boolean invoke(DeclarationDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                boolean isVariable = this.$descriptor instanceof VariableDescriptor && ((VariableDescriptor)this.$descriptor).isVar();
                boolean hasBackingField = this.$descriptor instanceof PropertyDescriptor && ResolveUtilKt.hasBackingField((PropertyDescriptor)this.$descriptor, this.$context.getTrace().getBindingContext());
                boolean hasDelegate = this.$declaration instanceof KtProperty && ((KtProperty)this.$declaration).getDelegate() != null;
                return !isVariable && hasBackingField || hasDelegate;
            }
        }));
        NativeThreadLocalCheckerKt.check(this, sharedImmutableFqName, declaration, descriptor2, context2, ErrorsNative.INAPPLICABLE_SHARED_IMMUTABLE_TOP_LEVEL, (Function1<? super DeclarationDescriptor, Boolean>)((Function1)new Function1<DeclarationDescriptor, Boolean>(descriptor2){
            final /* synthetic */ DeclarationDescriptor $descriptor;
            {
                this.$descriptor = $descriptor;
                super(1);
            }

            public final Boolean invoke(DeclarationDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DescriptorUtils.isTopLevelDeclaration(this.$descriptor);
            }
        }));
    }
}

