/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InlinePlatformCompatibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "frontend.java"})
public final class InlinePlatformCompatibilityChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmTarget jvmTarget;

    public InlinePlatformCompatibilityChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        CallableMemberDescriptor callableMemberDescriptor = obj instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)obj : null;
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor resultingDescriptor = callableMemberDescriptor;
        if (!(InlineUtil.isInline(resultingDescriptor) || resultingDescriptor instanceof PropertyDescriptor && InlineUtil.isInline(((PropertyDescriptor)resultingDescriptor).getGetter()))) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor2 = DescriptorUtils.getDirectMember(resultingDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor2, (String)"getDirectMember(...)");
        CallableMemberDescriptor propertyOrFun = callableMemberDescriptor2;
        Integer n = InlinePlatformCompatibilityChecker.Companion.getBytecodeVersionIfDeserializedDescriptor(propertyOrFun);
        if (n == null) {
            return;
        }
        int inliningBytecodeVersion = n;
        if (this.jvmTarget.getMajorVersion() < inliningBytecodeVersion) {
            context2.getTrace().report(ErrorsJvm.INLINE_FROM_HIGHER_PLATFORM.on(reportOn, JvmTarget.Companion.getDescription(inliningBytecodeVersion), JvmTarget.Companion.getDescription(this.jvmTarget.getMajorVersion())));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InlinePlatformCompatibilityChecker$Companion;", "", "()V", "getBytecodeVersionIfDeserializedDescriptor", "", "funOrProperty", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/Integer;", "getConcreteDeclarationForInline", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "frontend.java"})
    @SourceDebugExtension(value={"SMAP\nInlinePlatformCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlinePlatformCompatibilityChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/InlinePlatformCompatibilityChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n295#2,2:94\n*S KotlinDebug\n*F\n+ 1 InlinePlatformCompatibilityChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/InlinePlatformCompatibilityChecker$Companion\n*L\n81#1:94,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Integer getBytecodeVersionIfDeserializedDescriptor(DeclarationDescriptor funOrProperty) {
            SourceElement source;
            if (!(funOrProperty instanceof DeserializedCallableMemberDescriptor)) {
                return null;
            }
            DeclarationDescriptor declarationDescriptor = this.getConcreteDeclarationForInline((CallableMemberDescriptor)funOrProperty).getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor");
            ClassOrPackageFragmentDescriptor containingDeclaration2 = (ClassOrPackageFragmentDescriptor)declarationDescriptor;
            SourceElement sourceElement = containingDeclaration2.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
            SourceElement sourceElement2 = source = sourceElement;
            KotlinJvmBinaryClass kotlinJvmBinaryClass2 = sourceElement2 instanceof KotlinJvmBinarySourceElement ? ((KotlinJvmBinarySourceElement)source).getBinaryClass() : (sourceElement2 instanceof KotlinJvmBinaryPackageSourceElement ? ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)funOrProperty) : null);
            FileBasedKotlinClass fileBasedKotlinClass = kotlinJvmBinaryClass2 instanceof FileBasedKotlinClass ? (FileBasedKotlinClass)kotlinJvmBinaryClass2 : null;
            if (fileBasedKotlinClass == null) {
                return null;
            }
            FileBasedKotlinClass binaryClass = fileBasedKotlinClass;
            return binaryClass.getClassVersion();
        }

        private final CallableMemberDescriptor getConcreteDeclarationForInline(CallableMemberDescriptor $this$getConcreteDeclarationForInline) {
            if (!$this$getConcreteDeclarationForInline.getKind().isReal()) {
                Object v1;
                block3: {
                    Collection<? extends CallableMemberDescriptor> collection = $this$getConcreteDeclarationForInline.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
                    Iterable $this$firstOrNull$iv = collection;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        DeclarationDescriptor containingDeclaration2;
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.getContainingDeclaration(), (String)"getContainingDeclaration(...)");
                        if (!(!DescriptorUtils.isInterface(containingDeclaration2) && !DescriptorUtils.isAnnotationClass(containingDeclaration2))) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                CallableMemberDescriptor superImplementation = v1;
                if (superImplementation != null) {
                    return this.getConcreteDeclarationForInline(superImplementation);
                }
            }
            return $this$getConcreteDeclarationForInline;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

