/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValidateableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.CleanableBindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.BindingContextSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.MutableDiagnosticsWithSuppression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapImpl;
import org.jetbrains.kotlin.util.slicedMap.TrackingSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BindingTraceContext
implements BindingTrace {
    private static final boolean VALIDATION = Boolean.parseBoolean(System.getProperty("kotlin.bindingTrace.validation"));
    static final boolean TRACK_REWRITES = false;
    static final boolean TRACK_WITH_STACK_TRACES = true;
    private final MutableSlicedMap map;
    private final MutableDiagnosticsWithSuppression mutableDiagnostics;
    private final Project project;
    private final boolean isValidationEnabled;
    private final BindingContext bindingContext;

    public BindingTraceContext(Project project) {
        this(false, project);
    }

    public BindingTraceContext(boolean allowSliceRewrite, Project project) {
        this(BindingTraceFilter.Companion.getACCEPT_ALL(), allowSliceRewrite, project);
    }

    public BindingTraceContext(BindingTraceFilter filter2, boolean allowSliceRewrite, Project project) {
        this(filter2, allowSliceRewrite, VALIDATION, project);
    }

    public BindingTraceContext(BindingTraceFilter filter2, boolean allowSliceRewrite, boolean isValidationEnabled, Project project) {
        this(new SlicedMapImpl(allowSliceRewrite), filter2, isValidationEnabled, project);
    }

    private BindingTraceContext(@NotNull MutableSlicedMap map, BindingTraceFilter filter2, boolean isValidationEnabled, Project project) {
        if (map == null) {
            BindingTraceContext.$$$reportNull$$$0(0);
        }
        this.bindingContext = new CleanableBindingContext(){

            @Override
            @NotNull
            public Diagnostics getDiagnostics() {
                Diagnostics diagnostics2 = BindingTraceContext.this.mutableDiagnostics != null ? BindingTraceContext.this.mutableDiagnostics : Diagnostics.Companion.getEMPTY();
                if (diagnostics2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return diagnostics2;
            }

            @Override
            public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
                return BindingTraceContext.this.get(slice, key);
            }

            @Override
            @NotNull
            public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
                Collection<K> collection = BindingTraceContext.this.getKeys(slice);
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            @Override
            @NotNull
            public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
                if (slice == null) {
                    1.$$$reportNull$$$0(2);
                }
                ImmutableMap<K, V> immutableMap = BindingTraceContext.this.map.getSliceContents(slice);
                if (immutableMap == null) {
                    1.$$$reportNull$$$0(3);
                }
                return immutableMap;
            }

            @Override
            @Nullable
            public KotlinType getType(@NotNull KtExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return BindingTraceContext.this.getType(expression2);
            }

            @Override
            public void addOwnDataTo(@NotNull BindingTrace trace, boolean commitDiagnostics) {
                if (trace == null) {
                    1.$$$reportNull$$$0(5);
                }
                BindingContextUtils.addOwnDataTo(trace, null, commitDiagnostics, BindingTraceContext.this.map, BindingTraceContext.this.mutableDiagnostics);
            }

            @Override
            public void clear() {
                BindingTraceContext.this.map.clear();
            }

            @Override
            @Nullable
            public Project getProject() {
                return BindingTraceContext.this.project;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/resolve/BindingTraceContext$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "slice";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "trace";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDiagnostics";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeys";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/resolve/BindingTraceContext$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSliceContents";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSliceContents";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "addOwnDataTo";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.map = map;
        this.mutableDiagnostics = filter2.getIgnoreDiagnostics() ? null : new MutableDiagnosticsWithSuppression(new BindingContextSuppressCache(this.bindingContext), Diagnostics.Companion.getEMPTY());
        this.isValidationEnabled = isValidationEnabled;
        this.project = project;
    }

    public static BindingTraceContext createTraceableBindingTrace(Project project) {
        return new BindingTraceContext(new TrackingSlicedMap(true), BindingTraceFilter.Companion.getACCEPT_ALL(), VALIDATION, project);
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            BindingTraceContext.$$$reportNull$$$0(1);
        }
        if (this.mutableDiagnostics == null) {
            return;
        }
        this.mutableDiagnostics.report(diagnostic);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public void clearDiagnostics() {
        if (this.mutableDiagnostics != null) {
            this.mutableDiagnostics.clear();
        }
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.mutableDiagnostics != null;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            BindingTraceContext.$$$reportNull$$$0(2);
        }
        return bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value2) {
        if (this.isValidationEnabled && value2 instanceof ValidateableDescriptor && !ProgressManager.getInstance().isInNonCancelableSection()) {
            ((ValidateableDescriptor)value2).validate();
        }
        this.map.put(slice, key, value2);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.map.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> collection = this.map.getKeys(slice);
        if (collection == null) {
            BindingTraceContext.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @Nullable
    public KotlinType getType(@NotNull KtExpression expression2) {
        KotlinTypeInfo typeInfo;
        if (expression2 == null) {
            BindingTraceContext.$$$reportNull$$$0(4);
        }
        return (typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression2)) != null ? typeInfo.getType() : null;
    }

    @Override
    public void recordType(@NotNull KtExpression expression2, @Nullable KotlinType type2) {
        KotlinTypeInfo typeInfo;
        if (expression2 == null) {
            BindingTraceContext.$$$reportNull$$$0(5);
        }
        typeInfo = (typeInfo = this.get(BindingContext.EXPRESSION_TYPE_INFO, expression2)) != null ? typeInfo.replaceType(type2) : TypeInfoFactoryKt.createTypeInfo(type2);
        this.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/BindingTraceContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/BindingTraceContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "recordType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

