/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.serialization.FirProvidedDeclarationsForMetadataService;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl;", "Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataService;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "memberCache", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;", "topLevelsCache", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getProvidedCallables", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "owner", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getProvidedConstructors", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "getProvidedTopLevelDeclarations", "packageFqName", "registerDeclaration", "", "declaration", "ClassDeclarations", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirProvidedDeclarationsForMetadataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProvidedDeclarationsForMetadataService.kt\norg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,114:1\n381#2,7:115\n381#2,7:122\n*S KotlinDebug\n*F\n+ 1 FirProvidedDeclarationsForMetadataService.kt\norg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl\n*L\n84#1:115,7\n87#1:122,7\n*E\n"})
final class FirProvidedDeclarationsForMetadataServiceImpl
extends FirProvidedDeclarationsForMetadataService {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<FqName, List<FirDeclaration>> topLevelsCache;
    @NotNull
    private final Map<FirClassSymbol<?>, ClassDeclarations> memberCache;

    public FirProvidedDeclarationsForMetadataServiceImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.topLevelsCache = new LinkedHashMap();
        this.memberCache = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerDeclaration(@NotNull FirCallableDeclaration declaration) {
        FirRegularClass containingClass;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(declaration);
        FirRegularClass firRegularClass = containingClass = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClass(coneClassLikeLookupTag, this.session) : null;
        if (containingClass == null) {
            Object object;
            void $this$getOrPut$iv;
            Map<FqName, List<FirDeclaration>> map = this.topLevelsCache;
            FqName key$iv = declaration.getSymbol().getCallableId().getPackageName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List list2 = (List)object;
            ((Collection)list2).add(declaration);
        } else {
            ClassDeclarations classDeclarations;
            Map<FirClassSymbol<?>, ClassDeclarations> $this$getOrPut$iv = this.memberCache;
            FirRegularClassSymbol key$iv = containingClass.getSymbol();
            boolean $i$f$getOrPut = false;
            ClassDeclarations value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ClassDeclarations answer$iv = new ClassDeclarations();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                classDeclarations = answer$iv;
            } else {
                classDeclarations = value$iv;
            }
            ClassDeclarations declarations2 = classDeclarations;
            if (declaration instanceof FirConstructor) {
                ((Collection)declarations2.getProvidedConstructors()).add(declaration);
            } else {
                ((Collection)declarations2.getProvidedCallables()).add(declaration);
            }
        }
    }

    @Override
    @NotNull
    public List<FirDeclaration> getProvidedTopLevelDeclarations(@NotNull FqName packageFqName, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        List list2 = this.topLevelsCache.get(packageFqName);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FirConstructor> getProvidedConstructors(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Object object = this.memberCache.get(owner);
        if (object == null || (object = ((ClassDeclarations)object).getProvidedConstructors()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    @NotNull
    public List<FirCallableDeclaration> getProvidedCallables(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Object object = this.memberCache.get(owner);
        if (object == null || (object = ((ClassDeclarations)object).getProvidedCallables()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;", "", "()V", "providedCallables", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "getProvidedCallables", "()Ljava/util/List;", "providedConstructors", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "getProvidedConstructors", "fir-serialization"})
    private static final class ClassDeclarations {
        @NotNull
        private final List<FirCallableDeclaration> providedCallables = new ArrayList();
        @NotNull
        private final List<FirConstructor> providedConstructors = new ArrayList();

        @NotNull
        public final List<FirCallableDeclaration> getProvidedCallables() {
            return this.providedCallables;
        }

        @NotNull
        public final List<FirConstructor> getProvidedConstructors() {
            return this.providedConstructors;
        }
    }
}

