/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r*\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findCycle", "", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "knownCyclicConstructors", "getDelegated", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCommonConstructorDelegationIssuesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCommonConstructorDelegationIssuesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n56#2,11:106\n20#2,2:117\n37#3:119\n1863#4,2:120\n*S KotlinDebug\n*F\n+ 1 FirCommonConstructorDelegationIssuesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker\n*L\n27#1:106,11\n27#1:117,2\n68#1:119\n75#1:120,2\n*E\n"})
public final class FirCommonConstructorDelegationIssuesChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirCommonConstructorDelegationIssuesChecker INSTANCE = new FirCommonConstructorDelegationIssuesChecker();

    private FirCommonConstructorDelegationIssuesChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Iterator<Object> iterator2;
        block15: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Iterator<Object> element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirRegularClass)) continue;
                        iterator2 = element$iv;
                        break block15;
                    } while (0 <= n);
                }
                iterator2 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirRegularClass)) continue;
                    iterator2 = (Iterator<Object>)element$iv$iv;
                    break block15;
                }
                iterator2 = null;
            }
        }
        FirRegularClass containingClass = (FirRegularClass)((Object)iterator2);
        if (DeclarationUtilsKt.isEffectivelyExternal(declaration, containingClass, context2)) {
            return;
        }
        Set cyclicConstructors = new LinkedHashSet();
        boolean hasPrimaryConstructor = false;
        Object $i$f$firstIsInstanceOrNull = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        boolean isEffectivelyExpect = DeclarationUtilsKt.isEffectivelyExpect(declaration, $i$f$firstIsInstanceOrNull instanceof FirRegularClass ? (FirRegularClass)$i$f$firstIsInstanceOrNull : null, context2);
        Set otherConstructors = new LinkedHashSet();
        for (FirDeclaration it : declaration.getDeclarations()) {
            if (!(it instanceof FirConstructor)) continue;
            if (!((FirConstructor)it).isPrimary() || it instanceof FirErrorPrimaryConstructor) {
                ((Collection)otherConstructors).add(it);
                if (this.findCycle((FirConstructor)it, cyclicConstructors) != null) {
                    Set<FirConstructor> visited2;
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)cyclicConstructors, (Iterable)visited2);
                }
                continue;
            }
            hasPrimaryConstructor = true;
        }
        CollectionsKt.removeAll((Collection)otherConstructors, (Iterable)cyclicConstructors);
        if (hasPrimaryConstructor) {
            for (FirDeclaration it : otherConstructors) {
                if (isEffectivelyExpect) continue;
                FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)it).getDelegatedConstructor();
                if (firDelegatedConstructorCall != null ? firDelegatedConstructorCall.isThis() : false) continue;
                FirDelegatedConstructorCall firDelegatedConstructorCall2 = ((FirConstructor)it).getDelegatedConstructor();
                if ((firDelegatedConstructorCall2 != null ? firDelegatedConstructorCall2.getSource() : null) != null) {
                    FirDelegatedConstructorCall firDelegatedConstructorCall3 = ((FirConstructor)it).getDelegatedConstructor();
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)(firDelegatedConstructorCall3 != null ? firDelegatedConstructorCall3.getSource() : null), FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED(), (DiagnosticContext)context2, null, 8, null);
                    continue;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)((FirConstructor)it).getSource(), FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED(), (DiagnosticContext)context2, null, 8, null);
            }
        } else {
            for (FirDeclaration it : otherConstructors) {
                Object object;
                FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)it).getDelegatedConstructor();
                if (!((firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getCalleeReference() : null) instanceof FirDiagnosticHolder) || !(((object = ((FirConstructor)it).getDelegatedConstructor()) != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtFakeSourceElementKind)) continue;
                FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)it;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getStatus().isExpect()) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)((FirConstructor)it).getSource(), FirErrors.INSTANCE.getEXPLICIT_DELEGATION_CALL_REQUIRED(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        Iterable $this$forEach$iv = cyclicConstructors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirConstructor it = (FirConstructor)element$iv;
            boolean bl = false;
            FirDelegatedConstructorCall firDelegatedConstructorCall = it.getDelegatedConstructor();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)(firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getSource() : null), FirErrors.INSTANCE.getCYCLIC_CONSTRUCTOR_DELEGATION_CALL(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final Set<FirConstructor> findCycle(FirConstructor $this$findCycle, Set<? extends FirConstructor> knownCyclicConstructors) {
        Object[] objectArray = new FirConstructor[]{$this$findCycle};
        Set visitedConstructors = SetsKt.mutableSetOf((Object[])objectArray);
        FirConstructor it = $this$findCycle;
        FirConstructor delegated = this.getDelegated($this$findCycle);
        while ((!it.isPrimary() || it instanceof FirErrorPrimaryConstructor) && delegated != null) {
            if (visitedConstructors.contains(delegated) || knownCyclicConstructors.contains(delegated)) {
                return visitedConstructors;
            }
            it = delegated;
            delegated = this.getDelegated(delegated);
            visitedConstructors.add(it);
        }
        return null;
    }

    static /* synthetic */ Set findCycle$default(FirCommonConstructorDelegationIssuesChecker firCommonConstructorDelegationIssuesChecker, FirConstructor firConstructor, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        return firCommonConstructorDelegationIssuesChecker.findCycle(firConstructor, set);
    }

    private final FirConstructor getDelegated(FirConstructor $this$getDelegated) {
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$getDelegated.getSymbol(), FirResolvePhase.BODY_RESOLVE);
        Object object = $this$getDelegated.getDelegatedConstructor();
        return object != null && (object = ((FirDelegatedConstructorCall)object).getCalleeReference()) != null && (object = FirReferenceUtilsKt.toResolvedConstructorSymbol((FirReference)object, true)) != null ? (FirConstructor)((FirBasedSymbol)object).getFir() : null;
    }
}

