/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.util.SetMultimap;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyDeclarationCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "declaredVariablesInLoop", "Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Lorg/jetbrains/kotlin/fir/util/SetMultimap;)V", "getDeclaredVariablesInLoop", "()Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "data", "visitDoWhileLoop", "doWhileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRepeatable", "loop", "visitWhileLoop", "whileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "checkers"})
final class PropertyDeclarationCollector
extends FirVisitor<Unit, FirStatement> {
    @NotNull
    private final SetMultimap<FirStatement, FirPropertySymbol> declaredVariablesInLoop;

    public PropertyDeclarationCollector(@NotNull SetMultimap<FirStatement, FirPropertySymbol> declaredVariablesInLoop) {
        Intrinsics.checkNotNullParameter(declaredVariablesInLoop, (String)"declaredVariablesInLoop");
        this.declaredVariablesInLoop = declaredVariablesInLoop;
    }

    @NotNull
    public final SetMultimap<FirStatement, FirPropertySymbol> getDeclaredVariablesInLoop() {
        return this.declaredVariablesInLoop;
    }

    @Override
    public void visitElement(@NotNull FirElement element, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren(this, data2);
    }

    @Override
    public void visitProperty(@NotNull FirProperty property2, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        if (property2.isLocal() && data2 != null) {
            this.declaredVariablesInLoop.put(data2, property2.getSymbol());
        }
        this.visitElement((FirElement)property2, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
        this.visitRepeatable(whileLoop, whileLoop);
    }

    @Override
    public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
        this.visitRepeatable(doWhileLoop, doWhileLoop);
    }

    @Override
    public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @Nullable FirStatement data2) {
        Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
        EventOccurrencesRange eventOccurrencesRange = anonymousFunction.getInvocationKind();
        boolean bl = eventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(eventOccurrencesRange) : false;
        if (bl) {
            this.visitRepeatable(anonymousFunction, data2);
        } else {
            this.visitElement((FirElement)anonymousFunction, data2);
        }
    }

    private final void visitRepeatable(FirStatement loop2, FirStatement data2) {
        this.visitElement((FirElement)loop2, loop2);
        if (data2 != null) {
            this.declaredVariablesInLoop.putAll(data2, (Collection<FirPropertySymbol>)this.declaredVariablesInLoop.get(loop2));
        }
    }
}

