/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.components;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectJavaClassFinderKt;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaClass;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaPackage;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/components/ReflectJavaClassFinder;", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder;", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "canComputeKnownClassNamesInPackage", "", "findClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "request", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder$Request;", "findClasses", "", "findPackage", "Lorg/jetbrains/kotlin/load/java/structure/JavaPackage;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "mayHaveAnnotations", "knownClassNamesInPackage", "", "", "packageFqName", "descriptors.runtime"})
public final class ReflectJavaClassFinder
implements JavaClassFinder {
    @NotNull
    private final ClassLoader classLoader;

    public ReflectJavaClassFinder(@NotNull ClassLoader classLoader2) {
        Intrinsics.checkNotNullParameter((Object)classLoader2, (String)"classLoader");
        this.classLoader = classLoader2;
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ClassId classId = request.getClassId();
        FqName packageFqName = classId.getPackageFqName();
        String string2 = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String relativeClassName2 = StringsKt.replace$default((String)string2, (char)'.', (char)'$', (boolean)false, (int)4, null);
        String name2 = packageFqName.isRoot() ? relativeClassName2 : packageFqName.asString() + '.' + relativeClassName2;
        Class<?> klass = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, name2);
        return klass != null ? (JavaClass)new ReflectJavaClass(klass) : null;
    }

    @Override
    @NotNull
    public List<JavaClass> findClasses(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return CollectionsKt.listOfNotNull((Object)this.findClass(request));
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName2, boolean mayHaveAnnotations) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return new ReflectJavaPackage(fqName2);
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    @Override
    public boolean canComputeKnownClassNamesInPackage() {
        return false;
    }
}

