/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.JvmFileFacadeClass;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensionsImpl;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializerImpl;
import org.jetbrains.kotlin.backend.jvm.JvmIrSpecialAnnotationSymbolProvider;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.DescriptorSymbolTableExtension;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.sam.JavaSingleAbstractMethodUtils;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.load.kotlin.FacadeClassSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorExtensions;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0002PQB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202H\u0016J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u00101\u001a\u000205H\u0016J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u0002092\u0006\u00101\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J \u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J\"\u0010C\u001a\u0004\u0018\u00010\u000e2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010?\u001a\u00020@H\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010G2\u0006\u00101\u001a\u000202H\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010J2\u0006\u00101\u001a\u00020:H\u0016J\u0010\u0010K\u001a\u00020\u00062\u0006\u00101\u001a\u000205H\u0016J\u0010\u0010L\u001a\u00020\u00062\u0006\u00101\u001a\u00020MH\u0016J \u0010N\u001a\u0012\u0012\u0004\u0012\u00020M\u0012\u0006\u0012\u0004\u0018\u00010M\u0018\u00010O2\u0006\u00101\u001a\u000205H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0014R\u0014\u0010#\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0014R\u0014\u0010%\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0014R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "generateFacades", "", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Z)V", "cachedFields", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "getCachedFields", "()Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "classNameOverride", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassNameOverride", "()Ljava/util/Map;", "debugInfoOnlyOnVariablesInDestructuringDeclarations", "getDebugInfoOnlyOnVariablesInDestructuringDeclarations", "()Z", "enhancedNullability", "Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "getEnhancedNullability", "()Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "enhancedNullabilityAnnotationConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getEnhancedNullabilityAnnotationConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "flexibleMutabilityAnnotationConstructor", "getFlexibleMutabilityAnnotationConstructor", "flexibleNullabilityAnnotationConstructor", "getFlexibleNullabilityAnnotationConstructor", "irDeserializationEnabled", "getIrDeserializationEnabled", "parametersAreAssignable", "getParametersAreAssignable", "rawTypeAnnotationConstructor", "getRawTypeAnnotationConstructor", "samConversion", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "getSamConversion", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "shouldPreventDeprecatedIntegerValueTypeLiteralConversion", "getShouldPreventDeprecatedIntegerValueTypeLiteralConversion", "specialAnnotations", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrSpecialAnnotationSymbolProvider;", "computeExternalDeclarationOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "computeFieldVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "createCustomSuperConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "ktPureClassOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "deserializeClass", "irClass", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "generateFacadeClass", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "deserializedSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "getContainerSource", "getParentClassStaticScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "isPropertyWithPlatformField", "isStaticFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "unwrapSyntheticJavaProperty", "Lkotlin/Pair;", "JvmEnhancedNullability", "JvmSamConversion", "backend.jvm.entrypoint"})
public class JvmGeneratorExtensionsImpl
extends GeneratorExtensions
implements JvmGeneratorExtensions {
    @NotNull
    private final CompilerConfiguration configuration;
    private final boolean generateFacades;
    @NotNull
    private final Map<IrClass, JvmClassName> classNameOverride;
    private final boolean irDeserializationEnabled;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;
    @NotNull
    private final GeneratorExtensions.SamConversion samConversion;
    @NotNull
    private final JvmIrSpecialAnnotationSymbolProvider specialAnnotations;
    @NotNull
    private final IrConstructor flexibleNullabilityAnnotationConstructor;
    @NotNull
    private final IrConstructor flexibleMutabilityAnnotationConstructor;
    @NotNull
    private final IrConstructor enhancedNullabilityAnnotationConstructor;
    @NotNull
    private final IrConstructor rawTypeAnnotationConstructor;

    public JvmGeneratorExtensionsImpl(@NotNull CompilerConfiguration configuration2, boolean generateFacades) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.configuration = configuration2;
        this.generateFacades = generateFacades;
        this.classNameOverride = new LinkedHashMap();
        this.irDeserializationEnabled = this.configuration.get(JVMConfigurationKeys.SERIALIZE_IR) != JvmSerializeIrMode.NONE;
        this.cachedFields = new CachedFieldsForObjectInstances(IrFactoryImpl.INSTANCE, CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration));
        this.samConversion = new JvmSamConversion();
        this.specialAnnotations = new JvmIrSpecialAnnotationSymbolProvider(IrFactoryImpl.INSTANCE);
        this.flexibleNullabilityAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)this.specialAnnotations.getFlexibleNullabilityAnnotation().getOwner()));
        this.flexibleMutabilityAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)this.specialAnnotations.getFlexibleMutabilityAnnotation().getOwner()));
        this.enhancedNullabilityAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)this.specialAnnotations.getEnhancedNullabilityAnnotation().getOwner()));
        this.rawTypeAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)this.specialAnnotations.getRawTypeAnnotation().getOwner()));
    }

    public /* synthetic */ JvmGeneratorExtensionsImpl(CompilerConfiguration compilerConfiguration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(compilerConfiguration, bl);
    }

    @Override
    @NotNull
    public Map<IrClass, JvmClassName> getClassNameOverride() {
        return this.classNameOverride;
    }

    @Override
    public boolean getIrDeserializationEnabled() {
        return this.irDeserializationEnabled;
    }

    @Override
    @NotNull
    public CachedFieldsForObjectInstances getCachedFields() {
        return this.cachedFields;
    }

    @Override
    @NotNull
    public GeneratorExtensions.SamConversion getSamConversion() {
        return this.samConversion;
    }

    @Override
    @Nullable
    public DeserializedContainerSource getContainerSource(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DescriptorWithContainerSource descriptorWithContainerSource = descriptor2 instanceof DescriptorWithContainerSource ? (DescriptorWithContainerSource)descriptor2 : null;
        return descriptorWithContainerSource != null ? descriptorWithContainerSource.getContainerSource() : null;
    }

    @Override
    @Nullable
    public DescriptorVisibility computeFieldVisibility(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2) || descriptor2 instanceof JavaCallableMemberDescriptor ? descriptor2.getVisibility() : null;
    }

    @Override
    @Nullable
    public IrDeclarationOrigin computeExternalDeclarationOrigin(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return descriptor2 instanceof JavaCallableMemberDescriptor || descriptor2 instanceof JavaClassDescriptor ? (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB() : (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getIR_EXTERNAL_DECLARATION_STUB();
    }

    @Override
    @Nullable
    public IrClass generateFacadeClass(@NotNull IrFactory irFactory, @NotNull DeserializedContainerSource deserializedSource, @NotNull DeclarationStubGenerator stubGenerator) {
        JvmFileFacadeClass jvmFileFacadeClass;
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter((Object)deserializedSource, (String)"deserializedSource");
        Intrinsics.checkNotNullParameter((Object)stubGenerator, (String)"stubGenerator");
        if (!this.generateFacades || !(deserializedSource instanceof FacadeClassSource)) {
            return null;
        }
        JvmClassName jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName();
        if (jvmClassName == null) {
            jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getClassName();
        }
        JvmClassName facadeName = jvmClassName;
        IrDeclarationOrigin irDeclarationOrigin = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName() != null ? IrDeclarationOrigin.Companion.getJVM_MULTIFILE_CLASS() : IrDeclarationOrigin.Companion.getFILE_CLASS();
        Name name2 = facadeName.getFqNameForTopLevelClassMaybeWithDollars().shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
        JvmFileFacadeClass it = jvmFileFacadeClass = new JvmFileFacadeClass(irDeclarationOrigin, name2, deserializedSource, (Function1<? super IrClass, Boolean>)((Function1)new Function1<IrClass, Boolean>(this, stubGenerator){
            final /* synthetic */ JvmGeneratorExtensionsImpl this$0;
            final /* synthetic */ DeclarationStubGenerator $stubGenerator;
            {
                this.this$0 = $receiver;
                this.$stubGenerator = $stubGenerator;
                super(1);
            }

            public final Boolean invoke(IrClass facade) {
                Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
                return this.this$0.deserializeClass(facade, this.$stubGenerator, facade.getParent());
            }
        }));
        boolean bl = false;
        IrUtilsKt.createParameterDeclarations(it);
        this.getClassNameOverride().put(it, facadeName);
        return jvmFileFacadeClass;
    }

    @Override
    public boolean deserializeClass(@NotNull IrClass irClass, @NotNull DeclarationStubGenerator stubGenerator, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)stubGenerator, (String)"stubGenerator");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        return new JvmIrDeserializerImpl().deserializeTopLevelClass(irClass, stubGenerator.getIrBuiltIns(), stubGenerator.getSymbolTable(), CollectionsKt.listOf((Object)stubGenerator), this);
    }

    @Override
    public boolean isPropertyWithPlatformField(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isStaticFunction(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!DescriptorUtils.isNonCompanionObject(descriptor2.getContainingDeclaration())) return false;
        if (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2)) return true;
        if (!(descriptor2 instanceof PropertyAccessorDescriptor)) return false;
        PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
        if (!AnnotationUtilKt.hasJvmStaticAnnotation(propertyDescriptor)) return false;
        return true;
    }

    @Override
    @NotNull
    public StubGeneratorExtensions.EnhancedNullability getEnhancedNullability() {
        return JvmEnhancedNullability.Instance;
    }

    @Override
    @Nullable
    public MemberScope getParentClassStaticScope(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return UtilKt.getParentJavaStaticClassScope(descriptor2);
    }

    @Override
    @Nullable
    public IrDelegatingConstructorCall createCustomSuperConstructorCall(@NotNull KtPureClassOrObject ktPureClassOrObject, @NotNull ClassDescriptor descriptor2, @NotNull GeneratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)ktPureClassOrObject, (String)"ktPureClassOrObject");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!JvmAnnotationUtilKt.isJvmRecord(descriptor2)) {
            return null;
        }
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.resolveTopLevelClass(DescriptorUtilsKt.getModule(descriptor2), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FROM_BACKEND);
        if (classDescriptor2 == null) {
            throw new IllegalStateException(("Class not found: " + JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME()).toString());
        }
        ClassDescriptor recordClass = classDescriptor2;
        Collection<ClassConstructorDescriptor> collection = recordClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getConstructors(...)");
        ClassConstructorDescriptor recordConstructor = (ClassConstructorDescriptor)CollectionsKt.single((Iterable)collection);
        int n = PsiUtilsKt.getPureStartOffset(ktPureClassOrObject);
        int n2 = PsiUtilsKt.getPureEndOffset(ktPureClassOrObject);
        IrType irType = context2.getIrBuiltIns().getUnitType();
        DescriptorSymbolTableExtension descriptorSymbolTableExtension = context2.getSymbolTable().getDescriptorExtension();
        Intrinsics.checkNotNull((Object)recordConstructor);
        return IrDelegatingConstructorCallImpl.Companion.fromSymbolDescriptor$default(IrDelegatingConstructorCallImpl.Companion, n, n2, irType, descriptorSymbolTableExtension.referenceConstructor(recordConstructor), 0, 0, 48, null);
    }

    @Override
    public boolean getShouldPreventDeprecatedIntegerValueTypeLiteralConversion() {
        return true;
    }

    @Override
    @NotNull
    public IrConstructor getFlexibleNullabilityAnnotationConstructor() {
        return this.flexibleNullabilityAnnotationConstructor;
    }

    @Override
    @NotNull
    public IrConstructor getFlexibleMutabilityAnnotationConstructor() {
        return this.flexibleMutabilityAnnotationConstructor;
    }

    @Override
    @NotNull
    public IrConstructor getEnhancedNullabilityAnnotationConstructor() {
        return this.enhancedNullabilityAnnotationConstructor;
    }

    @Override
    @NotNull
    public IrConstructor getRawTypeAnnotationConstructor() {
        return this.rawTypeAnnotationConstructor;
    }

    @Override
    @Nullable
    public Pair<FunctionDescriptor, FunctionDescriptor> unwrapSyntheticJavaProperty(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof SyntheticJavaPropertyDescriptor) {
            return TuplesKt.to((Object)((SyntheticJavaPropertyDescriptor)descriptor2).getGetMethod(), (Object)((SyntheticJavaPropertyDescriptor)descriptor2).getSetMethod());
        }
        return null;
    }

    @Override
    public boolean getParametersAreAssignable() {
        return true;
    }

    @Override
    public boolean getDebugInfoOnlyOnVariablesInDestructuringDeclarations() {
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability;", "Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "()V", "hasEnhancedNullability", "", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "stripEnhancedNullability", "Instance", "backend.jvm.entrypoint"})
    public static class JvmEnhancedNullability
    extends StubGeneratorExtensions.EnhancedNullability {
        @NotNull
        public static final Instance Instance = new Instance(null);

        @Override
        public boolean hasEnhancedNullability(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            return TypeEnhancementKt.hasEnhancedNullability(kotlinType);
        }

        @Override
        @NotNull
        public KotlinType stripEnhancedNullability(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            return TypeEnhancementKt.hasEnhancedNullability(kotlinType) ? TypeUtilsKt.replaceAnnotations(kotlinType, new FilteredAnnotations(kotlinType.getAnnotations(), true, (Function1<? super FqName, Boolean>)((Function1)stripEnhancedNullability.1.INSTANCE))) : kotlinType;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability$Instance;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability;", "()V", "backend.jvm.entrypoint"})
        public static final class Instance
        extends JvmEnhancedNullability {
            private Instance() {
            }

            public /* synthetic */ Instance(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmSamConversion;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl;)V", "isCarefulApproximationOfContravariantProjection", "", "isPlatformSamType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "backend.jvm.entrypoint"})
    public final class JvmSamConversion
    extends GeneratorExtensions.SamConversion {
        @Override
        public boolean isPlatformSamType(@NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return JavaSingleAbstractMethodUtils.isSamType(type2);
        }

        @Override
        public boolean isCarefulApproximationOfContravariantProjection() {
            return JvmGeneratorExtensionsImpl.this.configuration.get(JVMConfigurationKeys.SAM_CONVERSIONS) != JvmClosureGenerationScheme.CLASS;
        }
    }
}

