/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.exec;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.AbstractPty;
import org.jline.terminal.spi.Pty;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.ExecHelper;
import org.jline.utils.OSUtils;

public class ExecPty
extends AbstractPty
implements Pty {
    private final String name;

    public static Pty current(TerminalProvider provider2, SystemStream systemStream) throws IOException {
        try {
            String result2 = ExecHelper.exec(true, OSUtils.TTY_COMMAND);
            if (systemStream != SystemStream.Output && systemStream != SystemStream.Error) {
                throw new IllegalArgumentException("systemStream should be Output or Error: " + (Object)((Object)systemStream));
            }
            return new ExecPty(provider2, systemStream, result2.trim());
        }
        catch (IOException e) {
            throw new IOException("Not a tty", e);
        }
    }

    protected ExecPty(TerminalProvider provider2, SystemStream systemStream, String name2) {
        super(provider2, systemStream);
        this.name = name2;
    }

    @Override
    public void close() throws IOException {
    }

    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getMasterInput() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream getMasterOutput() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected InputStream doGetSlaveInput() throws IOException {
        return this.systemStream != null ? new FileInputStream(FileDescriptor.in) : new FileInputStream(this.getName());
    }

    @Override
    public OutputStream getSlaveOutput() throws IOException {
        return this.systemStream == SystemStream.Output ? new FileOutputStream(FileDescriptor.out) : (this.systemStream == SystemStream.Error ? new FileOutputStream(FileDescriptor.err) : new FileOutputStream(this.getName()));
    }

    @Override
    public Attributes getAttr() throws IOException {
        String cfg = this.doGetConfig();
        return ExecPty.doGetAttr(cfg);
    }

    @Override
    protected void doSetAttr(Attributes attr) throws IOException {
        List<String> commands = this.getFlagsToSet(attr, this.getAttr());
        if (!commands.isEmpty()) {
            commands.add(0, OSUtils.STTY_COMMAND);
            if (this.systemStream == null) {
                commands.add(1, OSUtils.STTY_F_OPTION);
                commands.add(2, this.getName());
            }
            try {
                ExecHelper.exec(this.systemStream != null, commands.toArray(new String[0]));
            }
            catch (IOException e) {
                if (e.toString().contains("unable to perform all requested operations")) {
                    commands = this.getFlagsToSet(attr, this.getAttr());
                    if (!commands.isEmpty()) {
                        throw new IOException("Could not set the following flags: " + String.join((CharSequence)", ", commands), e);
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<String> getFlagsToSet(Attributes attr, Attributes current) {
        void var7_16;
        ArrayList<String> commands = new ArrayList<String>();
        for (Attributes.InputFlag inputFlag : Attributes.InputFlag.values()) {
            if (attr.getInputFlag(inputFlag) == current.getInputFlag(inputFlag)) continue;
            commands.add((attr.getInputFlag(inputFlag) ? inputFlag.name() : "-" + inputFlag.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.OutputFlag.values()) {
            if (attr.getOutputFlag((Attributes.OutputFlag)enum_) == current.getOutputFlag((Attributes.OutputFlag)enum_)) continue;
            commands.add((attr.getOutputFlag((Attributes.OutputFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.ControlFlag.values()) {
            if (attr.getControlFlag((Attributes.ControlFlag)enum_) == current.getControlFlag((Attributes.ControlFlag)enum_)) continue;
            commands.add((attr.getControlFlag((Attributes.ControlFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        for (Enum enum_ : Attributes.LocalFlag.values()) {
            if (attr.getLocalFlag((Attributes.LocalFlag)enum_) == current.getLocalFlag((Attributes.LocalFlag)enum_)) continue;
            commands.add((attr.getLocalFlag((Attributes.LocalFlag)enum_) ? enum_.name() : "-" + enum_.name()).toLowerCase());
        }
        String undef = System.getProperty("os.name").toLowerCase().startsWith("hp") ? "^-" : "undef";
        Attributes.ControlChar[] controlCharArray = Attributes.ControlChar.values();
        int n = controlCharArray.length;
        boolean bl = false;
        while (var7_16 < n) {
            Attributes.ControlChar cchar = controlCharArray[var7_16];
            int v = attr.getControlChar(cchar);
            if (v >= 0 && v != current.getControlChar(cchar)) {
                String str = "";
                commands.add(cchar.name().toLowerCase().substring(1));
                if (cchar == Attributes.ControlChar.VMIN || cchar == Attributes.ControlChar.VTIME) {
                    commands.add(Integer.toString(v));
                } else if (v == 0) {
                    commands.add(undef);
                } else {
                    if (v >= 128) {
                        v -= 128;
                        str = str + "M-";
                    }
                    if (v < 32 || v == 127) {
                        v ^= 0x40;
                        str = str + "^";
                    }
                    str = str + (char)v;
                    commands.add(str);
                }
            }
            ++var7_16;
        }
        return commands;
    }

    @Override
    public Size getSize() throws IOException {
        String cfg = this.doGetConfig();
        return ExecPty.doGetSize(cfg);
    }

    protected String doGetConfig() throws IOException {
        return this.systemStream != null ? ExecHelper.exec(true, OSUtils.STTY_COMMAND, "-a") : ExecHelper.exec(false, OSUtils.STTY_COMMAND, OSUtils.STTY_F_OPTION, this.getName(), "-a");
    }

    public static Attributes doGetAttr(String cfg) throws IOException {
        Boolean value2;
        Attributes attributes2 = new Attributes();
        for (Attributes.InputFlag inputFlag : Attributes.InputFlag.values()) {
            Boolean value22 = ExecPty.doGetFlag(cfg, inputFlag);
            if (value22 == null) continue;
            attributes2.setInputFlag(inputFlag, value22);
        }
        for (Enum enum_ : Attributes.OutputFlag.values()) {
            value2 = ExecPty.doGetFlag(cfg, enum_);
            if (value2 == null) continue;
            attributes2.setOutputFlag((Attributes.OutputFlag)enum_, value2);
        }
        for (Enum enum_ : Attributes.ControlFlag.values()) {
            value2 = ExecPty.doGetFlag(cfg, enum_);
            if (value2 == null) continue;
            attributes2.setControlFlag((Attributes.ControlFlag)enum_, value2);
        }
        for (Enum enum_ : Attributes.LocalFlag.values()) {
            value2 = ExecPty.doGetFlag(cfg, enum_);
            if (value2 == null) continue;
            attributes2.setLocalFlag((Attributes.LocalFlag)enum_, value2);
        }
        for (Enum enum_ : Attributes.ControlChar.values()) {
            Matcher matcher;
            String name2 = enum_.name().toLowerCase().substring(1);
            if ("reprint".endsWith(name2)) {
                name2 = "(?:reprint|rprnt)";
            }
            if (!(matcher = Pattern.compile("[\\s;]" + name2 + "\\s*=\\s*(.+?)[\\s;]").matcher(cfg)).find()) continue;
            attributes2.setControlChar((Attributes.ControlChar)enum_, ExecPty.parseControlChar(matcher.group(1).toUpperCase()));
        }
        return attributes2;
    }

    private static Boolean doGetFlag(String cfg, Enum<?> flag) {
        Matcher matcher = Pattern.compile("(?:^|[\\s;])(\\-?" + flag.name().toLowerCase() + ")(?:[\\s;]|$)").matcher(cfg);
        return matcher.find() ? Boolean.valueOf(!matcher.group(1).startsWith("-")) : null;
    }

    static int parseControlChar(String str) {
        if ("<UNDEF>".equals(str)) {
            return -1;
        }
        if ("DEL".equalsIgnoreCase(str)) {
            return 127;
        }
        if (str.charAt(0) == '0') {
            return Integer.parseInt(str, 8);
        }
        if (str.charAt(0) >= '1' && str.charAt(0) <= '9') {
            return Integer.parseInt(str, 10);
        }
        if (str.charAt(0) == '^') {
            if (str.charAt(1) == '?') {
                return 127;
            }
            return str.charAt(1) - 64;
        }
        if (str.charAt(0) == 'M' && str.charAt(1) == '-') {
            if (str.charAt(2) == '^') {
                if (str.charAt(3) == '?') {
                    return 255;
                }
                return str.charAt(3) - 64 + 128;
            }
            return str.charAt(2) + 128;
        }
        return str.charAt(0);
    }

    static Size doGetSize(String cfg) throws IOException {
        return new Size(ExecPty.doGetInt("columns", cfg), ExecPty.doGetInt("rows", cfg));
    }

    static int doGetInt(String name2, String cfg) throws IOException {
        String[] patterns2;
        for (String pattern : patterns2 = new String[]{"\\b([0-9]+)\\s+" + name2 + "\\b", "\\b" + name2 + "\\s+([0-9]+)\\b", "\\b" + name2 + "\\s*=\\s*([0-9]+)\\b"}) {
            Matcher matcher = Pattern.compile(pattern).matcher(cfg);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        throw new IOException("Unable to parse " + name2);
    }

    @Override
    public void setSize(Size size) throws IOException {
        if (this.systemStream != null) {
            ExecHelper.exec(true, OSUtils.STTY_COMMAND, "columns", Integer.toString(size.getColumns()), "rows", Integer.toString(size.getRows()));
        } else {
            ExecHelper.exec(false, OSUtils.STTY_COMMAND, OSUtils.STTY_F_OPTION, this.getName(), "columns", Integer.toString(size.getColumns()), "rows", Integer.toString(size.getRows()));
        }
    }

    public String toString() {
        return "ExecPty[" + this.getName() + (this.systemStream != null ? ", system]" : "]");
    }
}

