/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016JD\u0010\u000b\u001a&\u0012\u0004\u0012\u00020\r\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedSyntheticExtensionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "computeSuitableDescriptorAndError", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "descriptor", "Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nProtectedSyntheticExtensionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtectedSyntheticExtensionCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedSyntheticExtensionCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n2632#2,3:87\n*S KotlinDebug\n*F\n+ 1 ProtectedSyntheticExtensionCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedSyntheticExtensionCallChecker\n*L\n79#1:87,3\n*E\n"})
public final class ProtectedSyntheticExtensionCallChecker
implements CallChecker {
    @NotNull
    public static final ProtectedSyntheticExtensionCallChecker INSTANCE = new ProtectedSyntheticExtensionCallChecker();

    private ProtectedSyntheticExtensionCallChecker() {
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<FunctionDescriptor, DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor>> computeSuitableDescriptorAndError(SyntheticJavaPropertyDescriptor descriptor, PsiElement reportOn, CallCheckerContext context) {
        v0 = context.getResolutionContext().callPosition;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"callPosition");
        callPosition = v0;
        if (!(callPosition instanceof CallPosition.PropertyAssignment)) ** GOTO lbl-1000
        var7_5 = ((CallPosition.PropertyAssignment)callPosition).getLeftPart();
        v1 = var7_5 instanceof KtQualifiedExpression != false ? (KtQualifiedExpression)var7_5 : null;
        if (Intrinsics.areEqual((Object)(v1 != null ? v1.getSelectorExpression() : null), (Object)reportOn)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        isLeftSide = v2;
        getMethod = descriptor.getGetMethod();
        setMethod = descriptor.getSetMethod();
        isImprovingDiagnosticsEnabled = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ImproveReportingDiagnosticsOnProtectedMembersOfBaseClass);
        needToTakeSetter = isImprovingDiagnosticsEnabled != false && isLeftSide != false;
        suitableDescriptor = needToTakeSetter != false && setMethod != null ? setMethod : getMethod;
        return TuplesKt.to((Object)suitableDescriptor, needToTakeSetter != false && setMethod != null ? Errors.INVISIBLE_SETTER : Errors.INVISIBLE_MEMBER);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean bl;
        DeclarationDescriptor from2;
        DiagnosticFactory3 error;
        Object descriptor2;
        block7: {
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            descriptor2 = resolvedCall2.getResultingDescriptor();
            if (!(descriptor2 instanceof SyntheticJavaPropertyDescriptor)) {
                return;
            }
            Pair<FunctionDescriptor, DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor>> pair = this.computeSuitableDescriptorAndError((SyntheticJavaPropertyDescriptor)descriptor2, reportOn, context2);
            FunctionDescriptor sourceFunction = (FunctionDescriptor)pair.component1();
            error = (DiagnosticFactory3)pair.component2();
            from2 = context2.getScope().getOwnerDescriptor();
            if (!DescriptorVisibilityUtils.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)descriptor2, from2, context2.getLanguageVersionSettings())) {
                return;
            }
            if (resolvedCall2.getDispatchReceiver() != null && resolvedCall2.getExtensionReceiver() == null) {
                return;
            }
            ReceiverValue receiverValue = resolvedCall2.getExtensionReceiver();
            Intrinsics.checkNotNull((Object)receiverValue, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue");
            ReceiverValue receiverValue2 = receiverValue;
            Collection collection = CollectionsKt.listOf((Object)receiverValue2.getType());
            DataFlowInfo dataFlowInfo = context2.getDataFlowInfo();
            DataFlowValueFactory dataFlowValueFactory = context2.getDataFlowValueFactory();
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            List receiverTypes = CollectionsKt.plus((Collection)collection, (Iterable)dataFlowInfo.getStableTypes(dataFlowValueFactory.createDataFlowValue(receiverValue2, bindingContext, context2.getScope().getOwnerDescriptor()), context2.getLanguageVersionSettings()));
            Iterable $this$none$iv = receiverTypes;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!DescriptorVisibilityUtils.isVisible(SmartCastUtilKt.getReceiverValueWithSmartCast(null, it), sourceFunction, from2, context2.getLanguageVersionSettings())) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            context2.getTrace().report(error.on(reportOn, descriptor2, ((SyntheticJavaPropertyDescriptor)descriptor2).getVisibility(), from2));
        }
    }
}

