/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/BoxingUnboxingElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "changed", "", "apply", "js.translator"})
public final class BoxingUnboxingElimination {
    @NotNull
    private final JsBlock root;
    private boolean changed;

    public BoxingUnboxingElimination(@NotNull JsBlock root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    public final boolean apply() {
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(this){
            final /* synthetic */ BoxingUnboxingElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void endVisit(JsInvocation x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                super.endVisit(x, ctx);
                this.tryEliminate(x, ctx);
            }

            public void endVisit(JsNew x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                super.endVisit(x, ctx);
                this.tryEliminate(x, ctx);
            }

            public void endVisit(JsNameRef x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                super.endVisit(x, ctx);
                this.tryEliminate(x, ctx);
            }

            public void endVisit(JsArrayAccess x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                super.endVisit(x, ctx);
            }

            public boolean visit(JsFunction x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            private final void tryEliminate(JsExpression expression2, JsContext<JsNode> ctx) {
                if (!MetadataProperties.isInlineClassBoxing(expression2) && !MetadataProperties.isInlineClassUnboxing(expression2)) {
                    return;
                }
                JsExpression firstArg = (JsExpression)CollectionsKt.first(this.getArguments(expression2));
                if (!MetadataProperties.isInlineClassBoxing(firstArg) && !MetadataProperties.isInlineClassUnboxing(firstArg)) {
                    return;
                }
                if (MetadataProperties.isInlineClassBoxing(firstArg) != MetadataProperties.isInlineClassBoxing(expression2)) {
                    ctx.replaceMe((JsNode)CollectionsKt.first(this.getArguments(firstArg)));
                    BoxingUnboxingElimination.access$setChanged$p(this.this$0, true);
                }
            }

            private final List<JsExpression> getArguments(JsExpression $this$arguments) {
                List list2;
                JsExpression jsExpression = $this$arguments;
                if (jsExpression instanceof JsExpression.JsExpressionHasArguments) {
                    List list3 = ((JsExpression.JsExpressionHasArguments)$this$arguments).getArguments();
                    list2 = list3;
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getArguments(...)");
                } else {
                    list2 = jsExpression instanceof JsNameRef ? CollectionsKt.listOfNotNull((Object)((JsNameRef)$this$arguments).getQualifier()) : CollectionsKt.emptyList();
                }
                return list2;
            }
        };
        visitor2.accept((JsNode)this.root);
        return this.changed;
    }

    public static final /* synthetic */ void access$setChanged$p(BoxingUnboxingElimination $this, boolean bl) {
        $this.changed = bl;
    }
}

