/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/backend/ConstValueProviderImpl;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "getEvaluatedConstTracker", "()Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "findConstantValueFor", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "firExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Companion", "fir2ir"})
public final class ConstValueProviderImpl
extends ConstValueProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final EvaluatedConstTracker evaluatedConstTracker;

    public ConstValueProviderImpl(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.session = components2.getSession();
        this.evaluatedConstTracker = components2.getConfiguration().getEvaluatedConstTracker();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public EvaluatedConstTracker getEvaluatedConstTracker() {
        return this.evaluatedConstTracker;
    }

    @Override
    @Nullable
    public ConstantValue<?> findConstantValueFor(@Nullable FirExpression firExpression2) {
        FirFile firFile = this.getProcessingFirFile();
        if (firExpression2 == null || firFile == null) {
            return null;
        }
        if (firExpression2 instanceof FirVarargArgumentsExpression) {
            return null;
        }
        String string2 = UtilsKt.getPackageFqName(firFile).child(Name.identifier(firFile.getName())).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String fileName = string2;
        Pair<Integer, Integer> pair = Companion.getCorrespondingIrOffset(firExpression2);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> pair2 = pair;
        int start = ((Number)pair2.component1()).intValue();
        int end = ((Number)pair2.component2()).intValue();
        return this.getEvaluatedConstTracker().load(start, end, fileName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/backend/ConstValueProviderImpl$Companion;", "", "()V", "getCorrespondingIrOffset", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "fir2ir"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Pair<Integer, Integer> getCorrespondingIrOffset(@NotNull FirExpression $this$getCorrespondingIrOffset) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)$this$getCorrespondingIrOffset, (String)"<this>");
            if ($this$getCorrespondingIrOffset instanceof FirQualifiedAccessExpression && ConversionUtilsKt.shouldUseCalleeReferenceAsItsSourceInIr((FirQualifiedAccessExpression)$this$getCorrespondingIrOffset)) {
                int n;
                FirReference calleeReference = ((FirQualifiedAccessExpression)$this$getCorrespondingIrOffset).getCalleeReference();
                Object object = calleeReference.getSource();
                if (object != null && (object = ConversionUtilsKt.startOffsetSkippingComments((AbstractKtSourceElement)object)) != null) {
                    n = (Integer)object;
                } else {
                    KtSourceElement ktSourceElement = calleeReference.getSource();
                    n = ktSourceElement != null ? ktSourceElement.getStartOffset() : -1;
                }
                int start = n;
                KtSourceElement ktSourceElement = $this$getCorrespondingIrOffset.getSource();
                if (ktSourceElement == null) {
                    return null;
                }
                int end = ktSourceElement.getEndOffset();
                pair = TuplesKt.to((Object)start, (Object)end);
            } else {
                KtSourceElement ktSourceElement = $this$getCorrespondingIrOffset.getSource();
                if (ktSourceElement == null) {
                    return null;
                }
                int start = ktSourceElement.getStartOffset();
                KtSourceElement ktSourceElement2 = $this$getCorrespondingIrOffset.getSource();
                if (ktSourceElement2 == null) {
                    return null;
                }
                int end = ktSourceElement2.getEndOffset();
                pair = TuplesKt.to((Object)start, (Object)end);
            }
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

