/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirMissingDependencySupertypeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker INSTANCE = new FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker();

    private FirMissingDependencySupertypeInQualifiedAccessExpressionsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        boolean unresolvedLazySupertypesByDefault;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        KtSourceElement source = expression2.getSource();
        FirCallableSymbol symbol2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (symbol2 == null) {
            ConeSimpleKotlinType coneSimpleKotlinType;
            ConeSimpleKotlinType coneSimpleKotlinType2;
            ConeKotlinType coneKotlinType;
            FirExpression firExpression2 = expression2.getExplicitReceiver();
            ConeSimpleKotlinType receiverType2 = firExpression2 != null && (coneKotlinType = FirTypeUtilsKt.getResolvedType(firExpression2)) != null && (coneSimpleKotlinType2 = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType)) != null && (coneSimpleKotlinType = ConeTypeUtilsKt.originalIfDefinitelyNotNullable(coneSimpleKotlinType2)) != null ? TypeExpansionUtilsKt.fullyExpandedType(coneSimpleKotlinType, context2.getSession()) : null;
            FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(receiverType2, source, reporter2, context2);
            return;
        }
        boolean missingSupertype = FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(symbol2.getDispatchReceiverType(), source, reporter2, context2);
        boolean eagerChecksAllowed = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExtendedCompilerChecks());
        boolean bl = unresolvedLazySupertypesByDefault = symbol2 instanceof FirConstructorSymbol || symbol2 instanceof FirAnonymousFunctionSymbol;
        if (eagerChecksAllowed || !unresolvedLazySupertypesByDefault && !missingSupertype) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = FirVisibilityCheckerKt.getOwnerLookupTag(symbol2);
            FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes((FirBasedSymbol)(coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null), source, reporter2, context2);
            FirResolvedTypeRef firResolvedTypeRef = symbol2.getResolvedReceiverTypeRef();
            FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes(firResolvedTypeRef != null ? FirTypeUtilsKt.getConeTypeOrNull(firResolvedTypeRef) : null, source, reporter2, context2);
        }
    }
}

