/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerLoggerAdapterKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocationWithRange;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aT\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\r0\f2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\f\u001a&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\b\b\u0002\u0010\u0000\u001a\u00020\u0001\u001a&\u0010\u0012\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\b\b\u0002\u0010\u0000\u001a\u00020\u0001\u001aM\u0010\u0014\u001a\u0004\u0018\u00010\u0015\"\b\b\u0000\u0010\u0016*\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u0001H\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001d\u001a\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 \u001a\u000e\u0010!\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 \u001a \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#*\u00020%2\u0006\u0010&\u001a\u00020$H\u0002\u001a)\u0010'\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$\u0018\u00010#*\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010$H\u0002\u00a2\u0006\u0002\u0010)\u001a\u0016\u0010*\u001a\u0004\u0018\u00010+*\u00020,2\u0006\u0010-\u001a\u00020\u0011H\u0002\u001a\f\u0010.\u001a\u00020/*\u00020\u0001H\u0007\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u00060"}, d2={"messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getMessageCollector", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "checkKotlinPackageUsage", "", "F", "configuration", "files", "", "getPackage", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "getMessageLocation", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "checkKotlinPackageUsageForLightTree", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "checkKotlinPackageUsageForPsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLibraryFromHome", "Ljava/io/File;", "PathProvider", "", "paths", "getLibrary", "libraryName", "", "noLibraryArgument", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/lang/String;)Ljava/io/File;", "incrementalCompilationIsEnabled", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "incrementalCompilationIsEnabledForJs", "getLineAndColumnByOffsetStartingWithOnes", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "startOffset", "getLineAndColumnStartingWithOnesAt", "offset", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Integer;)Lkotlin/Pair;", "getLocationWithin", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocationWithRange;", "Lorg/jetbrains/kotlin/KtSourceElement;", "file", "toLogger", "Lorg/jetbrains/kotlin/util/Logger;", "cli"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/cli/common/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class UtilsKt {
    public static final boolean incrementalCompilationIsEnabled(@NotNull CommonCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Boolean bl = arguments2.getIncrementalCompilation();
        return bl != null ? bl : IncrementalCompilation.isEnabledForJvm();
    }

    public static final boolean incrementalCompilationIsEnabledForJs(@NotNull CommonCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Boolean bl = arguments2.getIncrementalCompilation();
        return bl != null ? bl : IncrementalCompilation.isEnabledForJs();
    }

    public static final <F> boolean checkKotlinPackageUsage(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends F> files2, @NotNull MessageCollector messageCollector2, @NotNull Function1<? super F, FqName> getPackage, @NotNull Function1<? super F, ? extends CompilerMessageSourceLocation> getMessageLocation) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkNotNullParameter(getPackage, (String)"getPackage");
        Intrinsics.checkNotNullParameter(getMessageLocation, (String)"getMessageLocation");
        if (configuration2.getBoolean(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE)) {
            return true;
        }
        FqName kotlinPackage = new FqName("kotlin");
        for (F file2 : files2) {
            if (!FqNamesUtilKt.isSubpackageOf((FqName)getPackage.invoke(file2), kotlinPackage)) continue;
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", (CompilerMessageSourceLocation)getMessageLocation.invoke(file2));
            return false;
        }
        return true;
    }

    private static final MessageCollector getMessageCollector(CompilerConfiguration $this$messageCollector) {
        MessageCollector messageCollector2 = $this$messageCollector.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.Companion.getNONE());
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector2, (String)"get(...)");
        return messageCollector2;
    }

    public static final boolean checkKotlinPackageUsageForPsi(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends KtFile> files2, @NotNull MessageCollector messageCollector2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        return UtilsKt.checkKotlinPackageUsage(configuration2, files2, messageCollector2, checkKotlinPackageUsageForPsi.1.INSTANCE, checkKotlinPackageUsageForPsi.2.INSTANCE);
    }

    public static /* synthetic */ boolean checkKotlinPackageUsageForPsi$default(CompilerConfiguration compilerConfiguration, Collection collection, MessageCollector messageCollector2, int n, Object object) {
        if ((n & 4) != 0) {
            messageCollector2 = UtilsKt.getMessageCollector(compilerConfiguration);
        }
        return UtilsKt.checkKotlinPackageUsageForPsi(compilerConfiguration, collection, messageCollector2);
    }

    public static final boolean checkKotlinPackageUsageForLightTree(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends FirFile> files2, @NotNull MessageCollector messageCollector2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        return UtilsKt.checkKotlinPackageUsage(configuration2, files2, messageCollector2, checkKotlinPackageUsageForLightTree.1.INSTANCE, checkKotlinPackageUsageForLightTree.2.INSTANCE);
    }

    public static /* synthetic */ boolean checkKotlinPackageUsageForLightTree$default(CompilerConfiguration compilerConfiguration, Collection collection, MessageCollector messageCollector2, int n, Object object) {
        if ((n & 4) != 0) {
            messageCollector2 = UtilsKt.getMessageCollector(compilerConfiguration);
        }
        return UtilsKt.checkKotlinPackageUsageForLightTree(compilerConfiguration, collection, messageCollector2);
    }

    private static final CompilerMessageLocationWithRange getLocationWithin(KtSourceElement $this$getLocationWithin, FirFile file2) {
        KtSourceFile ktSourceFile = file2.getSourceFile();
        if (ktSourceFile == null) {
            return null;
        }
        KtSourceFile sourceFile = ktSourceFile;
        Pair<Integer, Integer> pair = UtilsKt.getLineAndColumnStartingWithOnesAt(file2, $this$getLocationWithin.getStartOffset());
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> pair2 = pair;
        int startLine = ((Number)pair2.component1()).intValue();
        int startColumn = ((Number)pair2.component2()).intValue();
        Pair<Integer, Integer> pair3 = UtilsKt.getLineAndColumnStartingWithOnesAt(file2, $this$getLocationWithin.getEndOffset());
        if (pair3 == null) {
            return null;
        }
        Pair<Integer, Integer> pair4 = pair3;
        int endLine = ((Number)pair4.component1()).intValue();
        int endColumn = ((Number)pair4.component2()).intValue();
        CharSequence charSequence = KtSourceElementKt.getText($this$getLocationWithin);
        return CompilerMessageLocationWithRange.Companion.create(sourceFile.getPath(), startLine, startColumn, endLine, endColumn, charSequence != null ? ((Object)charSequence).toString() : null);
    }

    private static final Pair<Integer, Integer> getLineAndColumnStartingWithOnesAt(FirFile $this$getLineAndColumnStartingWithOnesAt, Integer offset2) {
        Object object;
        Integer n = offset2;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            KtSourceFileLinesMapping ktSourceFileLinesMapping = $this$getLineAndColumnStartingWithOnesAt.getSourceFileLinesMapping();
            object = ktSourceFileLinesMapping != null ? UtilsKt.getLineAndColumnByOffsetStartingWithOnes(ktSourceFileLinesMapping, it) : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final Pair<Integer, Integer> getLineAndColumnByOffsetStartingWithOnes(KtSourceFileLinesMapping $this$getLineAndColumnByOffsetStartingWithOnes, int startOffset) {
        Pair<Integer, Integer> pair = $this$getLineAndColumnByOffsetStartingWithOnes.getLineAndColumnByOffset(startOffset);
        int line = ((Number)pair.component1()).intValue();
        int column = ((Number)pair.component2()).intValue();
        return TuplesKt.to((Object)(line + 1), (Object)(column + 1));
    }

    @Nullable
    public static final <PathProvider> File getLibraryFromHome(@Nullable PathProvider paths, @NotNull Function1<? super PathProvider, ? extends File> getLibrary, @NotNull String libraryName2, @NotNull MessageCollector messageCollector2, @NotNull String noLibraryArgument) {
        File stdlibJar;
        Intrinsics.checkNotNullParameter(getLibrary, (String)"getLibrary");
        Intrinsics.checkNotNullParameter((Object)libraryName2, (String)"libraryName");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)noLibraryArgument, (String)"noLibraryArgument");
        if (paths != null && (stdlibJar = (File)getLibrary.invoke(paths)).exists()) {
            return stdlibJar;
        }
        messageCollector2.report(CompilerMessageSeverity.STRONG_WARNING, "Unable to find " + libraryName2 + " in the Kotlin home directory. Pass either " + noLibraryArgument + " to prevent adding it to the classpath, or the correct '-kotlin-home'", null);
        return null;
    }

    @Deprecated(message="Use org.jetbrains.kotlin.cli.common.messages.toLogger() instead", replaceWith=@ReplaceWith(expression="toLogger()", imports={"org.jetbrains.kotlin.cli.common.messages.toLogger"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final Logger toLogger(@NotNull MessageCollector $this$toLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$toLogger, (String)"<this>");
        return CompilerLoggerAdapterKt.toLogger$default($this$toLogger, false, 1, null);
    }

    public static final /* synthetic */ CompilerMessageLocationWithRange access$getLocationWithin(KtSourceElement $receiver, FirFile file2) {
        return UtilsKt.getLocationWithin($receiver, file2);
    }
}

