/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtVirtualFileSourceFile;
import org.jetbrains.kotlin.cli.common.GroupedKtSources;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CoreEnvironmentUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"javaFileExtensionWithDot", "", "kotlinFileExtensionWithDot", "ktSourceFileComparator", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/KtSourceFile;", "collectSources", "Lorg/jetbrains/kotlin/cli/common/GroupedKtSources;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "projectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/VfsBasedProjectEnvironment;", "cli"})
public final class GroupedKtSourcesKt {
    @NotNull
    private static final String kotlinFileExtensionWithDot = ".kt";
    @NotNull
    private static final String javaFileExtensionWithDot = ".java";
    @NotNull
    private static final Comparator<KtSourceFile> ktSourceFileComparator = GroupedKtSourcesKt::ktSourceFileComparator$lambda$0;

    @NotNull
    public static final GroupedKtSources collectSources(@NotNull CompilerConfiguration compilerConfiguration, @NotNull VfsBasedProjectEnvironment projectEnvironment2, @NotNull MessageCollector messageCollector2) {
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)projectEnvironment2, (String)"projectEnvironment");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        return GroupedKtSourcesKt.collectSources(compilerConfiguration, projectEnvironment2.getProject(), messageCollector2);
    }

    @NotNull
    public static final GroupedKtSources collectSources(@NotNull CompilerConfiguration compilerConfiguration, @NotNull Project project, @NotNull MessageCollector messageCollector2) {
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        TreeSet<KtSourceFile> platformSources = new TreeSet<KtSourceFile>(ktSourceFileComparator);
        TreeSet<KtSourceFile> commonSources = new TreeSet<KtSourceFile>(ktSourceFileComparator);
        Map sourcesByModuleName = new LinkedHashMap();
        boolean skipScriptsInLtMode = compilerConfiguration.getBoolean(CommonConfigurationKeys.USE_FIR) && compilerConfiguration.getBoolean(CommonConfigurationKeys.USE_LIGHT_TREE);
        Ref.BooleanRef skipScriptsInLtModeWarning = new Ref.BooleanRef();
        CoreEnvironmentUtilsKt.forAllFiles$default(CoreEnvironmentUtilsKt.getSourceRootsCheckingForDuplicates(compilerConfiguration, messageCollector2), compilerConfiguration, project, null, (Function3)new Function3<VirtualFile, Boolean, String, Unit>(skipScriptsInLtMode, commonSources, platformSources, (Map<String, Set<KtSourceFile>>)sourcesByModuleName, skipScriptsInLtModeWarning){
            final /* synthetic */ boolean $skipScriptsInLtMode;
            final /* synthetic */ TreeSet<KtSourceFile> $commonSources;
            final /* synthetic */ TreeSet<KtSourceFile> $platformSources;
            final /* synthetic */ Map<String, Set<KtSourceFile>> $sourcesByModuleName;
            final /* synthetic */ Ref.BooleanRef $skipScriptsInLtModeWarning;
            {
                this.$skipScriptsInLtMode = $skipScriptsInLtMode;
                this.$commonSources = $commonSources;
                this.$platformSources = $platformSources;
                this.$sourcesByModuleName = $sourcesByModuleName;
                this.$skipScriptsInLtModeWarning = $skipScriptsInLtModeWarning;
                super(3);
            }

            public final void invoke(VirtualFile virtualFile2, boolean isCommon, String moduleName) {
                Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
                KtVirtualFileSourceFile file2 = new KtVirtualFileSourceFile(virtualFile2);
                if (!StringsKt.endsWith$default((String)file2.getPath(), (String)".java", (boolean)false, (int)2, null)) {
                    if (StringsKt.endsWith$default((String)file2.getPath(), (String)".kt", (boolean)false, (int)2, null) || !this.$skipScriptsInLtMode) {
                        if (isCommon) {
                            this.$commonSources.add(file2);
                        } else {
                            this.$platformSources.add(file2);
                        }
                        if (moduleName != null) {
                            Set set;
                            Map<String, Set<KtSourceFile>> $this$getOrPut$iv = this.$sourcesByModuleName;
                            boolean $i$f$getOrPut = false;
                            Set value$iv = $this$getOrPut$iv.get(moduleName);
                            if (value$iv == null) {
                                boolean bl = false;
                                Set answer$iv = new LinkedHashSet<E>();
                                $this$getOrPut$iv.put(moduleName, answer$iv);
                                set = answer$iv;
                            } else {
                                set = value$iv;
                            }
                            set.add((KtSourceFile)file2);
                        }
                    } else {
                        this.$skipScriptsInLtModeWarning.element = true;
                    }
                }
            }
        }, 4, null);
        if (skipScriptsInLtModeWarning.element) {
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "Scripts are not yet supported with K2 in LightTree mode, consider using K1 or disable LightTree mode with -Xuse-fir-lt=false", null, 4, null);
        }
        return new GroupedKtSources((Collection<? extends KtSourceFile>)platformSources, (Collection<? extends KtSourceFile>)commonSources, sourcesByModuleName);
    }

    private static final int ktSourceFileComparator$lambda$0(KtSourceFile o1, KtSourceFile o2) {
        String string2 = o1.getPath();
        if (string2 == null) {
            throw new IllegalStateException("Expected a file with a well-defined path".toString());
        }
        String path1 = string2;
        String string3 = o2.getPath();
        if (string3 == null) {
            throw new IllegalStateException("Expected a file with a well-defined path".toString());
        }
        String path2 = string3;
        return path1.compareTo(path2);
    }
}

