/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.DescriptorProtos;
import org.jetbrains.kotlin.protobuf.ExtensionRegistry;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.FieldSet;
import org.jetbrains.kotlin.protobuf.Internal;
import org.jetbrains.kotlin.protobuf.InvalidProtocolBufferException;
import org.jetbrains.kotlin.protobuf.Message;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.protobuf.TextFormat;
import org.jetbrains.kotlin.protobuf.WireFormat;

public final class Descriptors {
    private static final Logger logger = Logger.getLogger(Descriptors.class.getName());

    private static String computeFullName(FileDescriptor file2, Descriptor parent2, String name2) {
        if (parent2 != null) {
            String string2 = String.valueOf(String.valueOf(parent2.getFullName()));
            String string3 = String.valueOf(String.valueOf(name2));
            return new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString();
        }
        if (file2.getPackage().length() > 0) {
            String string4 = String.valueOf(String.valueOf(file2.getPackage()));
            String string5 = String.valueOf(String.valueOf(name2));
            return new StringBuilder(1 + string4.length() + string5.length()).append(string4).append(".").append(string5).toString();
        }
        return name2;
    }

    public static final class OneofDescriptor {
        private final int index;
        private DescriptorProtos.OneofDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private Descriptor containingType;
        private int fieldCount;
        private FieldDescriptor[] fields;

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.proto.getName();
        }

        public FileDescriptor getFile() {
            return this.file;
        }

        public String getFullName() {
            return this.fullName;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        public FieldDescriptor getField(int index2) {
            return this.fields[index2];
        }

        private OneofDescriptor(DescriptorProtos.OneofDescriptorProto proto, FileDescriptor file2, Descriptor parent2, int index2) throws DescriptorValidationException {
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file2, parent2, proto.getName());
            this.file = file2;
            this.index = index2;
            this.containingType = parent2;
            this.fieldCount = 0;
        }

        static /* synthetic */ FieldDescriptor[] access$1702(OneofDescriptor x0, FieldDescriptor[] x1) {
            x0.fields = x1;
            return x1;
        }
    }

    private static final class DescriptorPool {
        private final Set<FileDescriptor> dependencies;
        private boolean allowUnknownDependencies;
        private final Map<String, GenericDescriptor> descriptorsByName = new HashMap<String, GenericDescriptor>();
        private final Map<DescriptorIntPair, FieldDescriptor> fieldsByNumber = new HashMap<DescriptorIntPair, FieldDescriptor>();
        private final Map<DescriptorIntPair, EnumValueDescriptor> enumValuesByNumber = new HashMap<DescriptorIntPair, EnumValueDescriptor>();

        DescriptorPool(FileDescriptor[] dependencies2, boolean allowUnknownDependencies) {
            this.dependencies = new HashSet<FileDescriptor>();
            this.allowUnknownDependencies = allowUnknownDependencies;
            for (int i2 = 0; i2 < dependencies2.length; ++i2) {
                this.dependencies.add(dependencies2[i2]);
                this.importPublicDependencies(dependencies2[i2]);
            }
            for (FileDescriptor dependency : this.dependencies) {
                try {
                    this.addPackage(dependency.getPackage(), dependency);
                }
                catch (DescriptorValidationException e) {
                    assert (false);
                }
            }
        }

        private void importPublicDependencies(FileDescriptor file2) {
            for (FileDescriptor dependency : file2.getPublicDependencies()) {
                if (!this.dependencies.add(dependency)) continue;
                this.importPublicDependencies(dependency);
            }
        }

        GenericDescriptor findSymbol(String fullName) {
            return this.findSymbol(fullName, SearchFilter.ALL_SYMBOLS);
        }

        GenericDescriptor findSymbol(String fullName, SearchFilter filter2) {
            GenericDescriptor result2 = this.descriptorsByName.get(fullName);
            if (result2 != null && (filter2 == SearchFilter.ALL_SYMBOLS || filter2 == SearchFilter.TYPES_ONLY && this.isType(result2) || filter2 == SearchFilter.AGGREGATES_ONLY && this.isAggregate(result2))) {
                return result2;
            }
            for (FileDescriptor dependency : this.dependencies) {
                result2 = ((FileDescriptor)dependency).pool.descriptorsByName.get(fullName);
                if (result2 == null || filter2 != SearchFilter.ALL_SYMBOLS && (filter2 != SearchFilter.TYPES_ONLY || !this.isType(result2)) && (filter2 != SearchFilter.AGGREGATES_ONLY || !this.isAggregate(result2))) continue;
                return result2;
            }
            return null;
        }

        boolean isType(GenericDescriptor descriptor2) {
            return descriptor2 instanceof Descriptor || descriptor2 instanceof EnumDescriptor;
        }

        boolean isAggregate(GenericDescriptor descriptor2) {
            return descriptor2 instanceof Descriptor || descriptor2 instanceof EnumDescriptor || descriptor2 instanceof PackageDescriptor || descriptor2 instanceof ServiceDescriptor;
        }

        GenericDescriptor lookupSymbol(String name2, GenericDescriptor relativeTo, SearchFilter filter2) throws DescriptorValidationException {
            GenericDescriptor result2;
            String fullname;
            if (name2.startsWith(".")) {
                fullname = name2.substring(1);
                result2 = this.findSymbol(fullname, filter2);
            } else {
                int firstPartLength = name2.indexOf(46);
                String firstPart = firstPartLength == -1 ? name2 : name2.substring(0, firstPartLength);
                StringBuilder scopeToTry = new StringBuilder(relativeTo.getFullName());
                while (true) {
                    int dotpos;
                    if ((dotpos = scopeToTry.lastIndexOf(".")) == -1) {
                        fullname = name2;
                        result2 = this.findSymbol(name2, filter2);
                        break;
                    }
                    scopeToTry.setLength(dotpos + 1);
                    scopeToTry.append(firstPart);
                    result2 = this.findSymbol(scopeToTry.toString(), SearchFilter.AGGREGATES_ONLY);
                    if (result2 != null) {
                        if (firstPartLength != -1) {
                            scopeToTry.setLength(dotpos + 1);
                            scopeToTry.append(name2);
                            result2 = this.findSymbol(scopeToTry.toString(), filter2);
                        }
                        fullname = scopeToTry.toString();
                        break;
                    }
                    scopeToTry.setLength(dotpos);
                }
            }
            if (result2 == null) {
                if (this.allowUnknownDependencies && filter2 == SearchFilter.TYPES_ONLY) {
                    String string2 = String.valueOf(String.valueOf(name2));
                    logger.warning(new StringBuilder(87 + string2.length()).append("The descriptor for message type \"").append(string2).append("\" can not be found and a placeholder is created for it").toString());
                    result2 = new Descriptor(fullname);
                    this.dependencies.add(result2.getFile());
                    return result2;
                }
                String string3 = String.valueOf(String.valueOf(name2));
                throw new DescriptorValidationException(relativeTo, new StringBuilder(18 + string3.length()).append("\"").append(string3).append("\" is not defined.").toString());
            }
            return result2;
        }

        void addSymbol(GenericDescriptor descriptor2) throws DescriptorValidationException {
            DescriptorPool.validateSymbolName(descriptor2);
            String fullName = descriptor2.getFullName();
            int dotpos = fullName.lastIndexOf(46);
            GenericDescriptor old = this.descriptorsByName.put(fullName, descriptor2);
            if (old != null) {
                this.descriptorsByName.put(fullName, old);
                if (descriptor2.getFile() == old.getFile()) {
                    if (dotpos == -1) {
                        String string2 = String.valueOf(String.valueOf(fullName));
                        throw new DescriptorValidationException(descriptor2, new StringBuilder(22 + string2.length()).append("\"").append(string2).append("\" is already defined.").toString());
                    }
                    String string3 = String.valueOf(String.valueOf(fullName.substring(dotpos + 1)));
                    String string4 = String.valueOf(String.valueOf(fullName.substring(0, dotpos)));
                    throw new DescriptorValidationException(descriptor2, new StringBuilder(28 + string3.length() + string4.length()).append("\"").append(string3).append("\" is already defined in \"").append(string4).append("\".").toString());
                }
                String string5 = String.valueOf(String.valueOf(fullName));
                String string6 = String.valueOf(String.valueOf(old.getFile().getName()));
                throw new DescriptorValidationException(descriptor2, new StringBuilder(33 + string5.length() + string6.length()).append("\"").append(string5).append("\" is already defined in file \"").append(string6).append("\".").toString());
            }
        }

        void addPackage(String fullName, FileDescriptor file2) throws DescriptorValidationException {
            String name2;
            int dotpos = fullName.lastIndexOf(46);
            if (dotpos == -1) {
                name2 = fullName;
            } else {
                this.addPackage(fullName.substring(0, dotpos), file2);
                name2 = fullName.substring(dotpos + 1);
            }
            GenericDescriptor old = this.descriptorsByName.put(fullName, new PackageDescriptor(name2, fullName, file2));
            if (old != null) {
                this.descriptorsByName.put(fullName, old);
                if (!(old instanceof PackageDescriptor)) {
                    String string2 = String.valueOf(String.valueOf(name2));
                    String string3 = String.valueOf(String.valueOf(old.getFile().getName()));
                    throw new DescriptorValidationException(file2, new StringBuilder(69 + string2.length() + string3.length()).append("\"").append(string2).append("\" is already defined (as something other than a ").append("package) in file \"").append(string3).append("\".").toString());
                }
            }
        }

        void addFieldByNumber(FieldDescriptor field2) throws DescriptorValidationException {
            DescriptorIntPair key = new DescriptorIntPair(field2.getContainingType(), field2.getNumber());
            FieldDescriptor old = this.fieldsByNumber.put(key, field2);
            if (old != null) {
                this.fieldsByNumber.put(key, old);
                int n = field2.getNumber();
                String string2 = String.valueOf(String.valueOf(field2.getContainingType().getFullName()));
                String string3 = String.valueOf(String.valueOf(old.getName()));
                throw new DescriptorValidationException((GenericDescriptor)field2, new StringBuilder(65 + string2.length() + string3.length()).append("Field number ").append(n).append(" has already been used in \"").append(string2).append("\" by field \"").append(string3).append("\".").toString());
            }
        }

        void addEnumValueByNumber(EnumValueDescriptor value2) {
            DescriptorIntPair key = new DescriptorIntPair(value2.getType(), value2.getNumber());
            EnumValueDescriptor old = this.enumValuesByNumber.put(key, value2);
            if (old != null) {
                this.enumValuesByNumber.put(key, old);
            }
        }

        static void validateSymbolName(GenericDescriptor descriptor2) throws DescriptorValidationException {
            String name2 = descriptor2.getName();
            if (name2.length() == 0) {
                throw new DescriptorValidationException(descriptor2, "Missing name.");
            }
            boolean valid = true;
            for (int i2 = 0; i2 < name2.length(); ++i2) {
                char c = name2.charAt(i2);
                if (c >= '\u0080') {
                    valid = false;
                }
                if (Character.isLetter(c) || c == '_' || Character.isDigit(c) && i2 > 0) continue;
                valid = false;
            }
            if (!valid) {
                String string2 = String.valueOf(String.valueOf(name2));
                throw new DescriptorValidationException(descriptor2, new StringBuilder(29 + string2.length()).append("\"").append(string2).append("\" is not a valid identifier.").toString());
            }
        }

        private static final class DescriptorIntPair {
            private final GenericDescriptor descriptor;
            private final int number;

            DescriptorIntPair(GenericDescriptor descriptor2, int number2) {
                this.descriptor = descriptor2;
                this.number = number2;
            }

            public int hashCode() {
                return this.descriptor.hashCode() * 65535 + this.number;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof DescriptorIntPair)) {
                    return false;
                }
                DescriptorIntPair other = (DescriptorIntPair)obj;
                return this.descriptor == other.descriptor && this.number == other.number;
            }
        }

        private static final class PackageDescriptor
        extends GenericDescriptor {
            private final String name;
            private final String fullName;
            private final FileDescriptor file;

            public Message toProto() {
                return this.file.toProto();
            }

            public String getName() {
                return this.name;
            }

            public String getFullName() {
                return this.fullName;
            }

            public FileDescriptor getFile() {
                return this.file;
            }

            PackageDescriptor(String name2, String fullName, FileDescriptor file2) {
                this.file = file2;
                this.fullName = fullName;
                this.name = name2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum SearchFilter {
            TYPES_ONLY,
            AGGREGATES_ONLY,
            ALL_SYMBOLS;

        }
    }

    public static class DescriptorValidationException
    extends Exception {
        private static final long serialVersionUID = 5750205775490483148L;
        private final String name;
        private final Message proto;
        private final String description;

        public String getProblemSymbolName() {
            return this.name;
        }

        public Message getProblemProto() {
            return this.proto;
        }

        public String getDescription() {
            return this.description;
        }

        private DescriptorValidationException(GenericDescriptor problemDescriptor, String description2) {
            String string2 = String.valueOf(String.valueOf(problemDescriptor.getFullName()));
            String string3 = String.valueOf(String.valueOf(description2));
            super(new StringBuilder(2 + string2.length() + string3.length()).append(string2).append(": ").append(string3).toString());
            this.name = problemDescriptor.getFullName();
            this.proto = problemDescriptor.toProto();
            this.description = description2;
        }

        private DescriptorValidationException(GenericDescriptor problemDescriptor, String description2, Throwable cause) {
            this(problemDescriptor, description2);
            this.initCause(cause);
        }

        private DescriptorValidationException(FileDescriptor problemDescriptor, String description2) {
            String string2 = String.valueOf(String.valueOf(problemDescriptor.getName()));
            String string3 = String.valueOf(String.valueOf(description2));
            super(new StringBuilder(2 + string2.length() + string3.length()).append(string2).append(": ").append(string3).toString());
            this.name = problemDescriptor.getName();
            this.proto = problemDescriptor.toProto();
            this.description = description2;
        }
    }

    public static abstract class GenericDescriptor {
        public abstract Message toProto();

        public abstract String getName();

        public abstract String getFullName();

        public abstract FileDescriptor getFile();
    }

    public static final class MethodDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.MethodDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final ServiceDescriptor service;
        private Descriptor inputType;
        private Descriptor outputType;

        public int getIndex() {
            return this.index;
        }

        public DescriptorProtos.MethodDescriptorProto toProto() {
            return this.proto;
        }

        public String getName() {
            return this.proto.getName();
        }

        public String getFullName() {
            return this.fullName;
        }

        public FileDescriptor getFile() {
            return this.file;
        }

        public ServiceDescriptor getService() {
            return this.service;
        }

        public Descriptor getInputType() {
            return this.inputType;
        }

        public Descriptor getOutputType() {
            return this.outputType;
        }

        public DescriptorProtos.MethodOptions getOptions() {
            return this.proto.getOptions();
        }

        private MethodDescriptor(DescriptorProtos.MethodDescriptorProto proto, FileDescriptor file2, ServiceDescriptor parent2, int index2) throws DescriptorValidationException {
            this.index = index2;
            this.proto = proto;
            this.file = file2;
            this.service = parent2;
            String string2 = String.valueOf(String.valueOf(parent2.getFullName()));
            String string3 = String.valueOf(String.valueOf(proto.getName()));
            this.fullName = new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString();
            file2.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor input = this.file.pool.lookupSymbol(this.proto.getInputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(input instanceof Descriptor)) {
                String string2 = String.valueOf(String.valueOf(this.proto.getInputType()));
                throw new DescriptorValidationException((GenericDescriptor)this, new StringBuilder(25 + string2.length()).append("\"").append(string2).append("\" is not a message type.").toString());
            }
            this.inputType = (Descriptor)input;
            GenericDescriptor output = this.file.pool.lookupSymbol(this.proto.getOutputType(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
            if (!(output instanceof Descriptor)) {
                String string3 = String.valueOf(String.valueOf(this.proto.getOutputType()));
                throw new DescriptorValidationException((GenericDescriptor)this, new StringBuilder(25 + string3.length()).append("\"").append(string3).append("\" is not a message type.").toString());
            }
            this.outputType = (Descriptor)output;
        }

        private void setProto(DescriptorProtos.MethodDescriptorProto proto) {
            this.proto = proto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ServiceDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.ServiceDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private MethodDescriptor[] methods;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.ServiceDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public DescriptorProtos.ServiceOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<MethodDescriptor> getMethods() {
            return Collections.unmodifiableList(Arrays.asList(this.methods));
        }

        public MethodDescriptor findMethodByName(String name2) {
            String string2 = String.valueOf(String.valueOf(this.fullName));
            String string3 = String.valueOf(String.valueOf(name2));
            GenericDescriptor result2 = this.file.pool.findSymbol(new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString());
            if (result2 != null && result2 instanceof MethodDescriptor) {
                return (MethodDescriptor)result2;
            }
            return null;
        }

        private ServiceDescriptor(DescriptorProtos.ServiceDescriptorProto proto, FileDescriptor file2, int index2) throws DescriptorValidationException {
            this.index = index2;
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file2, null, proto.getName());
            this.file = file2;
            this.methods = new MethodDescriptor[proto.getMethodCount()];
            for (int i2 = 0; i2 < proto.getMethodCount(); ++i2) {
                this.methods[i2] = new MethodDescriptor(proto.getMethod(i2), file2, this, i2);
            }
            file2.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            for (MethodDescriptor method : this.methods) {
                method.crossLink();
            }
        }

        private void setProto(DescriptorProtos.ServiceDescriptorProto proto) {
            this.proto = proto;
            for (int i2 = 0; i2 < this.methods.length; ++i2) {
                this.methods[i2].setProto(proto.getMethod(i2));
            }
        }
    }

    public static final class EnumValueDescriptor
    extends GenericDescriptor
    implements Internal.EnumLite {
        private final int index;
        private DescriptorProtos.EnumValueDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final EnumDescriptor type;

        public int getIndex() {
            return this.index;
        }

        public DescriptorProtos.EnumValueDescriptorProto toProto() {
            return this.proto;
        }

        public String getName() {
            return this.proto.getName();
        }

        public int getNumber() {
            return this.proto.getNumber();
        }

        public String toString() {
            return this.proto.getName();
        }

        public String getFullName() {
            return this.fullName;
        }

        public FileDescriptor getFile() {
            return this.file;
        }

        public EnumDescriptor getType() {
            return this.type;
        }

        public DescriptorProtos.EnumValueOptions getOptions() {
            return this.proto.getOptions();
        }

        private EnumValueDescriptor(DescriptorProtos.EnumValueDescriptorProto proto, FileDescriptor file2, EnumDescriptor parent2, int index2) throws DescriptorValidationException {
            this.index = index2;
            this.proto = proto;
            this.file = file2;
            this.type = parent2;
            String string2 = String.valueOf(String.valueOf(parent2.getFullName()));
            String string3 = String.valueOf(String.valueOf(proto.getName()));
            this.fullName = new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString();
            file2.pool.addSymbol(this);
            file2.pool.addEnumValueByNumber(this);
        }

        private void setProto(DescriptorProtos.EnumValueDescriptorProto proto) {
            this.proto = proto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumDescriptor
    extends GenericDescriptor
    implements Internal.EnumLiteMap<EnumValueDescriptor> {
        private final int index;
        private DescriptorProtos.EnumDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private EnumValueDescriptor[] values;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.EnumDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public DescriptorProtos.EnumOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<EnumValueDescriptor> getValues() {
            return Collections.unmodifiableList(Arrays.asList(this.values));
        }

        public EnumValueDescriptor findValueByName(String name2) {
            String string2 = String.valueOf(String.valueOf(this.fullName));
            String string3 = String.valueOf(String.valueOf(name2));
            GenericDescriptor result2 = this.file.pool.findSymbol(new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString());
            if (result2 != null && result2 instanceof EnumValueDescriptor) {
                return (EnumValueDescriptor)result2;
            }
            return null;
        }

        @Override
        public EnumValueDescriptor findValueByNumber(int number2) {
            return (EnumValueDescriptor)this.file.pool.enumValuesByNumber.get(new DescriptorPool.DescriptorIntPair(this, number2));
        }

        private EnumDescriptor(DescriptorProtos.EnumDescriptorProto proto, FileDescriptor file2, Descriptor parent2, int index2) throws DescriptorValidationException {
            this.index = index2;
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file2, parent2, proto.getName());
            this.file = file2;
            this.containingType = parent2;
            if (proto.getValueCount() == 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Enums must contain at least one value.");
            }
            this.values = new EnumValueDescriptor[proto.getValueCount()];
            for (int i2 = 0; i2 < proto.getValueCount(); ++i2) {
                this.values[i2] = new EnumValueDescriptor(proto.getValue(i2), file2, this, i2);
            }
            file2.pool.addSymbol(this);
        }

        private void setProto(DescriptorProtos.EnumDescriptorProto proto) {
            this.proto = proto;
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                this.values[i2].setProto(proto.getValue(i2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FieldDescriptor
    extends GenericDescriptor
    implements Comparable<FieldDescriptor>,
    FieldSet.FieldDescriptorLite<FieldDescriptor> {
        private static final WireFormat.FieldType[] table = WireFormat.FieldType.values();
        private final int index;
        private DescriptorProtos.FieldDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor extensionScope;
        private Type type;
        private Descriptor containingType;
        private Descriptor messageType;
        private OneofDescriptor containingOneof;
        private EnumDescriptor enumType;
        private Object defaultValue;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.FieldDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public int getNumber() {
            return this.proto.getNumber();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        public JavaType getJavaType() {
            return this.type.getJavaType();
        }

        @Override
        public WireFormat.JavaType getLiteJavaType() {
            return this.getLiteType().getJavaType();
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return table[this.type.ordinal()];
        }

        public boolean needsUtf8Check() {
            return this.type == Type.STRING && this.getFile().getOptions().getJavaStringCheckUtf8();
        }

        public boolean isRequired() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
        }

        public boolean isOptional() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL;
        }

        @Override
        public boolean isRepeated() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
        }

        @Override
        public boolean isPacked() {
            return this.getOptions().getPacked();
        }

        public boolean isPackable() {
            return this.isRepeated() && this.getLiteType().isPackable();
        }

        public boolean hasDefaultValue() {
            return this.proto.hasDefaultValue();
        }

        public Object getDefaultValue() {
            if (this.getJavaType() == JavaType.MESSAGE) {
                throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
            }
            return this.defaultValue;
        }

        public DescriptorProtos.FieldOptions getOptions() {
            return this.proto.getOptions();
        }

        public boolean isExtension() {
            return this.proto.hasExtendee();
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public OneofDescriptor getContainingOneof() {
            return this.containingOneof;
        }

        public Descriptor getExtensionScope() {
            if (!this.isExtension()) {
                throw new UnsupportedOperationException("This field is not an extension.");
            }
            return this.extensionScope;
        }

        public Descriptor getMessageType() {
            if (this.getJavaType() != JavaType.MESSAGE) {
                throw new UnsupportedOperationException("This field is not of message type.");
            }
            return this.messageType;
        }

        public EnumDescriptor getEnumType() {
            if (this.getJavaType() != JavaType.ENUM) {
                throw new UnsupportedOperationException("This field is not of enum type.");
            }
            return this.enumType;
        }

        @Override
        public int compareTo(FieldDescriptor other) {
            if (other.containingType != this.containingType) {
                throw new IllegalArgumentException("FieldDescriptors can only be compared to other FieldDescriptors for fields of the same message type.");
            }
            return this.getNumber() - other.getNumber();
        }

        private FieldDescriptor(DescriptorProtos.FieldDescriptorProto proto, FileDescriptor file2, Descriptor parent2, int index2, boolean isExtension) throws DescriptorValidationException {
            this.index = index2;
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file2, parent2, proto.getName());
            this.file = file2;
            if (proto.hasType()) {
                this.type = Type.valueOf(proto.getType());
            }
            if (this.getNumber() <= 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field numbers must be positive integers.");
            }
            if (isExtension) {
                if (!proto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee not set for extension field.");
                }
                this.containingType = null;
                this.extensionScope = parent2 != null ? parent2 : null;
                if (proto.hasOneofIndex()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index set for extension field.");
                }
                this.containingOneof = null;
            } else {
                if (proto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee set for non-extension field.");
                }
                this.containingType = parent2;
                if (proto.hasOneofIndex()) {
                    if (proto.getOneofIndex() < 0 || proto.getOneofIndex() >= parent2.toProto().getOneofDeclCount()) {
                        String string2 = String.valueOf(parent2.getName());
                        throw new DescriptorValidationException((GenericDescriptor)this, string2.length() != 0 ? "FieldDescriptorProto.oneof_index is out of range for type ".concat(string2) : new String("FieldDescriptorProto.oneof_index is out of range for type "));
                    }
                    this.containingOneof = parent2.getOneofs().get(proto.getOneofIndex());
                    this.containingOneof.fieldCount++;
                } else {
                    this.containingOneof = null;
                }
                this.extensionScope = null;
            }
            file2.pool.addSymbol(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void crossLink() throws DescriptorValidationException {
            if (this.proto.hasExtendee()) {
                GenericDescriptor extendee = this.file.pool.lookupSymbol(this.proto.getExtendee(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!(extendee instanceof Descriptor)) {
                    String string2 = String.valueOf(String.valueOf(this.proto.getExtendee()));
                    throw new DescriptorValidationException((GenericDescriptor)this, new StringBuilder(25 + string2.length()).append("\"").append(string2).append("\" is not a message type.").toString());
                }
                this.containingType = (Descriptor)extendee;
                if (!this.getContainingType().isExtensionNumber(this.getNumber())) {
                    String string3 = String.valueOf(String.valueOf(this.getContainingType().getFullName()));
                    int n = this.getNumber();
                    throw new DescriptorValidationException((GenericDescriptor)this, new StringBuilder(55 + string3.length()).append("\"").append(string3).append("\" does not declare ").append(n).append(" as an extension number.").toString());
                }
            }
            if (this.proto.hasTypeName()) {
                GenericDescriptor typeDescriptor = this.file.pool.lookupSymbol(this.proto.getTypeName(), this, DescriptorPool.SearchFilter.TYPES_ONLY);
                if (!this.proto.hasType()) {
                    if (typeDescriptor instanceof Descriptor) {
                        this.type = Type.MESSAGE;
                    } else if (typeDescriptor instanceof EnumDescriptor) {
                        this.type = Type.ENUM;
                    } else {
                        String string4 = String.valueOf(String.valueOf(this.proto.getTypeName()));
                        throw new DescriptorValidationException((GenericDescriptor)this, new StringBuilder(17 + string4.length()).append("\"").append(string4).append("\" is not a type.").toString());
                    }
                }
                if (this.getJavaType() == JavaType.MESSAGE) {
                    if (!(typeDescriptor instanceof Descriptor)) {
                        String string5 = String.valueOf(String.valueOf(this.proto.getTypeName()));
                        throw new DescriptorValidationException((GenericDescriptor)this, new StringBuilder(25 + string5.length()).append("\"").append(string5).append("\" is not a message type.").toString());
                    }
                    this.messageType = (Descriptor)typeDescriptor;
                    if (this.proto.hasDefaultValue()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "Messages can't have default values.");
                    }
                } else {
                    if (this.getJavaType() != JavaType.ENUM) throw new DescriptorValidationException((GenericDescriptor)this, "Field with primitive type has type_name.");
                    if (!(typeDescriptor instanceof EnumDescriptor)) {
                        String string6 = String.valueOf(String.valueOf(this.proto.getTypeName()));
                        throw new DescriptorValidationException((GenericDescriptor)this, new StringBuilder(23 + string6.length()).append("\"").append(string6).append("\" is not an enum type.").toString());
                    }
                    this.enumType = (EnumDescriptor)typeDescriptor;
                }
            } else if (this.getJavaType() == JavaType.MESSAGE || this.getJavaType() == JavaType.ENUM) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field with message or enum type missing type_name.");
            }
            if (this.proto.getOptions().getPacked() && !this.isPackable()) {
                throw new DescriptorValidationException((GenericDescriptor)this, "[packed = true] can only be specified for repeated primitive fields.");
            }
            if (this.proto.hasDefaultValue()) {
                if (this.isRepeated()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "Repeated fields cannot have default values.");
                }
                try {
                    switch (this.getType()) {
                        case INT32: 
                        case SINT32: 
                        case SFIXED32: {
                            this.defaultValue = TextFormat.parseInt32(this.proto.getDefaultValue());
                            break;
                        }
                        case UINT32: 
                        case FIXED32: {
                            this.defaultValue = TextFormat.parseUInt32(this.proto.getDefaultValue());
                            break;
                        }
                        case INT64: 
                        case SINT64: 
                        case SFIXED64: {
                            this.defaultValue = TextFormat.parseInt64(this.proto.getDefaultValue());
                            break;
                        }
                        case UINT64: 
                        case FIXED64: {
                            this.defaultValue = TextFormat.parseUInt64(this.proto.getDefaultValue());
                            break;
                        }
                        case FLOAT: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Float.valueOf(Float.POSITIVE_INFINITY);
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Float.valueOf(Float.NaN);
                                break;
                            }
                            this.defaultValue = Float.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case DOUBLE: {
                            if (this.proto.getDefaultValue().equals("inf")) {
                                this.defaultValue = Double.POSITIVE_INFINITY;
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("-inf")) {
                                this.defaultValue = Double.NEGATIVE_INFINITY;
                                break;
                            }
                            if (this.proto.getDefaultValue().equals("nan")) {
                                this.defaultValue = Double.NaN;
                                break;
                            }
                            this.defaultValue = Double.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case BOOL: {
                            this.defaultValue = Boolean.valueOf(this.proto.getDefaultValue());
                            break;
                        }
                        case STRING: {
                            this.defaultValue = this.proto.getDefaultValue();
                            break;
                        }
                        case BYTES: {
                            try {
                                this.defaultValue = TextFormat.unescapeBytes(this.proto.getDefaultValue());
                                break;
                            }
                            catch (TextFormat.InvalidEscapeSequenceException e) {
                                String string7 = String.valueOf(e.getMessage());
                                throw new DescriptorValidationException(this, string7.length() != 0 ? "Couldn't parse default value: ".concat(string7) : new String("Couldn't parse default value: "), e);
                            }
                        }
                        case ENUM: {
                            this.defaultValue = this.enumType.findValueByName(this.proto.getDefaultValue());
                            if (this.defaultValue != null) break;
                            String e = String.valueOf(String.valueOf(this.proto.getDefaultValue()));
                            throw new DescriptorValidationException((GenericDescriptor)this, new StringBuilder(30 + e.length()).append("Unknown enum default value: \"").append(e).append("\"").toString());
                        }
                        case MESSAGE: 
                        case GROUP: {
                            throw new DescriptorValidationException((GenericDescriptor)this, "Message type had default value.");
                        }
                    }
                }
                catch (NumberFormatException e) {
                    String string8 = String.valueOf(String.valueOf(this.proto.getDefaultValue()));
                    throw new DescriptorValidationException(this, new StringBuilder(33 + string8.length()).append("Could not parse default value: \"").append(string8).append("\"").toString(), e);
                }
            } else if (this.isRepeated()) {
                this.defaultValue = Collections.emptyList();
            } else {
                switch (this.getJavaType()) {
                    case ENUM: {
                        this.defaultValue = this.enumType.getValues().get(0);
                        break;
                    }
                    case MESSAGE: {
                        this.defaultValue = null;
                        break;
                    }
                    default: {
                        this.defaultValue = this.getJavaType().defaultDefault;
                    }
                }
            }
            if (!this.isExtension()) {
                this.file.pool.addFieldByNumber(this);
            }
            if (this.containingType == null || !this.containingType.getOptions().getMessageSetWireFormat()) return;
            if (!this.isExtension()) throw new DescriptorValidationException((GenericDescriptor)this, "MessageSets cannot have fields, only extensions.");
            if (this.isOptional() && this.getType() == Type.MESSAGE) return;
            throw new DescriptorValidationException((GenericDescriptor)this, "Extensions of MessageSets must be optional messages.");
        }

        private void setProto(DescriptorProtos.FieldDescriptorProto proto) {
            this.proto = proto;
        }

        @Override
        public MessageLite.Builder internalMergeFrom(MessageLite.Builder to, MessageLite from2) {
            return ((Message.Builder)to).mergeFrom((Message)from2);
        }

        static {
            if (Type.values().length != DescriptorProtos.FieldDescriptorProto.Type.values().length) {
                throw new RuntimeException("descriptor.proto has a new declared type but Desrciptors.java wasn't updated.");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum JavaType {
            INT(0),
            LONG(0L),
            FLOAT(Float.valueOf(0.0f)),
            DOUBLE(0.0),
            BOOLEAN(false),
            STRING(""),
            BYTE_STRING(ByteString.EMPTY),
            ENUM(null),
            MESSAGE(null);

            private final Object defaultDefault;

            private JavaType(Object defaultDefault) {
                this.defaultDefault = defaultDefault;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            DOUBLE(JavaType.DOUBLE),
            FLOAT(JavaType.FLOAT),
            INT64(JavaType.LONG),
            UINT64(JavaType.LONG),
            INT32(JavaType.INT),
            FIXED64(JavaType.LONG),
            FIXED32(JavaType.INT),
            BOOL(JavaType.BOOLEAN),
            STRING(JavaType.STRING),
            GROUP(JavaType.MESSAGE),
            MESSAGE(JavaType.MESSAGE),
            BYTES(JavaType.BYTE_STRING),
            UINT32(JavaType.INT),
            ENUM(JavaType.ENUM),
            SFIXED32(JavaType.INT),
            SFIXED64(JavaType.LONG),
            SINT32(JavaType.INT),
            SINT64(JavaType.LONG);

            private JavaType javaType;

            private Type(JavaType javaType) {
                this.javaType = javaType;
            }

            public DescriptorProtos.FieldDescriptorProto.Type toProto() {
                return DescriptorProtos.FieldDescriptorProto.Type.valueOf(this.ordinal() + 1);
            }

            public JavaType getJavaType() {
                return this.javaType;
            }

            public static Type valueOf(DescriptorProtos.FieldDescriptorProto.Type type2) {
                return Type.values()[type2.getNumber() - 1];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Descriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.DescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final Descriptor[] nestedTypes;
        private final EnumDescriptor[] enumTypes;
        private final FieldDescriptor[] fields;
        private final FieldDescriptor[] extensions;
        private final OneofDescriptor[] oneofs;

        public int getIndex() {
            return this.index;
        }

        @Override
        public DescriptorProtos.DescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }

        public Descriptor getContainingType() {
            return this.containingType;
        }

        public DescriptorProtos.MessageOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public List<OneofDescriptor> getOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<Descriptor> getNestedTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.nestedTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public boolean isExtensionNumber(int number2) {
            for (DescriptorProtos.DescriptorProto.ExtensionRange range : this.proto.getExtensionRangeList()) {
                if (range.getStart() > number2 || number2 >= range.getEnd()) continue;
                return true;
            }
            return false;
        }

        public boolean isExtendable() {
            return this.proto.getExtensionRangeList().size() != 0;
        }

        public FieldDescriptor findFieldByName(String name2) {
            String string2 = String.valueOf(String.valueOf(this.fullName));
            String string3 = String.valueOf(String.valueOf(name2));
            GenericDescriptor result2 = this.file.pool.findSymbol(new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString());
            if (result2 != null && result2 instanceof FieldDescriptor) {
                return (FieldDescriptor)result2;
            }
            return null;
        }

        public FieldDescriptor findFieldByNumber(int number2) {
            return (FieldDescriptor)this.file.pool.fieldsByNumber.get(new DescriptorPool.DescriptorIntPair(this, number2));
        }

        public Descriptor findNestedTypeByName(String name2) {
            String string2 = String.valueOf(String.valueOf(this.fullName));
            String string3 = String.valueOf(String.valueOf(name2));
            GenericDescriptor result2 = this.file.pool.findSymbol(new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString());
            if (result2 != null && result2 instanceof Descriptor) {
                return (Descriptor)result2;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String name2) {
            String string2 = String.valueOf(String.valueOf(this.fullName));
            String string3 = String.valueOf(String.valueOf(name2));
            GenericDescriptor result2 = this.file.pool.findSymbol(new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString());
            if (result2 != null && result2 instanceof EnumDescriptor) {
                return (EnumDescriptor)result2;
            }
            return null;
        }

        Descriptor(String fullname) throws DescriptorValidationException {
            String name2 = fullname;
            String packageName = "";
            int pos = fullname.lastIndexOf(46);
            if (pos != -1) {
                name2 = fullname.substring(pos + 1);
                packageName = fullname.substring(0, pos);
            }
            this.index = 0;
            this.proto = DescriptorProtos.DescriptorProto.newBuilder().setName(name2).addExtensionRange(DescriptorProtos.DescriptorProto.ExtensionRange.newBuilder().setStart(1).setEnd(0x20000000).build()).build();
            this.fullName = fullname;
            this.containingType = null;
            this.nestedTypes = new Descriptor[0];
            this.enumTypes = new EnumDescriptor[0];
            this.fields = new FieldDescriptor[0];
            this.extensions = new FieldDescriptor[0];
            this.oneofs = new OneofDescriptor[0];
            this.file = new FileDescriptor(packageName, this);
        }

        private Descriptor(DescriptorProtos.DescriptorProto proto, FileDescriptor file2, Descriptor parent2, int index2) throws DescriptorValidationException {
            int i2;
            this.index = index2;
            this.proto = proto;
            this.fullName = Descriptors.computeFullName(file2, parent2, proto.getName());
            this.file = file2;
            this.containingType = parent2;
            this.oneofs = new OneofDescriptor[proto.getOneofDeclCount()];
            for (i2 = 0; i2 < proto.getOneofDeclCount(); ++i2) {
                this.oneofs[i2] = new OneofDescriptor(proto.getOneofDecl(i2), file2, this, i2);
            }
            this.nestedTypes = new Descriptor[proto.getNestedTypeCount()];
            for (i2 = 0; i2 < proto.getNestedTypeCount(); ++i2) {
                this.nestedTypes[i2] = new Descriptor(proto.getNestedType(i2), file2, this, i2);
            }
            this.enumTypes = new EnumDescriptor[proto.getEnumTypeCount()];
            for (i2 = 0; i2 < proto.getEnumTypeCount(); ++i2) {
                this.enumTypes[i2] = new EnumDescriptor(proto.getEnumType(i2), file2, this, i2);
            }
            this.fields = new FieldDescriptor[proto.getFieldCount()];
            for (i2 = 0; i2 < proto.getFieldCount(); ++i2) {
                this.fields[i2] = new FieldDescriptor(proto.getField(i2), file2, this, i2, false);
            }
            this.extensions = new FieldDescriptor[proto.getExtensionCount()];
            for (i2 = 0; i2 < proto.getExtensionCount(); ++i2) {
                this.extensions[i2] = new FieldDescriptor(proto.getExtension(i2), file2, this, i2, true);
            }
            for (i2 = 0; i2 < proto.getOneofDeclCount(); ++i2) {
                OneofDescriptor.access$1702(this.oneofs[i2], new FieldDescriptor[this.oneofs[i2].getFieldCount()]);
                this.oneofs[i2].fieldCount = 0;
            }
            for (i2 = 0; i2 < proto.getFieldCount(); ++i2) {
                OneofDescriptor oneofDescriptor = this.fields[i2].getContainingOneof();
                if (oneofDescriptor == null) continue;
                ((OneofDescriptor)oneofDescriptor).fields[((OneofDescriptor)oneofDescriptor).fieldCount++] = this.fields[i2];
            }
            file2.pool.addSymbol(this);
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor descriptor2 : this.nestedTypes) {
                descriptor2.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.fields) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void setProto(DescriptorProtos.DescriptorProto proto) {
            int i2;
            this.proto = proto;
            for (i2 = 0; i2 < this.nestedTypes.length; ++i2) {
                this.nestedTypes[i2].setProto(proto.getNestedType(i2));
            }
            for (i2 = 0; i2 < this.enumTypes.length; ++i2) {
                this.enumTypes[i2].setProto(proto.getEnumType(i2));
            }
            for (i2 = 0; i2 < this.fields.length; ++i2) {
                this.fields[i2].setProto(proto.getField(i2));
            }
            for (i2 = 0; i2 < this.extensions.length; ++i2) {
                this.extensions[i2].setProto(proto.getExtension(i2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileDescriptor
    extends GenericDescriptor {
        private DescriptorProtos.FileDescriptorProto proto;
        private final Descriptor[] messageTypes;
        private final EnumDescriptor[] enumTypes;
        private final ServiceDescriptor[] services;
        private final FieldDescriptor[] extensions;
        private final FileDescriptor[] dependencies;
        private final FileDescriptor[] publicDependencies;
        private final DescriptorPool pool;

        @Override
        public DescriptorProtos.FileDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public String getName() {
            return this.proto.getName();
        }

        @Override
        public FileDescriptor getFile() {
            return this;
        }

        @Override
        public String getFullName() {
            return this.proto.getName();
        }

        public String getPackage() {
            return this.proto.getPackage();
        }

        public DescriptorProtos.FileOptions getOptions() {
            return this.proto.getOptions();
        }

        public List<Descriptor> getMessageTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.messageTypes));
        }

        public List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public List<ServiceDescriptor> getServices() {
            return Collections.unmodifiableList(Arrays.asList(this.services));
        }

        public List<FieldDescriptor> getExtensions() {
            return Collections.unmodifiableList(Arrays.asList(this.extensions));
        }

        public List<FileDescriptor> getDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.dependencies));
        }

        public List<FileDescriptor> getPublicDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.publicDependencies));
        }

        public Descriptor findMessageTypeByName(String name2) {
            GenericDescriptor result2;
            if (name2.indexOf(46) != -1) {
                return null;
            }
            if (this.getPackage().length() > 0) {
                String string2 = String.valueOf(String.valueOf(this.getPackage()));
                String string3 = String.valueOf(String.valueOf(name2));
                name2 = new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString();
            }
            if ((result2 = this.pool.findSymbol(name2)) != null && result2 instanceof Descriptor && result2.getFile() == this) {
                return (Descriptor)result2;
            }
            return null;
        }

        public EnumDescriptor findEnumTypeByName(String name2) {
            GenericDescriptor result2;
            if (name2.indexOf(46) != -1) {
                return null;
            }
            if (this.getPackage().length() > 0) {
                String string2 = String.valueOf(String.valueOf(this.getPackage()));
                String string3 = String.valueOf(String.valueOf(name2));
                name2 = new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString();
            }
            if ((result2 = this.pool.findSymbol(name2)) != null && result2 instanceof EnumDescriptor && result2.getFile() == this) {
                return (EnumDescriptor)result2;
            }
            return null;
        }

        public ServiceDescriptor findServiceByName(String name2) {
            GenericDescriptor result2;
            if (name2.indexOf(46) != -1) {
                return null;
            }
            if (this.getPackage().length() > 0) {
                String string2 = String.valueOf(String.valueOf(this.getPackage()));
                String string3 = String.valueOf(String.valueOf(name2));
                name2 = new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString();
            }
            if ((result2 = this.pool.findSymbol(name2)) != null && result2 instanceof ServiceDescriptor && result2.getFile() == this) {
                return (ServiceDescriptor)result2;
            }
            return null;
        }

        public FieldDescriptor findExtensionByName(String name2) {
            GenericDescriptor result2;
            if (name2.indexOf(46) != -1) {
                return null;
            }
            if (this.getPackage().length() > 0) {
                String string2 = String.valueOf(String.valueOf(this.getPackage()));
                String string3 = String.valueOf(String.valueOf(name2));
                name2 = new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString();
            }
            if ((result2 = this.pool.findSymbol(name2)) != null && result2 instanceof FieldDescriptor && result2.getFile() == this) {
                return (FieldDescriptor)result2;
            }
            return null;
        }

        public static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto proto, FileDescriptor[] dependencies2) throws DescriptorValidationException {
            return FileDescriptor.buildFrom(proto, dependencies2, false);
        }

        private static FileDescriptor buildFrom(DescriptorProtos.FileDescriptorProto proto, FileDescriptor[] dependencies2, boolean allowUnknownDependencies) throws DescriptorValidationException {
            DescriptorPool pool = new DescriptorPool(dependencies2, allowUnknownDependencies);
            FileDescriptor result2 = new FileDescriptor(proto, dependencies2, pool, allowUnknownDependencies);
            result2.crossLink();
            return result2;
        }

        public static void internalBuildGeneratedFileFrom(String[] descriptorDataParts, FileDescriptor[] dependencies2, InternalDescriptorAssigner descriptorAssigner) {
            FileDescriptor result2;
            DescriptorProtos.FileDescriptorProto proto;
            byte[] descriptorBytes;
            StringBuilder descriptorData = new StringBuilder();
            for (String part2 : descriptorDataParts) {
                descriptorData.append(part2);
            }
            try {
                descriptorBytes = descriptorData.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Standard encoding ISO-8859-1 not supported by JVM.", e);
            }
            try {
                proto = DescriptorProtos.FileDescriptorProto.parseFrom(descriptorBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", e);
            }
            try {
                result2 = FileDescriptor.buildFrom(proto, dependencies2, true);
            }
            catch (DescriptorValidationException e) {
                String string2 = String.valueOf(String.valueOf(proto.getName()));
                throw new IllegalArgumentException(new StringBuilder(35 + string2.length()).append("Invalid embedded descriptor for \"").append(string2).append("\".").toString(), e);
            }
            ExtensionRegistry registry = descriptorAssigner.assignDescriptors(result2);
            if (registry != null) {
                try {
                    proto = DescriptorProtos.FileDescriptorProto.parseFrom(descriptorBytes, (ExtensionRegistryLite)registry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", e);
                }
                result2.setProto(proto);
            }
        }

        public static void internalBuildGeneratedFileFrom(String[] descriptorDataParts, Class<?> descriptorOuterClass, String[] dependencies2, String[] dependencyFileNames, InternalDescriptorAssigner descriptorAssigner) {
            ArrayList<FileDescriptor> descriptors = new ArrayList<FileDescriptor>();
            for (int i2 = 0; i2 < dependencies2.length; ++i2) {
                try {
                    Class<?> clazz = descriptorOuterClass.getClassLoader().loadClass(dependencies2[i2]);
                    descriptors.add((FileDescriptor)clazz.getField("descriptor").get(null));
                    continue;
                }
                catch (Exception e) {
                    String string2 = String.valueOf(String.valueOf(dependencyFileNames[i2]));
                    logger.warning(new StringBuilder(36 + string2.length()).append("Descriptors for \"").append(string2).append("\" can not be found.").toString());
                }
            }
            FileDescriptor[] descriptorArray = new FileDescriptor[descriptors.size()];
            descriptors.toArray(descriptorArray);
            FileDescriptor.internalBuildGeneratedFileFrom(descriptorDataParts, descriptorArray, descriptorAssigner);
        }

        public static void internalUpdateFileDescriptor(FileDescriptor descriptor2, ExtensionRegistry registry) {
            DescriptorProtos.FileDescriptorProto proto;
            ByteString bytes = descriptor2.proto.toByteString();
            try {
                proto = DescriptorProtos.FileDescriptorProto.parseFrom(bytes, (ExtensionRegistryLite)registry);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", e);
            }
            descriptor2.setProto(proto);
        }

        private FileDescriptor(DescriptorProtos.FileDescriptorProto proto, FileDescriptor[] dependencies2, DescriptorPool pool, boolean allowUnknownDependencies) throws DescriptorValidationException {
            int i2;
            this.pool = pool;
            this.proto = proto;
            this.dependencies = (FileDescriptor[])dependencies2.clone();
            HashMap<String, FileDescriptor> nameToFileMap = new HashMap<String, FileDescriptor>();
            for (FileDescriptor file2 : dependencies2) {
                nameToFileMap.put(file2.getName(), file2);
            }
            ArrayList<FileDescriptor> publicDependencies = new ArrayList<FileDescriptor>();
            for (i2 = 0; i2 < proto.getPublicDependencyCount(); ++i2) {
                int index2 = proto.getPublicDependency(i2);
                if (index2 < 0 || index2 >= proto.getDependencyCount()) {
                    throw new DescriptorValidationException(this, "Invalid public dependency index.");
                }
                String name2 = proto.getDependency(index2);
                FileDescriptor file3 = (FileDescriptor)nameToFileMap.get(name2);
                if (file3 == null) {
                    if (allowUnknownDependencies) continue;
                    String string2 = String.valueOf(name2);
                    throw new DescriptorValidationException(this, string2.length() != 0 ? "Invalid public dependency: ".concat(string2) : new String("Invalid public dependency: "));
                }
                publicDependencies.add(file3);
            }
            this.publicDependencies = new FileDescriptor[publicDependencies.size()];
            publicDependencies.toArray(this.publicDependencies);
            pool.addPackage(this.getPackage(), this);
            this.messageTypes = new Descriptor[proto.getMessageTypeCount()];
            for (i2 = 0; i2 < proto.getMessageTypeCount(); ++i2) {
                this.messageTypes[i2] = new Descriptor(proto.getMessageType(i2), this, null, i2);
            }
            this.enumTypes = new EnumDescriptor[proto.getEnumTypeCount()];
            for (i2 = 0; i2 < proto.getEnumTypeCount(); ++i2) {
                this.enumTypes[i2] = new EnumDescriptor(proto.getEnumType(i2), this, null, i2);
            }
            this.services = new ServiceDescriptor[proto.getServiceCount()];
            for (i2 = 0; i2 < proto.getServiceCount(); ++i2) {
                this.services[i2] = new ServiceDescriptor(proto.getService(i2), this, i2);
            }
            this.extensions = new FieldDescriptor[proto.getExtensionCount()];
            for (i2 = 0; i2 < proto.getExtensionCount(); ++i2) {
                this.extensions[i2] = new FieldDescriptor(proto.getExtension(i2), this, null, i2, true);
            }
        }

        FileDescriptor(String packageName, Descriptor message) throws DescriptorValidationException {
            this.pool = new DescriptorPool(new FileDescriptor[0], true);
            this.proto = DescriptorProtos.FileDescriptorProto.newBuilder().setName(String.valueOf(message.getFullName()).concat(".placeholder.proto")).setPackage(packageName).addMessageType(message.toProto()).build();
            this.dependencies = new FileDescriptor[0];
            this.publicDependencies = new FileDescriptor[0];
            this.messageTypes = new Descriptor[]{message};
            this.enumTypes = new EnumDescriptor[0];
            this.services = new ServiceDescriptor[0];
            this.extensions = new FieldDescriptor[0];
            this.pool.addPackage(packageName, this);
            this.pool.addSymbol(message);
        }

        private void crossLink() throws DescriptorValidationException {
            for (Descriptor descriptor2 : this.messageTypes) {
                descriptor2.crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.services) {
                ((ServiceDescriptor)genericDescriptor).crossLink();
            }
            for (GenericDescriptor genericDescriptor : this.extensions) {
                ((FieldDescriptor)genericDescriptor).crossLink();
            }
        }

        private void setProto(DescriptorProtos.FileDescriptorProto proto) {
            int i2;
            this.proto = proto;
            for (i2 = 0; i2 < this.messageTypes.length; ++i2) {
                this.messageTypes[i2].setProto(proto.getMessageType(i2));
            }
            for (i2 = 0; i2 < this.enumTypes.length; ++i2) {
                this.enumTypes[i2].setProto(proto.getEnumType(i2));
            }
            for (i2 = 0; i2 < this.services.length; ++i2) {
                this.services[i2].setProto(proto.getService(i2));
            }
            for (i2 = 0; i2 < this.extensions.length; ++i2) {
                this.extensions[i2].setProto(proto.getExtension(i2));
            }
        }

        public static interface InternalDescriptorAssigner {
            public ExtensionRegistry assignDescriptors(FileDescriptor var1);
        }
    }
}

