/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Transformer", "backend.jvm.lower"})
public final class JvmLateinitLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmLateinitLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new Transformer(this.context));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0007H\u0016J\f\u0010$\u001a\u00020%*\u00020\nH\u0002J\f\u0010&\u001a\u00020%*\u00020'H\u0002J\u0014\u0010(\u001a\u00020\u0014*\u00020)2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "backingVariables", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lkotlin/collections/HashMap;", "getOrBuildLateinitBackingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "originalField", "getOrBuildLateinitBackingVar", "declaration", "transformGetter", "", "backingField", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitVariable", "isLateinitBackingField", "", "isRealLateinit", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmLateinitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLoweringKt\n*L\n1#1,236:1\n361#2,7:237\n218#3,12:244\n*S KotlinDebug\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n*L\n71#1:237,7\n170#1:244,12\n*E\n"})
    private static final class Transformer
    extends IrElementTransformerVoid {
        @NotNull
        private final JvmBackendContext backendContext;
        @NotNull
        private final HashMap<IrVariable, IrVariable> backingVariables;

        public Transformer(@NotNull JvmBackendContext backendContext) {
            Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
            this.backendContext = backendContext;
            this.backingVariables = new HashMap();
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (this.isLateinitBackingField(declaration)) {
                boolean bl;
                boolean bl2 = bl = declaration.getInitializer() == null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "lateinit property backing field should not have an initializer:\n" + DumpIrTreeKt.dump$default(declaration, false, false, 3, null);
                    throw new AssertionError((Object)string2);
                }
                return this.getOrBuildLateinitBackingField(declaration);
            }
            this.transformChildrenVoid(declaration);
            return declaration;
        }

        @Override
        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
            if (!declaration.isLateinit()) {
                return declaration;
            }
            return this.getOrBuildLateinitBackingVar(declaration);
        }

        private final IrVariable getOrBuildLateinitBackingVar(IrVariable declaration) {
            Object object;
            Map $this$getOrPut$iv = this.backingVariables;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(declaration);
            if (value$iv == null) {
                IrVariable irVariable2;
                boolean bl = false;
                IrVariable it = irVariable2 = DeclarationBuildersKt.buildVariable$default(declaration.getParent(), declaration.getStartOffset(), declaration.getEndOffset(), declaration.getOrigin(), declaration.getName(), IrTypesKt.makeNullable(declaration.getType()), true, false, false, 384, null);
                boolean bl2 = false;
                it.setInitializer(IrConstImpl.Companion.constNull(declaration.getStartOffset(), declaration.getEndOffset(), this.backendContext.getIrBuiltIns().getNothingNType()));
                IrVariable answer$iv = irVariable2;
                $this$getOrPut$iv.put(declaration, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (IrVariable)object;
        }

        @Override
        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            IrProperty property2;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
            IrProperty irProperty2 = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property2 != null && this.isRealLateinit(property2) && Intrinsics.areEqual((Object)declaration, (Object)property2.getGetter())) {
                IrField irField = property2.getBackingField();
                Intrinsics.checkNotNull((Object)irField);
                this.transformGetter(this.getOrBuildLateinitBackingField(irField), declaration);
                return declaration;
            }
            this.transformChildrenVoid(declaration);
            return declaration;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration irValue = expression2.getSymbol().getOwner();
            if (!(irValue instanceof IrVariable) || !((IrVariable)irValue).isLateinit()) {
                return expression2;
            }
            IrVariable irVariable2 = this.backingVariables.get(irValue);
            if (irVariable2 == null) {
                throw new AssertionError((Object)("Lateinit variable reference before use: " + DumpIrTreeKt.dump$default(expression2, false, false, 3, null)));
            }
            IrVariable irBackingVar = irVariable2;
            BackendContext backendContext = (BackendContext)this.backendContext;
            IrDeclarationParent irDeclarationParent = irBackingVar.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            DeclarationIrBuilder $this$visitGetValue_u24lambda_u243 = LowerUtilsKt.createIrBuilder((BackendContext)backendContext, (IrSymbol)((IrSymbolOwner)((Object)irDeclarationParent)).getSymbol(), (int)expression2.getStartOffset(), (int)expression2.getEndOffset());
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitGetValue_u24lambda_u243;
            IrType irType = expression2.getType();
            IrExpression irExpression = ExpressionHelpersKt.irEqualsNull((IrBuilderWithScope)$this$visitGetValue_u24lambda_u243, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitGetValue_u24lambda_u243, irBackingVar));
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$visitGetValue_u24lambda_u243;
            String string2 = irBackingVar.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irBackingVar.name.asString()");
            return ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression, this.backendContext.throwUninitializedPropertyAccessException(irBuilderWithScope2, string2), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitGetValue_u24lambda_u243, irBackingVar), null, 16, null);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrValueDeclaration irValue = expression2.getSymbol().getOwner();
            if (!(irValue instanceof IrVariable) || !((IrVariable)irValue).isLateinit()) {
                return expression2;
            }
            IrVariable irVariable2 = (IrVariable)((Map)this.backingVariables).get(expression2.getSymbol().getOwner());
            if (irVariable2 == null) {
                throw new AssertionError((Object)("Lateinit variable reference before use: " + DumpIrTreeKt.dump$default(expression2, false, false, 3, null)));
            }
            IrVariable irBackingVar = irVariable2;
            IrSetValue $this$visitSetValue_u24lambda_u244 = expression2;
            boolean bl = false;
            return new IrSetValueImpl($this$visitSetValue_u24lambda_u244.getStartOffset(), $this$visitSetValue_u24lambda_u244.getEndOffset(), $this$visitSetValue_u24lambda_u244.getType(), irBackingVar.getSymbol(), $this$visitSetValue_u24lambda_u244.getValue(), $this$visitSetValue_u24lambda_u244.getOrigin());
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrField irField = (IrField)expression2.getSymbol().getOwner();
            if (!this.isLateinitBackingField(irField)) {
                return expression2;
            }
            IrField newField = this.getOrBuildLateinitBackingField(irField);
            IrGetField $this$visitGetField_u24lambda_u245 = expression2;
            boolean bl = false;
            return new IrGetFieldImpl($this$visitGetField_u24lambda_u245.getStartOffset(), $this$visitGetField_u24lambda_u245.getEndOffset(), newField.getSymbol(), newField.getType(), $this$visitGetField_u24lambda_u245.getReceiver(), $this$visitGetField_u24lambda_u245.getOrigin(), $this$visitGetField_u24lambda_u245.getSuperQualifierSymbol());
        }

        @Override
        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrField irField = (IrField)expression2.getSymbol().getOwner();
            if (!this.isLateinitBackingField(irField)) {
                return expression2;
            }
            IrField newField = this.getOrBuildLateinitBackingField(irField);
            IrSetField $this$visitSetField_u24lambda_u246 = expression2;
            boolean bl = false;
            return new IrSetFieldImpl($this$visitSetField_u24lambda_u246.getStartOffset(), $this$visitSetField_u24lambda_u246.getEndOffset(), newField.getSymbol(), $this$visitSetField_u24lambda_u246.getReceiver(), $this$visitSetField_u24lambda_u246.getValue(), $this$visitSetField_u24lambda_u246.getType(), $this$visitSetField_u24lambda_u246.getOrigin(), $this$visitSetField_u24lambda_u246.getSuperQualifierSymbol());
        }

        private final boolean isLateinitBackingField(IrField $this$isLateinitBackingField) {
            IrPropertySymbol irPropertySymbol = $this$isLateinitBackingField.getCorrespondingPropertySymbol();
            IrProperty property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            return property2 != null && this.isRealLateinit(property2);
        }

        private final boolean isRealLateinit(IrProperty $this$isRealLateinit) {
            return $this$isRealLateinit.isLateinit() && !$this$isRealLateinit.isFakeOverride();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter((IrFunctionSymbol)expression2.getSymbol())) {
                return expression2;
            }
            IrExpression irExpression2 = expression2.getExtensionReceiver();
            Intrinsics.checkNotNull((Object)irExpression2);
            IrExpression $this$replaceTailExpression$iv = irExpression2;
            boolean $i$f$replaceTailExpression = false;
            IrExpression current$iv = $this$replaceTailExpression$iv;
            IrContainerExpression block$iv = null;
            while (current$iv instanceof IrContainerExpression) {
                block$iv = (IrContainerExpression)current$iv;
                Object object = CollectionsKt.last(((IrContainerExpression)current$iv).getStatements());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                current$iv = (IrExpression)object;
            }
            IrExpression it = current$iv;
            boolean bl = false;
            IrPropertyReference irPropertyReference = it instanceof IrPropertyReference ? (IrPropertyReference)it : null;
            if (irPropertyReference == null) {
                throw new AssertionError((Object)("Property reference expected: " + RenderIrElementKt.render(it)));
            }
            IrPropertyReference irPropertyRef = irPropertyReference;
            Object object = irPropertyRef.getGetter();
            if (object == null || (object = (IrSimpleFunction)object.getOwner()) == null || (object = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)object, false, null, 3, null)) == null || (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) == null || (object = (IrProperty)object.getOwner()) == null) {
                throw new AssertionError((Object)("isInitialized cannot be invoked on " + RenderIrElementKt.render(it)));
            }
            Object property2 = object;
            if (!((IrProperty)property2).isLateinit()) {
                boolean $i$a$-require-JvmLateinitLowering$Transformer$visitCall$1$22 = false;
                String $i$a$-require-JvmLateinitLowering$Transformer$visitCall$1$22 = "isInitialized invoked on non-lateinit property " + RenderIrElementKt.render((IrElement)property2);
                throw new IllegalArgumentException($i$a$-require-JvmLateinitLowering$Transformer$visitCall$1$22.toString());
            }
            IrField irField = ((IrProperty)property2).getBackingField();
            if (irField == null) {
                throw new AssertionError((Object)"Lateinit property is supposed to have a backing field");
            }
            IrField backingField2 = irField;
            IrField newField = this.getOrBuildLateinitBackingField(backingField2);
            DeclarationIrBuilder $this$visitCall_u24lambda_u249_u24lambda_u248 = LowerUtilsKt.createIrBuilder((BackendContext)((BackendContext)this.backendContext), ((IrPropertyReference)it).getSymbol(), (int)expression2.getStartOffset(), (int)expression2.getEndOffset());
            boolean bl2 = false;
            current$iv = ExpressionHelpersKt.irNotEquals((IrBuilderWithScope)$this$visitCall_u24lambda_u249_u24lambda_u248, ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)$this$visitCall_u24lambda_u249_u24lambda_u248, ((IrPropertyReference)it).getDispatchReceiver(), newField, null, 4, null), ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$visitCall_u24lambda_u249_u24lambda_u248));
            if (block$iv == null) {
                irExpression = current$iv;
            } else {
                void var2_2;
                block$iv.getStatements().set(block$iv.getStatements().size() - 1, current$iv);
                irExpression = var2_2;
            }
            return irExpression;
        }

        private final void transformGetter(IrField backingField2, IrFunction getter2) {
            boolean bl;
            IrType type2 = backingField2.getType();
            boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType$default(type2, false, 1, null);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = false;
                String $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = "'lateinit' property type should not be primitive:\n" + DumpIrTreeKt.dump$default(backingField2, false, false, 3, null);
                throw new AssertionError((Object)$i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22);
            }
            int startOffset = getter2.getStartOffset();
            int endOffset = getter2.getEndOffset();
            getter2.setBody(this.backendContext.getIrFactory().createBlockBody(startOffset, endOffset, (Function1<? super IrBlockBody, Unit>)((Function1)new Function1<IrBlockBody, Unit>(this, getter2, startOffset, endOffset, backingField2){
                final /* synthetic */ Transformer this$0;
                final /* synthetic */ IrFunction $getter;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrField $backingField;
                {
                    this.this$0 = $receiver;
                    this.$getter = $getter;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$backingField = $backingField;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                    IrGetValueImpl irGetValueImpl;
                    DeclarationIrBuilder irBuilder;
                    Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                    DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)((BackendContext)Transformer.access$getBackendContext$p(this.this$0)), (IrSymbol)this.$getter.getSymbol(), (int)this.$startOffset, (int)this.$endOffset);
                    IrFunction irFunction2 = this.$getter;
                    IrField irField = this.$backingField;
                    Transformer transformer2 = this.this$0;
                    DeclarationIrBuilder $this$invoke_u24lambda_u241 = declarationIrBuilder;
                    boolean bl = false;
                    Scope scope2 = $this$invoke_u24lambda_u241.getScope();
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$invoke_u24lambda_u241;
                    IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
                    if (irValueParameter != null) {
                        void it;
                        IrValueParameter irValueParameter2 = irValueParameter;
                        IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                        Scope scope3 = scope2;
                        boolean bl2 = false;
                        IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u241, (IrValueDeclaration)it);
                        scope2 = scope3;
                        irBuilderWithScope = irBuilderWithScope2;
                        irGetValueImpl = irGetValueImpl2;
                    } else {
                        irGetValueImpl = null;
                    }
                    IrVariable resultVar = IrBuilderKt.createTmpVariable$default(scope2, (IrExpression)ExpressionHelpersKt.irGetField$default(irBuilderWithScope, irGetValueImpl, irField, null, 4, null), null, false, null, null, 30, null);
                    resultVar.setParent(irFunction2);
                    $this$createBlockBody.getStatements().add(resultVar);
                    IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$invoke_u24lambda_u241;
                    IrType irType = $this$invoke_u24lambda_u241.getContext().getIrBuiltIns().getNothingType();
                    IrExpression irExpression = ExpressionHelpersKt.irNotEquals((IrBuilderWithScope)$this$invoke_u24lambda_u241, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u241, resultVar), ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$invoke_u24lambda_u241));
                    IrExpression irExpression2 = ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$invoke_u24lambda_u241, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u241, resultVar));
                    IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$invoke_u24lambda_u241;
                    String string2 = irField.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"backingField.name.asString()");
                    IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope3, irType, irExpression, irExpression2, Transformer.access$throwUninitializedPropertyAccessException(transformer2, irBuilderWithScope4, string2), null, 16, null);
                    $this$createBlockBody.getStatements().add(throwIfNull);
                }
            })));
        }

        private final IrExpression throwUninitializedPropertyAccessException(IrBuilderWithScope $this$throwUninitializedPropertyAccessException, String name2) {
            return this.backendContext.throwUninitializedPropertyAccessException($this$throwUninitializedPropertyAccessException, name2);
        }

        private final IrField getOrBuildLateinitBackingField(IrField originalField) {
            return IrTypePredicatesKt.isMarkedNullable(originalField.getType()) ? originalField : (IrField)MappingsKt.getOrPut((Mapping.Delegate)this.backendContext.getMapping().getLateInitFieldToNullableField(), (IrDeclaration)originalField, (Function0)((Function0)new Function0<IrField>(this, originalField){
                final /* synthetic */ Transformer this$0;
                final /* synthetic */ IrField $originalField;
                {
                    this.this$0 = $receiver;
                    this.$originalField = $originalField;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final IrField invoke() {
                    void $this$buildField$iv;
                    Object object = Transformer.access$getBackendContext$p(this.this$0).getIrFactory();
                    IrField irField = this.$originalField;
                    boolean $i$f$buildField = false;
                    IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
                    boolean bl = false;
                    IrFieldBuilder $this$invoke_u24lambda_u240 = $this$buildField_u24lambda_u244$iv;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u240.updateFrom(irField);
                    $this$invoke_u24lambda_u240.setType(IrTypesKt.makeNullable(irField.getType()));
                    $this$invoke_u24lambda_u240.setName(irField.getName());
                    object = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, $this$buildField_u24lambda_u244$iv);
                    irField = this.$originalField;
                    Object $this$invoke_u24lambda_u241 = object;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u241.setParent(irField.getParent());
                    ((IrField)$this$invoke_u24lambda_u241).setCorrespondingPropertySymbol(irField.getCorrespondingPropertySymbol());
                    $this$invoke_u24lambda_u241.setAnnotations(irField.getAnnotations());
                    return object;
                }
            }));
        }

        public static final /* synthetic */ IrExpression access$throwUninitializedPropertyAccessException(Transformer $this, IrBuilderWithScope $receiver, String name2) {
            return $this.throwUninitializedPropertyAccessException($receiver, name2);
        }
    }
}

