/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsDataFlowExtras;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsTypeChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "frontend.java"})
public final class RuntimeAssertionsTypeChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final RuntimeAssertionsTypeChecker INSTANCE = new RuntimeAssertionsTypeChecker();

    private RuntimeAssertionsTypeChecker() {
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType2, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType2, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (TypeUtils.noExpectedType(c.expectedType) || c.expectedType instanceof StubTypeForBuilderInference) {
            return;
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"c.expectedType");
        RuntimeAssertionInfo assertionInfo = RuntimeAssertionInfo.Companion.create(kotlinType, expressionType2, new RuntimeAssertionsDataFlowExtras(c, expressionType2, expression2));
        if (assertionInfo != null) {
            c.trace.record(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, expression2, assertionInfo);
        }
    }
}

