/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicVerifier;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/MethodVerifier;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "checkPoint", "", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "transform", "", "internalClassName", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "backend"})
public final class MethodVerifier
extends MethodTransformer {
    @NotNull
    private final String checkPoint;
    @NotNull
    private final GenerationState generationState;

    public MethodVerifier(@NotNull String checkPoint, @NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)checkPoint, (String)"checkPoint");
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        this.checkPoint = checkPoint;
        this.generationState = generationState;
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        if (!this.generationState.getShouldValidateBytecode()) {
            return;
        }
        try {
            MethodTransformer.analyze(internalClassName, methodNode, (Interpreter)new BasicVerifier());
        }
        catch (Throwable e) {
            throw new AssertionError(this.checkPoint + ": incorrect bytecode", e);
        }
    }
}

