/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class AttributedString
extends AttributedCharSequence {
    final char[] buffer;
    final int[] style;
    final int start;
    final int end;
    public static final AttributedString EMPTY = new AttributedString("");
    public static final AttributedString NEWLINE = new AttributedString("\n");

    public AttributedString(CharSequence str) {
        this(str, 0, str.length(), null);
    }

    public AttributedString(CharSequence str, int start, int end) {
        this(str, start, end, null);
    }

    public AttributedString(CharSequence str, AttributedStyle s) {
        this(str, 0, str.length(), s);
    }

    public AttributedString(CharSequence str, int start, int end, AttributedStyle s) {
        if (end < start) {
            throw new InvalidParameterException();
        }
        if (str instanceof AttributedString) {
            AttributedString as = (AttributedString)str;
            this.buffer = as.buffer;
            if (s != null) {
                this.style = (int[])as.style.clone();
                for (int i2 = 0; i2 < this.style.length; ++i2) {
                    this.style[i2] = this.style[i2] & ~s.getMask() | s.getStyle();
                }
            } else {
                this.style = as.style;
            }
            this.start = as.start + start;
            this.end = as.start + end;
        } else if (str instanceof AttributedStringBuilder) {
            AttributedStringBuilder asb = (AttributedStringBuilder)str;
            AttributedString as = asb.subSequence(start, end);
            this.buffer = as.buffer;
            this.style = as.style;
            if (s != null) {
                for (int i3 = 0; i3 < this.style.length; ++i3) {
                    this.style[i3] = this.style[i3] & ~s.getMask() | s.getStyle();
                }
            }
            this.start = as.start;
            this.end = as.end;
        } else {
            int l = end - start;
            this.buffer = new char[l];
            for (int i4 = 0; i4 < l; ++i4) {
                this.buffer[i4] = str.charAt(start + i4);
            }
            this.style = new int[l];
            if (s != null) {
                Arrays.fill(this.style, s.getStyle());
            }
            this.start = 0;
            this.end = l;
        }
    }

    AttributedString(char[] buffer, int[] style, int start, int end) {
        this.buffer = buffer;
        this.style = style;
        this.start = start;
        this.end = end;
    }

    public static AttributedString fromAnsi(String ansi) {
        return AttributedString.fromAnsi(ansi, 0);
    }

    public static AttributedString fromAnsi(String ansi, int tabs) {
        if (ansi == null) {
            return null;
        }
        AttributedStringBuilder sb = new AttributedStringBuilder(ansi.length());
        sb.tabs(tabs);
        sb.appendAnsi(ansi);
        return sb.toAttributedString();
    }

    public static String stripAnsi(String ansi) {
        if (ansi == null) {
            return null;
        }
        AttributedStringBuilder sb = new AttributedStringBuilder(ansi.length());
        sb.appendAnsi(ansi);
        return sb.toString();
    }

    @Override
    protected char[] buffer() {
        return this.buffer;
    }

    @Override
    protected int offset() {
        return this.start;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public AttributedStyle styleAt(int index2) {
        return new AttributedStyle(this.style[this.start + index2], this.style[this.start + index2]);
    }

    @Override
    int styleCodeAt(int index2) {
        return this.style[this.start + index2];
    }

    @Override
    public AttributedString subSequence(int start, int end) {
        return new AttributedString(this, start, end);
    }

    public AttributedString styleMatches(Pattern pattern, AttributedStyle style) {
        Matcher matcher = pattern.matcher(this);
        boolean result2 = matcher.find();
        if (result2) {
            int[] newstyle = (int[])this.style.clone();
            do {
                for (int i2 = matcher.start(); i2 < matcher.end(); ++i2) {
                    newstyle[this.start + i2] = newstyle[this.start + i2] & ~style.getMask() | style.getStyle();
                }
            } while (result2 = matcher.find());
            return new AttributedString(this.buffer, newstyle, this.start, this.end);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributedString that = (AttributedString)o;
        return this.end - this.start == that.end - that.start && this.arrEq(this.buffer, that.buffer, this.start, that.start, this.end - this.start) && this.arrEq(this.style, that.style, this.start, that.start, this.end - this.start);
    }

    private boolean arrEq(char[] a1, char[] a2, int s1, int s2, int l) {
        for (int i2 = 0; i2 < l; ++i2) {
            if (a1[s1 + i2] == a2[s2 + i2]) continue;
            return false;
        }
        return true;
    }

    private boolean arrEq(int[] a1, int[] a2, int s1, int s2, int l) {
        for (int i2 = 0; i2 < l; ++i2) {
            if (a1[s1 + i2] == a2[s2 + i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.buffer);
        result2 = 31 * result2 + Arrays.hashCode(this.style);
        result2 = 31 * result2 + this.start;
        result2 = 31 * result2 + this.end;
        return result2;
    }

    public static AttributedString join(AttributedString delimiter, AttributedString ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        return AttributedString.join(delimiter, Arrays.asList(elements));
    }

    public static AttributedString join(AttributedString delimiter, Iterable<AttributedString> elements) {
        Objects.requireNonNull(elements);
        AttributedStringBuilder sb = new AttributedStringBuilder();
        int i2 = 0;
        for (AttributedString str : elements) {
            if (i2++ > 0 && delimiter != null) {
                sb.append(delimiter);
            }
            sb.append(str);
        }
        return sb.toAttributedString();
    }
}

