/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J\u0016\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "checkRedeclarations", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkRedeclarationsInPackages", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "topLevelFqNames", "Lcom/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getTopLevelDescriptorsByFqName", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "fqName", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "reportRedeclarationsWithClassifiers", "descriptorMap", "Lorg/jetbrains/kotlin/name/Name;", "resolveAnnotationsOnFiles", "scopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "frontend"})
@SourceDebugExtension(value={"SMAP\nDeclarationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationResolver.kt\norg/jetbrains/kotlin/resolve/DeclarationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 diagnosticUtils.kt\norg/jetbrains/kotlin/diagnostics/DiagnosticUtilsKt\n*L\n1#1,112:1\n1747#2,3:113\n3190#2,10:120\n163#3,4:116\n*S KotlinDebug\n*F\n+ 1 DeclarationResolver.kt\norg/jetbrains/kotlin/resolve/DeclarationResolver\n*L\n69#1:113,3\n87#1:120,10\n71#1:116,4\n*E\n"})
public final class DeclarationResolver {
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final BindingTrace trace;

    public DeclarationResolver(@NotNull AnnotationResolver annotationResolver, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.annotationResolver = annotationResolver;
        this.trace = trace;
    }

    public final void resolveAnnotationsOnFiles(@NotNull TopDownAnalysisContext c, @NotNull FileScopeProvider scopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)scopeProvider2, (String)"scopeProvider");
        Collection<KtFile> collection = c.getFiles();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"c.files");
        Map filesToScope2 = CollectionsKt.keysToMap((Iterable)collection, (Function1)new Function1<KtFile, LexicalScope>(scopeProvider2){
            final /* synthetic */ FileScopeProvider $scopeProvider;
            {
                this.$scopeProvider = $scopeProvider;
                super(1);
            }

            @NotNull
            public final LexicalScope invoke(KtFile it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return this.$scopeProvider.getFileResolutionScope(it);
            }
        });
        for (Map.Entry entry : filesToScope2.entrySet()) {
            KtFile file2 = (KtFile)entry.getKey();
            LexicalScope fileScope = (LexicalScope)entry.getValue();
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file2.getAnnotationEntries(), this.trace);
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file2.getDanglingAnnotations(), this.trace);
        }
    }

    public final void checkRedeclarations(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        for (ClassDescriptorWithResolutionScopes classDescriptor2 : c.getDeclaredClasses().values()) {
            HashMultimap descriptorMap = HashMultimap.create();
            MemberScope memberScope2 = classDescriptor2.getUnsubstitutedMemberScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"classDescriptor.unsubstitutedMemberScope");
            for (DeclarationDescriptor desc : ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null)) {
                if (!(desc instanceof ClassifierDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put((Object)desc.getName(), (Object)desc);
            }
            Intrinsics.checkNotNullExpressionValue((Object)descriptorMap, (String)"descriptorMap");
            this.reportRedeclarationsWithClassifiers((Multimap<Name, DeclarationDescriptor>)((Multimap)descriptorMap));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRedeclarationsWithClassifiers(Multimap<Name, DeclarationDescriptor> descriptorMap) {
        for (Name name2 : descriptorMap.keySet()) {
            boolean bl;
            Collection descriptors;
            block5: {
                descriptors = descriptorMap.get((Object)name2);
                if (descriptors.size() <= 1) continue;
                Intrinsics.checkNotNullExpressionValue((Object)descriptors, (String)"descriptors");
                Iterable $this$any$iv = descriptors;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof ClassifierDescriptor)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            for (DeclarationDescriptor descriptor2 : descriptors) {
                void it;
                void trace$iv;
                PsiElement psiElement$iv;
                BindingTrace bindingTrace = this.trace;
                Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"descriptor");
                DeclarationDescriptor descriptor$iv = descriptor2;
                boolean $i$f$reportOnDeclaration = false;
                if (DescriptorToSourceUtils.descriptorToDeclaration(descriptor$iv) == null) continue;
                boolean bl3 = false;
                PsiElement psiElement = psiElement$iv;
                void var14_17 = trace$iv;
                boolean bl4 = false;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on((PsiElement)it, descriptors);
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"REDECLARATION.on(it, descriptors)");
                var14_17.report(parametrizedDiagnostic);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkRedeclarationsInPackages(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull Multimap<FqName, KtElement> topLevelFqNames) {
        Intrinsics.checkNotNullParameter((Object)topLevelDescriptorProvider, (String)"topLevelDescriptorProvider");
        Intrinsics.checkNotNullParameter(topLevelFqNames, (String)"topLevelFqNames");
        Map map = topLevelFqNames.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"topLevelFqNames.asMap()");
        for (Map.Entry entry : map.entrySet()) {
            void $this$partition$iv;
            FqName fqName2 = (FqName)entry.getKey();
            Collection declarationsOrPackageDirectives = (Collection)entry.getValue();
            if (fqName2.isRoot()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"fqName");
            Iterable iterable = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Object[] second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                if (it instanceof MemberDescriptor && ((MemberDescriptor)it).isExpect()) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List expected = (List)pair.component1();
            List actual = (List)pair.component2();
            second$iv = new List[]{expected, actual};
            for (List descriptors : kotlin.collections.CollectionsKt.listOf((Object[])second$iv)) {
                if (descriptors.size() <= 1) continue;
                for (KtElement directive : declarationsOrPackageDirectives) {
                    KtPackageDirective ktPackageDirective = directive instanceof KtPackageDirective ? (KtPackageDirective)directive : null;
                    if (ktPackageDirective == null || (ktPackageDirective = ktPackageDirective.getNameIdentifier()) == null) {
                        ktPackageDirective = (PsiElement)directive;
                    }
                    KtPackageDirective reportAt = ktPackageDirective;
                    this.trace.report(Errors.PACKAGE_OR_CLASSIFIER_REDECLARATION.on(reportAt, fqName2.shortName().asString()));
                }
            }
        }
    }

    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(TopLevelDescriptorProvider topLevelDescriptorProvider, FqName fqName2, LookupLocation location) {
        HashSet<ClassifierDescriptor> descriptors = new HashSet<ClassifierDescriptor>();
        CollectionsKt.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassifierDescriptors(fqName2, location));
        return descriptors;
    }
}

