/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.error.ErrorClassDescriptor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H$J$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H$J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ,\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010!\u001a\u00020\u000fJ:\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010#\u001a\u0004\u0018\u00010\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u001bH\u0002J\"\u0010%\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\fJ\f\u0010&\u001a\u00020\u001b*\u00020\u001bH\u0002J\f\u0010'\u001a\u00020(*\u00020\u001bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "allowErrorTypeInAnnotations", "", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/ir/util/TypeTranslator;Z)V", "adjustAnnotationArgumentValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "value", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "extractAnnotationOffsets", "Lkotlin/Pair;", "", "annotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "extractAnnotationParameterOffsets", "argumentName", "Lorg/jetbrains/kotlin/name/Name;", "generateAnnotationConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "realType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateAnnotationValueAsExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "endOffset", "constantValue", "valueParameter", "generateConstantOrAnnotationValueAsExpression", "expectedType", "expectedArrayElementType", "generateConstantValueAsExpression", "getArrayElementType", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nConstantValueGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantValueGenerator.kt\norg/jetbrains/kotlin/ir/util/ConstantValueGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1603#2,9:223\n1855#2:232\n1856#2:235\n1612#2:236\n1#3:233\n1#3:234\n*S KotlinDebug\n*F\n+ 1 ConstantValueGenerator.kt\norg/jetbrains/kotlin/ir/util/ConstantValueGenerator\n*L\n98#1:223,9\n98#1:232\n98#1:235\n98#1:236\n98#1:234\n*E\n"})
public abstract class ConstantValueGenerator {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final TypeTranslator typeTranslator;
    private final boolean allowErrorTypeInAnnotations;

    public ConstantValueGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull ReferenceSymbolTable symbolTable, @NotNull TypeTranslator typeTranslator2, boolean allowErrorTypeInAnnotations) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)typeTranslator2, (String)"typeTranslator");
        this.moduleDescriptor = moduleDescriptor;
        this.symbolTable = symbolTable;
        this.typeTranslator = typeTranslator2;
        this.allowErrorTypeInAnnotations = allowErrorTypeInAnnotations;
    }

    @NotNull
    protected abstract Pair<Integer, Integer> extractAnnotationOffsets(@NotNull AnnotationDescriptor var1);

    @NotNull
    protected abstract Pair<Integer, Integer> extractAnnotationParameterOffsets(@NotNull AnnotationDescriptor var1, @NotNull Name var2);

    private final IrType toIrType(KotlinType $this$toIrType) {
        return this.typeTranslator.translateType($this$toIrType);
    }

    @NotNull
    public final IrExpression generateConstantValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"constantValue");
        IrExpression irExpression = this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, constantValue, null, null);
        Intrinsics.checkNotNull((Object)irExpression);
        return irExpression;
    }

    @Nullable
    public final IrExpression generateAnnotationValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue, @NotNull ValueParameterDescriptor valueParameter2) {
        Intrinsics.checkNotNullParameter(constantValue, (String)"constantValue");
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, constantValue, valueParameter2.getType(), valueParameter2.getVarargElementType());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateConstantOrAnnotationValueAsExpression(int startOffset, int endOffset, ConstantValue<?> constantValue, KotlinType expectedType, KotlinType expectedArrayElementType) {
        IrExpression irExpression;
        KotlinType constantValueType = constantValue.getType(this.moduleDescriptor);
        KotlinType kotlinType = expectedType;
        if (kotlinType == null) {
            kotlinType = constantValueType;
        }
        KotlinType constantKtType = kotlinType;
        IrType constantType = this.toIrType(constantKtType);
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof StringValue) {
            irExpression = IrConstImpl.Companion.string(startOffset, endOffset, constantType, (String)((StringValue)constantValue).getValue());
        } else if (constantValue2 instanceof IntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((IntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof UIntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((UIntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof NullValue) {
            irExpression = IrConstImpl.Companion.constNull(startOffset, endOffset, constantType);
        } else if (constantValue2 instanceof BooleanValue) {
            irExpression = IrConstImpl.Companion.boolean(startOffset, endOffset, constantType, (Boolean)((BooleanValue)constantValue).getValue());
        } else if (constantValue2 instanceof LongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((LongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof ULongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((ULongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof DoubleValue) {
            irExpression = IrConstImpl.Companion.double(startOffset, endOffset, constantType, ((Number)((DoubleValue)constantValue).getValue()).doubleValue());
        } else if (constantValue2 instanceof FloatValue) {
            irExpression = IrConstImpl.Companion.float(startOffset, endOffset, constantType, ((Number)((FloatValue)constantValue).getValue()).floatValue());
        } else if (constantValue2 instanceof CharValue) {
            irExpression = IrConstImpl.Companion.char(startOffset, endOffset, constantType, ((Character)((CharValue)constantValue).getValue()).charValue());
        } else if (constantValue2 instanceof ByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((ByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof UByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((UByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof ShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((ShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof UShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((UShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof ArrayValue) {
            List list2;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            KotlinType kotlinType2 = expectedArrayElementType;
            if (kotlinType2 == null) {
                kotlinType2 = this.getArrayElementType(constantValueType);
            }
            KotlinType arrayElementType = kotlinType2;
            Iterable iterable = (Iterable)((ArrayValue)constantValue).getValue();
            IrType irType = this.toIrType(arrayElementType);
            IrType irType2 = constantType;
            int n = endOffset;
            int n2 = startOffset;
            boolean $i$f$mapNotNull = false;
            void var13_21 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrExpression it$iv$iv;
                KotlinType newExpectedType;
                KotlinType kotlinType3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ConstantValue it = (ConstantValue)element$iv$iv;
                boolean bl2 = false;
                KotlinType it2 = kotlinType3 = arrayElementType;
                boolean bl3 = false;
                KotlinType kotlinType4 = newExpectedType = expectedType != null ? kotlinType3 : null;
                if (this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, it, newExpectedType, null) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = list2 = (List)destination$iv$iv;
            IrType irType3 = irType;
            IrType irType4 = irType2;
            int n3 = n;
            int n4 = n2;
            irExpression = new IrVarargImpl(n4, n3, irType4, irType3, list3);
        } else if (constantValue2 instanceof EnumValue) {
            ClassifierDescriptor classifierDescriptor = constantValueType.getMemberScope().getContributedClassifier(((EnumValue)constantValue).getEnumEntryName(), NoLookupLocation.FROM_BACKEND);
            if (classifierDescriptor == null) {
                throw new AssertionError((Object)("No such enum entry " + ((EnumValue)constantValue).getEnumEntryName() + " in " + constantType));
            }
            ClassifierDescriptor enumEntryDescriptor = classifierDescriptor;
            if (!(enumEntryDescriptor instanceof ClassDescriptor)) {
                throw new AssertionError((Object)("Enum entry " + enumEntryDescriptor + " should be a ClassDescriptor"));
            }
            if (!DescriptorUtils.isEnumEntry(enumEntryDescriptor)) {
                return null;
            }
            irExpression = new IrGetEnumValueImpl(startOffset, endOffset, constantType, this.symbolTable.referenceEnumEntry((ClassDescriptor)enumEntryDescriptor));
        } else if (constantValue2 instanceof AnnotationValue) {
            irExpression = this.generateAnnotationConstructorCall((AnnotationDescriptor)((AnnotationValue)constantValue).getValue(), constantKtType);
        } else if (constantValue2 instanceof KClassValue) {
            IrClassReferenceImpl irClassReferenceImpl;
            KotlinType classifierKtType = ((KClassValue)constantValue).getArgumentType(this.moduleDescriptor);
            if (KotlinTypeKt.isError(classifierKtType)) {
                irClassReferenceImpl = null;
            } else {
                ClassifierDescriptor classifierDescriptor = classifierKtType.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor == null) {
                    throw new AssertionError((Object)("Unexpected KClassValue: " + classifierKtType));
                }
                ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                irClassReferenceImpl = new IrClassReferenceImpl(startOffset, endOffset, this.toIrType(constantValue.getType(this.moduleDescriptor)), IrUtilsKt.referenceClassifier(this.symbolTable, classifierDescriptor2), this.toIrType(classifierKtType));
            }
            irExpression = irClassReferenceImpl;
        } else if (constantValue2 instanceof ErrorValue) {
            irExpression = null;
        } else {
            String string2 = "Unexpected constant value: " + constantValue.getClass().getSimpleName() + ' ' + constantValue;
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return irExpression;
    }

    @Nullable
    public final IrConstructorCall generateAnnotationConstructorCall(@NotNull AnnotationDescriptor annotationDescriptor, @Nullable KotlinType realType) {
        boolean bl;
        boolean bl2;
        KotlinType annotationType;
        ClassifierDescriptor annotationClassDescriptor;
        Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"annotationDescriptor");
        KotlinType kotlinType = realType;
        if (kotlinType == null) {
            kotlinType = annotationDescriptor.getType();
        }
        if (!((annotationClassDescriptor = (annotationType = kotlinType).getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor)) {
            return null;
        }
        if (annotationClassDescriptor instanceof NotFoundClasses.MockClassDescriptor) {
            return null;
        }
        boolean bl3 = bl2 = DescriptorUtils.isAnnotationClass(annotationClassDescriptor) || this.allowErrorTypeInAnnotations && annotationClassDescriptor instanceof ErrorClassDescriptor;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22 = false;
            String $i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22 = "Annotation class expected: " + annotationClassDescriptor;
            throw new AssertionError((Object)$i$a$-assert-ConstantValueGenerator$generateAnnotationConstructorCall$22);
        }
        ClassConstructorDescriptor classConstructorDescriptor = ((ClassDescriptor)annotationClassDescriptor).getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            Collection<ClassConstructorDescriptor> collection = ((ClassDescriptor)annotationClassDescriptor).getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"annotationClassDescriptor.constructors");
            classConstructorDescriptor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (classConstructorDescriptor == null) {
                throw new AssertionError((Object)("No constructor for annotation class " + annotationClassDescriptor));
            }
        }
        ClassConstructorDescriptor primaryConstructorDescriptor = classConstructorDescriptor;
        IrConstructorSymbol primaryConstructorSymbol = this.symbolTable.referenceConstructor(primaryConstructorDescriptor);
        Pair<Integer, Integer> pair = this.extractAnnotationOffsets(annotationDescriptor);
        int startOffset = ((Number)pair.component1()).intValue();
        int endOffset = ((Number)pair.component2()).intValue();
        IrType irType = this.toIrType(annotationType);
        int n = primaryConstructorDescriptor.getValueParameters().size();
        int n2 = ((ClassDescriptor)annotationClassDescriptor).getDeclaredTypeParameters().size();
        SourceElement sourceElement = annotationDescriptor.getSource();
        IrConstructorCallImpl irCall = new IrConstructorCallImpl(startOffset, endOffset, irType, primaryConstructorSymbol, n2, 0, n, null, sourceElement, 128, null);
        TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.create(annotationType).buildSubstitutor();
        ClassConstructorDescriptor classConstructorDescriptor2 = primaryConstructorDescriptor.substitute(substitutor2);
        if (classConstructorDescriptor2 == null) {
            throw new IllegalStateException("Cannot substitute constructor".toString());
        }
        ClassConstructorDescriptor substitutedConstructor = classConstructorDescriptor2;
        List<TypeProjection> typeArguments = annotationType.getArguments();
        boolean bl4 = bl = typeArguments.size() == ((ClassDescriptor)annotationClassDescriptor).getDeclaredTypeParameters().size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int n3 = typeArguments.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TypeProjection typeArgument = typeArguments.get(i2);
            KotlinType kotlinType2 = typeArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"typeArgument.type");
            irCall.putTypeArgument(i2, this.toIrType(kotlinType2));
        }
        for (ValueParameterDescriptor valueParameter2 : substitutedConstructor.getValueParameters()) {
            ConstantValue<?> argumentValue;
            int argumentIndex = valueParameter2.getIndex();
            if (annotationDescriptor.getAllValueArguments().get(valueParameter2.getName()) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)valueParameter2, (String)"valueParameter");
            ConstantValue<?> adjustedValue = this.adjustAnnotationArgumentValue(argumentValue, valueParameter2);
            Name name2 = valueParameter2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"valueParameter.name");
            Pair<Integer, Integer> pair2 = this.extractAnnotationParameterOffsets(annotationDescriptor, name2);
            int parameterStartOffset = ((Number)pair2.component1()).intValue();
            int parameterEndOffset = ((Number)pair2.component2()).intValue();
            IrExpression irArgument = this.generateAnnotationValueAsExpression(parameterStartOffset, parameterEndOffset, adjustedValue, valueParameter2);
            irCall.putValueArgument(argumentIndex, irArgument);
        }
        return irCall;
    }

    public static /* synthetic */ IrConstructorCall generateAnnotationConstructorCall$default(ConstantValueGenerator constantValueGenerator, AnnotationDescriptor annotationDescriptor, KotlinType kotlinType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateAnnotationConstructorCall");
        }
        if ((n & 2) != 0) {
            kotlinType = null;
        }
        return constantValueGenerator.generateAnnotationConstructorCall(annotationDescriptor, kotlinType);
    }

    private final ConstantValue<?> adjustAnnotationArgumentValue(ConstantValue<?> value2, ValueParameterDescriptor parameter2) {
        if (KotlinBuiltIns.isArrayOrPrimitiveArray(parameter2.getType()) && !(value2 instanceof ArrayValue)) {
            return new ArrayValue(CollectionsKt.listOf(value2), (Function1<? super ModuleDescriptor, ? extends KotlinType>)((Function1)new Function1<ModuleDescriptor, KotlinType>(parameter2){
                final /* synthetic */ ValueParameterDescriptor $parameter;
                {
                    this.$parameter = $parameter;
                    super(1);
                }

                @NotNull
                public final KotlinType invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KotlinType kotlinType = this.$parameter.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.type");
                    return kotlinType;
                }
            }));
        }
        return value2;
    }

    private final KotlinType getArrayElementType(KotlinType $this$getArrayElementType) {
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns($this$getArrayElementType).getArrayElementType($this$getArrayElementType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"builtIns.getArrayElementType(this)");
        return kotlinType;
    }
}

