/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkGlobalDeclaration", "checkLocalDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSealedSupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedSupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,85:1\n73#2:86\n49#2:87\n*S KotlinDebug\n*F\n+ 1 FirSealedSupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker\n*L\n45#1:86\n71#1:87\n*E\n"})
public final class FirSealedSupertypeChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSealedSupertypeChecker INSTANCE = new FirSealedSupertypeChecker();

    private FirSealedSupertypeChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (FirDeclarationUtilKt.getClassId(declaration).isLocal()) {
            this.checkLocalDeclaration(declaration, context, reporter2);
        } else {
            this.checkGlobalDeclaration(declaration, context, reporter2);
        }
    }

    private final void checkGlobalDeclaration(FirClass declaration, CheckerContext context, DiagnosticReporter reporter2) {
        FqName fqName2 = FirDeclarationUtilKt.getClassId(declaration).getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"declaration.classId.packageFqName");
        FqName subclassPackage = fqName2;
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            FqName superClassPackage;
            FirRegularClassSymbol superClass;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ClassId superClassId;
            if (ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(superTypeRef)) == null || superClassId.isLocal() || ((firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context.getSession()).getClassLikeSymbolByClassId(superClassId)) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null) == null) continue;
            superClass = superClass;
            FirClassSymbol $this$isSealed$iv = superClass;
            boolean $i$f$isSealed = false;
            if (!($this$isSealed$iv.getResolvedStatus().getModality() == Modality.SEALED)) continue;
            if (superClass.getOrigin() instanceof FirDeclarationOrigin.Java) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_INHERITS_JAVA_SEALED_CLASS(), (DiagnosticContext)context, null, 8, null);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)superClass.getClassId().getPackageFqName(), (String)"superClass.classId.packageFqName");
            if (!Intrinsics.areEqual((Object)superClassPackage, (Object)subclassPackage)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_PACKAGE(), (DiagnosticContext)context, null, 8, null);
            }
            if (Intrinsics.areEqual((Object)superClass.getModuleData(), (Object)declaration.getModuleData())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_MODULE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkLocalDeclaration(FirClass declaration, CheckerContext context, DiagnosticReporter reporter2) {
        for (FirTypeRef it : declaration.getSuperTypeRefs()) {
            FirRegularClassSymbol superClassSymbol;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ClassId classId;
            if (ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it)) == null || classId.isLocal() || ((firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context.getSession()).getClassLikeSymbolByClassId(classId)) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null) == null) continue;
            superClassSymbol = superClassSymbol;
            FirClassSymbol $this$modality$iv = superClassSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.SEALED) continue;
            String declarationType = declaration instanceof FirAnonymousObject ? "Anonymous object" : "Local class";
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)it.getSource(), FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS(), (Object)declarationType, (Object)superClassSymbol.getClassKind(), (DiagnosticContext)context, null, 32, null);
            return;
        }
    }
}

