/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.backend.common.lower.ClosureAnnotator;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmInnerClassesSupport;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesSymbolRemapper;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrAnonymousInitializerImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrClassImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SimpleTypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010&\u001a\u00020\u001d*\u00020\u001bH\u0002J \u0010'\u001a\u00020\u001d*\u00020\u001b2\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getInnerClassesSupport", "()Lorg/jetbrains/kotlin/backend/jvm/JvmInnerClassesSupport;", "scriptingJvmPackage", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "getScriptingJvmPackage", "()Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "scriptingJvmPackage$delegate", "Lkotlin/Lazy;", "collectCapturingClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrClassImpl;", "irScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "typeRemapper", "Lorg/jetbrains/kotlin/ir/util/SimpleTypeRemapper;", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irScriptClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "finalizeScriptClass", "", "symbolRemapper", "Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesSymbolRemapper;", "lower", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "prepareScriptClass", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addScriptMainFun", "addSimplePropertyFrom", "from", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nScriptLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 6 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptLoweringKt\n+ 7 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptLoweringKt$addAnonymousInitializer$1\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,937:1\n38#2,4:938\n38#2,4:993\n274#2,9:997\n191#2:1018\n185#2:1019\n179#2,10:1020\n274#2,9:1030\n98#2:1039\n92#2,10:1040\n55#2,4:1050\n1855#3,2:942\n1864#3,3:955\n1855#3,2:958\n1855#3:961\n1856#3:987\n1549#3:988\n1620#3,2:989\n1622#3:992\n405#4,10:944\n405#4,10:975\n72#5:954\n73#5:960\n72#5,2:985\n921#6,3:962\n924#6,9:966\n921#7:965\n1#8:991\n346#9,12:1006\n*S KotlinDebug\n*F\n+ 1 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering\n*L\n89#1:938,4\n357#1:993,4\n366#1:997,9\n382#1:1018\n382#1:1019\n382#1:1020,10\n388#1:1030,9\n415#1:1039\n415#1:1040,10\n419#1:1050,4\n186#1:942,2\n239#1:955,3\n254#1:958,2\n272#1:961\n272#1:987\n334#1:988\n334#1:989,2\n334#1:992\n232#1:944,10\n291#1:975,10\n232#1:954\n232#1:960\n291#1:985,2\n289#1:962,3\n289#1:966,9\n289#1:965\n376#1:1006,12\n*E\n"})
final class ScriptsToClassesLowering {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final JvmInnerClassesSupport innerClassesSupport;
    @NotNull
    private final Lazy scriptingJvmPackage$delegate;

    public ScriptsToClassesLowering(@NotNull JvmBackendContext context, @NotNull JvmInnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)innerClassesSupport, (String)"innerClassesSupport");
        this.context = context;
        this.innerClassesSupport = innerClassesSupport;
        this.scriptingJvmPackage$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<IrExternalPackageFragment>(this){
            final /* synthetic */ ScriptsToClassesLowering this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrExternalPackageFragment invoke() {
                return IrExternalPackageFragmentImpl.Companion.createEmptyExternalPackageFragment(this.this$0.getContext().getState().getModule(), new FqName("kotlin.script.experimental.jvm"));
            }
        }));
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final JvmInnerClassesSupport getInnerClassesSupport() {
        return this.innerClassesSupport;
    }

    public final void lower(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Map scriptsToClasses = new LinkedHashMap();
        for (IrFile irFile : module2.getFiles()) {
            ListIterator<IrDeclaration> iterator2 = irFile.getDeclarations().listIterator();
            while (iterator2.hasNext()) {
                IrDeclaration declaration = iterator2.next();
                if (!(declaration instanceof IrScript)) continue;
                IrClass scriptClass = this.prepareScriptClass(irFile, (IrScript)declaration);
                scriptsToClasses.put(declaration, scriptClass);
                iterator2.set(scriptClass);
            }
        }
        ScriptsToClassesSymbolRemapper symbolRemapper = new ScriptsToClassesSymbolRemapper(scriptsToClasses);
        for (Map.Entry entry : scriptsToClasses.entrySet()) {
            IrScript irScript = (IrScript)entry.getKey();
            IrClass irScriptClass = (IrClass)entry.getValue();
            this.finalizeScriptClass(irScriptClass, irScript, symbolRemapper);
            PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irScriptClass, irScript.getParent());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass prepareScriptClass(IrFile irFile, IrScript irScript) {
        IrClass irClass2;
        Name name2;
        void it;
        IrFileEntry fileEntry = irFile.getFileEntry();
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$prepareScriptClass_u24lambda_u241 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$prepareScriptClass_u24lambda_u241.setStartOffset(0);
        $this$prepareScriptClass_u24lambda_u241.setEndOffset(fileEntry.getMaxOffset());
        $this$prepareScriptClass_u24lambda_u241.setOrigin(IrDeclarationOrigin.SCRIPT_CLASS.INSTANCE);
        Name name3 = irScript.getName();
        IrClassBuilder irClassBuilder = $this$prepareScriptClass_u24lambda_u241;
        boolean bl3 = false;
        if (it.isSpecial()) {
            String string2 = irScript.getName().asStringStripSpecialMarkers();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"irScript.name.asStringStripSpecialMarkers()");
            name2 = NameUtils.getScriptNameForFile(StringsKt.removePrefix((String)string2, (CharSequence)"script-"));
        } else {
            name2 = it;
        }
        irClassBuilder.setName(name2);
        $this$prepareScriptClass_u24lambda_u241.setKind(ClassKind.CLASS);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
        $this$prepareScriptClass_u24lambda_u241.setVisibility(descriptorVisibility);
        $this$prepareScriptClass_u24lambda_u241.setModality(Modality.FINAL);
        IrClass irScriptClass = irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl4 = false;
        Collection collection = irScriptClass.getSuperTypes();
        IrType irType = irScript.getBaseClass();
        if (irType == null) {
            irType = this.context.getIrBuiltIns().getAnyNType();
        }
        irScriptClass.setSuperTypes(CollectionsKt.plus((Collection)collection, (Object)irType));
        irScriptClass.setParent(irFile);
        irScriptClass.setMetadata(irScript.getMetadata());
        irScript.setTargetClass(irScriptClass.getSymbol());
        return irClass2;
    }

    private final Set<IrClassImpl> collectCapturingClasses(IrScript irScript, SimpleTypeRemapper typeRemapper) {
        ClosureAnnotator annotator = new ClosureAnnotator((IrElement)irScript, (IrDeclaration)irScript);
        Set capturingClasses = new LinkedHashSet();
        IrElementVisitorVoid collector2 = new IrElementVisitorVoid(annotator, irScript, this, capturingClasses, typeRemapper){
            final /* synthetic */ ClosureAnnotator $annotator;
            final /* synthetic */ IrScript $irScript;
            final /* synthetic */ ScriptsToClassesLowering this$0;
            final /* synthetic */ Set<IrClassImpl> $capturingClasses;
            final /* synthetic */ SimpleTypeRemapper $typeRemapper;
            {
                this.$annotator = $annotator;
                this.$irScript = $irScript;
                this.this$0 = $receiver;
                this.$capturingClasses = $capturingClasses;
                this.$typeRemapper = $typeRemapper;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            /*
             * WARNING - void declaration
             */
            public void visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (declaration instanceof IrClassImpl && !((IrClassImpl)declaration).isInner()) {
                    boolean bl;
                    Object object;
                    block23: {
                        void $this$forEach$iv;
                        Object it;
                        Object $this$forEach$iv2;
                        Closure closure = this.$annotator.getClassClosure(declaration);
                        object = new LinkedHashSet<E>();
                        IrScript irScript = this.$irScript;
                        Set it2 = object;
                        boolean bl22 = false;
                        IrValueParameter irValueParameter = irScript.getThisReceiver();
                        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(it2, irValueParameter != null ? irValueParameter.getType() : null);
                        Set scriptsReceivers = object;
                        List<IrScriptSymbol> list2 = this.$irScript.getEarlierScripts();
                        if (list2 != null) {
                            $this$forEach$iv2 = list2;
                            boolean $i$f$forEach = false;
                            Iterator<T> bl22 = $this$forEach$iv2.iterator();
                            while (bl22.hasNext()) {
                                T element$iv = bl22.next();
                                it = (IrScriptSymbol)element$iv;
                                boolean bl3 = false;
                                IrValueParameter irValueParameter2 = ((IrScript)it.getOwner()).getThisReceiver();
                                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(scriptsReceivers, irValueParameter2 != null ? irValueParameter2.getType() : null);
                            }
                        }
                        object = this.$irScript.getImplicitReceiversParameters();
                        $this$forEach$iv2 = this.$typeRemapper;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (IrValueParameter)element$iv;
                            boolean bl4 = false;
                            scriptsReceivers.add(it.getType());
                            scriptsReceivers.add(((SimpleTypeRemapper)$this$forEach$iv2).remapType(it.getType()));
                        }
                        Iterable $this$any$iv = closure.getCapturedValues();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                IrValueSymbol it3 = (IrValueSymbol)element$iv;
                                boolean bl5 = false;
                                if (!scriptsReceivers.contains(it3.getOwner().getType())) continue;
                                bl = true;
                                break block23;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        if (IrUtilsKt.isInterface(declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_INTERFACE(), null, 8, null);
                        } else if (IrUtilsKt.isEnumClass(declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM(), null, 8, null);
                        } else if (IrUtilsKt.isEnumEntry(declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM_ENTRY(), null, 8, null);
                        } else if (declaration.isCompanion()) {
                            collectCapturingClasses.collector.1.visitClass$reportError(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
                        } else if (declaration.getKind().isSingleton()) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), null, 8, null);
                        } else if (IrUtilsKt.isClass(declaration)) {
                            if (!Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$irScript)) {
                                IrDeclarationParent irDeclarationParent = declaration.getParent();
                                IrClass irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                                boolean bl6 = irClass2 != null ? !irClass2.isInner() : false;
                                if (bl6) {
                                    KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this.this$0.getContext().getKtDiagnosticReporter().at((IrDeclaration)declaration);
                                    KtDiagnosticFactory2<String, String> ktDiagnosticFactory2 = JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_NESTED_CLASS();
                                    String string2 = declaration.getName().asString();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"declaration.name.asString()");
                                    IrDeclarationParent irDeclarationParent2 = declaration.getParent();
                                    Object object2 = irDeclarationParent2 instanceof IrDeclarationWithName ? (IrDeclarationWithName)((Object)irDeclarationParent2) : null;
                                    if (object2 == null || (object2 = object2.getName()) == null) {
                                        object2 = SpecialNames.NO_NAME_PROVIDED;
                                    }
                                    object = ((Name)object2).asString();
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(declaration.parent as? \u2026NAME_PROVIDED).asString()");
                                    diagnosticContextImpl.report(ktDiagnosticFactory2, string2, object);
                                }
                            } else {
                                this.$capturingClasses.add((IrClassImpl)declaration);
                            }
                        }
                    }
                }
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConst(@NotNull IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
            }

            public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
            }

            public void visitField(@NotNull IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
            }

            public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
            }

            public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitScript(@NotNull IrScript declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }

            private static final void visitClass$reportError(ScriptsToClassesLowering this$0, IrClass $declaration, KtDiagnosticFactory1<String> factory2, Name name2) {
                KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this$0.getContext().getKtDiagnosticReporter().at((IrDeclaration)$declaration);
                Name name3 = name2;
                if (name3 == null) {
                    name3 = $declaration.getName();
                }
                String string2 = name3.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name ?: declaration.name).asString()");
                diagnosticContextImpl.report(factory2, string2);
            }

            static /* synthetic */ void visitClass$reportError$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass2, KtDiagnosticFactory1 ktDiagnosticFactory1, Name name2, int n, Object object) {
                if ((n & 8) != 0) {
                    name2 = null;
                }
                collectCapturingClasses.collector.1.visitClass$reportError(scriptsToClassesLowering, irClass2, ktDiagnosticFactory1, name2);
            }
        };
        for (IrStatement statement2 : irScript.getStatements()) {
            if (!(statement2 instanceof IrClassImpl)) continue;
            collector2.visitClass((IrClass)statement2);
        }
        return capturingClasses;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void finalizeScriptClass(IrClass irScriptClass, IrScript irScript, ScriptsToClassesSymbolRemapper symbolRemapper) {
        block17: {
            typeRemapper = new SimpleTypeRemapper(symbolRemapper);
            capturingClasses = this.collectCapturingClasses(irScript, typeRemapper);
            var7_6 = irScript.getEarlierScriptsParameter();
            if (var7_6 == null) ** GOTO lbl-1000
            earlierScriptsParameter = var7_6;
            $i$a$-let-ScriptsToClassesLowering$finalizeScriptClass$earlierScriptField$1 = false;
            v0 = irScriptClass.getFactory();
            v1 = IrDeclarationOrigin.SCRIPT_EARLIER_SCRIPTS.INSTANCE;
            v2 = new IrFieldSymbolImpl(null, 1, null);
            v3 = Name.identifier("$$earlierScripts");
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"identifier(\"\\$\\$earlierScripts\")");
            v4 = earlierScriptsParameter.getType();
            v5 = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"PRIVATE");
            var8_13 = v0.createField(-1, -1, v1, v2, v3, v4, v5, true, false, false);
            if (var8_13 != null) {
                it = var9_14 = var8_13;
                $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$earlierScriptField$2 = false;
                it.setParent(irScriptClass);
                irScriptClass.getDeclarations().add((IrDeclaration)it);
                v6 = var9_14;
            } else lbl-1000:
            // 2 sources

            {
                v6 = null;
            }
            earlierScriptField = v6;
            var8_13 = new ArrayList<Pair>();
            $this$finalizeScriptClass_u24lambda_u246 = var8_13;
            $i$a$-apply-ScriptsToClassesLowering$finalizeScriptClass$implicitReceiversFieldsWithParameters$1 = false;
            $this$forEach$iv = irScript.getImplicitReceiversParameters();
            $i$f$forEach = false;
            var13_18 = $this$forEach$iv.iterator();
            while (var13_18.hasNext()) {
                element$iv = var13_18.next();
                param = (IrValueParameter)element$iv;
                $i$a$-forEach-ScriptsToClassesLowering$finalizeScriptClass$implicitReceiversFieldsWithParameters$1$1 = false;
                v7 = irScriptClass.getFactory();
                v8 = IrDeclarationOrigin.SCRIPT_IMPLICIT_RECEIVER.INSTANCE;
                v9 = new IrFieldSymbolImpl(null, 1, null);
                v10 = new StringBuilder().append("$$implicitReceiver_");
                v11 = IrTypesKt.getClassFqName(param.getType());
                v12 = v11 != null && (v11 = v11.shortName()) != null ? v11.asString() : null;
                Intrinsics.checkNotNull((Object)v12);
                v13 = Name.identifier(v10.append(v12).toString());
                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"identifier(\"\\$\\$implicit\u2026rtName()?.asString()!!}\")");
                v14 = typeRemapper.remapType(param.getType());
                v15 = DescriptorVisibilities.PRIVATE;
                Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"PRIVATE");
                field = v7.createField(-1, -1, v8, v9, v13, v14, v15, true, false, false);
                field.setParent(irScriptClass);
                irScriptClass.getDeclarations().add(field);
                $this$finalizeScriptClass_u24lambda_u246.add(TuplesKt.to((Object)field, (Object)param));
            }
            implicitReceiversFieldsWithParameters = var8_13;
            scriptTransformer = new ScriptToClassTransformer(irScript, irScriptClass, typeRemapper, this.context, (Set<? extends IrClassImpl>)capturingClasses, this.innerClassesSupport, (IrField)earlierScriptField, (Collection<? extends Pair<? extends IrField, ? extends IrValueParameter>>)implicitReceiversFieldsWithParameters);
            lambdaPatcher = new ScriptFixLambdasTransformer(irScriptClass);
            irScriptClass.setThisReceiver(scriptTransformer.getScriptClassReceiver());
            v16 = irScriptClass.getThisReceiver();
            defaultContext = new ScriptToClassTransformerContext(v16 != null ? v16.getSymbol() : null, null, null, false, null, 16, null);
            v17 = irScript.getConstructor();
            $i$f$forEach = v17 != null ? ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)v17, scriptTransformer, defaultContext, lambdaPatcher) : null;
            v18 = $i$f$forEach instanceof IrConstructor != false ? (IrConstructor)$i$f$forEach : null;
            if (v18 == null) {
                v18 = this.createConstructor(irScriptClass, irScript);
            }
            constructor = $this$forEach$iv = v18;
            $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1 = false;
            explicitParamsStartIndex = irScript.getEarlierScriptsParameter() == null ? 0 : 1;
            explicitParameters = constructor.getValueParameters().subList(explicitParamsStartIndex, irScript.getExplicitCallParameters().size() + explicitParamsStartIndex);
            $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)constructor.getSymbol(), (int)0, (int)0, (int)6, null);
            startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            $i$f$irBlockBody = false;
            var20_33 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            $i$f$blockBody = false;
            var22_35 = this_$iv$iv;
            var23_36 = constructor;
            $i$a$-irBlockBody$default-ScriptsToClassesLowering$finalizeScriptClass$1$1 = false;
            v19 = irScript.getBaseClass();
            v20 = v19 != null && (v19 = IrTypesKt.getClassOrNull((IrType)v19)) != null && (v19 = (Sequence<IrConstructor>)v19.getOwner()) != null && (v19 = IrUtilsKt.getConstructors((IrClass)v19)) != null ? (IrConstructor)SequencesKt.firstOrNull(v19) : (baseClassCtor = null);
            if (baseClassCtor == null) {
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411, (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
            } else {
                var27_43 = var26_42 = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411, baseClassCtor);
                var28_46 = $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1 = false;
                $this$forEachIndexed$iv = explicitParameters;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    if ((var35_57 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var36_58 = (IrValueParameter)item$iv;
                    idx = var35_57;
                    $i$a$-forEachIndexed-ScriptsToClassesLowering$finalizeScriptClass$1$1$1$1 = false;
                    it.putValueArgument(idx, new IrGetValueImpl(valueParameter.getStartOffset(), valueParameter.getEndOffset(), valueParameter.getType(), valueParameter.getSymbol(), null, 16, null));
                }
                var28_46.unaryPlus(var26_42);
            }
            if (earlierScriptField != null) {
                v21 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                v22 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                v23 = irScriptClass.getThisReceiver();
                Intrinsics.checkNotNull((Object)v23);
                v24 = ExpressionHelpersKt.irGet(v22, v23);
                v25 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                v26 = irScript.getEarlierScriptsParameter();
                Intrinsics.checkNotNull((Object)v26);
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.unaryPlus(ExpressionHelpersKt.irSetField$default(v21, v24, (IrField)earlierScriptField, ExpressionHelpersKt.irGet(v25, v26), null, 8, null));
            }
            $this$forEach$iv = implicitReceiversFieldsWithParameters;
            $i$f$forEach = false;
            $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1 = $this$forEach$iv.iterator();
            while ($i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1.hasNext()) {
                element$iv = $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1.next();
                $i$f$forEachIndexed = (Pair)element$iv;
                $i$a$-forEach-ScriptsToClassesLowering$finalizeScriptClass$1$1$2 = false;
                field = (IrField)$i$f$forEachIndexed.component1();
                correspondingParameter = (IrValueParameter)$i$f$forEachIndexed.component2();
                v27 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                v28 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                v29 = irScriptClass.getThisReceiver();
                Intrinsics.checkNotNull((Object)v29);
                v30 = ExpressionHelpersKt.irGet(v28, v29);
                v31 = (IrBuilderWithScope)$this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                v32 = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)correspondingParameter, scriptTransformer, defaultContext, lambdaPatcher);
                Intrinsics.checkNotNull((Object)v32, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrValueParameter");
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.unaryPlus(ExpressionHelpersKt.irSetField$default(v27, v30, field, ExpressionHelpersKt.irGet(v31, (IrValueParameter)v32), null, 8, null));
            }
            $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.unaryPlus(new IrInstanceInitializerCallImpl(irScript.getStartOffset(), irScript.getEndOffset(), irScriptClass.getSymbol(), $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.getContext().getIrBuiltIns().getUnitType()));
            var23_36.setBody(this_$iv$iv.doBuild());
            irScriptClass.getDeclarations().add((IrDeclaration)constructor);
            constructor.setParent(irScriptClass);
            hasMain = false;
            $this$forEach$iv = irScript.getStatements();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                scriptStatement = (IrStatement)element$iv;
                $i$a$-forEach-ScriptsToClassesLowering$finalizeScriptClass$2 = false;
                var18_30 = scriptStatement;
                if (var18_30 instanceof IrVariable) {
                    v33 = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                    Intrinsics.checkNotNull((Object)v33, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                    copy /* !! */  = (IrVariable)v33;
                    ScriptsToClassesLowering.addSimplePropertyFrom$default(this, irScriptClass, copy /* !! */ , null, 2, null);
                    continue;
                }
                if (var18_30 instanceof IrDeclaration) {
                    v34 = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                    Intrinsics.checkNotNull((Object)v34, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                    copy /* !! */  = (IrDeclaration)v34;
                    irScriptClass.getDeclarations().add(copy /* !! */ );
                    if (!(copy /* !! */  instanceof IrSimpleFunction) || !Intrinsics.areEqual((Object)((IrSimpleFunction)copy /* !! */ ).getName().asString(), (Object)"main")) continue;
                    hasMain = true;
                    continue;
                }
                v35 = ScriptsToClassesLowering.finalizeScriptClass$patchForClass((IrElement)scriptStatement, scriptTransformer, defaultContext, lambdaPatcher);
                Intrinsics.checkNotNull((Object)v35, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
                transformedStatement = (IrStatement)v35;
                $this$addAnonymousInitializer_u24default$iv = irScriptClass;
                $i$f$addAnonymousInitializer = false;
                $this$addAnonymousInitializer_u24lambda_u240$iv = new IrFunctionBuilder();
                $i$a$-run-ScriptLoweringKt$addAnonymousInitializer$2$iv = false;
                $i$a$-irBlockBody$default-ScriptsToClassesLowering$finalizeScriptClass$1$1 = $this$addAnonymousInitializer_u24lambda_u240$iv;
                $i$a$-addAnonymousInitializer-ScriptLoweringKt$addAnonymousInitializer$1 = false;
                $this$null = $i$a$-irBlockBody$default-ScriptsToClassesLowering$finalizeScriptClass$1$1;
                $this$addAnonymousInitializer_u24lambda_u240$iv.setReturnType(IrUtilsKt.getDefaultType($this$addAnonymousInitializer_u24default$iv));
                anonymousInitializer$iv = $this$forEach$iv = new IrAnonymousInitializerImpl($this$addAnonymousInitializer_u24lambda_u240$iv.getStartOffset(), $this$addAnonymousInitializer_u24lambda_u240$iv.getEndOffset(), $this$addAnonymousInitializer_u24lambda_u240$iv.getOrigin(), new IrAnonymousInitializerSymbolImpl(null, 1, null), false, null, 48, null);
                $i$a$-also-ScriptLoweringKt$addAnonymousInitializer$3$iv = false;
                $this$addAnonymousInitializer_u24default$iv.getDeclarations().add((IrDeclaration)anonymousInitializer$iv);
                anonymousInitializer$iv.setParent($this$addAnonymousInitializer_u24default$iv);
                irInitializer = var20_33 = (IrAnonymousInitializer)$this$forEach$iv;
                $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$2$1 = false;
                $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)irInitializer.getSymbol(), (int)0, (int)0, (int)6, null);
                startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                $i$f$irBlockBody = false;
                $this$forEach$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                $i$f$blockBody = false;
                $i$a$-also-ScriptsToClassesLowering$finalizeScriptClass$1$1$1 = this_$iv$iv;
                var30_50 = irInitializer;
                $i$a$-irBlockBody$default-ScriptsToClassesLowering$finalizeScriptClass$2$1$1 = false;
                if (transformedStatement instanceof IrComposite) {
                    for (IrStatement statement : ((IrComposite)transformedStatement).getStatements()) {
                        $this$finalizeScriptClass_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.unaryPlus(statement);
                    }
                } else {
                    $this$finalizeScriptClass_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.unaryPlus(transformedStatement);
                }
                var30_50.setBody(this_$iv$iv.doBuild());
            }
            if (!hasMain) {
                this.addScriptMainFun(irScriptClass);
            }
            v36 = irScriptClass.getAnnotations();
            v37 = irScriptClass.getParent();
            Intrinsics.checkNotNull((Object)v37, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            irScriptClass.setAnnotations(CollectionsKt.plus((Collection)v36, (Iterable)((IrFile)v37).getAnnotations()));
            v38 = irScript.getResultProperty();
            if (v38 == null || (v38 = (IrProperty)v38.getOwner()) == null) break block17;
            irResultProperty = v38;
            $i$a$-let-ScriptsToClassesLowering$finalizeScriptClass$3 = false;
            this.context.getState().getScriptSpecific().setResultFieldName(irResultProperty.getName().getIdentifier());
            this.context.getState().getScriptSpecific().setResultType((v39 /* !! */  = irResultProperty.getBackingField()) != null && (v39 /* !! */  = v39 /* !! */ .getType()) != null ? IrBasedDescriptorsKt.toIrBasedKotlinType((IrType)v39 /* !! */ ) : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createConstructor(IrClass irScriptClass, IrScript irScript) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$createConstructor_u24lambda_u2422_u24lambda_u2421;
        List list2;
        Object object = new IrFunctionBuilder();
        IrFunctionBuilder $this$createConstructor_u24lambda_u2417 = object;
        boolean bl = false;
        $this$createConstructor_u24lambda_u2417.setPrimary(true);
        IrValueParameter irValueParameter = irScriptClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrType irType = irValueParameter.getType();
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        $this$createConstructor_u24lambda_u2417.setReturnType((IrSimpleType)irType);
        IrFunctionBuilder $this$createConstructor_u24lambda_u2418 = object;
        boolean bl2 = false;
        Object irConstructor2 = object = irScriptClass.getFactory().createConstructor($this$createConstructor_u24lambda_u2418.getStartOffset(), $this$createConstructor_u24lambda_u2418.getEndOffset(), $this$createConstructor_u24lambda_u2418.getOrigin(), new IrConstructorSymbolImpl(null, 1, null), SpecialNames.INIT, $this$createConstructor_u24lambda_u2418.getVisibility(), $this$createConstructor_u24lambda_u2418.getReturnType(), $this$createConstructor_u24lambda_u2418.isInline(), $this$createConstructor_u24lambda_u2418.isExternal(), $this$createConstructor_u24lambda_u2418.isPrimary(), $this$createConstructor_u24lambda_u2418.isExpect(), $this$createConstructor_u24lambda_u2418.getContainerSource());
        boolean bl3 = false;
        List list3 = list2 = CollectionsKt.createListBuilder();
        Object object2 = irConstructor2;
        boolean bl4 = false;
        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)$this$createConstructor_u24lambda_u2422_u24lambda_u2421, irScript.getEarlierScriptsParameter());
        Iterable iterable = irScript.getExplicitCallParameters();
        void var11_11 = $this$createConstructor_u24lambda_u2422_u24lambda_u2421;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameterImpl irValueParameterImpl;
            IrVariable irVariable2 = (IrVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            IrValueParameterImpl it2 = irValueParameterImpl = new IrValueParameterImpl(it.getStartOffset(), it.getEndOffset(), IrDeclarationOrigin.SCRIPT_CALL_PARAMETER.INSTANCE, new IrValueParameterSymbolImpl(null, 1, null), it.getName(), 0, it.getType(), null, false, false, false, false, null, 4096, null);
            boolean bl6 = false;
            it2.setParent(irScript);
            collection.add(irValueParameterImpl);
        }
        var11_11.addAll((List)destination$iv$iv);
        $this$createConstructor_u24lambda_u2422_u24lambda_u2421.addAll((Collection)irScript.getImplicitReceiversParameters());
        $this$createConstructor_u24lambda_u2422_u24lambda_u2421.addAll((Collection)irScript.getProvidedPropertiesParameters());
        ((IrFunction)object2).setValueParameters(CollectionsKt.build((List)list2));
        irConstructor2.setParent(irScript);
        return object;
    }

    private final IrExternalPackageFragment getScriptingJvmPackage() {
        Lazy lazy = this.scriptingJvmPackage$delegate;
        return (IrExternalPackageFragment)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void addScriptMainFun(IrClass $this$addScriptMainFun) {
        void $this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430;
        void $this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431;
        void $this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432;
        Object object;
        IrValueParameter irValueParameter;
        IrClassSymbol javaLangClass2 = this.context.getIr().getSymbols().getJavaLangClass();
        IrSimpleFunction kClassJavaPropertyGetter = this.context.getIr().getSymbols().getKClassJavaPropertyGetter();
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$addScriptMainFun_u24lambda_u2423 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("RunnerKt");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"RunnerKt\")");
        $this$addScriptMainFun_u24lambda_u2423.setName(name2);
        $this$addScriptMainFun_u24lambda_u2423.setKind(ClassKind.CLASS);
        $this$addScriptMainFun_u24lambda_u2423.setModality(Modality.FINAL);
        Object $this$addScriptMainFun_u24lambda_u2426 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        $this$addScriptMainFun_u24lambda_u2426.setParent(this.getScriptingJvmPackage());
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$addScriptMainFun_u24lambda_u2426);
        IrSimpleFunction $this$addScriptMainFun_u24lambda_u2426_u24lambda_u2425 = bl = DeclarationBuildersKt.addFunction$default((IrClass)$this$addScriptMainFun_u24lambda_u2426, "runCompiledScript", this.context.getIrBuiltIns().getUnitType(), null, null, true, false, false, null, 0, 0, 1004, null);
        boolean bl4 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$addScriptMainFun_u24lambda_u2426_u24lambda_u2425, "scriptClass", (IrType)IrTypesKt.getStarProjectedType(javaLangClass2), null, 4, null);
        IrFunction $this$addValueParameter$iv = $this$addScriptMainFun_u24lambda_u2426_u24lambda_u2425;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
        boolean bl5 = false;
        IrValueParameterBuilder $this$addScriptMainFun_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424 = $this$addValueParameter_u24lambda_u2430$iv;
        boolean bl6 = false;
        Name name3 = Name.identifier("args");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"args\")");
        $this$addScriptMainFun_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.setName(name3);
        Object object2 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        $this$addScriptMainFun_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.setType(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), object2));
        $this$addScriptMainFun_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.setOrigin(IrDeclarationOrigin.DEFINED.INSTANCE);
        $this$addScriptMainFun_u24lambda_u2426_u24lambda_u2425_u24lambda_u2424.setVarargElementType(this.context.getIrBuiltIns().getAnyNType());
        if ($this$addValueParameter_u24lambda_u2430$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2430$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2430$iv, $this$addValueParameter$iv);
        boolean bl7 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        IrClassSymbol scriptRunnerPackageClass = ((IrClass)$this$buildClass$iv).getSymbol();
        Sequence<IrSimpleFunctionSymbol> $this$single$iv = IrUtilsKt.getFunctions(scriptRunnerPackageClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl8 = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"runCompiledScript")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol scriptRunHelper = single$iv;
        IrClassReferenceImpl scriptClassRef = new IrClassReferenceImpl($this$addScriptMainFun.getStartOffset(), $this$addScriptMainFun.getEndOffset(), IrTypesKt.getStarProjectedType(this.context.getIrBuiltIns().getKClassClass()), this.context.getIrBuiltIns().getKClassClass(), IrUtilsKt.getDefaultType($this$addScriptMainFun));
        IrClass $this$addFunction$iv = $this$addScriptMainFun;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv$iv$iv = new IrFunctionBuilder();
        boolean bl9 = false;
        IrFunctionBuilder $this$addScriptMainFun_u24lambda_u2428 = $this$buildFun_u24lambda_u2418$iv$iv$iv;
        boolean $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = false;
        Name name4 = Name.identifier("main");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(\"main\")");
        $this$addScriptMainFun_u24lambda_u2428.setName(name4);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
        $this$addScriptMainFun_u24lambda_u2428.setVisibility(descriptorVisibility);
        $this$addScriptMainFun_u24lambda_u2428.setReturnType(this.context.getIrBuiltIns().getUnitType());
        $this$addScriptMainFun_u24lambda_u2428.setModality(Modality.FINAL);
        Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2418$iv$iv$iv);
        boolean bl10 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent($this$addFunction$iv);
        Object mainFun = object = $this$buildFun$iv$iv$iv;
        boolean bl11 = false;
        IrFunction $this$addValueParameter$iv2 = (IrFunction)mainFun;
        boolean $i$f$addValueParameter22 = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2430$iv2 = new IrValueParameterBuilder();
        $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
        Object $this$addScriptMainFun_u24lambda_u2433_u24lambda_u2429 = $this$addValueParameter_u24lambda_u2430$iv2;
        boolean bl12 = false;
        Name name5 = Name.identifier("args");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(\"args\")");
        ((IrDeclarationBuilder)$this$addScriptMainFun_u24lambda_u2433_u24lambda_u2429).setName(name5);
        IrType[] $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        ((IrValueParameterBuilder)$this$addScriptMainFun_u24lambda_u2433_u24lambda_u2429).setType(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22));
        if ($this$addValueParameter_u24lambda_u2430$iv2.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2430$iv2.setIndex($this$addValueParameter$iv2.getValueParameters().size());
        }
        object2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv2.getFactory(), $this$addValueParameter_u24lambda_u2430$iv2, $this$addValueParameter$iv2);
        IrType[] valueParameter$iv2 = object2;
        $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
        $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), (Object)valueParameter$iv2));
        IrType[] args = object2;
        DeclarationIrBuilder $i$f$addValueParameter22 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSimpleFunction)mainFun).getSymbol(), (int)0, (int)0, (int)6, null);
        Object object3 = mainFun;
        boolean bl13 = false;
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432, scriptRunHelper);
        $this$addScriptMainFun_u24lambda_u2433_u24lambda_u2429 = irCall;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432;
        boolean bl14 = false;
        object2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432, IrTypesKt.getStarProjectedType(javaLangClass2), null, kClassJavaPropertyGetter.getSymbol());
        valueParameter$iv2 = object2;
        int n = 0;
        void var22_49 = $this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431;
        boolean bl15 = false;
        $this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431_u24lambda_u2430.setExtensionReceiver(scriptClassRef);
        Unit unit2 = Unit.INSTANCE;
        var22_49.putValueArgument(n, (IrExpression)object2);
        $this$addScriptMainFun_u24lambda_u2433_u24lambda_u2432_u24lambda_u2431.putValueArgument(1, new IrGetValueImpl(-1, -1, args.getType(), args.getSymbol(), null, 16, null));
        ((IrFunction)object3).setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irCall));
    }

    /*
     * WARNING - void declaration
     */
    private final void addSimplePropertyFrom(IrClass $this$addSimplePropertyFrom, IrValueDeclaration from2, IrExpressionBody initializer2) {
        void field2;
        IrField irField;
        void $this$addSimplePropertyFrom_u24lambda_u2437_u24lambda_u2435;
        Object object;
        IrClass $this$addProperty$iv = $this$addSimplePropertyFrom;
        boolean $i$f$addProperty = false;
        Object $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
        boolean $i$f$buildProperty = false;
        IrPropertyBuilder $this$buildProperty_u24lambda_u248$iv$iv = new IrPropertyBuilder();
        boolean bl = false;
        IrPropertyBuilder $this$addSimplePropertyFrom_u24lambda_u2434 = $this$buildProperty_u24lambda_u248$iv$iv;
        boolean $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = false;
        $this$addSimplePropertyFrom_u24lambda_u2434.updateFrom(from2);
        $this$addSimplePropertyFrom_u24lambda_u2434.setName(from2.getName());
        Object property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u248$iv$iv);
        boolean bl2 = false;
        $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
        property$iv.setParent($this$addProperty$iv);
        Object property2 = object = $this$buildProperty$iv$iv;
        boolean bl3 = false;
        IrFactory $this$buildField$iv = this.context.getIrFactory();
        boolean $i$f$buildField22 = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = $this$buildField_u24lambda_u244$iv;
        Object object2 = property2;
        boolean bl5 = false;
        $this$addSimplePropertyFrom_u24lambda_u2437_u24lambda_u2435.setName(from2.getName());
        $this$addSimplePropertyFrom_u24lambda_u2437_u24lambda_u2435.setType(from2.getType());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PROTECTED");
        $this$addSimplePropertyFrom_u24lambda_u2437_u24lambda_u2435.setVisibility(descriptorVisibility);
        IrField $i$f$buildField22 = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u244$iv);
        boolean bl6 = false;
        field2.setParent($this$addSimplePropertyFrom);
        if (initializer2 != null) {
            field2.setInitializer(initializer2);
        }
        DeclarationBuildersKt.addDefaultGetter((IrProperty)property2, $this$addSimplePropertyFrom, this.context.getIrBuiltIns());
        ((IrProperty)object2).setBackingField(irField);
    }

    static /* synthetic */ void addSimplePropertyFrom$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass2, IrValueDeclaration irValueDeclaration, IrExpressionBody irExpressionBody, int n, Object object) {
        if ((n & 2) != 0) {
            irExpressionBody = null;
        }
        scriptsToClassesLowering.addSimplePropertyFrom(irClass2, irValueDeclaration, irExpressionBody);
    }

    /*
     * WARNING - void declaration
     */
    private static final <E extends IrElement> IrElement finalizeScriptClass$patchForClass(E $this$finalizeScriptClass_u24patchForClass, ScriptToClassTransformer scriptTransformer, ScriptToClassTransformerContext defaultContext2, ScriptFixLambdasTransformer lambdaPatcher) {
        Object object;
        IrElementTransformer irElementTransformer;
        E e;
        block3: {
            block2: {
                void it;
                e = $this$finalizeScriptClass_u24patchForClass;
                irElementTransformer = scriptTransformer;
                object = $this$finalizeScriptClass_u24patchForClass instanceof IrDeclaration ? (IrDeclaration)$this$finalizeScriptClass_u24patchForClass : null;
                if (object == null) break block2;
                IrDeclaration irDeclaration2 = object;
                IrElementTransformer irElementTransformer2 = irElementTransformer;
                E e2 = e;
                boolean bl = false;
                ScriptToClassTransformerContext scriptToClassTransformerContext = ScriptToClassTransformerContext.copy$default(defaultContext2, null, null, null, false, (IrDeclaration)it, 15, null);
                e = e2;
                irElementTransformer = irElementTransformer2;
                ScriptToClassTransformerContext scriptToClassTransformerContext2 = scriptToClassTransformerContext;
                object = scriptToClassTransformerContext2;
                if (scriptToClassTransformerContext2 != null) break block3;
            }
            object = defaultContext2;
        }
        return e.transform(irElementTransformer, (Object)object).transform(lambdaPatcher, new ScriptFixLambdasTransformerContext(false, null, 3, null));
    }
}

