/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$run$;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLoweringKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EnumClassTransformer", "backend.jvm.lower"})
final class EnumClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public EnumClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        if (!IrUtilsKt.isEnumClass(irClass2)) {
            return;
        }
        new EnumClassTransformer(irClass2, this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.EnumEntries)).run();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J\u0006\u0010\"\u001a\u00020#R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0010j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "supportsEnumEntries", "", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Z)V", "declarationToEnumEntry", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "enumArrayType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "enumEntryOrdinals", "Lgnu/trove/TObjectIntHashMap;", "loweredEnumConstructorParameters", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lkotlin/collections/HashMap;", "loweredEnumConstructors", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildEntriesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "entriesHelper", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "buildEntriesHelperFunction", "valuesField", "buildEnumEntryField", "enumEntry", "buildValuesField", "valuesHelperFunction", "buildValuesHelperFunction", "run", "", "EnumClassCallTransformer", "EnumClassDeclarationsTransformer", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 IrArrayBuilder.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilderKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n473#2:369\n1295#2:370\n1296#2:372\n1#3:371\n1#3:386\n191#4:373\n185#4:374\n179#4,10:375\n191#4:398\n185#4:399\n179#4,10:400\n61#4:410\n55#4,10:411\n61#4:421\n55#4,10:422\n20#5:385\n800#6,11:387\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer\n*L\n110#1:369\n110#1:370\n110#1:372\n162#1:386\n155#1:373\n155#1:374\n155#1:375,10\n170#1:398\n170#1:399\n170#1:400,10\n181#1:410\n181#1:411,10\n196#1:421\n196#1:422,10\n162#1:385\n163#1:387,11\n*E\n"})
    private final class EnumClassTransformer {
        @NotNull
        private final IrClass irClass;
        private final boolean supportsEnumEntries;
        @NotNull
        private final HashMap<IrConstructorSymbol, IrConstructor> loweredEnumConstructors;
        @NotNull
        private final HashMap<IrValueParameterSymbol, IrValueParameter> loweredEnumConstructorParameters;
        @NotNull
        private final TObjectIntHashMap<IrEnumEntry> enumEntryOrdinals;
        @NotNull
        private final Map<IrDeclaration, IrEnumEntry> declarationToEnumEntry;
        @NotNull
        private final IrSimpleType enumArrayType;

        public EnumClassTransformer(IrClass irClass2, boolean supportsEnumEntries) {
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            this.irClass = irClass2;
            this.supportsEnumEntries = supportsEnumEntries;
            this.loweredEnumConstructors = new HashMap();
            this.loweredEnumConstructorParameters = new HashMap();
            this.enumEntryOrdinals = new TObjectIntHashMap();
            this.declarationToEnumEntry = new LinkedHashMap();
            IrType[] irTypeArray = new IrType[]{IrUtilsKt.getDefaultType(this.irClass)};
            this.enumArrayType = IrTypesKt.typeWith((IrClassifierSymbol)EnumClassLowering.this.context.getIrBuiltIns().getArrayClass(), irTypeArray);
        }

        public final void run() {
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.irClass.getDeclarations());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)EnumClassTransformer$run$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$forEach$iv = SequencesKt.withIndex((Sequence)sequence2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IndexedValue indexedValue = (IndexedValue)element$iv;
                boolean bl = false;
                int index2 = indexedValue.component1();
                IrEnumEntry enumEntry = (IrEnumEntry)indexedValue.component2();
                this.enumEntryOrdinals.put((Object)enumEntry, index2);
                if (enumEntry.getCorrespondingClass() != null) {
                    IrClass entryClass;
                    boolean bl2 = false;
                    this.declarationToEnumEntry.put(entryClass, enumEntry);
                }
                this.declarationToEnumEntry.put(this.buildEnumEntryField(enumEntry), enumEntry);
            }
            CollectionsKt.removeAll(this.irClass.getDeclarations(), (Function1)run.2.INSTANCE);
            CollectionsKt.addAll((Collection)this.irClass.getDeclarations(), (Iterable)this.declarationToEnumEntry.keySet());
            IrFunction valuesHelperFunction = this.buildValuesHelperFunction();
            IrField valuesField = this.buildValuesField(valuesHelperFunction);
            IrField entriesField = null;
            if (this.supportsEnumEntries) {
                IrFunction entriesHelperFunction = this.buildEntriesHelperFunction(valuesField);
                entriesField = this.buildEntriesField(entriesHelperFunction);
            } else {
                entriesField = null;
            }
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassDeclarationsTransformer(valuesField, entriesField));
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, (IrElementTransformerVoid)((Object)new EnumClassCallTransformer()));
        }

        private final IrField buildEnumEntryField(IrEnumEntry enumEntry) {
            IrField irField;
            IrField $this$buildEnumEntryField_u24lambda_u242 = irField = EnumClassLowering.this.context.getCachedDeclarations().getFieldForEnumEntry(enumEntry);
            boolean bl = false;
            IrExpressionBody irExpressionBody = enumEntry.getInitializerExpression();
            Intrinsics.checkNotNull((Object)irExpressionBody);
            $this$buildEnumEntryField_u24lambda_u242.setInitializer(new IrExpressionBodyImpl((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irExpressionBody.getExpression(), $this$buildEnumEntryField_u24lambda_u242)));
            $this$buildEnumEntryField_u24lambda_u242.setAnnotations(CollectionsKt.plus((Collection)$this$buildEnumEntryField_u24lambda_u242.getAnnotations(), (Iterable)enumEntry.getAnnotations()));
            return irField;
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction buildValuesHelperFunction() {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$irArray$iv;
            IrArrayBuilder irArrayBuilder;
            void $this$buildValuesHelperFunction_u24lambda_u246_u24lambda_u245;
            IrClass $this$addFunction$iv = this.irClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv$iv$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv$iv$iv22 = false;
            IrFunctionBuilder $this$buildValuesHelperFunction_u24lambda_u243 = $this$buildFun_u24lambda_u2418$iv$iv$iv;
            boolean bl = false;
            Name name2 = Name.identifier("$values");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(VALUES_HELPER_FUNCTION_NAME)");
            $this$buildValuesHelperFunction_u24lambda_u243.setName(name2);
            $this$buildValuesHelperFunction_u24lambda_u243.setReturnType(this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildValuesHelperFunction_u24lambda_u243.setVisibility(descriptorVisibility);
            $this$buildValuesHelperFunction_u24lambda_u243.setOrigin(IrDeclarationOrigin.SYNTHETIC_HELPER_FOR_ENUM_VALUES.INSTANCE);
            Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2418$iv$iv$iv);
            boolean bl2 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object object = $this$buildFun$iv$iv$iv;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            Object $this$buildValuesHelperFunction_u24lambda_u246 = object;
            boolean bl3 = false;
            $this$buildFun$iv$iv$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrSimpleFunction)$this$buildValuesHelperFunction_u24lambda_u246).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildValuesHelperFunction_u24lambda_u246;
            boolean bl4 = false;
            void $i$a$-run-DeclarationBuildersKt$buildFun$1$iv$iv$iv22 = $this$buildValuesHelperFunction_u24lambda_u246_u24lambda_u245;
            IrType arrayType$iv = ((IrFunction)$this$buildValuesHelperFunction_u24lambda_u246).getReturnType();
            boolean $i$f$irArray = false;
            IrArrayBuilder $this$irArray_u24lambda_u240$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
            boolean bl5 = false;
            IrArrayBuilder irArrayBuilder2 = $this$irArray_u24lambda_u240$iv;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u246_u24lambda_u245;
            boolean bl6 = false;
            Iterable $this$filterIsInstance$iv = this.declarationToEnumEntry.keySet();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (IrField irField : (List)destination$iv$iv) {
                void $this$buildValuesHelperFunction_u24lambda_u246_u24lambda_u245_u24lambda_u244;
                $this$buildValuesHelperFunction_u24lambda_u246_u24lambda_u245_u24lambda_u244.unaryPlus(ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u246_u24lambda_u245, null, irField, null, 4, null));
            }
            ((IrFunction)object2).setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irArrayBuilder.build()));
            return (IrFunction)object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction buildEntriesHelperFunction(IrField valuesField) {
            void $this$buildEntriesHelperFunction_u24lambda_u249_u24lambda_u248;
            IrClass $this$addFunction$iv = this.irClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildEntriesHelperFunction_u24lambda_u247 = $this$buildFun_u24lambda_u2418$iv$iv$iv;
            boolean bl2 = false;
            Name name2 = Name.identifier("$entries");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(ENTRIES_HELPER_FUNCTION_NAME)");
            $this$buildEntriesHelperFunction_u24lambda_u247.setName(name2);
            $this$buildEntriesHelperFunction_u24lambda_u247.setReturnType(this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildEntriesHelperFunction_u24lambda_u247.setVisibility(descriptorVisibility);
            $this$buildEntriesHelperFunction_u24lambda_u247.setOrigin(IrDeclarationOrigin.SYNTHETIC_HELPER_FOR_ENUM_VALUES.INSTANCE);
            Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2418$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object object = $this$buildFun$iv$iv$iv;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            Object $this$buildEntriesHelperFunction_u24lambda_u249 = object;
            boolean bl4 = false;
            $this$buildFun$iv$iv$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrSimpleFunction)$this$buildEntriesHelperFunction_u24lambda_u249).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildEntriesHelperFunction_u24lambda_u249;
            boolean bl5 = false;
            ((IrFunction)object2).setBody(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$buildEntriesHelperFunction_u24lambda_u249_u24lambda_u248, ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)$this$buildEntriesHelperFunction_u24lambda_u249_u24lambda_u248, null, valuesField, null, 4, null)));
            return (IrFunction)object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildValuesField(IrFunction valuesHelperFunction) {
            void $this$buildValuesField_u24lambda_u2412_u24lambda_u2411;
            IrClass $this$addField$iv = this.irClass;
            boolean $i$f$addField = false;
            Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildValuesField_u24lambda_u2410 = $this$buildField_u24lambda_u244$iv$iv;
            boolean bl2 = false;
            Name name2 = Name.identifier("$VALUES");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(Implementatio\u2026n.ENUM_VALUES_FIELD_NAME)");
            $this$buildValuesField_u24lambda_u2410.setName(name2);
            $this$buildValuesField_u24lambda_u2410.setType(this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildValuesField_u24lambda_u2410.setVisibility(descriptorVisibility);
            $this$buildValuesField_u24lambda_u2410.setOrigin(IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE);
            $this$buildValuesField_u24lambda_u2410.setFinal(true);
            $this$buildValuesField_u24lambda_u2410.setStatic(true);
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
            boolean $i$a$-also-DeclarationBuildersKt$addField$1$iv22 = false;
            field$iv.setParent($this$addField$iv);
            $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
            Object object = $this$buildField$iv$iv;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            Object $this$buildValuesField_u24lambda_u2412 = object;
            boolean bl3 = false;
            JvmIrBuilder $i$a$-also-DeclarationBuildersKt$addField$1$iv22 = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrField)$this$buildValuesField_u24lambda_u2412).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildValuesField_u24lambda_u2412;
            boolean bl4 = false;
            ((IrField)object2).setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2412_u24lambda_u2411, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2412_u24lambda_u2411, valuesHelperFunction.getSymbol())));
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildEntriesField(IrFunction entriesHelper) {
            void $this$buildEntriesField_u24lambda_u2415_u24lambda_u2414;
            void $this$addField$iv;
            Object object = this.irClass;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            boolean $i$f$addField = false;
            Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildEntriesField_u24lambda_u2413 = $this$buildField_u24lambda_u244$iv$iv;
            boolean bl2 = false;
            Name name2 = Name.identifier("$ENTRIES");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(ENTRIES_FIELD_NAME)");
            $this$buildEntriesField_u24lambda_u2413.setName(name2);
            $this$buildEntriesField_u24lambda_u2413.setType(IrTypesKt.getDefaultType(enumClassLowering.context.getIr().getSymbols().getEnumEntries()));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildEntriesField_u24lambda_u2413.setVisibility(descriptorVisibility);
            $this$buildEntriesField_u24lambda_u2413.setOrigin(IrDeclarationOrigin.FIELD_FOR_ENUM_ENTRIES.INSTANCE);
            $this$buildEntriesField_u24lambda_u2413.setFinal(true);
            $this$buildEntriesField_u24lambda_u2413.setStatic(true);
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
            boolean bl3 = false;
            field$iv.setParent((IrDeclarationParent)$this$addField$iv);
            $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
            object = $this$buildField$iv$iv;
            enumClassLowering = EnumClassLowering.this;
            Object $this$buildEntriesField_u24lambda_u2415 = object;
            boolean bl4 = false;
            field$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrField)$this$buildEntriesField_u24lambda_u2415).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildEntriesField_u24lambda_u2415;
            boolean bl5 = false;
            ((IrField)object2).setInitializer(EnumClassLoweringKt.irCreateEnumEntriesIndy((IrBuilderWithScope)$this$buildEntriesField_u24lambda_u2415_u24lambda_u2414, entriesHelper, this.enumArrayType, enumClassLowering.context));
            return object;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "valuesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "entriesField", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrField;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm.lower"})
        @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n223#2,4:369\n1549#3:373\n1620#3,3:374\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer\n*L\n217#1:369,4\n230#1:373\n230#1:374,3\n*E\n"})
        private final class EnumClassDeclarationsTransformer
        extends IrElementTransformerVoid {
            @NotNull
            private final IrField valuesField;
            @Nullable
            private final IrField entriesField;

            public EnumClassDeclarationsTransformer(@Nullable IrField valuesField, IrField entriesField) {
                Intrinsics.checkNotNullParameter((Object)valuesField, (String)"valuesField");
                this.valuesField = valuesField;
                this.entriesField = entriesField;
            }

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrUtilsKt.isEnumEntry(declaration) ? super.visitClass(declaration) : (IrStatement)declaration;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
                Collection<IrValueParameter> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrFactory $this$buildConstructor$iv = EnumClassLowering.this.context.getIrFactory();
                boolean $i$f$buildConstructor = false;
                IrFunctionBuilder $this$buildConstructor_u24lambda_u2422$iv = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$visitConstructor_u24lambda_u240 = $this$buildConstructor_u24lambda_u2422$iv;
                boolean $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = false;
                $this$visitConstructor_u24lambda_u240.updateFrom(declaration);
                $this$visitConstructor_u24lambda_u240.setReturnType(declaration.getReturnType());
                IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2422$iv);
                EnumClassLowering enumClassLowering = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                IrConstructor $this$visitConstructor_u24lambda_u243 = irConstructor2;
                boolean bl2 = false;
                $this$visitConstructor_u24lambda_u243.setParent(declaration.getParent());
                $this$visitConstructor_u24lambda_u243.setAnnotations(declaration.getAnnotations());
                DeclarationBuildersKt.addValueParameter((IrFunction)$this$visitConstructor_u24lambda_u243, "$enum$name", enumClassLowering.context.getIrBuiltIns().getStringType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE);
                DeclarationBuildersKt.addValueParameter((IrFunction)$this$visitConstructor_u24lambda_u243, "$enum$ordinal", enumClassLowering.context.getIrBuiltIns().getIntType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.ENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER.INSTANCE);
                Iterable $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = declaration.getValueParameters();
                Collection collection2 = $this$visitConstructor_u24lambda_u243.getValueParameters();
                IrConstructor irConstructor3 = $this$visitConstructor_u24lambda_u243;
                boolean $i$f$map = false;
                void var11_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void param;
                    IrValueParameter irValueParameter;
                    IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    IrValueParameter newParam = irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)param, $this$visitConstructor_u24lambda_u243, null, param.getIndex() + 2, 0, 0, null, null, null, null, null, false, false, false, 8186, null);
                    boolean bl4 = false;
                    ((Map)enumClassTransformer.loweredEnumConstructorParameters).put(param.getSymbol(), newParam);
                    collection.add(irValueParameter);
                }
                collection = (List)destination$iv$iv;
                irConstructor3.setValueParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
                IrBody irBody = declaration.getBody();
                $this$visitConstructor_u24lambda_u243.setBody(irBody != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBody, $this$visitConstructor_u24lambda_u243) : null);
                ((Map)enumClassTransformer.loweredEnumConstructors).put(declaration.getSymbol(), $this$visitConstructor_u24lambda_u243);
                $this$visitConstructor_u24lambda_u243.setMetadata(declaration.getMetadata());
                return irConstructor2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrDeclarationReference irDeclarationReference;
                void $this$visitSimpleFunction_u24lambda_u246;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Object object = declaration.getBody();
                IrSyntheticBody irSyntheticBody = object instanceof IrSyntheticBody ? (IrSyntheticBody)object : null;
                if (irSyntheticBody == null) {
                    return declaration;
                }
                IrSyntheticBody body2 = irSyntheticBody;
                JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(EnumClassLowering.this.context, declaration.getSymbol(), 0, 0, 6, null);
                object = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                JvmIrBuilder jvmIrBuilder2 = jvmIrBuilder;
                IrSimpleFunction irSimpleFunction = declaration;
                boolean bl = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246;
                switch (WhenMappings.$EnumSwitchMapping$0[body2.getKind().ordinal()]) {
                    case 1: {
                        void $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244;
                        IrCall irCall;
                        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246, ((EnumClassLowering)object).context.getIr().getSymbols().getObjectCloneFunction(), declaration.getReturnType(), 0, 0, null, 28, null);
                        IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                        boolean bl2 = false;
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244.setDispatchReceiver(ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246, null, this.valuesField, null, 4, null));
                        irBuilderWithScope = irBuilderWithScope2;
                        irDeclarationReference = irCall;
                        break;
                    }
                    case 2: {
                        void $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245;
                        IrCall irCall;
                        IrCall $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246, $this$visitSimpleFunction_u24lambda_u246.getBackendContext().getIr().getSymbols().getEnumValueOfFunction());
                        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
                        boolean bl3 = false;
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245.putValueArgument(0, JvmIrUtilsKt.javaClassReference((JvmIrBuilder)$this$visitSimpleFunction_u24lambda_u246, IrUtilsKt.getDefaultType(enumClassTransformer.irClass)));
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245.putValueArgument(1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246, declaration.getValueParameters().get(0)));
                        irBuilderWithScope = irBuilderWithScope3;
                        irDeclarationReference = irCall;
                        break;
                    }
                    case 3: {
                        IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246;
                        IrField irField = this.entriesField;
                        Intrinsics.checkNotNull((Object)irField);
                        irDeclarationReference = ExpressionHelpersKt.irGetField$default(irBuilderWithScope4, null, irField, null, 4, null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irDeclarationReference));
                return declaration;
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[IrSyntheticBodyKind.values().length];
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_VALUES.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_VALUEOF.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_ENTRIES.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;)V", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "passConstructorArguments", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "original", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "backend.jvm.lower"})
        @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,368:1\n1#2:369\n*E\n"})
        private final class EnumClassCallTransformer
        extends IrElementTransformerVoidWithContext {
            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrUtilsKt.isEnumEntry(declaration) ? super.visitClassNew(declaration) : (IrStatement)declaration;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrValueParameter irValueParameter = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    irExpression = new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }

            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                IrValueParameter irValueParameter = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    irExpression = new IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getValue(), expression2.getOrigin());
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }

            @NotNull
            public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrFunctionAccessExpression irFunctionAccessExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, (IrElementTransformerVoid)((Object)this));
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                IrSymbol scopeOwnerSymbol = scopeWithIr.getScope().getScopeOwnerSymbol();
                IrBuilder irBuilder = LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)EnumClassLowering.this.context), (IrSymbol)scopeOwnerSymbol, (int)0, (int)0, (int)6, null)), (IrElement)expression2);
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                DeclarationIrBuilder $this$visitEnumConstructorCall_u24lambda_u243 = (DeclarationIrBuilder)irBuilder;
                boolean bl = false;
                IrConstructor irConstructor2 = (IrConstructor)enumClassTransformer.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor2 == null) {
                    irConstructor2 = (IrConstructor)expression2.getSymbol().getOwner();
                }
                Intrinsics.checkNotNullExpressionValue((Object)irConstructor2, (String)"loweredEnumConstructors[\u2026: expression.symbol.owner");
                IrConstructor constructor2 = irConstructor2;
                IrFunctionAccessExpression it = irFunctionAccessExpression = scopeOwnerSymbol instanceof IrConstructorSymbol ? (IrFunctionAccessExpression)ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u243, constructor2) : ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u243, constructor2);
                boolean bl2 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u243;
                IrFunctionAccessExpression irFunctionAccessExpression2 = expression2;
                Map map = enumClassTransformer.declarationToEnumEntry;
                IrSymbolOwner irSymbolOwner = scopeOwnerSymbol.getOwner();
                Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                this.passConstructorArguments(irBuilderWithScope, it, irFunctionAccessExpression2, (IrEnumEntry)map.get((IrDeclaration)irSymbolOwner));
                return irFunctionAccessExpression;
            }

            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCall irDelegatingConstructorCall2;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, (IrElementTransformerVoid)((Object)this));
                IrConstructor irConstructor2 = (IrConstructor)EnumClassTransformer.this.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor2 == null) {
                    return expression2;
                }
                IrConstructor replacement = irConstructor2;
                BackendContext backendContext = (BackendContext)EnumClassLowering.this.context;
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                DeclarationIrBuilder $this$visitDelegatingConstructorCall_u24lambda_u245 = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)((IrBuilder)LowerUtilsKt.createIrBuilder$default((BackendContext)backendContext, (IrSymbol)scopeWithIr.getScope().getScopeOwnerSymbol(), (int)0, (int)0, (int)6, null)), (IrElement)expression2);
                boolean bl = false;
                IrDelegatingConstructorCall it = irDelegatingConstructorCall2 = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$visitDelegatingConstructorCall_u24lambda_u245, replacement);
                boolean bl2 = false;
                EnumClassCallTransformer.passConstructorArguments$default(this, (IrBuilderWithScope)$this$visitDelegatingConstructorCall_u24lambda_u245, it, expression2, null, 4, null);
                return irDelegatingConstructorCall2;
            }

            private final void passConstructorArguments(IrBuilderWithScope $this$passConstructorArguments, IrFunctionAccessExpression call2, IrFunctionAccessExpression original2, IrEnumEntry enumEntry) {
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(call2, original2, 0, 2, null);
                if (enumEntry != null) {
                    String string2 = enumEntry.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"enumEntry.name.asString()");
                    call2.putValueArgument(0, ExpressionHelpersKt.irString($this$passConstructorArguments, string2));
                    call2.putValueArgument(1, ExpressionHelpersKt.irInt$default($this$passConstructorArguments, EnumClassTransformer.this.enumEntryOrdinals.get((Object)enumEntry), null, 2, null));
                } else {
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull((Object)scopeWithIr);
                    IrSymbol irSymbol2 = scopeWithIr.getScope().getScopeOwnerSymbol();
                    Intrinsics.checkNotNull((Object)irSymbol2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol");
                    IrConstructorSymbol constructor2 = (IrConstructorSymbol)irSymbol2;
                    call2.putValueArgument(0, ExpressionHelpersKt.irGet($this$passConstructorArguments, ((IrConstructor)constructor2.getOwner()).getValueParameters().get(0)));
                    call2.putValueArgument(1, ExpressionHelpersKt.irGet($this$passConstructorArguments, ((IrConstructor)constructor2.getOwner()).getValueParameters().get(1)));
                }
                int n = original2.getValueArgumentsCount();
                for (int index2 = 0; index2 < n; ++index2) {
                    IrExpression it;
                    if (original2.getValueArgument(index2) == null) continue;
                    boolean bl = false;
                    call2.putValueArgument(index2 + 2, it);
                }
            }

            static /* synthetic */ void passConstructorArguments$default(EnumClassCallTransformer enumClassCallTransformer, IrBuilderWithScope irBuilderWithScope, IrFunctionAccessExpression irFunctionAccessExpression, IrFunctionAccessExpression irFunctionAccessExpression2, IrEnumEntry irEnumEntry, int n, Object object) {
                if ((n & 4) != 0) {
                    irEnumEntry = null;
                }
                enumClassCallTransformer.passConstructorArguments(irBuilderWithScope, irFunctionAccessExpression, irFunctionAccessExpression2, irEnumEntry);
            }
        }
    }
}

